/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard.table;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.ui.model.SortedTableModel;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.ui.wizard.data.SingleFileRestoreItem;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.compare.ReverseComparator;
import de.dal33t.powerfolder.util.logging.Loggable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class SingleFileRestoreTableModel
extends PFComponent
implements TableModel,
SortedTableModel {
    private static final String[] COLUMNS = new String[]{Translation.get("single_file_restore_table_model.modified_date"), Translation.get("single_file_restore_table_model.version"), Translation.get("single_file_restore_table_model.size"), Translation.get("single_file_restore_table_model.local")};
    static final int COL_MODIFIED_DATE = 0;
    static final int COL_VERSION = 1;
    static final int COL_SIZE = 2;
    static final int COL_LOCAL = 3;
    private final List<SingleFileRestoreItem> fileInfos = new ArrayList<SingleFileRestoreItem>();
    private int fileInfoComparatorType = -1;
    private boolean sortAscending = true;
    private int sortColumn;
    private final List<TableModelListener> listeners = new CopyOnWriteArrayList<TableModelListener>();

    public SingleFileRestoreTableModel(Controller controller) {
        super(controller);
    }

    @Override
    public int getRowCount() {
        return this.fileInfos.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMNS[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return FileInfo.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.fileInfos.get(n);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        throw new UnsupportedOperationException("Cannot modify SingleFileRestoreTableModel");
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listeners.add(tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listeners.remove(tableModelListener);
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public boolean isSortAscending() {
        return this.sortAscending;
    }

    @Override
    public boolean sortBy(int n) {
        this.sortColumn = n;
        switch (n) {
            case 1: {
                return this.sortMe(2);
            }
            case 2: {
                return this.sortMe(0);
            }
            case 0: {
                return this.sortMe(1);
            }
            case 3: {
                return this.sortMe(1);
            }
        }
        this.sortColumn = -1;
        return false;
    }

    public boolean sortMe(int n) {
        boolean bl;
        if (this.fileInfos.isEmpty()) {
            return false;
        }
        int n2 = this.fileInfoComparatorType;
        this.fileInfoComparatorType = n;
        if (n2 != n && (bl = this.sort())) {
            this.fireModelChanged();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sort() {
        if (this.fileInfoComparatorType != -1) {
            SingleFileRestoreItemComparator singleFileRestoreItemComparator = new SingleFileRestoreItemComparator(this.fileInfoComparatorType);
            List<SingleFileRestoreItem> list = this.fileInfos;
            synchronized (list) {
                if (this.sortAscending) {
                    Collections.sort(this.fileInfos, singleFileRestoreItemComparator);
                } else {
                    Collections.sort(this.fileInfos, new ReverseComparator<SingleFileRestoreItem>(singleFileRestoreItemComparator));
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverseList() {
        this.sortAscending = !this.sortAscending;
        List<SingleFileRestoreItem> list = this.fileInfos;
        synchronized (list) {
            Collections.reverse(this.fileInfos);
        }
        this.fireModelChanged();
    }

    private void fireModelChanged() {
        TableModelEvent tableModelEvent = new TableModelEvent(this);
        for (TableModelListener tableModelListener : this.listeners) {
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    @Override
    public void setAscending(boolean bl) {
        this.sortAscending = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileInfos(List<SingleFileRestoreItem> list) {
        List<SingleFileRestoreItem> list2 = this.fileInfos;
        synchronized (list2) {
            this.fileInfos.clear();
            this.fileInfos.addAll(list);
        }
        this.update();
    }

    private void update() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SingleFileRestoreTableModel.this.sort();
                SingleFileRestoreTableModel.this.fireModelChanged();
            }
        };
        UIUtil.invokeLaterInEDT(runnable);
    }

    public List<SingleFileRestoreItem> getRestoreItems() {
        return Collections.unmodifiableList(this.fileInfos);
    }

    private static class SingleFileRestoreItemComparator
    extends Loggable
    implements Comparator<SingleFileRestoreItem> {
        public static final int BY_SIZE = 0;
        public static final int BY_MODIFIED_DATE = 1;
        public static final int BY_VERSION = 2;
        public static final int BY_LOCAL = 3;
        private static final int BEFORE = -1;
        private static final int AFTER = 1;
        private int sortBy;
        private static final SingleFileRestoreItemComparator[] COMPARATORS = new SingleFileRestoreItemComparator[8];

        SingleFileRestoreItemComparator(int n) {
            this.sortBy = n;
        }

        @Override
        public int compare(SingleFileRestoreItem singleFileRestoreItem, SingleFileRestoreItem singleFileRestoreItem2) {
            switch (this.sortBy) {
                case 0: {
                    if (singleFileRestoreItem.getFileInfo().isLookupInstance() || singleFileRestoreItem2.getFileInfo().isLookupInstance()) {
                        return this.sortByVersion(singleFileRestoreItem, singleFileRestoreItem2);
                    }
                    if (singleFileRestoreItem.getFileInfo().getSize() < singleFileRestoreItem2.getFileInfo().getSize()) {
                        return -1;
                    }
                    if (singleFileRestoreItem.getFileInfo().getSize() > singleFileRestoreItem2.getFileInfo().getSize()) {
                        return 1;
                    }
                    return this.sortByVersion(singleFileRestoreItem, singleFileRestoreItem2);
                }
                case 1: {
                    if (singleFileRestoreItem.getFileInfo().getModifiedDate() == null && singleFileRestoreItem2.getFileInfo().getModifiedDate() == null) {
                        return this.sortByVersion(singleFileRestoreItem, singleFileRestoreItem2);
                    }
                    if (singleFileRestoreItem.getFileInfo().getModifiedDate() == null) {
                        return -1;
                    }
                    if (singleFileRestoreItem2.getFileInfo().getModifiedDate() == null) {
                        return 1;
                    }
                    int n = singleFileRestoreItem2.getFileInfo().getModifiedDate().compareTo(singleFileRestoreItem.getFileInfo().getModifiedDate());
                    if (n == 0) {
                        return this.sortByVersion(singleFileRestoreItem, singleFileRestoreItem2);
                    }
                    return n;
                }
                case 2: {
                    return this.sortByVersion(singleFileRestoreItem, singleFileRestoreItem2);
                }
                case 3: {
                    if (singleFileRestoreItem.isLocal() && singleFileRestoreItem2.isLocal() || !singleFileRestoreItem.isLocal() && !singleFileRestoreItem2.isLocal()) {
                        return this.sortByVersion(singleFileRestoreItem, singleFileRestoreItem2);
                    }
                    return singleFileRestoreItem.isLocal() ? -1 : 1;
                }
            }
            return 0;
        }

        private int sortByVersion(SingleFileRestoreItem singleFileRestoreItem, SingleFileRestoreItem singleFileRestoreItem2) {
            if (singleFileRestoreItem.getFileInfo().getFolderInfo() == null && singleFileRestoreItem2.getFileInfo().getFolderInfo() == null) {
                return 0;
            }
            if (singleFileRestoreItem.getFileInfo().getFolderInfo() == null) {
                return -1;
            }
            if (singleFileRestoreItem2.getFileInfo().getFolderInfo() == null) {
                return 1;
            }
            if (singleFileRestoreItem.getFileInfo() instanceof DirectoryInfo || singleFileRestoreItem2.getFileInfo() instanceof DirectoryInfo) {
                return 1;
            }
            return singleFileRestoreItem.getFileInfo().getVersion() - singleFileRestoreItem2.getFileInfo().getVersion();
        }

        static {
            SingleFileRestoreItemComparator.COMPARATORS[0] = new SingleFileRestoreItemComparator(0);
            SingleFileRestoreItemComparator.COMPARATORS[1] = new SingleFileRestoreItemComparator(1);
            SingleFileRestoreItemComparator.COMPARATORS[2] = new SingleFileRestoreItemComparator(2);
        }
    }
}

