/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.message.Invitation;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.wizard.ConfirmDiskLocationPanel;
import de.dal33t.powerfolder.ui.wizard.DesktopSyncSetupPanel;
import de.dal33t.powerfolder.ui.wizard.FileSyncSetupPanel;
import de.dal33t.powerfolder.ui.wizard.FolderAutoCreatePanel;
import de.dal33t.powerfolder.ui.wizard.FolderOnlineStoragePanel;
import de.dal33t.powerfolder.ui.wizard.LoginPanel;
import de.dal33t.powerfolder.ui.wizard.MultiFileRestorePanel;
import de.dal33t.powerfolder.ui.wizard.MultiOnlineStorageSetupPanel;
import de.dal33t.powerfolder.ui.wizard.PFWizardPanel;
import de.dal33t.powerfolder.ui.wizard.ReceivedInvitationPanel;
import de.dal33t.powerfolder.ui.wizard.SendInvitationsPanel;
import de.dal33t.powerfolder.ui.wizard.SingleFileRestorePanel;
import de.dal33t.powerfolder.ui.wizard.TextPanelPanel;
import de.dal33t.powerfolder.ui.wizard.TypicalFolderSetupPanel;
import de.dal33t.powerfolder.ui.wizard.WhatToDoPanel;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JDialog;
import jwf.Wizard;
import jwf.WizardContext;
import jwf.WizardListener;

public class PFWizard
extends PFUIComponent {
    static final int HEADER_FONT_SIZE = 20;
    public static final String SUCCESS_PANEL = "successpanel";
    private static final AtomicInteger NUMBER_OF_OPEN_WIZARDS = new AtomicInteger();
    private final AtomicBoolean doneWizardClose = new AtomicBoolean();
    private JDialog dialog;
    private final Wizard wizard;
    private final String title;

    public PFWizard(Controller controller, String string) {
        super(controller);
        this.title = string;
        NUMBER_OF_OPEN_WIZARDS.incrementAndGet();
        this.setSuspendNewFolderSearch(true);
        this.wizard = new Wizard();
    }

    private void decrementOpenWizards() {
        if (!this.doneWizardClose.getAndSet(true)) {
            NUMBER_OF_OPEN_WIZARDS.decrementAndGet();
            this.setSuspendNewFolderSearch(false);
        }
    }

    private void setSuspendNewFolderSearch(boolean bl) {
        this.getController().getFolderRepository().setSuspendNewFolderSearch(bl);
    }

    public static boolean isWizardOpen() {
        return NUMBER_OF_OPEN_WIZARDS.get() > 0;
    }

    public static void openBasicSetupWizard(Controller controller) {
        PFWizard pFWizard = new PFWizard(controller, Translation.get("wizard.pfwizard.folder_title"));
        PFWizardPanel pFWizardPanel = WhatToDoPanel.doSyncOption(controller, pFWizard.getWizardContext(), false);
        pFWizard.open(new LoginPanel(controller, pFWizardPanel, !controller.isBackupOnly()));
    }

    public static void openWhatToDoWizard(Controller controller) {
        PFWizard pFWizard = new PFWizard(controller, Translation.get("wizard.pfwizard.folder_title"));
        pFWizard.open(new WhatToDoPanel(controller));
    }

    public static void openSendInvitationWizard(Controller controller, FolderInfo folderInfo) {
        PFWizard pFWizard = new PFWizard(controller, Translation.get("wizard.pfwizard.invitation_title"));
        pFWizard.getWizardContext().setAttribute("disklocation.folder_info", folderInfo);
        TextPanelPanel textPanelPanel = new TextPanelPanel(controller, Translation.get("wizard.send_invitations.send_success"), Translation.get("wizard.send_invitations.send_success_info"), true);
        pFWizard.getWizardContext().setAttribute(SUCCESS_PANEL, textPanelPanel);
        pFWizard.open(new SendInvitationsPanel(controller));
    }

    public static void openOnlineStorageJoinWizard(Controller controller, List<FolderInfo> list) {
        PFWizard pFWizard = new PFWizard(controller, Translation.get("wizard.pfwizard.online_storage_title"));
        pFWizard.getWizardContext().setAttribute("folder.infos", list);
        pFWizard.getWizardContext().setAttribute("disklocation.send_invitations", false);
        TextPanelPanel textPanelPanel = new TextPanelPanel(controller, Translation.get("wizard.setup_success"), Translation.get("wizard.success_join"));
        pFWizard.getWizardContext().setAttribute(SUCCESS_PANEL, textPanelPanel);
        pFWizard.open(new MultiOnlineStorageSetupPanel(controller));
    }

    public static void openTypicalFolderJoinWizard(Controller controller, FolderInfo folderInfo) {
        PFWizard pFWizard = new PFWizard(controller, Translation.get("wizard.pfwizard.folder_title"));
        pFWizard.getWizardContext().setAttribute("folder.info", folderInfo);
        pFWizard.getWizardContext().setAttribute("disklocation.send_invitations", false);
        pFWizard.getWizardContext().setAttribute("folder_create.backup_by_os", controller.getOSClient().isBackupByDefault());
        TextPanelPanel textPanelPanel = new TextPanelPanel(controller, Translation.get("wizard.setup_success"), Translation.get("wizard.success_join"), true);
        pFWizard.getWizardContext().setAttribute(SUCCESS_PANEL, textPanelPanel);
        pFWizard.open(new TypicalFolderSetupPanel(controller));
    }

    public static void openInvitationReceivedWizard(Controller controller, Invitation invitation) {
        ReceivedInvitationPanel receivedInvitationPanel = new ReceivedInvitationPanel(controller, invitation);
        PFWizard pFWizard = new PFWizard(controller, Translation.get("wizard.pfwizard.invitation_title"));
        pFWizard.open(receivedInvitationPanel);
    }

    public static void openLoginWizard(Controller controller, ServerClient serverClient) {
        PFWizard pFWizard = new PFWizard(controller, Translation.get("wizard.pfwizard.login_title"));
        TextPanelPanel textPanelPanel = new TextPanelPanel(controller, Translation.get("wizard.finish.os_login_title"), Translation.get("wizard.finish.os_login_text"), true);
        FileSyncSetupPanel fileSyncSetupPanel = new FileSyncSetupPanel(controller, serverClient, textPanelPanel);
        pFWizard.open(new LoginPanel(controller, serverClient, fileSyncSetupPanel, false));
    }

    public static void openDesktopSyncWizard(Controller controller, ServerClient serverClient) {
        PFWizard pFWizard = new PFWizard(controller, Translation.get("wizard.desktop_sync.title"));
        TextPanelPanel textPanelPanel = new TextPanelPanel(controller, Translation.get("wizard.desktop_sync.title"), Translation.get("wizard.desktop_sync.success_text"), true);
        pFWizard.open(new DesktopSyncSetupPanel(controller, textPanelPanel, serverClient));
    }

    public static void openMirrorFolderWizard(Controller controller, Folder folder) {
        PFWizard pFWizard = new PFWizard(controller, Translation.get("wizard.pfwizard.folder_title"));
        pFWizard.open(new FolderOnlineStoragePanel(controller, folder.getInfo()));
    }

    public static void openExistingDirectoryWizard(Controller controller, Path path) {
        Reject.ifTrue(path == null || !Files.exists(path, new LinkOption[0]), "No directory supplied");
        PFWizard pFWizard = new PFWizard(controller, Translation.get("wizard.pfwizard.folder_title"));
        pFWizard.getWizardContext().setAttribute("folder_create.backup_by_os", controller.getOSClient().isBackupByDefault());
        pFWizard.open(new ConfirmDiskLocationPanel(controller, path));
    }

    public static boolean hideFolderJoinWizard(Controller controller) {
        return ConfigurationEntry.FOLDER_CREATE_IN_BASEDIR_ONLY.getValueBoolean(controller) != false && PreferencesEntry.EXPERT_MODE.getValueBoolean(controller) == false;
    }

    public void open(PFWizardPanel pFWizardPanel) {
        Reject.ifNull(pFWizardPanel, "Wizard panel is null");
        if (this.dialog == null) {
            this.buildUI();
        }
        this.wizard.start(pFWizardPanel, false);
        if (PFWizard.hideFolderJoinWizard(this.getController()) && pFWizardPanel instanceof MultiOnlineStorageSetupPanel) {
            this.dialog.setVisible(false);
        } else {
            this.dialog.setVisible(true);
        }
    }

    public WizardContext getWizardContext() {
        return this.wizard.getContext();
    }

    private void buildUI() {
        this.dialog = new JDialog((Dialog)null);
        this.dialog.setResizable(true);
        this.dialog.setTitle(this.title);
        this.dialog.setModal(true);
        this.dialog.setIconImage(Icons.getImageById("powerfolder_32.icon"));
        this.getUIController().getMainFrame().getUIComponent().setIconImage(Icons.getImageById("powerfolder_32.icon"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BACK_I18N", Translation.get("wizard.control.back"));
        hashMap.put("NEXT_I18N", Translation.get("wizard.control.next"));
        hashMap.put("FINISH_I18N", Translation.get("wizard.control.finish"));
        hashMap.put("CANCEL_I18N", Translation.get("wizard.control.cancel"));
        hashMap.put("HELP_I18N", Translation.get("wizard.control.help"));
        hashMap.put("BACK_I18N_DESCRIPTION", Translation.get("wizard.control.back.description"));
        hashMap.put("NEXT_I18N_DESCRIPTION", Translation.get("wizard.control.next.description"));
        hashMap.put("FINISH_I18N_DESCRIPTION", Translation.get("wizard.control.finish.description"));
        hashMap.put("CANCEL_I18N_DESCRIPTION", Translation.get("wizard.control.cancel.description"));
        hashMap.put("HELP_I18N_DESCRIPTION", Translation.get("wizard.control.help.description"));
        this.wizard.setI18NMap(hashMap);
        this.dialog.getRootPane().setDefaultButton(this.wizard.getNextButton());
        this.wizard.addWizardListener(new WizardListener(){

            @Override
            public void wizardFinished(Wizard wizard) {
                PFWizard.this.dialog.setVisible(false);
                PFWizard.this.dialog.dispose();
            }

            @Override
            public void wizardCancelled(Wizard wizard) {
                PFWizard.this.dialog.setVisible(false);
                PFWizard.this.dialog.dispose();
            }

            @Override
            public void wizardPanelChanged(Wizard wizard) {
            }
        });
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PFWizard.this.decrementOpenWizards();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                PFWizard.this.decrementOpenWizards();
            }
        });
        this.dialog.getContentPane().add(this.wizard);
        this.dialog.pack();
        int n = ((int)Toolkit.getDefaultToolkit().getScreenSize().getWidth() - this.dialog.getWidth()) / 2;
        int n2 = ((int)Toolkit.getDefaultToolkit().getScreenSize().getHeight() - this.dialog.getHeight()) / 3;
        this.dialog.setLocation(n, n2);
        this.wizard.getContext().setAttribute("dialog", this.dialog);
        this.getUIController().setWizardDialogReference(this.dialog);
        this.getUIController().setActiveFrame(3);
    }

    public static void openFolderAutoCreateWizard(Controller controller, FolderInfo folderInfo) {
        Folder folder = controller.getFolderRepository().getFolder(folderInfo);
        if (folder == null) {
            DialogFactory.genericDialog(controller, Translation.get("wizard.control.no_folder.title"), Translation.get("wizard.control.no_folder.description"), GenericDialogType.INFO);
        } else {
            FolderAutoCreatePanel folderAutoCreatePanel = new FolderAutoCreatePanel(controller, folderInfo);
            PFWizard pFWizard = new PFWizard(controller, Translation.get("wizard.pfwizard.folder_title"));
            pFWizard.open(folderAutoCreatePanel);
        }
    }

    public static void openMultiFileRestoreWizard(Controller controller, List<FileInfo> list) {
        PFWizard pFWizard = new PFWizard(controller, Translation.get("wizard.pfwizard.restore_title"));
        if (list.size() == 1) {
            FileInfo fileInfo = list.get(0);
            Folder folder = fileInfo.getFolder(controller.getFolderRepository());
            pFWizard.open(new SingleFileRestorePanel(controller, folder, fileInfo));
        } else {
            pFWizard.open(new MultiFileRestorePanel(controller, list));
        }
    }

    public static void openSingleFileRestoreWizard(Controller controller, Folder folder, FileInfo fileInfo, FileInfo fileInfo2) {
        PFWizard pFWizard = new PFWizard(controller, Translation.get("wizard.pfwizard.restore_title"));
        pFWizard.open(new SingleFileRestorePanel(controller, folder, fileInfo, fileInfo2));
    }
}

