/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.FolderInfoFactory;
import de.dal33t.powerfolder.ui.panel.SyncProfileSelectorPanel;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.ui.wizard.FolderCreatePanel;
import de.dal33t.powerfolder.ui.wizard.PFWizardPanel;
import de.dal33t.powerfolder.ui.wizard.TextPanelPanel;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jwf.WizardPanel;

public class FolderSetupPanel
extends PFWizardPanel {
    private JTextField folderNameTextField;
    private SyncProfileSelectorPanel syncProfileSelectorPanel;

    public FolderSetupPanel(Controller controller) {
        super(controller);
    }

    @Override
    public boolean hasNext() {
        return StringUtils.isNotBlank(this.folderNameTextField.getText());
    }

    @Override
    public WizardPanel next() {
        FolderInfo folderInfo = FolderInfoFactory.newTopFolder(this.folderNameTextField.getText().trim());
        this.getWizardContext().setAttribute("disklocation.folder_info", folderInfo);
        this.getWizardContext().setAttribute("disklocation.sync_profile", this.syncProfileSelectorPanel.getSyncProfile());
        this.getWizardContext().setAttribute("disklocation.prompt_text", Translation.get("wizard.what_to_do.invite.select_local"));
        TextPanelPanel textPanelPanel = new TextPanelPanel(this.getController(), Translation.get("wizard.setup_success"), Translation.get("wizard.success_join"));
        this.getWizardContext().setAttribute("successpanel", textPanelPanel);
        return new FolderCreatePanel(this.getController());
    }

    @Override
    protected JPanel buildContent() {
        FormLayout formLayout = new FormLayout("right:pref, 3dlu, 140dlu, pref:grow", "pref, 3dlu, pref, 3dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)new JLabel(Translation.get("file_info.name")), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.folderNameTextField, cellConstraints.xy(3, 1));
        if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
            panelBuilder.add((Component)new JLabel(Translation.get("general.transfer_mode")), cellConstraints.xy(1, 3));
            JPanel jPanel = (JPanel)this.syncProfileSelectorPanel.getUIComponent();
            jPanel.setOpaque(false);
            panelBuilder.add((Component)jPanel, cellConstraints.xyw(3, 3, 2));
        }
        return panelBuilder.getPanel();
    }

    @Override
    protected void initComponents() {
        this.folderNameTextField = SimpleComponentFactory.createTextField(true);
        String string = (String)this.getWizardContext().getAttribute("disklocation.initial_folder_name");
        if (string != null) {
            this.folderNameTextField.setText(string);
        }
        this.folderNameTextField.addKeyListener(new MyKeyListener());
        Object object = this.getWizardContext().getAttribute("disklocation.sync_profile");
        this.syncProfileSelectorPanel = object != null && object instanceof SyncProfile ? new SyncProfileSelectorPanel(this.getController(), (SyncProfile)object) : new SyncProfileSelectorPanel(this.getController());
    }

    @Override
    protected String getTitle() {
        return Translation.get("wizard.folder_setup.title");
    }

    private class MyKeyListener
    implements KeyListener {
        private MyKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            FolderSetupPanel.this.updateButtons();
        }
    }
}

