/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.event.FolderRepositoryAdapter;
import de.dal33t.powerfolder.event.FolderRepositoryEvent;
import de.dal33t.powerfolder.event.FolderRepositoryListener;
import de.dal33t.powerfolder.security.Account;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.ui.widget.ActionLabel;
import de.dal33t.powerfolder.ui.wizard.FolderCreateItem;
import de.dal33t.powerfolder.ui.wizard.FolderCreatePanel;
import de.dal33t.powerfolder.ui.wizard.PFWizardPanel;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StreamUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.UserDirectories;
import de.dal33t.powerfolder.util.UserDirectory;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.os.OSUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import jwf.WizardPanel;

public class DesktopSyncSetupPanel
extends PFWizardPanel {
    private static final Logger LOG = Logger.getLogger(DesktopSyncSetupPanel.class.getName());
    private static final String WALLPAPER_CHANGER_EXE = "WallpaperChanger.exe";
    private static final String WALLPAPERS_DIR = "wallpapers";
    private WizardPanel nextPanel;
    private JTextArea infoLabel;
    private ActionLabel agreeLabel;
    private ActionLabel skipLabel;
    private JCheckBox wallpaperBox;
    private boolean agreed;
    private UserDirectory desktopDir;
    private ServerClient client;
    private FolderRepositoryListener postProcessor;

    public DesktopSyncSetupPanel(Controller controller, WizardPanel wizardPanel, ServerClient serverClient) {
        super(controller);
        Reject.ifNull(wizardPanel, "Nextpanel is null");
        Reject.ifNull(serverClient, "Client");
        this.nextPanel = wizardPanel;
        this.agreed = false;
        this.client = serverClient;
    }

    public static WizardPanel insertStepIfAvailable(Controller controller, WizardPanel wizardPanel, ServerClient serverClient) {
        boolean bl;
        if (!DesktopSyncSetupPanel.offerOption(controller)) {
            return wizardPanel;
        }
        Reject.ifNull(serverClient, "Client");
        if (!serverClient.isAllowedToCreateFolders()) {
            return wizardPanel;
        }
        boolean bl2 = bl = UserDirectories.getDesktopDirectory() != null;
        if (!bl) {
            return wizardPanel;
        }
        wizardPanel = new DesktopSyncSetupPanel(controller, wizardPanel, serverClient);
        return wizardPanel;
    }

    public static boolean offerOption(Controller controller) {
        return DesktopSyncSetupPanel.isFirstTime(controller) && ConfigurationEntry.SHOW_DESKTOP_SYNC_OPTION.getValueBoolean(controller) != false;
    }

    private static boolean isFirstTime(Controller controller) {
        return controller.getPreferences().getBoolean("openwizard_desktop", true);
    }

    private void setFirstTime() {
        this.getController().getPreferences().putBoolean("openwizard_desktop", false);
    }

    @Override
    protected void afterDisplay() {
        super.afterDisplay();
        this.setFirstTime();
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public WizardPanel next() {
        if (!this.agreed) {
            return this.nextPanel;
        }
        return new FolderCreatePanel(this.getController());
    }

    @Override
    protected String getTitle() {
        return Translation.get("wizard.desktop_sync.title");
    }

    @Override
    protected JComponent buildContent() {
        FormLayout formLayout = new FormLayout("9dlu, 120dlu:grow", "pref, 9dlu, pref, 1dlu, pref, 10dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setBorder(this.createFewContentBorder());
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.add((Component)this.infoLabel, cellConstraints.xyw(1, n, 2));
        panelBuilder.add((Component)this.agreeLabel.getUIComponent(), cellConstraints.xyw(1, n += 2, 2));
        panelBuilder.add((Component)this.wallpaperBox, cellConstraints.xyw(2, n += 2, 1));
        panelBuilder.add((Component)this.skipLabel.getUIComponent(), cellConstraints.xyw(2, n += 2, 1));
        n += 2;
        return panelBuilder.getPanel();
    }

    @Override
    protected void initComponents() {
        this.infoLabel = new JTextArea(Translation.get("wizard.desktop_sync.info_text"));
        this.infoLabel.setEditable(false);
        this.infoLabel.setCursor(null);
        this.infoLabel.setOpaque(false);
        this.infoLabel.setFocusable(false);
        this.infoLabel.setFont(UIManager.getFont("Label.font"));
        this.infoLabel.setEditable(false);
        this.infoLabel.setOpaque(false);
        this.infoLabel.setWrapStyleWord(true);
        this.infoLabel.setLineWrap(true);
        this.agreeLabel = new ActionLabel(this.getController(), new AgreeAction(this.getController()));
        this.agreeLabel.convertToBigLabel();
        Account account = this.client.getAccount();
        boolean bl = account == null || !account.isProUser();
        this.wallpaperBox = SimpleComponentFactory.createCheckBox(Translation.get("wizard.desktop_sync.wallpaper"));
        this.wallpaperBox.setSelected(bl && this.setWallpaperAvailable());
        this.wallpaperBox.setVisible(this.setWallpaperAvailable());
        this.skipLabel = new ActionLabel(this.getController(), new SkipAction(this.getController()));
        this.skipLabel.convertToBigLabel();
        this.skipLabel.setIcon(null);
    }

    private boolean setWallpaperAvailable() {
        return (OSUtil.isWindowsSystem() || OSUtil.isMacOS()) && ConfigurationEntry.SHOW_WALLPAPER_OPTION.getValueBoolean(this.getController()) != false;
    }

    private synchronized void setWallpaper() {
        String[] stringArray;
        Object object;
        Path path = Controller.getTempFilesLocation().resolve(WALLPAPERS_DIR);
        try {
            path = Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            LOG.warning("Unable to create temporary directory for wallpapers at " + path + ". " + iOException);
            return;
        }
        Path path2 = path.resolve(WALLPAPER_CHANGER_EXE);
        path2.toFile().deleteOnExit();
        Util.copyResourceTo(WALLPAPER_CHANGER_EXE, WALLPAPERS_DIR, path2, true, true);
        if (path2 == null || Files.notExists(path2, new LinkOption[0])) {
            LOG.warning("Unable to install helper at " + path2);
            return;
        }
        Util.copyResourceTo("7.png", WALLPAPERS_DIR, path.resolve("7.png"), true, true);
        Util.copyResourceTo("9.png", WALLPAPERS_DIR, path.resolve("9.png"), true, true);
        Path path3 = path.resolve("9.png");
        LOG.fine("Setting Desktop wallpaper to " + path.toAbsolutePath());
        if (OSUtil.isWindowsSystem()) {
            object = "\"" + path2.toAbsolutePath().toString() + "\"";
            object = (String)object + " \"";
            object = (String)object + path.toAbsolutePath();
            object = (String)object + "\"";
            object = (String)object + " 2";
            object = (String)object + " \"";
            object = (String)object + path.toAbsolutePath();
            object = (String)object + "\"";
            stringArray = new String[]{object};
        } else if (OSUtil.isMacOS() && Files.exists(path3, new LinkOption[0])) {
            object = "tell application \"Finder\" to set desktop picture to POSIX file";
            object = (String)object + " \"";
            object = (String)object + path3.toAbsolutePath().toString();
            object = (String)object + "\"";
            object = (String)object;
            stringArray = new String[]{"osascript", "-e", object};
        } else {
            LOG.warning("Unable to set wallpaper. dir: " + path + " file: " + path3);
            return;
        }
        LOG.fine("Executing command " + Arrays.asList(stringArray));
        try {
            object = Runtime.getRuntime().exec(stringArray);
            this.getController().schedule(() -> DesktopSyncSetupPanel.lambda$setWallpaper$0((Process)object), 20000L);
            byte[] byArray = StreamUtils.readIntoByteArray(((Process)object).getInputStream());
            Object object2 = new String(byArray);
            byte[] byArray2 = StreamUtils.readIntoByteArray(((Process)object).getErrorStream());
            Object object3 = new String(byArray2);
            int n = ((Process)object).waitFor();
            byArray = StreamUtils.readIntoByteArray(((Process)object).getInputStream());
            object2 = (String)object2 + new String(byArray);
            byArray2 = StreamUtils.readIntoByteArray(((Process)object).getErrorStream());
            object3 = (String)object3 + new String(byArray2);
            if (n == 0) {
                LOG.info("Desktop wallpaper successfully set");
            } else {
                LOG.warning("Failed to set Desktop wallpaper: " + (String)object3);
            }
        }
        catch (Exception exception) {
            LOG.info("Failed to set Desktop wallpaper " + exception);
        }
    }

    private static /* synthetic */ void lambda$setWallpaper$0(Process process) {
        process.destroy();
    }

    private class AgreeAction
    extends BaseAction {
        protected AgreeAction(Controller controller) {
            super("action_desktop_sync.agree", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            DesktopSyncSetupPanel.this.agreed = true;
            DesktopSyncSetupPanel.this.getWizardContext().setAttribute("successpanel", DesktopSyncSetupPanel.this.nextPanel);
            DesktopSyncSetupPanel.this.getWizardContext().setAttribute("folder_create.backup_by_os", true);
            DesktopSyncSetupPanel.this.desktopDir = UserDirectories.getDesktopDirectory();
            FolderCreateItem folderCreateItem = new FolderCreateItem(DesktopSyncSetupPanel.this.desktopDir.getDirectory());
            DesktopSyncSetupPanel.this.getWizardContext().setAttribute("disklocation.folder_create_items", Collections.singletonList(folderCreateItem));
            boolean bl2 = bl = this.getController().getFolderRepository().findExistingFolder(DesktopSyncSetupPanel.this.desktopDir.getDirectory()) != null;
            if (!bl) {
                DesktopSyncSetupPanel.this.postProcessor = new FolderCreatePostProcessor();
                this.getController().getFolderRepository().addFolderRepositoryListener(DesktopSyncSetupPanel.this.postProcessor);
            }
            if (DesktopSyncSetupPanel.this.wallpaperBox.isSelected()) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        DesktopSyncSetupPanel.this.setWallpaper();
                    }
                };
                this.getController().getIOProvider().startIO(runnable);
            }
            DesktopSyncSetupPanel.this.getWizard().next();
        }
    }

    private class SkipAction
    extends BaseAction {
        protected SkipAction(Controller controller) {
            super("action_desktop_sync.skip", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DesktopSyncSetupPanel.this.getWizard().next();
        }
    }

    private class FolderCreatePostProcessor
    extends FolderRepositoryAdapter {
        private FolderCreatePostProcessor() {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }

        @Override
        public void folderCreated(FolderRepositoryEvent folderRepositoryEvent) {
            if (!folderRepositoryEvent.getFolder().getCommitOrLocalDir().equals(DesktopSyncSetupPanel.this.desktopDir.getDirectory())) {
                return;
            }
            folderRepositoryEvent.getFolder().addPattern("*.lnk");
            DesktopSyncSetupPanel.this.getController().getFolderRepository().removeFolderRepositoryListener(DesktopSyncSetupPanel.this.postProcessor);
        }

        @Override
        public void folderMoved(FolderRepositoryEvent folderRepositoryEvent) {
            this.folderCreated(folderRepositoryEvent);
        }
    }
}

