/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.util;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.Sizes;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.os.OSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class UIUtil {
    private static final Logger log = Logger.getLogger(UIUtil.class.getName());
    public static final int MED_FONT_SIZE = 15;
    public static final String UIMANAGER_LOOK_N_FEEL_PROPERTY = "lookAndFeel";
    public static final String UIMANAGER_DARK_CONTROL_SHADOW_COLOR_PROPERTY = "controlDkShadow";

    private UIUtil() {
    }

    public static void setFontSize(JLabel jLabel, int n) {
        SimpleComponentFactory.setFont(jLabel, n, jLabel.getFont().getStyle());
    }

    public static void setFontStyle(JLabel jLabel, int n) {
        SimpleComponentFactory.setFont(jLabel, jLabel.getFont().getSize(), n);
    }

    public static void invokeAndWaitInEDT(Runnable runnable) throws InterruptedException {
        Reject.ifNull(runnable, "Task is null");
        if (!Util.isAwtAvailable() || SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)invocationTargetException.getCause();
                }
                throw new RuntimeException("Exception while executing in event dispatcher thread", invocationTargetException.getCause());
            }
        }
    }

    public static void invokeLaterInEDT(Runnable runnable) {
        Reject.ifNull(runnable, "Task is null");
        if (Util.isAwtAvailable()) {
            SwingUtilities.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    public static JTable whiteStripTable(JTable jTable) {
        jTable.getParent().setBackground(Color.WHITE);
        return jTable;
    }

    public static Window getParentWindow(ActionEvent actionEvent) {
        if (!(actionEvent.getSource() instanceof Component)) {
            return null;
        }
        Component component = (Component)actionEvent.getSource();
        while (component.getParent() != null) {
            if (component instanceof Window) {
                return (Window)component;
            }
            component = component.getParent();
        }
        if (component instanceof Window) {
            return (Window)component;
        }
        return null;
    }

    public static JComponent setZeroHeight(JComponent jComponent) {
        Dimension dimension = jComponent.getPreferredSize();
        dimension.height = 0;
        jComponent.setPreferredSize(dimension);
        return jComponent;
    }

    public static JComponent removeBorder(JComponent jComponent) {
        jComponent.setBorder(Borders.EMPTY_BORDER);
        return jComponent;
    }

    public static JComponent setZeroWidth(JComponent jComponent) {
        Dimension dimension = jComponent.getPreferredSize();
        dimension.width = 0;
        jComponent.setPreferredSize(dimension);
        return jComponent;
    }

    public static void addUIChangeTask(final Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("Task is null");
        }
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (UIUtil.UIMANAGER_LOOK_N_FEEL_PROPERTY.equals(propertyChangeEvent.getPropertyName())) {
                    log.warning("UIManager changed l&f, executing task: " + runnable);
                    runnable.run();
                }
            }
        });
    }

    public static final int toModel(JTable jTable, int n) {
        if (n >= jTable.getColumnCount()) {
            return -1;
        }
        return jTable.getColumnModel().getColumn(n).getModelIndex();
    }

    public static Object getUserObject(Object object) {
        Object object2 = object;
        if (object instanceof DefaultMutableTreeNode) {
            object2 = ((DefaultMutableTreeNode)object).getUserObject();
        }
        return object2 != null ? object2 : object;
    }

    public static TreePath getPathTo(TreeNode treeNode) {
        Reject.ifNull(treeNode, "TreeNode is null");
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        TreeNode treeNode2 = treeNode;
        do {
            arrayList.add(0, treeNode2);
        } while ((treeNode2 = treeNode2.getParent()) != null);
        Object[] objectArray = new Object[arrayList.size()];
        arrayList.toArray(objectArray);
        return new TreePath(objectArray);
    }

    public static void ensureMinimumWidth(int n, JComponent jComponent) {
        Dimension dimension = jComponent.getPreferredSize();
        dimension.width = Sizes.dialogUnitXAsPixel(n, jComponent);
        jComponent.setPreferredSize(dimension);
    }

    public static void applyTranslucency(Window window, Float f) {
        window.setOpacity(f.floatValue());
    }

    public static void putOnScreen(JFrame jFrame) {
        if (jFrame.getWidth() <= 0 || jFrame.getHeight() <= 0) {
            jFrame.pack();
            int n = Math.max(jFrame.getWidth(), 600);
            int n2 = Math.max(jFrame.getHeight(), 400);
            jFrame.setSize(n, n2);
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (jFrame.getX() < 0) {
            jFrame.setLocation(0, jFrame.getY());
        }
        if (jFrame.getY() < 0) {
            jFrame.setLocation(jFrame.getX(), 0);
        }
        if (jFrame.getX() > dimension.width) {
            jFrame.setLocation(dimension.width - jFrame.getWidth(), jFrame.getY());
        }
        if (jFrame.getY() > dimension.height) {
            jFrame.setLocation(0, dimension.height - jFrame.getHeight());
        }
    }

    public static void putOnScreen(JDialog jDialog) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (jDialog.getX() < 0) {
            jDialog.setLocation(0, jDialog.getY());
        }
        if (jDialog.getY() < 0) {
            jDialog.setLocation(jDialog.getX(), 0);
        }
        if (jDialog.getX() > dimension.width) {
            jDialog.setLocation(dimension.width - jDialog.getWidth(), jDialog.getY());
        }
        if (jDialog.getY() > dimension.height) {
            jDialog.setLocation(0, dimension.height - jDialog.getHeight());
        }
    }

    public static void setMacDockImage(Image image) {
        if (!OSUtil.isMacOS()) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("com.apple.eawt.Application");
            Method method = clazz.getMethod("getApplication", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            Method method2 = clazz.getMethod("setDockIconImage", Image.class);
            method2.invoke(object, image);
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Unable to dock image. " + exception, exception);
        }
    }

    public static int getScreenWidthAllMonitors() {
        try {
            GraphicsDevice[] graphicsDeviceArray;
            int n = 0;
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice graphicsDevice : graphicsDeviceArray = graphicsEnvironment.getScreenDevices()) {
                DisplayMode displayMode = graphicsDevice.getDisplayMode();
                n += displayMode.getWidth();
            }
            return n;
        }
        catch (Exception exception) {
            log.warning("Unable to get screen configuration. " + exception);
            return Toolkit.getDefaultToolkit().getScreenSize().width;
        }
    }
}

