/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.preferences;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Constants;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.model.ApplicationModel;
import de.dal33t.powerfolder.ui.preferences.PreferenceTab;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WarningsNotificationsSettingsTab
extends PFComponent
implements PreferenceTab {
    private JCheckBox showSystemNotificationBox;
    private JSlider notificationTranslucentSlider;
    private JSlider notificationDisplaySlider;
    private JCheckBox showPauseOptionsCB;
    private JCheckBox warnOnNoDirectConnectivityCB;
    private JCheckBox warnOnPossibleFilenameProblemsCB;
    private JCheckBox warnOnCloseIfNotInSyncCB;
    private JCheckBox warnIfCloudSpaceFullCB;
    private JPanel panel;
    private boolean needsRestart;
    private ApplicationModel applicationModel;
    private JCheckBox folderSyncCB;
    private JLabel folderSyncLabel;
    private JSlider folderSyncSlider;

    public WarningsNotificationsSettingsTab(Controller controller) {
        super(controller);
        this.initComponents();
    }

    @Override
    public String getTabName() {
        return Translation.get("exp.preferences.warnings_notifications.title");
    }

    @Override
    public boolean needsRestart() {
        return this.needsRestart;
    }

    @Override
    public void undoChanges() {
    }

    @Override
    public boolean validate() {
        return true;
    }

    private void initComponents() {
        boolean bl;
        this.applicationModel = this.getController().getUIController().getApplicationModel();
        this.showSystemNotificationBox = new JCheckBox(Translation.get("exp.preferences.warnings_notifications.show_system_notifications"));
        this.showSystemNotificationBox.setSelected((Boolean)this.applicationModel.getSystemNotificationsValueModel().getValue());
        this.showPauseOptionsCB = new JCheckBox(Translation.get("exp.preferences.warnings_notifications.show_pause_options"));
        this.showPauseOptionsCB.setSelected(PreferencesEntry.SHOW_ASK_FOR_PAUSE.getValueBoolean(this.getController()));
        this.folderSyncSlider = new JSlider();
        this.folderSyncSlider.setMinimum(1);
        this.folderSyncSlider.setMaximum(30);
        this.folderSyncSlider.setValue(ConfigurationEntry.FOLDER_SYNC_WARN_SECONDS.getValueInt(this.getController()) / 60 / 60 / 24);
        this.folderSyncSlider.setMinorTickSpacing(1);
        this.folderSyncSlider.setPaintTicks(true);
        this.folderSyncSlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        ((Dictionary)hashtable).put(1, new JLabel("1"));
        ((Dictionary)hashtable).put(10, new JLabel("10"));
        ((Dictionary)hashtable).put(20, new JLabel("20"));
        ((Dictionary)hashtable).put(30, new JLabel("30"));
        this.folderSyncSlider.setLabelTable(hashtable);
        this.folderSyncLabel = new JLabel(Translation.get("exp.preferences.warnings_notifications.folder_sync_text"));
        this.notificationDisplaySlider = new JSlider();
        this.notificationDisplaySlider.setMinimum(0);
        this.notificationDisplaySlider.setMaximum(30);
        this.notificationDisplaySlider.setValue(PreferencesEntry.NOTIFICATION_DISPLAY.getValueInt(this.getController()));
        this.notificationDisplaySlider.setMajorTickSpacing(5);
        this.notificationDisplaySlider.setMinorTickSpacing(1);
        this.notificationDisplaySlider.setPaintTicks(true);
        this.notificationDisplaySlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> hashtable2 = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 30; i += this.notificationDisplaySlider.getMajorTickSpacing()) {
            ((Dictionary)hashtable2).put(i, new JLabel(Integer.toString(i)));
        }
        this.notificationDisplaySlider.setLabelTable(hashtable2);
        this.notificationTranslucentSlider = new JSlider();
        this.notificationTranslucentSlider.setMinimum(0);
        this.notificationTranslucentSlider.setMaximum(80);
        this.notificationTranslucentSlider.setValue(PreferencesEntry.NOTIFICATION_TRANSLUCENT.getValueInt(this.getController()));
        this.notificationTranslucentSlider.setMajorTickSpacing(20);
        this.notificationTranslucentSlider.setMinorTickSpacing(5);
        this.notificationTranslucentSlider.setPaintTicks(true);
        this.notificationTranslucentSlider.setPaintLabels(true);
        this.folderSyncCB = new JCheckBox(Translation.get("exp.preferences.warnings_notifications.folder_sync_warn_use"), (boolean)ConfigurationEntry.FOLDER_SYNC_USE.getValueBoolean(this.getController()));
        this.folderSyncCB.addChangeListener(new FolderChangeListener());
        Hashtable<Integer, JLabel> hashtable3 = new Hashtable<Integer, JLabel>();
        for (bl = false; bl <= 80 != 0; bl += this.notificationTranslucentSlider.getMajorTickSpacing()) {
            ((Dictionary)hashtable3).put(bl ? 1 : 0, new JLabel(Integer.toString(bl ? 1 : 0) + "%"));
        }
        this.notificationTranslucentSlider.setLabelTable(hashtable3);
        bl = PreferencesEntry.WARN_ON_NO_DIRECT_CONNECTIVITY.getValueBoolean(this.getController());
        boolean bl2 = PreferencesEntry.WARN_ON_CLOSE.getValueBoolean(this.getController());
        boolean bl3 = PreferencesEntry.FILE_NAME_CHECK.getValueBoolean(this.getController());
        boolean bl4 = PreferencesEntry.WARN_FULL_CLOUD.getValueBoolean(this.getController());
        this.warnOnCloseIfNotInSyncCB = new JCheckBox(Translation.get("exp.preferences.warnings_notifications.warn_on_close_if_not_in_sync"), bl2);
        this.warnOnNoDirectConnectivityCB = new JCheckBox(Translation.get("exp.preferences.warnings_notifications.warn_on_no_direct_connectivity"), bl);
        this.warnOnPossibleFilenameProblemsCB = new JCheckBox(Translation.get("exp.preferences.warnings_notifications.warn_on_possible_file_name_problems"), bl3);
        this.warnIfCloudSpaceFullCB = new JCheckBox(Translation.get("exp.preferences.warnings_notifications.warn_if_cloud_space_full"), bl4);
        this.doFolderChangeEvent();
    }

    @Override
    public JPanel getUIPanel() {
        if (this.panel == null) {
            FormLayout formLayout = new FormLayout("right:pref, 3dlu, 140dlu, pref:grow", "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu");
            PanelBuilder panelBuilder = new PanelBuilder(formLayout);
            panelBuilder.setBorder(Borders.createEmptyBorder("3dlu, 3dlu, 3dlu, 3dlu"));
            CellConstraints cellConstraints = new CellConstraints();
            int n = 1;
            panelBuilder.add((Component)this.showPauseOptionsCB, cellConstraints.xyw(3, n, 2));
            panelBuilder.add((Component)this.warnIfCloudSpaceFullCB, cellConstraints.xyw(3, n += 2, 2));
            panelBuilder.add((Component)this.warnOnNoDirectConnectivityCB, cellConstraints.xyw(3, n += 2, 2));
            panelBuilder.add((Component)this.warnOnCloseIfNotInSyncCB, cellConstraints.xyw(3, n += 2, 2));
            panelBuilder.add((Component)this.warnOnPossibleFilenameProblemsCB, cellConstraints.xyw(3, n += 2, 2));
            panelBuilder.add((Component)this.folderSyncCB, cellConstraints.xyw(3, n += 2, 2));
            panelBuilder.add((Component)this.folderSyncLabel, cellConstraints.xy(1, n += 2));
            panelBuilder.add((Component)this.folderSyncSlider, cellConstraints.xy(3, n));
            panelBuilder.addSeparator(Translation.get("exp.preferences.warnings_notifications.notifications"), cellConstraints.xyw(1, n += 2, 3));
            panelBuilder.add((Component)this.showSystemNotificationBox, cellConstraints.xyw(3, n += 2, 2));
            if (Constants.OPACITY_SUPPORTED) {
                panelBuilder.addLabel(Translation.get("exp.preferences.warnings_notifications.notification_translucency"), cellConstraints.xy(1, n += 2));
                panelBuilder.add(this.createNotificationTranslucentSpinnerPanel(), cellConstraints.xyw(3, n, 2));
            }
            panelBuilder.addLabel(Translation.get("exp.preferences.warnings_notifications.notification_delay"), cellConstraints.xy(1, n += 2));
            panelBuilder.add(this.createNotificationDisplaySpinnerPanel(), cellConstraints.xyw(3, n, 2));
            this.panel = panelBuilder.getPanel();
        }
        return this.panel;
    }

    private void doFolderChangeEvent() {
        this.folderSyncLabel.setEnabled(this.folderSyncCB.isSelected());
        this.folderSyncSlider.setEnabled(this.folderSyncCB.isSelected());
    }

    private Component createNotificationDisplaySpinnerPanel() {
        FormLayout formLayout = new FormLayout("140dlu, 3dlu, pref, pref:grow", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.notificationDisplaySlider, cellConstraints.xy(1, 1));
        JButton jButton = new JButton(new PreviewAction(this.getController()));
        panelBuilder.add((Component)jButton, cellConstraints.xy(3, 1));
        return panelBuilder.getPanel();
    }

    private Component createNotificationTranslucentSpinnerPanel() {
        FormLayout formLayout = new FormLayout("140dlu, pref:grow", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.notificationTranslucentSlider, cellConstraints.xy(1, 1));
        return panelBuilder.getPanel();
    }

    @Override
    public void save() {
        boolean bl = this.warnOnNoDirectConnectivityCB.isSelected();
        boolean bl2 = this.warnOnCloseIfNotInSyncCB.isSelected();
        boolean bl3 = this.warnOnPossibleFilenameProblemsCB.isSelected();
        boolean bl4 = this.warnIfCloudSpaceFullCB.isSelected();
        if (this.showSystemNotificationBox != null) {
            this.applicationModel.getSystemNotificationsValueModel().setValue(this.showSystemNotificationBox.isSelected());
        }
        PreferencesEntry.NOTIFICATION_TRANSLUCENT.setValue(this.getController(), this.notificationTranslucentSlider.getValue());
        PreferencesEntry.SHOW_ASK_FOR_PAUSE.setValue(this.getController(), this.showPauseOptionsCB.isSelected());
        PreferencesEntry.NOTIFICATION_DISPLAY.setValue(this.getController(), this.notificationDisplaySlider.getValue());
        PreferencesEntry.WARN_ON_NO_DIRECT_CONNECTIVITY.setValue(this.getController(), bl);
        PreferencesEntry.WARN_ON_CLOSE.setValue(this.getController(), bl2);
        PreferencesEntry.WARN_FULL_CLOUD.setValue(this.getController(), bl4);
        PreferencesEntry.FILE_NAME_CHECK.setValue(this.getController(), bl3);
        ConfigurationEntry.FOLDER_SYNC_USE.setValue(this.getController(), String.valueOf(this.folderSyncCB.isSelected()));
        ConfigurationEntry.FOLDER_SYNC_WARN_SECONDS.setValue(this.getController(), String.valueOf(this.folderSyncSlider.getValue() * 60 * 60 * 24));
    }

    private class FolderChangeListener
    implements ChangeListener {
        private FolderChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            WarningsNotificationsSettingsTab.this.doFolderChangeEvent();
        }
    }

    private class PreviewAction
    extends BaseAction {
        private PreviewAction(Controller controller) {
            super("exp.action_preview", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Integer n = PreferencesEntry.NOTIFICATION_DISPLAY.getValueInt(this.getController());
            Integer n2 = PreferencesEntry.NOTIFICATION_TRANSLUCENT.getValueInt(this.getController());
            PreferencesEntry.NOTIFICATION_DISPLAY.setValue(this.getController(), WarningsNotificationsSettingsTab.this.notificationDisplaySlider.getValue());
            PreferencesEntry.NOTIFICATION_TRANSLUCENT.setValue(this.getController(), WarningsNotificationsSettingsTab.this.notificationTranslucentSlider.getValue());
            this.getController().getUIController().previewMessage(Translation.get("exp.preferences.warnings_notifications.notification_preview_title"), Translation.get("exp.preferences.warnings_notifications.notification_preview_text"));
            PreferencesEntry.NOTIFICATION_DISPLAY.setValue(this.getController(), n);
            PreferencesEntry.NOTIFICATION_TRANSLUCENT.setValue(this.getController(), n2);
        }
    }
}

