/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.preferences;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.NetworkingMode;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.transfer.TransferManager;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.panel.LineSpeedSelectionPanel;
import de.dal33t.powerfolder.ui.preferences.HTTPProxySettingsDialog;
import de.dal33t.powerfolder.ui.preferences.LANList;
import de.dal33t.powerfolder.ui.preferences.PreferenceTab;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.net.UDTSocket;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class NetworkSettingsTab
extends PFComponent
implements PreferenceTab {
    private JPanel panel;
    private JComboBox<String> networkingModeCombo;
    private JCheckBox relayedConnectionCB;
    private JCheckBox udtConnectionCB;
    private LineSpeedSelectionPanel wanSpeed;
    private LineSpeedSelectionPanel lanSpeed;
    private JButton httpProxyButton;
    private JCheckBox randomPortCB;
    private JTextField advPortTF;
    private JCheckBox openPortCB;
    private JComboBox bindAddressCombo;
    private LANList lanList;
    private boolean needsRestart;

    public NetworkSettingsTab(Controller controller) {
        super(controller);
        this.initComponents();
    }

    @Override
    public String getTabName() {
        return Translation.get("exp.preferences.network.title");
    }

    @Override
    public boolean needsRestart() {
        return this.needsRestart;
    }

    @Override
    public void undoChanges() {
    }

    @Override
    public boolean validate() {
        return true;
    }

    private void initComponents() {
        String[] stringArray = new String[NetworkingMode.values().length];
        stringArray[NetworkingMode.PRIVATEMODE.ordinal()] = Translation.get("general.network_mode.private");
        stringArray[NetworkingMode.LANONLYMODE.ordinal()] = Translation.get("general.network_mode.lan_only");
        stringArray[NetworkingMode.SERVERONLYMODE.ordinal()] = Translation.get("general.network_mode.server_only");
        this.networkingModeCombo = new JComboBox<String>(stringArray);
        NetworkingMode networkingMode = this.getController().getNetworkingMode();
        String string = NetworkSettingsTab.getTooltip(networkingMode);
        this.networkingModeCombo.setSelectedIndex(networkingMode.ordinal());
        this.networkingModeCombo.setToolTipText(string);
        this.networkingModeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NetworkingMode networkingMode = NetworkingMode.values()[NetworkSettingsTab.this.networkingModeCombo.getSelectedIndex()];
                NetworkSettingsTab.this.networkingModeCombo.setToolTipText(NetworkSettingsTab.getTooltip(networkingMode));
                NetworkSettingsTab.this.enableDisableComponents(NetworkingMode.LANONLYMODE == networkingMode);
            }
        });
        String string2 = ConfigurationEntry.NET_PORT.getValue(this.getController());
        if (string2 == null) {
            string2 = Integer.toString(1337);
        }
        this.advPortTF = new JTextField(string2){

            @Override
            protected Document createDefaultModel() {
                return new NumberAndCommaDocument();
            }
        };
        this.advPortTF.setToolTipText(Translation.get("exp.preferences.network.adv_port_tooltip"));
        this.randomPortCB = SimpleComponentFactory.createCheckBox(Translation.get("exp.preferences.network.random_port"));
        this.randomPortCB.setToolTipText(Translation.get("exp.preferences.network.random_port_tooltip"));
        this.randomPortCB.setSelected(ConfigurationEntry.NET_BIND_RANDOM_PORT.getValueBoolean(this.getController()));
        this.advPortTF.setEnabled(!this.randomPortCB.isSelected());
        this.randomPortCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NetworkSettingsTab.this.advPortTF.setEnabled(!NetworkSettingsTab.this.randomPortCB.isSelected());
            }
        });
        this.relayedConnectionCB = SimpleComponentFactory.createCheckBox(Translation.get("exp.preferences.network.use_relayed_connections"));
        this.relayedConnectionCB.setSelected(ConfigurationEntry.RELAYED_CONNECTIONS_ENABLED.getValueBoolean(this.getController()));
        this.udtConnectionCB = SimpleComponentFactory.createCheckBox(Translation.get("exp.preferences.network.use_udt_connection"));
        this.udtConnectionCB.setSelected(ConfigurationEntry.UDT_CONNECTIONS_ENABLED.getValueBoolean(this.getController()));
        HttpProxyAction httpProxyAction = new HttpProxyAction(this.getController());
        this.httpProxyButton = new JButton(httpProxyAction);
        this.wanSpeed = new LineSpeedSelectionPanel(this.getController(), true, true);
        this.lanSpeed = new LineSpeedSelectionPanel(this.getController(), false, true);
        this.enableDisableComponents(this.getController().isLanOnly());
        TransferManager transferManager = this.getController().getTransferManager();
        this.wanSpeed.setSpeedKBPS(ConfigurationEntry.TRANSFER_LIMIT_AUTODETECT.getValueBoolean(this.getController()), transferManager.getUploadCPSForWAN() / 1024L, transferManager.getDownloadCPSForWAN() / 1024L);
        this.lanSpeed.setSpeedKBPS(false, transferManager.getUploadCPSForLAN() / 1024L, transferManager.getDownloadCPSForLAN() / 1024L);
        String string3 = ConfigurationEntry.NET_BIND_ADDRESS.getValueArray(this.getController())[0];
        this.bindAddressCombo = new JComboBox();
        this.bindAddressCombo.addItem(Translation.get("exp.preferences.network.bind_any"));
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (!(inetAddress instanceof Inet4Address)) continue;
                    this.bindAddressCombo.addItem(new InterfaceChoice(networkInterface, inetAddress));
                    if (StringUtils.isEmpty(string3) || !inetAddress.getHostAddress().equals(string3)) continue;
                    this.bindAddressCombo.setSelectedIndex(this.bindAddressCombo.getItemCount() - 1);
                }
            }
        }
        catch (SocketException socketException) {
            this.logWarning("SocketException. " + socketException);
        }
        catch (Error error) {
            this.logWarning("Error. " + error);
        }
        this.lanList = new LANList(this.getController());
        this.lanList.load();
    }

    private void enableDisableComponents(boolean bl) {
        this.relayedConnectionCB.setEnabled(!bl);
        this.udtConnectionCB.setEnabled(!bl && UDTSocket.isSupported());
        this.udtConnectionCB.setVisible(UDTSocket.isSupported());
        this.wanSpeed.setEnabled(!bl);
    }

    @Override
    public JPanel getUIPanel() {
        if (this.panel == null) {
            FormLayout formLayout = new FormLayout("right:pref, 3dlu, 140dlu, pref:grow", "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref");
            PanelBuilder panelBuilder = new PanelBuilder(formLayout);
            panelBuilder.setBorder(Borders.createEmptyBorder("3dlu, 3dlu, 3dlu, 3dlu"));
            CellConstraints cellConstraints = new CellConstraints();
            int n = 1;
            panelBuilder.addLabel(Translation.get("exp.preferences.network_mode_name"), cellConstraints.xy(1, n));
            panelBuilder.add(this.networkingModeCombo, cellConstraints.xy(3, n));
            panelBuilder.add((Component)this.relayedConnectionCB, cellConstraints.xy(3, n += 2));
            panelBuilder.add((Component)this.udtConnectionCB, cellConstraints.xy(3, n += 2));
            panelBuilder.add((Component)ButtonBarFactory.buildLeftAlignedBar(this.httpProxyButton), cellConstraints.xy(3, n += 2));
            panelBuilder.addLabel(Translation.get("exp.preferences.network.line_settings"), cellConstraints.xywh(1, n += 2, 1, 1, "default, top"));
            panelBuilder.add((Component)this.wanSpeed.getUiComponent(), cellConstraints.xyw(3, n, 2));
            panelBuilder.addLabel(Translation.get("exp.preferences.network.lan_line_settings"), cellConstraints.xywh(1, n += 2, 1, 1, "default, top"));
            panelBuilder.add((Component)this.lanSpeed.getUiComponent(), cellConstraints.xyw(3, n, 2));
            panelBuilder.add((Component)this.randomPortCB, cellConstraints.xy(3, n += 2));
            panelBuilder.addLabel(Translation.get("exp.preferences.network.bind"), cellConstraints.xy(1, n += 2)).setToolTipText(Translation.get("exp.preferences.network.bind_tooltip"));
            panelBuilder.add((Component)this.bindAddressCombo, cellConstraints.xy(3, n));
            panelBuilder.addLabel(Translation.get("exp.preferences.network.ip_lan_list"), cellConstraints.xywh(1, n += 2, 1, 1, "default, top"));
            panelBuilder.add((Component)this.lanList.getUIPanel(), cellConstraints.xy(3, n));
            this.panel = panelBuilder.getPanel();
        }
        return this.panel;
    }

    private static Component pairPanel(JComponent jComponent, JComponent jComponent2) {
        FormLayout formLayout = new FormLayout("pref, 3dlu, pref", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)jComponent, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)jComponent2, cellConstraints.xy(3, 1));
        return panelBuilder.getPanel();
    }

    @Override
    public void save() {
        Object object;
        try {
            int n;
            String string = this.advPortTF.getText();
            object = new StringTokenizer(string, ",");
            while (object.hasMoreTokens()) {
                n = Integer.parseInt(object.nextToken());
                if (n >= 0 && n <= 65535) continue;
                throw new NumberFormatException("Port out of range [0,65535]");
            }
            if (ConfigurationEntry.NET_PORT.getValue(this.getController()) == null) {
                try {
                    n = Integer.parseInt(string);
                    if (n != 1337) {
                        this.needsRestart = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!this.needsRestart && !string.equals(ConfigurationEntry.NET_PORT.getValue(this.getController()))) {
                this.needsRestart = true;
            }
            ConfigurationEntry.NET_PORT.setValue(this.getController(), string);
        }
        catch (NumberFormatException numberFormatException) {
            this.logWarning("Unparsable port number");
        }
        boolean bl = ConfigurationEntry.NET_BIND_RANDOM_PORT.getValueBoolean(this.getController());
        if (bl != this.randomPortCB.isSelected()) {
            ConfigurationEntry.NET_BIND_RANDOM_PORT.setValue(this.getController(), String.valueOf(this.randomPortCB.isSelected()));
            this.needsRestart = true;
        }
        object = NetworkingMode.values()[this.networkingModeCombo.getSelectedIndex()];
        this.getController().setNetworkingMode((NetworkingMode)((Object)object));
        TransferManager transferManager = this.getController().getTransferManager();
        ConfigurationEntry.TRANSFER_LIMIT_AUTODETECT.setValue(this.getController(), this.wanSpeed.isAutomatic());
        if (this.wanSpeed.isAutomatic()) {
            this.getController().getIOProvider().startIO(transferManager.getRecalculateAutomaticRate());
        } else {
            transferManager.setUploadCPSForWAN(this.wanSpeed.getUploadSpeedKBPS());
            transferManager.setDownloadCPSForWAN(this.wanSpeed.getDownloadSpeedKBPS());
        }
        transferManager.setUploadCPSForLAN(this.lanSpeed.getUploadSpeedKBPS());
        transferManager.setDownloadCPSForLAN(this.lanSpeed.getDownloadSpeedKBPS());
        ConfigurationEntry.RELAYED_CONNECTIONS_ENABLED.setValue(this.getController(), String.valueOf(this.relayedConnectionCB.isSelected()));
        ConfigurationEntry.UDT_CONNECTIONS_ENABLED.setValue(this.getController(), String.valueOf(this.udtConnectionCB.isSelected()));
        String string = ConfigurationEntry.NET_BIND_ADDRESS.getValueArray(this.getController())[0];
        Object object2 = this.bindAddressCombo.getSelectedItem();
        if (object2 instanceof String) {
            if (!StringUtils.isEmpty(string)) {
                ConfigurationEntry.NET_BIND_ADDRESS.removeValue(this.getController());
                this.needsRestart = true;
            }
        } else {
            InetAddress inetAddress = ((InterfaceChoice)object2).getAddress();
            if (!inetAddress.getHostAddress().equals(string)) {
                ConfigurationEntry.NET_BIND_ADDRESS.setValue(this.getController(), inetAddress.getHostAddress());
                this.needsRestart = true;
            }
        }
        this.needsRestart |= this.lanList.save();
    }

    private static String getTooltip(NetworkingMode networkingMode) {
        if (networkingMode == NetworkingMode.LANONLYMODE) {
            return Translation.get("exp.preferences.network.lan_only_tooltip");
        }
        if (networkingMode == NetworkingMode.PRIVATEMODE) {
            return Translation.get("exp.preferences.network.private_tooltip");
        }
        if (networkingMode == NetworkingMode.SERVERONLYMODE) {
            return Translation.get("exp.preferences.network.server_only_tooltip");
        }
        return null;
    }

    private static class HttpProxyAction
    extends BaseAction {
        private HttpProxyAction(Controller controller) {
            super("action_proxy", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new HTTPProxySettingsDialog(this.getController()).open();
        }
    }

    private static class InterfaceChoice {
        private InetAddress address;
        private String showString;

        private InterfaceChoice(NetworkInterface networkInterface, InetAddress inetAddress) {
            this.address = inetAddress;
            StringBuilder stringBuilder = new StringBuilder();
            if (inetAddress.getAddress() != null) {
                for (int i = 0; i < inetAddress.getAddress().length; ++i) {
                    if (i > 0) {
                        stringBuilder.append('.');
                    }
                    stringBuilder.append(inetAddress.getAddress()[i] & 0xFF);
                }
            }
            stringBuilder.append(" / ");
            if (StringUtils.isNotBlank(networkInterface.getDisplayName())) {
                stringBuilder.append(networkInterface.getDisplayName().trim());
            }
            this.showString = stringBuilder.toString();
        }

        public String toString() {
            return this.showString;
        }

        public InetAddress getAddress() {
            return this.address;
        }
    }

    private static class NumberAndCommaDocument
    extends PlainDocument {
        private NumberAndCommaDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray;
            if (string == null) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (char c : cArray = string.toCharArray()) {
                if (!Character.isDigit(c) && c != ',') continue;
                stringBuilder.append(c);
            }
            super.insertString(n, stringBuilder.toString(), attributeSet);
        }
    }
}

