/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.folder.files.table;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderRepository;
import de.dal33t.powerfolder.disk.dao.FileInfoCriteria;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.DiskItem;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.security.AccessMode;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.transfer.DownloadManager;
import de.dal33t.powerfolder.transfer.TransferManager;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.contextmenu.ShareFileNotificationHandler;
import de.dal33t.powerfolder.ui.information.HasDetailsPanel;
import de.dal33t.powerfolder.ui.information.folder.files.DirectoryFilterListener;
import de.dal33t.powerfolder.ui.information.folder.files.FileDetailsPanel;
import de.dal33t.powerfolder.ui.information.folder.files.FilesTab;
import de.dal33t.powerfolder.ui.information.folder.files.FilteredDirectoryEvent;
import de.dal33t.powerfolder.ui.information.folder.files.FilteredDirectoryModel;
import de.dal33t.powerfolder.ui.information.folder.files.table.FilesTable;
import de.dal33t.powerfolder.ui.information.folder.files.table.FilesTableModel;
import de.dal33t.powerfolder.ui.information.folder.files.versions.FileVersionsPanel;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.ui.widget.ActionLabel;
import de.dal33t.powerfolder.ui.widget.ActivityVisualizationWorker;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.os.OSUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class FilesTablePanel
extends PFUIComponent
implements HasDetailsPanel,
DirectoryFilterListener {
    private JPanel uiComponent;
    private FileDetailsPanel fileDetailsPanel;
    private FileVersionsPanel fileVersionsPanel;
    private JPanel detailsPanel;
    private FilesTableModel tableModel;
    private FilesTable table;
    private OpenFileAction openFileAction;
    private BrowserAction browserAction;
    private DeleteFileAction deleteFileAction;
    private DownloadFileAction downloadFileAction;
    private AbortDownloadAction abortDownloadAction;
    private AddIgnoreAction addIgnoreAction;
    private RemoveIgnoreAction removeIgnoreAction;
    private UnmarkAction unmarkAction;
    private SingleFileTransferAction singleFileTransferAction;
    private RestoreArchiveAction restoreArchiveAction;
    private JPopupMenu fileMenu;
    private JScrollPane tableScroller;
    private JPanel emptyPanel;
    private JLabel emptyLabel;
    private ActionLabel emptyResetLink;
    private FilesTab parent;

    public FilesTablePanel(Controller controller, FilesTab filesTab) {
        super(controller);
        this.parent = filesTab;
        this.fileDetailsPanel = new FileDetailsPanel(controller, false);
        this.fileVersionsPanel = new FileVersionsPanel(controller);
        this.detailsPanel = this.createDetailsPanel();
        this.detailsPanel.setVisible(false);
        this.tableModel = new FilesTableModel(controller);
        this.tableModel.addTableModelListener(new MyTableModelListener());
        this.table = new FilesTable(this.tableModel);
        this.table.getSelectionModel().addListSelectionListener(new MyListSelectionListener());
        this.table.addMouseListener(new TableMouseListener());
        this.table.registerKeyboardAction(new SelectAllAction(), KeyStroke.getKeyStroke(65, 2), 0);
    }

    public JPanel getUIComponent() {
        if (this.uiComponent == null) {
            this.buildUIComponent();
        }
        return this.uiComponent;
    }

    private void buildUIComponent() {
        this.createToolBar();
        FormLayout formLayout = new FormLayout("fill:pref:grow", "fill:0:grow, 3dlu, pref");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.tableScroller = new JScrollPane(this.table);
        this.emptyLabel = new JLabel(Translation.get("files_table_panel.no_files_available"));
        this.emptyLabel.setEnabled(false);
        this.emptyResetLink = new ActionLabel(this.getController(), new MyResetFiltersAction(this.getController()));
        UIUtil.whiteStripTable(this.table);
        UIUtil.setZeroHeight(this.tableScroller);
        UIUtil.removeBorder(this.tableScroller);
        this.buildEmptyPanel();
        defaultFormBuilder.add((Component)this.tableScroller, cellConstraints.xy(1, 1));
        defaultFormBuilder.add((Component)this.emptyPanel, cellConstraints.xy(1, 1));
        defaultFormBuilder.add((Component)this.detailsPanel, cellConstraints.xy(1, 3));
        this.buildPopupMenus();
        this.uiComponent = defaultFormBuilder.getPanel();
        this.updateEmptyLabel();
    }

    private void buildEmptyPanel() {
        FormLayout formLayout = new FormLayout("pref:grow, center:pref, pref:grow", "pref:grow, center:pref, pref:grow");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        FormLayout formLayout2 = new FormLayout("pref:grow, center:pref, pref:grow", "pref, 3dlu, pref");
        DefaultFormBuilder defaultFormBuilder2 = new DefaultFormBuilder(formLayout2);
        defaultFormBuilder2.add((Component)this.emptyLabel, cellConstraints.xy(2, 1));
        defaultFormBuilder2.add((Component)this.emptyResetLink.getUIComponent(), cellConstraints.xy(2, 3));
        JPanel jPanel = defaultFormBuilder2.getPanel();
        defaultFormBuilder.add((Component)jPanel, cellConstraints.xy(2, 2));
        this.emptyPanel = defaultFormBuilder.getPanel();
    }

    private void createToolBar() {
        this.openFileAction = new OpenFileAction(this.getController());
        this.openFileAction.setEnabled(false);
        this.browserAction = new BrowserAction(this.getController());
        this.browserAction.setEnabled(false);
        this.downloadFileAction = new DownloadFileAction(this.getController());
        this.downloadFileAction.setEnabled(false);
        this.abortDownloadAction = new AbortDownloadAction(this.getController());
        this.abortDownloadAction.setEnabled(false);
        this.deleteFileAction = new DeleteFileAction(this.getController());
        this.deleteFileAction.setEnabled(false);
        this.addIgnoreAction = new AddIgnoreAction(this.getController());
        this.addIgnoreAction.setEnabled(false);
        this.removeIgnoreAction = new RemoveIgnoreAction(this.getController());
        this.removeIgnoreAction.setEnabled(false);
        this.unmarkAction = new UnmarkAction(this.getController());
        this.unmarkAction.setEnabled(false);
        this.singleFileTransferAction = new SingleFileTransferAction(this.getController());
        this.singleFileTransferAction.setEnabled(false);
        this.restoreArchiveAction = new RestoreArchiveAction(this.getController());
        this.restoreArchiveAction.setEnabled(false);
    }

    private void buildPopupMenus() {
        this.fileMenu = new JPopupMenu();
        if (OSUtil.isWindowsSystem() || OSUtil.isMacOS()) {
            this.fileMenu.add(this.openFileAction);
        }
        this.fileMenu.add(this.browserAction);
        this.fileMenu.add(this.downloadFileAction);
        this.fileMenu.add(this.abortDownloadAction);
        this.fileMenu.add(this.deleteFileAction);
        this.fileMenu.add(this.addIgnoreAction);
        this.fileMenu.add(this.removeIgnoreAction);
        this.fileMenu.add(this.unmarkAction);
        this.fileMenu.add(this.restoreArchiveAction);
    }

    @Override
    public void toggleDetails() {
        this.detailsPanel.setVisible(!this.detailsPanel.isVisible());
    }

    @Override
    public void adviseOfChange(FilteredDirectoryEvent filteredDirectoryEvent) {
        FilteredDirectoryModel filteredDirectoryModel = filteredDirectoryEvent.getModel();
        this.tableModel.setFilteredDirectoryModel(filteredDirectoryModel);
        switch (filteredDirectoryEvent.getFileFilterMode()) {
            case 0: {
                this.emptyLabel.setText(Translation.get("files_table_panel.no_files_available.local_and_incoming"));
                break;
            }
            case 1: {
                this.emptyLabel.setText(Translation.get("files_table_panel.no_files_available.local_only"));
                break;
            }
            case 2: {
                this.emptyLabel.setText(Translation.get("files_table_panel.no_files_available.new_only"));
                break;
            }
            case 3: {
                this.emptyLabel.setText(Translation.get("files_table_panel.no_files_available.deleted_previous"));
                break;
            }
            case 4: {
                this.emptyLabel.setText(Translation.get("files_table_panel.no_files_available.unsynchronized"));
                break;
            }
            default: {
                this.emptyLabel.setText(Translation.get("files_table_panel.no_files_available"));
            }
        }
        this.emptyResetLink.setVisible(!filteredDirectoryEvent.isDefaultFilter());
    }

    @Override
    public void adviseOfFilteringBegin() {
        this.emptyLabel.setText(Translation.get("files_table_panel.finding_files"));
        this.emptyResetLink.setVisible(false);
    }

    @Override
    public void invalidate() {
        this.tableModel.setFilteredDirectoryModel(new FilteredDirectoryModel("", "", null));
        this.emptyLabel.setText(Translation.get("files_table_panel.finding_files"));
        this.emptyResetLink.setVisible(false);
    }

    public void setFolder(Folder folder) {
        this.tableModel.setFolder(folder);
    }

    public void openSelectedFile() {
        DiskItem[] diskItemArray;
        if (this.table == null || this.tableModel == null) {
            return;
        }
        int[] nArray = this.table.getSelectedRows();
        for (DiskItem diskItem : diskItemArray = this.tableModel.getDiskItemsAtRows(nArray)) {
            Path path;
            FileInfo fileInfo;
            if (diskItem instanceof DirectoryInfo) {
                fileInfo = (DirectoryInfo)diskItem;
                path = fileInfo.getDiskFile(this.getController().getFolderRepository());
                if (!Files.exists(path, new LinkOption[0])) continue;
                PathUtils.openFile(path);
                continue;
            }
            if (!(diskItem instanceof FileInfo) || (path = (fileInfo = (FileInfo)diskItem).getDiskFile(this.getController().getFolderRepository())) == null || !Files.exists(path, new LinkOption[0])) continue;
            this.table.setCursor(Cursor.getPredefinedCursor(3));
            PathUtils.openFile(path);
            this.table.setCursor(Cursor.getDefaultCursor());
            TransferManager transferManager = this.getController().getTransferManager();
            if (!transferManager.isCompletedDownload(fileInfo)) continue;
            transferManager.clearCompletedDownload(fileInfo);
            this.parent.scheduleDirectoryFiltering();
        }
    }

    private void deleteSelectedFiles() {
        if (this.table == null || this.tableModel == null) {
            return;
        }
        int[] nArray = this.table.getSelectedRows();
        final DiskItem[] diskItemArray = this.tableModel.getDiskItemsAtRows(nArray);
        ActivityVisualizationWorker activityVisualizationWorker = new ActivityVisualizationWorker(this.getUIController()){

            @Override
            public Object construct() {
                FolderRepository folderRepository = FilesTablePanel.this.getController().getFolderRepository();
                for (DiskItem diskItem : diskItemArray) {
                    try {
                        Folder folder;
                        FileInfo fileInfo;
                        if (diskItem instanceof DirectoryInfo) {
                            fileInfo = (DirectoryInfo)diskItem;
                            folder = fileInfo.getFolder(FilesTablePanel.this.getController().getFolderRepository());
                            FileInfoCriteria fileInfoCriteria = new FileInfoCriteria();
                            fileInfoCriteria.setPath((DirectoryInfo)fileInfo);
                            fileInfoCriteria.addMember(FilesTablePanel.this.getController().getMySelf());
                            fileInfoCriteria.setRecursive(true);
                            Collection<FileInfo> collection = folder.getDAO().findFiles(fileInfoCriteria);
                            folder.removeFilesLocal(null, collection);
                            folder.removeFilesLocal(fileInfo);
                            continue;
                        }
                        if (!(diskItem instanceof FileInfo)) continue;
                        fileInfo = (FileInfo)diskItem;
                        folder = fileInfo.getFolder(folderRepository);
                        folder.removeFilesLocal(fileInfo);
                    }
                    catch (Exception exception) {
                        FilesTablePanel.this.logSevere(exception);
                    }
                }
                return null;
            }

            @Override
            protected String getTitle() {
                return Translation.get("delete.busy.title");
            }

            @Override
            protected String getWorkingText() {
                return Translation.get("delete.busy.description");
            }
        };
        activityVisualizationWorker.start();
    }

    public DiskItem[] getSelectedRows() {
        int[] nArray = this.table.getSelectedRows();
        return this.tableModel.getDiskItemsAtRows(nArray);
    }

    public DiskItem[] getAllRows() {
        return this.tableModel.getAllDiskItems();
    }

    private void updateEmptyLabel() {
        if (this.tableScroller != null) {
            this.tableScroller.setVisible(this.tableModel.getRowCount() != 0);
        }
        if (this.emptyPanel != null) {
            this.emptyPanel.setVisible(this.tableModel.getRowCount() == 0);
        }
    }

    public void sortLatestDate() {
        this.tableModel.sortLatestDate();
    }

    private void handleDoubleClick() {
        int n = this.table.getSelectionModel().getLeadSelectionIndex();
        DiskItem diskItem = this.tableModel.getDiskItemsAtRows(new int[]{n})[0];
        if (diskItem != null) {
            if (diskItem instanceof DirectoryInfo) {
                DirectoryInfo directoryInfo = (DirectoryInfo)diskItem;
                this.parent.selectionChanged(directoryInfo.getRelativeName());
            } else if (diskItem instanceof FileInfo) {
                if (this.downloadFileAction.isEnabled()) {
                    ActionEvent actionEvent = new ActionEvent(this, 0, this.downloadFileAction.getName());
                    this.downloadFileAction.actionPerformed(actionEvent);
                } else if (this.openFileAction.isEnabled()) {
                    ActionEvent actionEvent = new ActionEvent(this, 0, this.openFileAction.getName());
                    this.openFileAction.actionPerformed(actionEvent);
                }
            }
        }
    }

    private JPanel createDetailsPanel() {
        FormLayout formLayout = new FormLayout("fill:pref:grow", "pref, 3dlu, pref");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.addSeparator(null, cellConstraints.xy(1, 1));
        JTabbedPane jTabbedPane = new JTabbedPane();
        defaultFormBuilder.add((Component)jTabbedPane, cellConstraints.xy(1, 3));
        jTabbedPane.add((Component)this.fileDetailsPanel.getPanel(), Translation.get("files_table_panel.file_details_tab.text"));
        jTabbedPane.setToolTipTextAt(0, Translation.get("files_table_panel.file_details_tab.tip"));
        jTabbedPane.add(this.fileVersionsPanel.getPanel(), Translation.get("files_table_panel.file_versions_tab.text"));
        jTabbedPane.setToolTipTextAt(1, Translation.get("files_table_panel.file_versions_tab.tip"));
        jTabbedPane.setSelectedIndex(1);
        return defaultFormBuilder.getPanel();
    }

    private void downloadDirectory(DirectoryInfo directoryInfo) {
        FolderRepository folderRepository = this.getController().getFolderRepository();
        Folder folder = directoryInfo.getFolder(folderRepository);
        FileInfoCriteria fileInfoCriteria = new FileInfoCriteria();
        fileInfoCriteria.setPath(directoryInfo);
        fileInfoCriteria.setRecursive(true);
        fileInfoCriteria.setType(FileInfoCriteria.Type.FILES_ONLY);
        fileInfoCriteria.addWriteMembersAndMyself(folder);
        Collection<FileInfo> collection = folder.getDAO().findFiles(fileInfoCriteria);
        for (FileInfo fileInfo : collection) {
            if (fileInfo.isDownloading(this.getController())) continue;
            this.getController().getTransferManager().downloadNewestVersion(fileInfo);
        }
    }

    private class DownloadFileAction
    extends BaseAction {
        DownloadFileAction(Controller controller) {
            super("action_download_file", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ActivityVisualizationWorker activityVisualizationWorker = new ActivityVisualizationWorker(this.getUIController()){

                @Override
                public Object construct() {
                    for (DiskItem diskItem : FilesTablePanel.this.getSelectedRows()) {
                        FileInfo fileInfo;
                        if (diskItem instanceof DirectoryInfo) {
                            fileInfo = (DirectoryInfo)diskItem;
                            FilesTablePanel.this.downloadDirectory((DirectoryInfo)fileInfo);
                            continue;
                        }
                        if (!(diskItem instanceof FileInfo)) continue;
                        fileInfo = (FileInfo)diskItem;
                        FolderRepository folderRepository = DownloadFileAction.this.getController().getFolderRepository();
                        Folder folder = fileInfo.getFolder(folderRepository);
                        if (folder == null) {
                            return null;
                        }
                        if (fileInfo.isDownloading(DownloadFileAction.this.getController())) {
                            return null;
                        }
                        DownloadFileAction.this.getController().getTransferManager().downloadNewestVersion(fileInfo);
                    }
                    return null;
                }

                @Override
                protected String getTitle() {
                    return Translation.get("download.busy.title");
                }

                @Override
                protected String getWorkingText() {
                    return Translation.get("download.busy.description");
                }
            };
            activityVisualizationWorker.start();
        }
    }

    private class SingleFileTransferAction
    extends BaseAction {
        private SingleFileTransferAction(Controller controller) {
            super("action_single_file_transfer", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (DiskItem diskItem : FilesTablePanel.this.getSelectedRows()) {
                if (diskItem == null || !(diskItem instanceof FileInfo)) continue;
                FileInfo fileInfo = (FileInfo)diskItem;
                this.getUIController().transferSingleFile(fileInfo.getDiskFile(this.getController().getFolderRepository()), null);
            }
        }
    }

    private class UnmarkAction
    extends BaseAction {
        private UnmarkAction(Controller controller) {
            super("action_unmark", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (DiskItem diskItem : FilesTablePanel.this.getSelectedRows()) {
                if (diskItem == null || !(diskItem instanceof FileInfo)) continue;
                FileInfo fileInfo = (FileInfo)diskItem;
                TransferManager transferManager = this.getController().getTransferManager();
                if (!transferManager.isCompletedDownload(fileInfo)) continue;
                transferManager.clearCompletedDownload(fileInfo);
                FilesTablePanel.this.parent.scheduleDirectoryFiltering();
            }
        }
    }

    private class AbortDownloadAction
    extends BaseAction {
        private AbortDownloadAction(Controller controller) {
            super("exp.action_abort_download", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (DiskItem diskItem : FilesTablePanel.this.getSelectedRows()) {
                if (!(diskItem instanceof FileInfo)) continue;
                FileInfo fileInfo = (FileInfo)diskItem;
                TransferManager transferManager = this.getController().getTransferManager();
                DownloadManager downloadManager = transferManager.getActiveDownload(fileInfo);
                if (downloadManager == null) continue;
                downloadManager.abort();
            }
        }
    }

    private class RestoreArchiveAction
    extends BaseAction {
        private RestoreArchiveAction(Controller controller) {
            super("action_restore_archive", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FilesTablePanel.this.parent.fileArchive();
        }
    }

    private class DeleteFileAction
    extends BaseAction {
        DeleteFileAction(Controller controller) {
            super("action_delete_file", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FilesTablePanel.this.deleteSelectedFiles();
        }
    }

    private class RemoveIgnoreAction
    extends BaseAction {
        private RemoveIgnoreAction(Controller controller) {
            super("action_remove_ignore", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (DiskItem diskItem : FilesTablePanel.this.getSelectedRows()) {
                FileInfo fileInfo;
                if (diskItem != null && diskItem instanceof DirectoryInfo) {
                    fileInfo = (DirectoryInfo)diskItem;
                    FilesTablePanel.this.tableModel.getFolder().removePattern(fileInfo.getRelativeName() + "/*");
                    continue;
                }
                if (diskItem == null || !(diskItem instanceof FileInfo)) continue;
                fileInfo = (FileInfo)diskItem;
                FilesTablePanel.this.tableModel.getFolder().removePattern(fileInfo.getRelativeName());
            }
            this.getController().getFolderRepository().getFileRequestor().triggerFileRequesting(FilesTablePanel.this.tableModel.getFolder().getInfo());
        }
    }

    private class AddIgnoreAction
    extends BaseAction {
        private AddIgnoreAction(Controller controller) {
            super("action_add_ignore", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (DiskItem diskItem : FilesTablePanel.this.getSelectedRows()) {
                FileInfo fileInfo;
                if (diskItem != null && diskItem instanceof DirectoryInfo) {
                    fileInfo = (DirectoryInfo)diskItem;
                    FilesTablePanel.this.tableModel.getFolder().addPattern(fileInfo.getRelativeName() + "/*");
                    continue;
                }
                if (diskItem == null || !(diskItem instanceof FileInfo)) continue;
                fileInfo = (FileInfo)diskItem;
                FilesTablePanel.this.tableModel.getFolder().addPattern(fileInfo.getRelativeName());
            }
            this.getController().getTransferManager().checkActiveTranfersForExcludes();
        }
    }

    private class BrowserAction
    extends BaseAction {
        BrowserAction(Controller controller) {
            super("action_browser", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DiskItem diskItem;
            if (FilesTablePanel.this.getSelectedRows().length == 1 && (diskItem = FilesTablePanel.this.getSelectedRows()[0]) instanceof FileInfo) {
                final FileInfo fileInfo = (FileInfo)diskItem;
                this.getController().getIOProvider().startIO(new Runnable(){

                    @Override
                    public void run() {
                        String string = Util.getClipboardContents();
                        String string2 = BrowserAction.this.getController().getOSClient().getFolderService(fileInfo.getFolderInfo()).getFileLink(fileInfo);
                        Util.setClipboardContents(string2);
                        ShareFileNotificationHandler shareFileNotificationHandler = new ShareFileNotificationHandler(BrowserAction.this.getController(), fileInfo, string);
                        shareFileNotificationHandler.show();
                    }
                });
            }
        }
    }

    private class OpenFileAction
    extends BaseAction {
        OpenFileAction(Controller controller) {
            super("action_open_file", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FilesTablePanel.this.openSelectedFile();
        }
    }

    private class MyTableModelListener
    implements TableModelListener {
        private MyTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            FilesTablePanel.this.updateEmptyLabel();
        }
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl = false;
            boolean bl2 = false;
            if (FilesTablePanel.this.getSelectedRows().length > 0) {
                DiskItem diskItem = FilesTablePanel.this.getSelectedRows()[0];
                if (OSUtil.isWindowsSystem() || OSUtil.isMacOS()) {
                    FilesTablePanel.this.openFileAction.setEnabled(diskItem != null);
                }
                FilesTablePanel.this.browserAction.setEnabled(diskItem != null && diskItem instanceof FileInfo && FilesTablePanel.this.getSelectedRows().length == 1 && ConfigurationEntry.WEB_LOGIN_ALLOWED.getValueBoolean(FilesTablePanel.this.getController()) != false);
                if (diskItem != null && diskItem instanceof DirectoryInfo) {
                    DirectoryInfo directoryInfo = (DirectoryInfo)diskItem;
                    boolean bl3 = FilesTablePanel.this.tableModel.getFolder().getDiskItemFilter().isRetained(directoryInfo);
                    FilesTablePanel.this.addIgnoreAction.setEnabled(bl3);
                    FilesTablePanel.this.removeIgnoreAction.setEnabled(!bl3);
                    FilesTablePanel.this.deleteFileAction.setEnabled(true);
                    FilesTablePanel.this.fileDetailsPanel.setFileInfo(null);
                    FilesTablePanel.this.fileVersionsPanel.setFileInfo(null);
                    bl2 = true;
                    FilesTablePanel.this.restoreArchiveAction.setEnabled(true);
                    FolderInfo folderInfo = ((DirectoryInfo)diskItem).getFolderInfo();
                    FilesTablePanel.this.restoreArchiveAction.allowWith(FolderPermission.get(folderInfo, AccessMode.READ_WRITE));
                    bl = true;
                } else if (diskItem != null && diskItem instanceof FileInfo) {
                    TransferManager transferManager = FilesTablePanel.this.getController().getTransferManager();
                    FileInfo fileInfo = (FileInfo)diskItem;
                    FilesTablePanel.this.fileDetailsPanel.setFileInfo(fileInfo);
                    FilesTablePanel.this.fileVersionsPanel.setFileInfo(fileInfo);
                    bl2 = true;
                    FolderRepository folderRepository = FilesTablePanel.this.getController().getFolderRepository();
                    if (fileInfo.diskFileExists(FilesTablePanel.this.getController()) && !fileInfo.isNewerAvailable(folderRepository)) {
                        bl2 = false;
                    } else if (!(fileInfo.isDeleted() || fileInfo.isExpected(folderRepository) || fileInfo.isNewerAvailable(folderRepository))) {
                        bl2 = false;
                    }
                    FilesTablePanel.this.deleteFileAction.setEnabled(!bl2);
                    DownloadManager downloadManager = FilesTablePanel.this.getController().getTransferManager().getActiveDownload(fileInfo);
                    FilesTablePanel.this.abortDownloadAction.setEnabled(downloadManager != null);
                    boolean bl4 = FilesTablePanel.this.tableModel.getFolder().getDiskItemFilter().isRetained(fileInfo);
                    FilesTablePanel.this.addIgnoreAction.setEnabled(bl4);
                    FilesTablePanel.this.removeIgnoreAction.setEnabled(!bl4);
                    FilesTablePanel.this.unmarkAction.setEnabled(transferManager.isCompletedDownload(fileInfo));
                    FilesTablePanel.this.singleFileTransferAction.setEnabled(true);
                    FilesTablePanel.this.restoreArchiveAction.setEnabled(true);
                    FolderInfo folderInfo = ((FileInfo)diskItem).getFolderInfo();
                    FilesTablePanel.this.restoreArchiveAction.allowWith(FolderPermission.get(folderInfo, AccessMode.READ_WRITE));
                    bl = true;
                }
            } else {
                FilesTablePanel.this.browserAction.setEnabled(false);
            }
            FilesTablePanel.this.downloadFileAction.setEnabled(bl2);
            if (!bl) {
                FilesTablePanel.this.fileDetailsPanel.setFileInfo(null);
                FilesTablePanel.this.fileVersionsPanel.setFileInfo(null);
                FilesTablePanel.this.deleteFileAction.setEnabled(false);
                FilesTablePanel.this.abortDownloadAction.setEnabled(false);
                FilesTablePanel.this.addIgnoreAction.setEnabled(false);
                FilesTablePanel.this.removeIgnoreAction.setEnabled(false);
                FilesTablePanel.this.unmarkAction.setEnabled(false);
                FilesTablePanel.this.singleFileTransferAction.setEnabled(false);
                FilesTablePanel.this.restoreArchiveAction.setEnabled(false);
            }
        }
    }

    private class TableMouseListener
    extends MouseAdapter {
        private TableMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                FilesTablePanel.this.handleDoubleClick();
            }
        }

        private void showContextMenu(MouseEvent mouseEvent) {
            FilesTablePanel.this.fileMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private class SelectAllAction
    extends AbstractAction {
        private SelectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FilesTablePanel.this.table.selectAll();
        }
    }

    private class MyResetFiltersAction
    extends BaseAction {
        MyResetFiltersAction(Controller controller) {
            super("action_reset_filters", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FilesTablePanel.this.parent.resetFilters();
        }
    }
}

