/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.dialog.directory;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.util.Icons;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;

class DirectoryTreeNode
extends DefaultMutableTreeNode {
    private boolean volume;
    private boolean scanned;
    private Icon icon;
    private boolean real;
    private Controller controller;
    private String enhancedVolumeText;

    DirectoryTreeNode(Controller controller, String string, Path path, boolean bl, boolean bl2) {
        block10: {
            super(path);
            this.controller = controller;
            this.volume = bl;
            this.real = bl2;
            try {
                if (bl) {
                    this.add(new DefaultMutableTreeNode());
                    this.enhancedVolumeText = string;
                    break block10;
                }
                if (path == null || !Files.isDirectory(path, new LinkOption[0]) || !Files.isReadable(path) || Files.isHidden(path)) break block10;
                this.scanned = true;
                try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
                    for (Path path2 : directoryStream) {
                        if (path2 == null || !Files.isReadable(path2) || !Files.isDirectory(path2, new LinkOption[0]) || Files.isHidden(path2)) continue;
                        this.add(new DefaultMutableTreeNode());
                        this.scanned = false;
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public void scan(List<String> list) {
        while (this.getChildCount() > 0) {
            this.remove(0);
        }
        Path path = this.getDir();
        if (path != null && Files.isDirectory(path, new LinkOption[0]) && Files.isReadable(path)) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
                Path path2;
                TreeMap<Path, Boolean> treeMap = new TreeMap<Path, Boolean>();
                for (Path iterator : directoryStream) {
                    treeMap.put(iterator, true);
                }
                String string = this.controller.getFolderRepository().getFoldersBasedirString();
                if (string.equals(this.getDir().toAbsolutePath().toString()) && list != null && !list.isEmpty()) {
                    for (String string2 : list) {
                        path2 = Paths.get(string, string2);
                        if (!Files.notExists(path2, new LinkOption[0])) continue;
                        treeMap.put(path2, false);
                    }
                }
                if (!treeMap.isEmpty()) {
                    for (Map.Entry entry : treeMap.entrySet()) {
                        path2 = (Path)entry.getKey();
                        boolean bl = (Boolean)entry.getValue();
                        if (bl && (!Files.isDirectory(path2, new LinkOption[0]) || Files.isHidden(path2) || !Files.isReadable(path2))) continue;
                        DirectoryTreeNode directoryTreeNode = new DirectoryTreeNode(this.controller, null, path2, false, bl);
                        this.add(directoryTreeNode);
                    }
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.scanned = true;
    }

    public void unscan() {
        this.scanned = false;
    }

    public boolean isScanned() {
        return this.scanned;
    }

    public boolean isVolume() {
        return this.volume;
    }

    public Path getDir() {
        return (Path)this.getUserObject();
    }

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = this.real ? FileSystemView.getFileSystemView().getSystemIcon(this.getDir().toFile()) : Icons.getIconById("online_folder_small.icon");
        }
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public String getEnhancedVolumeText() {
        return this.enhancedVolumeText;
    }
}

