/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.dialog;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.ui.dialog.BaseDialog;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class PauseDialog
extends BaseDialog {
    private static final Map<Integer, String> PAUSE_RESUME_VALUES = new TreeMap<Integer, String>();
    private JButton pauseButton;
    private JCheckBox neverAskAgainCB;
    private JComboBox<String> pauseValuesCombo;

    public PauseDialog(Controller controller) {
        super(BaseDialog.Senior.NONE, controller, true);
    }

    @Override
    public String getTitle() {
        return Translation.get("pause_dialog.title");
    }

    @Override
    protected Icon getIcon() {
        return null;
    }

    @Override
    protected JComponent getContent() {
        this.pauseButton = new JButton(Translation.get("pause_dialog.button.text"));
        this.pauseButton.setMnemonic(Translation.get("pause_dialog.button.text").trim().charAt(0));
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PauseDialog.this.pause();
            }
        });
        this.neverAskAgainCB = new JCheckBox(Translation.get("general.neverAskAgain"));
        this.neverAskAgainCB.setMnemonic(Translation.get("general.neverAskAgain").charAt(0));
        int n = ConfigurationEntry.PAUSE_RESUME_SECONDS.getValueInt(this.getController());
        this.pauseValuesCombo = new JComboBox();
        int n2 = 0;
        for (Map.Entry<Integer, String> object2 : PAUSE_RESUME_VALUES.entrySet()) {
            this.pauseValuesCombo.addItem(object2.getValue());
            if (n == object2.getKey()) {
                this.pauseValuesCombo.setSelectedIndex(n2);
            }
            ++n2;
        }
        FormLayout formLayout = new FormLayout("pref, 3dlu, pref:grow", "pref, 3dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)new JLabel(Translation.get("pause_dialog.pause_label.text")), cellConstraints.xy(1, 1));
        panelBuilder.add(this.pauseValuesCombo, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.neverAskAgainCB, cellConstraints.xyw(1, 3, 3));
        return panelBuilder.getPanel();
    }

    private void pause() {
        if (this.neverAskAgainCB.isSelected()) {
            PreferencesEntry.SHOW_ASK_FOR_PAUSE.setValue(this.getController(), false);
        }
        int n = 0;
        for (Integer n2 : PAUSE_RESUME_VALUES.keySet()) {
            if (n == this.pauseValuesCombo.getSelectedIndex()) {
                ConfigurationEntry.PAUSE_RESUME_SECONDS.setValue(this.getController(), n2);
                this.getController().saveConfig();
                break;
            }
            ++n;
        }
        this.getController().setPaused(!this.getController().isPaused());
        this.dialog.dispose();
    }

    @Override
    protected JButton getDefaultButton() {
        return this.pauseButton;
    }

    @Override
    protected Component getButtonBar() {
        JButton jButton = PauseDialog.createCancelButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PauseDialog.this.dialog.dispose();
            }
        });
        return ButtonBarFactory.buildCenteredBar(this.pauseButton, jButton);
    }

    static {
        PAUSE_RESUME_VALUES.put(0, Translation.get("pause_dialog.pause.user_inactive"));
        PAUSE_RESUME_VALUES.put(300, Translation.get("pause_dialog.pause.5minutes"));
        PAUSE_RESUME_VALUES.put(3600, Translation.get("pause_dialog.pause.1hour"));
        PAUSE_RESUME_VALUES.put(29280, Translation.get("pause_dialog.pause.8hours"));
        PAUSE_RESUME_VALUES.put(Integer.MAX_VALUE, Translation.get("pause_dialog.pause.permanent"));
    }
}

