/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.dialog;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.ui.dialog.BaseDialog;
import de.dal33t.powerfolder.ui.panel.SyncProfileSelectorPanel;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class DeleteSyncProfileDialog
extends BaseDialog {
    private JButton deleteButton;
    private JComboBox<String> syncProfilesCombo;
    private SyncProfileSelectorPanel syncProfileSelectorPanel;

    public DeleteSyncProfileDialog(Controller controller, SyncProfileSelectorPanel syncProfileSelectorPanel) {
        super(BaseDialog.Senior.NONE, controller, true);
        this.syncProfileSelectorPanel = syncProfileSelectorPanel;
    }

    @Override
    public String getTitle() {
        return Translation.get("exp.dialog.delete_profile.title");
    }

    @Override
    protected Icon getIcon() {
        return null;
    }

    @Override
    protected JComponent getContent() {
        this.initComponents();
        FormLayout formLayout = new FormLayout("right:pref, 3dlu, pref", "pref, 3dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        SyncProfile syncProfile = this.syncProfileSelectorPanel.getSyncProfile();
        panelBuilder.add((Component)new JLabel(Translation.get("transfer_mode.delete.profile", syncProfile.getName() + "?")), cellConstraints.xyw(1, 1, 3));
        panelBuilder.add((Component)new JLabel(Translation.get("transfer_mode.substitute.profile")), cellConstraints.xy(1, 3));
        panelBuilder.add(this.syncProfilesCombo, cellConstraints.xy(3, 3));
        return panelBuilder.getPanel();
    }

    private void initComponents() {
        SyncProfile syncProfile = this.syncProfileSelectorPanel.getSyncProfile();
        this.syncProfilesCombo = new JComboBox();
        for (SyncProfile syncProfile2 : SyncProfile.getSyncProfilesCopy()) {
            if (syncProfile2.equals(syncProfile)) continue;
            this.syncProfilesCombo.addItem(syncProfile2.getName());
        }
    }

    @Override
    protected Component getButtonBar() {
        this.deleteButton = new JButton(Translation.get("general.delete"));
        this.deleteButton.setMnemonic(Translation.get("general.delete.key").trim().charAt(0));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeleteSyncProfileDialog.this.deletePressed();
            }
        });
        JButton jButton = DeleteSyncProfileDialog.createCancelButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeleteSyncProfileDialog.this.cancelPressed();
            }
        });
        return ButtonBarFactory.buildCenteredBar(this.deleteButton, jButton);
    }

    @Override
    protected JButton getDefaultButton() {
        return this.deleteButton;
    }

    private void deletePressed() {
        SyncProfile syncProfile = this.syncProfileSelectorPanel.getSyncProfile();
        String string = (String)this.syncProfilesCombo.getSelectedItem();
        for (SyncProfile syncProfile2 : SyncProfile.getSyncProfilesCopy()) {
            if (!syncProfile2.getName().equals(string)) continue;
            for (Folder folder : this.getController().getFolderRepository().getFolders()) {
                if (!folder.getSyncProfile().equals(syncProfile)) continue;
                folder.setSyncProfile(syncProfile2);
            }
            this.syncProfileSelectorPanel.setSyncProfile(syncProfile2, true);
            SyncProfile.deleteProfile(syncProfile);
            this.syncProfileSelectorPanel.configureCombo(syncProfile2);
            this.close();
        }
    }

    private void cancelPressed() {
        this.close();
    }
}

