/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.dialog;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.disk.SyncProfileConfiguration;
import de.dal33t.powerfolder.ui.dialog.BaseDialog;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.panel.SyncProfileSelectorPanel;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CreateEditSyncProfileDialog
extends BaseDialog
implements ActionListener,
KeyListener {
    private JTextField syncProfileName;
    private JComboBox<String> syncProfilesCombo;
    private JCheckBox autoDownloadBox;
    private JCheckBox syncDeletionBox;
    private SpinnerNumberModel scanTimeModel;
    private JSpinner scanTimeSpinner;
    private SyncProfileSelectorPanel syncProfileSelectorPanel;
    private JLabel scanInfoLabel;
    private JRadioButton periodicRadioButton;
    private JRadioButton dailyRadioButton;
    private JRadioButton instantRadioButton;
    private SpinnerNumberModel hourModel;
    private JSpinner hourSpinner;
    private JComboBox<String> dayCombo;
    private JComboBox<String> timeTypeCombo;
    private final boolean create;
    private JButton saveButton;
    private final SyncProfileConfiguration originalConfiguration;
    private final String originalProfileName;

    public CreateEditSyncProfileDialog(Controller controller, SyncProfileSelectorPanel syncProfileSelectorPanel, boolean bl) {
        super(BaseDialog.Senior.NONE, controller, true);
        this.syncProfileSelectorPanel = syncProfileSelectorPanel;
        this.create = bl;
        this.originalConfiguration = syncProfileSelectorPanel.getSyncProfile().getConfiguration();
        this.originalProfileName = syncProfileSelectorPanel.getSyncProfile().getName();
    }

    @Override
    public String getTitle() {
        if (this.create) {
            return Translation.get("exp.dialog.create_edit_profile.title_create");
        }
        return Translation.get("exp.dialog.create_edit_profile.title_edit");
    }

    @Override
    protected Icon getIcon() {
        return null;
    }

    @Override
    protected JComponent getContent() {
        this.initComponents();
        FormLayout formLayout = new FormLayout("right:pref, 3dlu, pref", "pref, 15dlu, pref, 15dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)new JLabel(Translation.get("exp.dialog.create_edit_profile.profile_name")), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.syncProfileName, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)new JLabel(Translation.get("exp.dialog.create_edit_profile.configure_from")), cellConstraints.xy(1, 3));
        panelBuilder.add(this.createSyncComboPanel(), cellConstraints.xy(3, 3));
        panelBuilder.addSeparator(Translation.get("exp.dialog.create_edit_profile.synchronization"), cellConstraints.xyw(1, 5, 3));
        panelBuilder.add((Component)this.autoDownloadBox, cellConstraints.xy(3, 7));
        panelBuilder.add((Component)this.syncDeletionBox, cellConstraints.xy(3, 9));
        panelBuilder.addSeparator(Translation.get("exp.dialog.create_edit_profile.change_detection"), cellConstraints.xyw(1, 11, 3));
        panelBuilder.add((Component)this.instantRadioButton, cellConstraints.xy(3, 13));
        panelBuilder.add((Component)this.periodicRadioButton, cellConstraints.xy(3, 15));
        panelBuilder.add((Component)new JLabel(Translation.get("exp.dialog.create_edit_profile.time_between_scans")), cellConstraints.xy(1, 17));
        panelBuilder.add(this.createRegularPanel(), cellConstraints.xy(3, 17));
        panelBuilder.add((Component)this.dailyRadioButton, cellConstraints.xy(3, 19));
        panelBuilder.add((Component)new JLabel(Translation.get("exp.dialog.create_edit_profile.hour_day_sync")), cellConstraints.xy(1, 21));
        panelBuilder.add(this.createDailyComboPanel(), cellConstraints.xy(3, 21));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.periodicRadioButton);
        buttonGroup.add(this.dailyRadioButton);
        buttonGroup.add(this.instantRadioButton);
        return panelBuilder.getPanel();
    }

    private Component createSyncComboPanel() {
        FormLayout formLayout = new FormLayout("pref", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add(this.syncProfilesCombo, cellConstraints.xy(1, 1));
        return panelBuilder.getPanel();
    }

    public Component createDailyComboPanel() {
        FormLayout formLayout = new FormLayout("pref, 3dlu, pref", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.hourSpinner, cellConstraints.xy(1, 1));
        panelBuilder.add(this.dayCombo, cellConstraints.xy(3, 1));
        return panelBuilder.getPanel();
    }

    public Component createRegularPanel() {
        FormLayout formLayout = new FormLayout("pref, 3dlu, pref", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.scanTimeSpinner, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.scanInfoLabel, cellConstraints.xy(3, 1));
        panelBuilder.add(this.timeTypeCombo, cellConstraints.xy(3, 1));
        return panelBuilder.getPanel();
    }

    private void initComponents() {
        Object object;
        SyncProfile syncProfile = this.syncProfileSelectorPanel.getSyncProfile();
        this.syncProfileName = new JTextField();
        if (this.create) {
            object = CreateEditSyncProfileDialog.calculateBestName(syncProfile.getName());
            this.syncProfileName.setText((String)object);
        } else {
            this.syncProfileName.setText(syncProfile.getName());
        }
        this.syncProfileName.addKeyListener(this);
        this.syncProfilesCombo = new JComboBox();
        this.syncProfilesCombo.addItem("");
        for (SyncProfile serializable2 : SyncProfile.getSyncProfilesCopy()) {
            this.syncProfilesCombo.addItem(serializable2.getName());
        }
        this.syncProfilesCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                CreateEditSyncProfileDialog.this.preselectDefaults();
            }
        });
        this.autoDownloadBox = new JCheckBox(Translation.get("exp.dialog.create_edit_profile.auto_download"));
        this.syncDeletionBox = new JCheckBox(Translation.get("exp.dialog.create_edit_profile.sync_deletion"));
        this.scanTimeModel = new SpinnerNumberModel(0, 0, 9999, 1);
        this.scanTimeSpinner = new JSpinner(this.scanTimeModel);
        this.scanInfoLabel = new JLabel(Translation.get("exp.dialog.create_edit_profile.change_detection_manual"));
        this.scanTimeModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CreateEditSyncProfileDialog.this.infoTypeVisible();
            }
        });
        this.periodicRadioButton = new JRadioButton(Translation.get("exp.dialog.create_edit_profile.periodic_sync"));
        this.periodicRadioButton.addActionListener(this);
        this.dailyRadioButton = new JRadioButton(Translation.get("exp.dialog.create_edit_profile.daily_sync"));
        this.dailyRadioButton.addActionListener(this);
        this.instantRadioButton = new JRadioButton(Translation.get("exp.dialog.create_edit_profile.instant_sync"));
        this.instantRadioButton.addActionListener(this);
        this.dayCombo = new JComboBox<String>(new String[]{Translation.get("exp.dialog.create_edit_profile.every_day"), Translation.get("general.sunday"), Translation.get("general.monday"), Translation.get("general.tuesday"), Translation.get("general.wednesday"), Translation.get("general.thursday"), Translation.get("general.friday"), Translation.get("general.saturday"), Translation.get("exp.dialog.create_edit_profile.weekdays"), Translation.get("exp.dialog.create_edit_profile.weekends")});
        this.dayCombo.setMaximumRowCount(10);
        this.hourModel = new SpinnerNumberModel(12, 0, 23, 1);
        this.hourSpinner = new JSpinner(this.hourModel);
        this.dayCombo.addActionListener(this);
        this.timeTypeCombo = new JComboBox<String>(new String[]{Translation.get("general.hours"), Translation.get("general.minutes"), Translation.get("general.seconds")});
        this.timeTypeCombo.addActionListener(this);
        object = this.syncProfileSelectorPanel.getSyncProfile();
        SyncProfileConfiguration syncProfileConfiguration = ((SyncProfile)object).getConfiguration();
        this.autoDownloadBox.setSelected(syncProfileConfiguration.isAutoDownload());
        this.syncDeletionBox.setSelected(syncProfileConfiguration.isSyncDeletion());
        this.scanTimeModel.setValue(syncProfileConfiguration.getTimeBetweenRegularScans());
        this.dailyRadioButton.setSelected(syncProfileConfiguration.isDailySync());
        this.periodicRadioButton.setSelected(syncProfileConfiguration.isPeriodicSync());
        this.instantRadioButton.setSelected(syncProfileConfiguration.isInstantSync());
        this.hourModel.setValue(syncProfileConfiguration.getDailyHour());
        this.dayCombo.setSelectedIndex(syncProfileConfiguration.getDailyDay());
        if (syncProfileConfiguration.getRegularTimeType().equals("h")) {
            this.timeTypeCombo.setSelectedIndex(0);
        } else if (syncProfileConfiguration.getRegularTimeType().equals("s")) {
            this.timeTypeCombo.setSelectedIndex(2);
        } else {
            this.timeTypeCombo.setSelectedIndex(1);
        }
        this.scanTimeSpinner.setEnabled(syncProfileConfiguration.isPeriodicSync());
        this.hourSpinner.setEnabled(syncProfileConfiguration.isDailySync());
        this.dayCombo.setEnabled(syncProfileConfiguration.isDailySync());
        this.timeTypeCombo.setEnabled(syncProfileConfiguration.isPeriodicSync());
        this.infoTypeVisible();
    }

    private void infoTypeVisible() {
        if (this.scanTimeModel.getNumber().intValue() == 0) {
            this.scanInfoLabel.setVisible(true);
            this.timeTypeCombo.setVisible(false);
        } else {
            this.scanInfoLabel.setVisible(false);
            this.timeTypeCombo.setVisible(true);
        }
    }

    private static String calculateBestName(String string) {
        String string2;
        boolean bl;
        int n = 0;
        do {
            bl = true;
            string2 = n == 0 ? Translation.get("exp.dialog.create_edit_profile.suggestNameTemplate0", string) : Translation.get("exp.dialog.create_edit_profile.suggestNameTemplateN", string, String.valueOf(n));
            for (SyncProfile syncProfile : SyncProfile.getSyncProfilesCopy()) {
                String string3 = syncProfile.getName();
                if (!string3.equalsIgnoreCase(string2)) continue;
                bl = false;
                break;
            }
            ++n;
        } while (!bl);
        return string2;
    }

    private void preselectDefaults() {
        int n = this.syncProfilesCombo.getSelectedIndex() - 1;
        List<SyncProfile> list = SyncProfile.getSyncProfilesCopy();
        if (n >= 0 && n < list.size()) {
            SyncProfile syncProfile = SyncProfile.getSyncProfilesCopy().get(n);
            SyncProfileConfiguration syncProfileConfiguration = syncProfile.getConfiguration();
            this.autoDownloadBox.setSelected(syncProfileConfiguration.isAutoDownload());
            this.syncDeletionBox.setSelected(syncProfileConfiguration.isSyncDeletion());
            this.scanTimeModel.setValue(syncProfileConfiguration.getTimeBetweenRegularScans());
            this.periodicRadioButton.setSelected(syncProfileConfiguration.isPeriodicSync());
            this.periodicRadioButton.setSelected(syncProfileConfiguration.isInstantSync());
            this.dailyRadioButton.setSelected(syncProfileConfiguration.isDailySync());
            this.hourModel.setValue(syncProfileConfiguration.getDailyHour());
            this.dayCombo.setSelectedIndex(syncProfileConfiguration.getDailyDay());
            if (syncProfileConfiguration.getRegularTimeType().equals("h")) {
                this.timeTypeCombo.setSelectedIndex(0);
            } else if (syncProfileConfiguration.getRegularTimeType().equals("s")) {
                this.timeTypeCombo.setSelectedIndex(2);
            } else {
                this.timeTypeCombo.setSelectedIndex(1);
            }
            this.enableTimeDate();
            this.syncProfilesCombo.setSelectedIndex(0);
        }
    }

    @Override
    protected Component getButtonBar() {
        this.saveButton = new JButton(Translation.get("general.save"));
        this.saveButton.setMnemonic(Translation.get("general.save.key").trim().charAt(0));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateEditSyncProfileDialog.this.savePressed();
            }
        });
        this.configureSaveButton();
        JButton jButton = CreateEditSyncProfileDialog.createCancelButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateEditSyncProfileDialog.this.cancelPressed();
            }
        });
        return ButtonBarFactory.buildCenteredBar(this.saveButton, jButton);
    }

    @Override
    protected JButton getDefaultButton() {
        return this.saveButton;
    }

    private void savePressed() {
        String string = "m";
        if (this.timeTypeCombo.getSelectedIndex() == 0) {
            string = "h";
        } else if (this.timeTypeCombo.getSelectedIndex() == 2) {
            string = "s";
        }
        boolean bl = this.instantRadioButton.isSelected();
        boolean bl2 = !bl && this.dailyRadioButton.isSelected();
        SyncProfileConfiguration syncProfileConfiguration = new SyncProfileConfiguration(this.autoDownloadBox.isSelected(), this.autoDownloadBox.isSelected(), this.syncDeletionBox.isSelected(), this.syncDeletionBox.isSelected(), this.scanTimeModel.getNumber().intValue(), bl2, this.hourModel.getNumber().intValue(), this.dayCombo.getSelectedIndex(), string, bl);
        String string2 = this.syncProfileName.getText().trim();
        if (this.create) {
            if (this.checkDuplicateProfileName(string2) || this.checkDuplicateConfiguration(syncProfileConfiguration)) {
                return;
            }
            SyncProfile syncProfile = SyncProfile.retrieveSyncProfile(string2, syncProfileConfiguration);
            this.syncProfileSelectorPanel.setSyncProfile(syncProfile, true);
        } else {
            if (this.originalProfileName.equals(string2) && this.originalConfiguration.equals(syncProfileConfiguration)) {
                this.close();
            }
            SyncProfile syncProfile = this.syncProfileSelectorPanel.getSyncProfile();
            if (!this.originalConfiguration.equals(syncProfileConfiguration)) {
                if (this.checkDuplicateConfiguration(syncProfileConfiguration)) {
                    return;
                }
                syncProfile.setConfiguration(syncProfileConfiguration);
                this.syncProfileSelectorPanel.setSyncProfile(syncProfile, true);
            }
            if (!this.originalProfileName.equals(string2)) {
                if (this.checkDuplicateProfileName(string2)) {
                    return;
                }
                syncProfile.setName(string2);
                this.syncProfileSelectorPanel.setSyncProfile(syncProfile, true);
            }
        }
        this.close();
    }

    private boolean checkDuplicateProfileName(String string) {
        for (SyncProfile syncProfile : SyncProfile.getSyncProfilesCopy()) {
            if (!syncProfile.getName().equals(string)) continue;
            String string2 = Translation.get("exp.dialog.create_edit_profile.duplicate_profile_title");
            String string3 = Translation.get("exp.dialog.create_edit_profile.cannot_save_name", syncProfile.getName());
            DialogFactory.genericDialog(this.getController(), string2, string3, GenericDialogType.ERROR);
            return true;
        }
        return false;
    }

    private boolean checkDuplicateConfiguration(SyncProfileConfiguration syncProfileConfiguration) {
        for (SyncProfile syncProfile : SyncProfile.getSyncProfilesCopy()) {
            if (!syncProfile.getConfiguration().equals(syncProfileConfiguration)) continue;
            String string = Translation.get("exp.dialog.create_edit_profile.duplicate_profile_title");
            String string2 = Translation.get("exp.dialog.create_edit_profile.cannot_save_profile", syncProfile.getName());
            DialogFactory.genericDialog(this.getController(), string, string2, GenericDialogType.ERROR);
            return true;
        }
        return false;
    }

    private void cancelPressed() {
        this.close();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.periodicRadioButton) || actionEvent.getSource().equals(this.dailyRadioButton) || actionEvent.getSource().equals(this.instantRadioButton)) {
            this.enableTimeDate();
        }
    }

    private void enableTimeDate() {
        this.scanTimeSpinner.setEnabled(this.periodicRadioButton.isSelected());
        this.scanInfoLabel.setEnabled(this.periodicRadioButton.isSelected());
        this.timeTypeCombo.setEnabled(this.periodicRadioButton.isSelected());
        this.hourSpinner.setEnabled(this.dailyRadioButton.isSelected());
        this.dayCombo.setEnabled(this.dailyRadioButton.isSelected());
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.syncProfileName) {
            this.configureSaveButton();
        }
    }

    private void configureSaveButton() {
        this.saveButton.setEnabled(this.syncProfileName.getText().trim().length() > 0);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        String string = this.syncProfileName.getText();
        while (string.endsWith(",")) {
            this.syncProfileName.removeKeyListener(this);
            this.syncProfileName.setText(string.substring(0, string.length() - 1));
            this.syncProfileName.addKeyListener(this);
            string = this.syncProfileName.getText();
        }
    }
}

