/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.dialog;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.util.CursorUtils;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public abstract class BaseDialog
extends PFUIComponent {
    private static final AtomicInteger NUMBER_OF_OPEN_DIALOGS = new AtomicInteger();
    private final Senior senior;
    private final boolean modal;
    private boolean resizable;
    protected JDialog dialog;
    private final AtomicBoolean doneWizardClose = new AtomicBoolean();

    public static boolean isDialogOpen() {
        return NUMBER_OF_OPEN_DIALOGS.get() > 0;
    }

    protected BaseDialog(Senior senior, Controller controller, boolean bl) {
        super(controller);
        this.senior = senior;
        this.modal = bl;
        NUMBER_OF_OPEN_DIALOGS.incrementAndGet();
    }

    protected BaseDialog(Senior senior, Controller controller, boolean bl, boolean bl2) {
        this(senior, controller, bl);
        this.resizable = bl2;
    }

    private void decrementOpenDialogCount() {
        if (!this.doneWizardClose.getAndSet(true)) {
            NUMBER_OF_OPEN_DIALOGS.decrementAndGet();
        }
    }

    public abstract String getTitle();

    protected abstract Icon getIcon();

    protected abstract JComponent getContent();

    protected abstract JButton getDefaultButton();

    protected abstract Component getButtonBar();

    protected static JButton createOKButton(ActionListener actionListener) {
        JButton jButton = new JButton(Translation.get("general.ok"));
        jButton.setMnemonic(Translation.get("general.ok.key").trim().charAt(0));
        jButton.addActionListener(actionListener);
        return jButton;
    }

    protected static JButton createCancelButton(ActionListener actionListener) {
        JButton jButton = new JButton(Translation.get("general.cancel"));
        jButton.setMnemonic(Translation.get("general.cancel.key").trim().charAt(0));
        jButton.addActionListener(actionListener);
        return jButton;
    }

    protected static JButton createCloseButton(ActionListener actionListener) {
        JButton jButton = new JButton(Translation.get("general.close"));
        jButton.setMnemonic(Translation.get("general.close.key").trim().charAt(0));
        jButton.addActionListener(actionListener);
        return jButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDialog open() {
        Window window = this.getUIController().getActiveFrame();
        Cursor cursor = CursorUtils.setWaitCursor(window);
        try {
            this.createUIComponent();
            UIUtil.putOnScreen(this.dialog);
            this.dialog.setVisible(true);
            JDialog jDialog = this.dialog;
            return jDialog;
        }
        finally {
            CursorUtils.returnToOriginal(window, cursor);
        }
    }

    public void close() {
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    protected void rePack() {
        if (this.dialog == null) {
            throw new IllegalStateException("Must be open to rePack");
        }
        this.dialog.pack();
    }

    private void createUIComponent() {
        int n;
        int n2;
        int n3;
        int n4;
        JLabel jLabel;
        JFrame jFrame = null;
        if (this.senior == Senior.MAIN_FRAME) {
            jFrame = this.getUIController().getMainFrame().getUIComponent();
        }
        this.dialog = new JDialog((Window)jFrame, this.getTitle(), this.modal ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
        this.dialog.setResizable(this.resizable);
        this.dialog.setDefaultCloseOperation(2);
        FormLayout formLayout = new FormLayout("pref, pref:grow", "fill:pref:grow, 10dlu, fill:pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        Icon icon = this.getIcon();
        JLabel jLabel2 = jLabel = icon != null ? new JLabel(this.getIcon()) : null;
        if (jLabel != null) {
            jLabel.setBorder(Borders.createEmptyBorder("3dlu, 3dlu, 3dlu, 3dlu"));
            panelBuilder.add((Component)jLabel, cellConstraints.xywh(1, 1, 1, 1, "right, top"));
        }
        JComponent jComponent = this.getContent();
        jComponent.setBorder(Borders.createEmptyBorder("3dlu, 3dlu, 3dlu, 3dlu"));
        panelBuilder.add((Component)jComponent, cellConstraints.xy(2, 1));
        Component component = this.getButtonBar();
        ((JComponent)component).setBorder(Borders.createEmptyBorder("3dlu, 3dlu, 3dlu, 3dlu"));
        panelBuilder.add(component, cellConstraints.xyw(1, 3, 2));
        this.dialog.getContentPane().add(panelBuilder.getPanel());
        this.dialog.getRootPane().setDefaultButton(this.getDefaultButton());
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane jRootPane = this.dialog.getRootPane();
        jRootPane.registerKeyboardAction(new CloseAction(), keyStroke, 2);
        this.dialog.pack();
        if (jFrame != null && jFrame.isVisible() && this.senior == Senior.MAIN_FRAME) {
            n4 = jFrame.getX();
            n3 = jFrame.getY();
            n2 = jFrame.getWidth();
            n = jFrame.getHeight();
        } else {
            n4 = 0;
            n3 = 0;
            n2 = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
            n = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        }
        int n5 = n4 + (n2 - this.dialog.getWidth()) / 2;
        int n6 = n3 + (n - this.dialog.getHeight()) / 2;
        this.dialog.setLocation(n5, n6);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                BaseDialog.this.decrementOpenDialogCount();
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                BaseDialog.this.decrementOpenDialogCount();
            }
        });
    }

    public static enum Senior {
        NONE,
        MAIN_FRAME;

    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseDialog.this.close();
        }
    }
}

