/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.computers;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.event.ListenerSupportFactory;
import de.dal33t.powerfolder.event.NodeManagerAdapter;
import de.dal33t.powerfolder.event.NodeManagerEvent;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.message.Identity;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.net.ConnectionHandler;
import de.dal33t.powerfolder.net.ConnectionQuality;
import de.dal33t.powerfolder.security.SecurityManagerEvent;
import de.dal33t.powerfolder.security.SecurityManagerListener;
import de.dal33t.powerfolder.ui.ExpandableView;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.dialog.ConnectDialog;
import de.dal33t.powerfolder.ui.event.ExpansionEvent;
import de.dal33t.powerfolder.ui.event.ExpansionListener;
import de.dal33t.powerfolder.ui.util.CursorUtils;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.ui.widget.JButtonMini;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class ExpandableComputerView
extends PFUIComponent
implements ExpandableView {
    private final Member node;
    private JPanel uiComponent;
    private JPanel lowerOuterPanel;
    private AtomicBoolean expanded;
    private JLabel infoLabel;
    private JButtonMini reconnectButton;
    private JButtonMini addRemoveButton;
    private JButtonMini pictoLabel;
    private JPanel upperPanel;
    private MyAddRemoveFriendAction addRemoveFriendAction;
    private MyReconnectAction reconnectAction;
    private JLabel lastSeenLabel;
    private JLabel usernameLabel;
    private JLabel versionLabel;
    private MyNodeManagerListener nodeManagerListener;
    private MySecurityManagerListener secManagerListener;
    private ExpansionListener listenerSupport;
    private JPopupMenu contextMenu;
    private JPanel borderPanel;
    private final AtomicBoolean focus = new AtomicBoolean();

    public ExpandableComputerView(Controller controller, Member member) {
        super(controller);
        this.listenerSupport = ListenerSupportFactory.createListenerSupport(ExpansionListener.class);
        this.node = member;
    }

    public void expand() {
        this.expanded.set(true);
        this.upperPanel.setToolTipText(Translation.get("exp.exp_computer_view.collapse"));
        this.lowerOuterPanel.setVisible(true);
        this.updateBorderPanel();
        this.listenerSupport.resetAllButSource(new ExpansionEvent(this));
    }

    @Override
    public void collapse() {
        this.expanded.set(false);
        this.upperPanel.setToolTipText(Translation.get("exp.exp_computer_view.expand"));
        this.lowerOuterPanel.setVisible(false);
        this.updateBorderPanel();
    }

    public void setFocus(boolean bl) {
        this.focus.set(bl);
        this.updateBorderPanel();
    }

    public boolean hasFocus() {
        return this.focus.get();
    }

    private void updateBorderPanel() {
        if (this.focus.get()) {
            this.borderPanel.setBorder(BorderFactory.createEtchedBorder());
        } else {
            this.borderPanel.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    public JPanel getUIComponent() {
        if (this.uiComponent == null) {
            this.buildUI();
        }
        return this.uiComponent;
    }

    public boolean isExpanded() {
        return this.expanded.get();
    }

    private void buildUI() {
        this.initComponent();
        FormLayout formLayout = new FormLayout("pref, 3dlu, pref, pref:grow, 3dlu, pref", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.pictoLabel, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.infoLabel, cellConstraints.xy(3, 1));
        this.upperPanel = panelBuilder.getPanel();
        this.upperPanel.setOpaque(false);
        this.upperPanel.setToolTipText(Translation.get("exp.exp_computer_view.expand"));
        MyMouseAdapter myMouseAdapter = new MyMouseAdapter();
        this.upperPanel.addMouseListener(myMouseAdapter);
        CursorUtils.setHandCursor(this.upperPanel);
        this.pictoLabel.addActionListener(new PrimaryButtonActionListener());
        FormLayout formLayout2 = new FormLayout("pref, pref:grow, 3dlu, pref, 2dlu, pref, 2dlu, pref", "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref");
        PanelBuilder panelBuilder2 = new PanelBuilder(formLayout2);
        panelBuilder2.setBorder(Borders.createEmptyBorder("0, 3dlu, 0, 3dlu"));
        panelBuilder2.addSeparator(null, cellConstraints.xyw(1, 1, 8));
        panelBuilder2.add((Component)this.usernameLabel, cellConstraints.xy(1, 3));
        panelBuilder2.add((Component)this.addRemoveButton, cellConstraints.xywh(6, 3, 1, 3));
        panelBuilder2.add((Component)this.reconnectButton, cellConstraints.xywh(8, 3, 1, 3));
        panelBuilder2.add((Component)this.lastSeenLabel, cellConstraints.xy(1, 5));
        if (this.getController().isVerbose()) {
            panelBuilder2.appendRow("3dlu");
            panelBuilder2.appendRow("pref");
            panelBuilder2.add((Component)this.versionLabel, cellConstraints.xy(1, 7));
        }
        JPanel jPanel = panelBuilder2.getPanel();
        jPanel.setOpaque(false);
        FormLayout formLayout3 = new FormLayout("pref:grow", "3dlu, pref");
        PanelBuilder panelBuilder3 = new PanelBuilder(formLayout3);
        this.lowerOuterPanel = panelBuilder3.getPanel();
        this.lowerOuterPanel.setOpaque(false);
        this.lowerOuterPanel.setVisible(false);
        panelBuilder3.add((Component)jPanel, cellConstraints.xy(1, 2));
        FormLayout formLayout4 = new FormLayout("3dlu, pref:grow, 3dlu", "3dlu, pref, pref, 3dlu");
        PanelBuilder panelBuilder4 = new PanelBuilder(formLayout4);
        panelBuilder4.add((Component)this.upperPanel, cellConstraints.xy(2, 2));
        JPanel jPanel2 = panelBuilder3.getPanel();
        jPanel2.setOpaque(false);
        panelBuilder4.add((Component)jPanel2, cellConstraints.xy(2, 3));
        this.borderPanel = panelBuilder4.getPanel();
        this.borderPanel.setOpaque(false);
        FormLayout formLayout5 = new FormLayout("3dlu, pref:grow, 3dlu", "pref, 3dlu");
        PanelBuilder panelBuilder5 = new PanelBuilder(formLayout5);
        panelBuilder5.add((Component)this.borderPanel, cellConstraints.xy(2, 1));
        this.uiComponent = panelBuilder5.getPanel();
        this.uiComponent.setOpaque(false);
        this.uiComponent.setTransferHandler(new MyTransferHandler());
    }

    private void initComponent() {
        this.expanded = new AtomicBoolean();
        this.infoLabel = new JLabel(this.node.getNick());
        this.lastSeenLabel = new JLabel();
        AccountInfo accountInfo = this.node.getAccountInfo();
        this.usernameLabel = new JLabel(accountInfo != null ? accountInfo.getScrabledDisplayName() : null);
        this.versionLabel = new JLabel(Translation.get("exp.exp_computer_view.version", ""));
        this.reconnectAction = new MyReconnectAction(this.getController());
        this.reconnectButton = new JButtonMini(this.reconnectAction);
        this.addRemoveFriendAction = new MyAddRemoveFriendAction(this.getController());
        this.addRemoveButton = new JButtonMini(this.addRemoveFriendAction);
        this.pictoLabel = new JButtonMini(Icons.getIconById("blank.icon"), "");
        this.updateDetails();
        this.configureAddRemoveButton();
        this.registerListeners();
    }

    public void removeCoreListeners() {
        this.getController().getNodeManager().removeNodeManagerListener(this.nodeManagerListener);
        this.getController().getSecurityManager().removeListener(this.secManagerListener);
    }

    private void registerListeners() {
        this.nodeManagerListener = new MyNodeManagerListener();
        this.getController().getNodeManager().addNodeManagerListener(this.nodeManagerListener);
        this.secManagerListener = new MySecurityManagerListener();
        this.getController().getSecurityManager().addListener(this.secManagerListener);
    }

    public Member getNode() {
        return this.node;
    }

    private void updateDetailsIfRequired(Member member) {
        if (this.node == null) {
            return;
        }
        if (this.node.equals(member)) {
            this.updateDetails();
            this.configureAddRemoveButton();
        }
    }

    private void configureAddRemoveButton() {
        if (this.node.isFriend()) {
            this.addRemoveFriendAction.setAdd(false);
        } else {
            this.addRemoveFriendAction.setAdd(true);
        }
        this.addRemoveButton.configureFromAction(this.addRemoveFriendAction);
    }

    private void updateDetails() {
        String string;
        Object object;
        Serializable serializable;
        if (this.node.isCompletelyConnected()) {
            this.lastSeenLabel.setText(Translation.get("exp.exp_computer_view.connected_text"));
        } else if (this.node.isConnecting()) {
            this.lastSeenLabel.setText(Translation.get("exp.exp_computer_view.connecting_text"));
        } else {
            serializable = this.node.getLastConnectTime();
            object = serializable == null ? "" : Format.formatDateShort((Date)serializable);
            this.lastSeenLabel.setText(Translation.get("exp.exp_computer_view.last_seen_text", new String[]{object}));
        }
        serializable = this.node.getAccountInfo();
        if (serializable != null && !this.node.isServer()) {
            this.usernameLabel.setText(Translation.get("exp.exp_computer_view.account", ((AccountInfo)serializable).getScrabledDisplayName()));
        } else if (this.node.isServer()) {
            this.usernameLabel.setText("");
        } else {
            this.usernameLabel.setText(Translation.get("exp.exp_computer_view.no_login"));
        }
        if (this.getController().isVerbose() && (object = this.node.getIdentity()) != null) {
            this.versionLabel.setText(Translation.get("exp.exp_computer_view.version", ((Identity)object).getProgramVersion()));
        }
        if (this.node.isCompletelyConnected()) {
            ConnectionQuality connectionQuality;
            ConnectionHandler connectionHandler = this.node.getPeer();
            object = "node_friend_connected.icon";
            string = Translation.get("exp.exp_computer_view.node_friend_connected_text");
            if (this.node.isOnLAN()) {
                object = "node_friend_lan.icon";
                string = Translation.get("exp.connection_lan.text");
            } else if (connectionHandler != null && (connectionQuality = connectionHandler.getConnectionQuality()) != null) {
                switch (connectionQuality) {
                    case GOOD: {
                        object = "node_friend_connected.icon";
                        string = Translation.get("exp.connection_quality_good.text");
                        break;
                    }
                    case MEDIUM: {
                        object = "node_friend_medium.icon";
                        string = Translation.get("exp.connection_quality_medium.text");
                        break;
                    }
                    case POOR: {
                        object = "node_friend_poor.icon";
                        string = Translation.get("exp.connection_quality_poor.text");
                    }
                }
            }
        } else if (this.node.isConnecting()) {
            object = "node_friend_disconnected.icon";
            string = Translation.get("exp.exp_computer_view.node_connecting_text");
        } else {
            object = "node_friend_disconnected.icon";
            string = Translation.get("exp.exp_computer_view.node_friend_disconnected_text");
        }
        this.pictoLabel.setIcon(Icons.getIconById((String)object));
        this.pictoLabel.setToolTipText(string);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ExpandableComputerView expandableComputerView = (ExpandableComputerView)object;
        return this.node.equals(expandableComputerView.node);
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public void addExpansionListener(ExpansionListener expansionListener) {
        ListenerSupportFactory.addListener(this.listenerSupport, expansionListener);
    }

    public void removeExpansionListener(ExpansionListener expansionListener) {
        ListenerSupportFactory.removeListener(this.listenerSupport, expansionListener);
    }

    public JPopupMenu createPopupMenu() {
        if (this.contextMenu == null) {
            this.contextMenu = new JPopupMenu();
            this.contextMenu.add(this.addRemoveFriendAction).setIcon(null);
            this.contextMenu.add(this.reconnectAction).setIcon(null);
        }
        return this.contextMenu;
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private volatile boolean mouseOver;

        private MyMouseAdapter() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (PreferencesEntry.AUTO_EXPAND.getValueBoolean(ExpandableComputerView.this.getController()).booleanValue()) {
                this.mouseOver = true;
                if (!ExpandableComputerView.this.expanded.get()) {
                    ExpandableComputerView.this.getController().schedule(() -> {
                        if (this.mouseOver && !ExpandableComputerView.this.expanded.get()) {
                            ExpandableComputerView.this.expand();
                        }
                    }, 2000L);
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.mouseOver = false;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showContextMenu(mouseEvent);
            }
        }

        private void showContextMenu(MouseEvent mouseEvent) {
            ExpandableComputerView.this.createPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                ExpandableComputerView.this.setFocus(true);
                if (ExpandableComputerView.this.expanded.get()) {
                    ExpandableComputerView.this.collapse();
                } else {
                    ExpandableComputerView.this.expand();
                }
            }
        }
    }

    private class PrimaryButtonActionListener
    implements ActionListener {
        private PrimaryButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ExpandableComputerView.this.expanded.get()) {
                ExpandableComputerView.this.collapse();
            } else {
                ExpandableComputerView.this.expand();
            }
        }
    }

    private class MyTransferHandler
    extends TransferHandler {
        private MyTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            return transferSupport.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            if (!transferSupport.isDrop()) {
                return false;
            }
            final Path path = this.getFileList(transferSupport);
            if (path == null) {
                return false;
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ExpandableComputerView.this.getUIController().transferSingleFile(path, ExpandableComputerView.this.node);
                }
            };
            SwingUtilities.invokeLater(runnable);
            return true;
        }

        private Path getFileList(TransferHandler.TransferSupport transferSupport) {
            Transferable transferable = transferSupport.getTransferable();
            try {
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                if (list.size() == 1) {
                    for (Object e : list) {
                        Path path;
                        if (!(e instanceof Path) || !Files.isDirectory(path = (Path)e, new LinkOption[0])) continue;
                        return path;
                    }
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                ExpandableComputerView.this.logSevere(unsupportedFlavorException);
            }
            catch (IOException iOException) {
                ExpandableComputerView.this.logSevere(iOException);
            }
            return null;
        }
    }

    private class MyReconnectAction
    extends BaseAction {
        MyReconnectAction(Controller controller) {
            super("exp.action_reconnect", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            final ConnectDialog connectDialog = new ConnectDialog(this.getController(), UIUtil.getParentWindow(actionEvent));
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    block3: {
                        connectDialog.open(ExpandableComputerView.this.node.getNick());
                        ExpandableComputerView.this.node.shutdown();
                        try {
                            if (ExpandableComputerView.this.node.reconnect().isFailure()) {
                                throw new ConnectionException(Translation.get("dialog.unable_to_connect_to_member", ExpandableComputerView.this.node.getNick()));
                            }
                        }
                        catch (ConnectionException connectionException) {
                            connectDialog.close();
                            if (connectDialog.isCanceled() || ExpandableComputerView.this.node.isConnected()) break block3;
                            connectionException.show(MyReconnectAction.this.getController());
                        }
                    }
                    connectDialog.close();
                }
            };
            new Thread(runnable, "Reconnector to " + ExpandableComputerView.this.node.getNick()).start();
        }
    }

    private class MyAddRemoveFriendAction
    extends BaseAction {
        private boolean add;

        private MyAddRemoveFriendAction(Controller controller) {
            super("exp.action_add_friend", controller);
            this.add = true;
        }

        public void setAdd(boolean bl) {
            this.add = bl;
            if (bl) {
                this.configureFromActionId("exp.action_add_friend");
            } else {
                this.configureFromActionId("exp.action_remove_friend");
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExpandableComputerView.this.node.setFriend(this.add, null);
        }
    }

    private class MyNodeManagerListener
    extends NodeManagerAdapter {
        private MyNodeManagerListener() {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }

        @Override
        public void friendAdded(NodeManagerEvent nodeManagerEvent) {
            ExpandableComputerView.this.updateDetailsIfRequired(nodeManagerEvent.getNode());
        }

        @Override
        public void friendRemoved(NodeManagerEvent nodeManagerEvent) {
            ExpandableComputerView.this.updateDetailsIfRequired(nodeManagerEvent.getNode());
        }

        @Override
        public void nodeAdded(NodeManagerEvent nodeManagerEvent) {
        }

        @Override
        public void nodeConnecting(NodeManagerEvent nodeManagerEvent) {
            ExpandableComputerView.this.updateDetailsIfRequired(nodeManagerEvent.getNode());
        }

        @Override
        public void nodeConnected(NodeManagerEvent nodeManagerEvent) {
            ExpandableComputerView.this.updateDetailsIfRequired(nodeManagerEvent.getNode());
        }

        @Override
        public void nodeDisconnected(NodeManagerEvent nodeManagerEvent) {
            ExpandableComputerView.this.updateDetailsIfRequired(nodeManagerEvent.getNode());
        }

        @Override
        public void nodeOnline(NodeManagerEvent nodeManagerEvent) {
            ExpandableComputerView.this.updateDetailsIfRequired(nodeManagerEvent.getNode());
        }

        @Override
        public void nodeOffline(NodeManagerEvent nodeManagerEvent) {
            ExpandableComputerView.this.updateDetailsIfRequired(nodeManagerEvent.getNode());
        }

        @Override
        public void nodeRemoved(NodeManagerEvent nodeManagerEvent) {
        }

        @Override
        public void settingsChanged(NodeManagerEvent nodeManagerEvent) {
            ExpandableComputerView.this.updateDetailsIfRequired(nodeManagerEvent.getNode());
        }

        @Override
        public void startStop(NodeManagerEvent nodeManagerEvent) {
            ExpandableComputerView.this.updateDetailsIfRequired(nodeManagerEvent.getNode());
        }
    }

    private class MySecurityManagerListener
    implements SecurityManagerListener {
        private MySecurityManagerListener() {
        }

        @Override
        public void nodeAccountStateChanged(SecurityManagerEvent securityManagerEvent) {
            ExpandableComputerView.this.updateDetailsIfRequired(securityManagerEvent.getNode());
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }
}

