/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui;

import de.dal33t.powerfolder.util.Reject;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Timer;

public class WindowDragManager {
    private Timer timer;
    private Component window;
    private int x;
    private int y;
    private int startX;
    private int startY;
    private int origX;
    private int origY;

    public WindowDragManager(Component component, int n) {
        Reject.ifNull(component, "Component must not be null");
        Reject.ifTrue(n <= 0, "timeout must be > 0");
        this.timer = new Timer(n, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WindowDragManager.this.updateComponentLocation();
            }
        });
        this.window = component;
        this.x = component.getX();
        this.y = component.getY();
    }

    public void start(MouseEvent mouseEvent) {
        this.timer.start();
        Point point = mouseEvent.getLocationOnScreen();
        Point point2 = this.window.getLocation();
        this.startX = point.x;
        this.startY = point.y;
        this.origX = point2.x;
        this.origY = point2.y;
    }

    public void stop(MouseEvent mouseEvent) {
        this.timer.stop();
        this.update(mouseEvent);
        this.updateComponentLocation();
    }

    public void update(MouseEvent mouseEvent) {
        Point point = mouseEvent.getLocationOnScreen();
        int n = point.x - this.startX;
        int n2 = point.y - this.startY;
        this.x = this.origX + n;
        this.y = this.origY + n2;
    }

    public void updateComponentLocation() {
        Point point = this.window.getLocation();
        if (point.x != this.x || point.y != this.y) {
            this.window.setLocation(this.x, this.y);
        }
    }
}

