/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui;

import com.jgoodies.binding.value.ValueModel;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.TimerTask;

public abstract class FilterModel
extends PFComponent {
    private static final long DELAY = 500L;
    private TimerTask task;
    private final ValueModel searchFieldVM;
    private ValueModel flatMode;

    protected FilterModel(Controller controller, ValueModel valueModel) {
        super(controller);
        this.searchFieldVM = valueModel;
        valueModel.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (FilterModel.this.task != null) {
                    FilterModel.this.task.cancel();
                }
                FilterModel.this.task = new TimerTask(){

                    @Override
                    public void run() {
                        FilterModel.this.preScheduleFiltering();
                        FilterModel.this.scheduleFiltering();
                        FilterModel.this.task = null;
                    }
                };
                FilterModel.this.getController().schedule(FilterModel.this.task, 500L);
            }
        });
    }

    public void preScheduleFiltering() {
    }

    public abstract void scheduleFiltering();

    public ValueModel getSearchFieldVM() {
        return this.searchFieldVM;
    }

    public boolean isFlatMode() {
        Object object = this.flatMode.getValue();
        return object != null && (Boolean)this.flatMode.getValue() != false;
    }

    public void setFlatMode(ValueModel valueModel) {
        this.flatMode = valueModel;
        valueModel.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TimerTask timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        FilterModel.this.scheduleFiltering();
                    }
                };
                FilterModel.this.getController().schedule(timerTask, 500L);
            }
        });
    }
}

