/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui;

import com.liferay.nativity.control.NativityControl;
import com.liferay.nativity.control.NativityControlUtil;
import com.liferay.nativity.listeners.SocketOpenListener;
import com.liferay.nativity.modules.contextmenu.ContextMenuControlUtil;
import com.liferay.nativity.modules.fileicon.FileIconControl;
import com.liferay.nativity.modules.fileicon.FileIconControlUtil;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderRepository;
import de.dal33t.powerfolder.ui.contextmenu.ContextMenuHandler;
import de.dal33t.powerfolder.ui.iconoverlay.IconOverlayHandler;
import de.dal33t.powerfolder.ui.iconoverlay.IconOverlayIndex;
import de.dal33t.powerfolder.ui.iconoverlay.IconOverlayUpdateListener;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.mac.MacUtils;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class FileBrowserIntegration
extends PFComponent {
    private NativityControl nc;
    private IconOverlayHandler iconOverlayHandler;
    private IconOverlayUpdateListener updateListener;
    private FileIconControl iconControl;

    public FileBrowserIntegration(Controller controller) {
        super(controller);
    }

    public boolean start() {
        this.logFine("Starting file browser integration");
        if (this.nc == null) {
            this.nc = NativityControlUtil.getNativityControl();
            if (this.nc == null) {
                this.logFine("Could not start file browser integration");
                return false;
            }
        }
        if (this.iconOverlayHandler == null) {
            this.iconOverlayHandler = new IconOverlayHandler(this.getController());
            this.iconControl = FileIconControlUtil.getFileIconControl(this.nc, this.iconOverlayHandler);
        }
        if (this.updateListener == null) {
            this.updateListener = new IconOverlayUpdateListener(this.getController(), this.iconControl, this.iconOverlayHandler);
        }
        if (PreferencesEntry.ENABLE_CONTEXT_MENU.getValueBoolean(this.getController()).booleanValue()) {
            this.logFine("Initializing context menu");
            ContextMenuControlUtil.getContextMenuControl(this.nc, new ContextMenuHandler(this.getController()));
        }
        FolderRepository folderRepository = this.getController().getFolderRepository();
        for (Folder folder : folderRepository.getFolders()) {
            folder.addFolderListener(this.updateListener);
        }
        folderRepository.addFolderRepositoryListener(this.updateListener);
        folderRepository.getLocking().addListener(this.updateListener);
        this.getController().getTransferManager().addListener(this.updateListener);
        if (OSUtil.isWindowsSystem()) {
            this.logFine("Connect file browser integration to Windows");
            return this.fbWindows();
        }
        if (OSUtil.isMacOS()) {
            this.logFine("Connect file browser integration to OS X");
            return this.fbApple();
        }
        return false;
    }

    private boolean fbApple() {
        try {
            this.logFine("Preparing icons");
            Path path = Paths.get(MacUtils.getInstance().getRecourcesLocation(), new String[0]).toAbsolutePath();
            final Path path2 = path.resolve(IconOverlayIndex.OK_OVERLAY.getFilename());
            final Path path3 = path.resolve(IconOverlayIndex.SYNCING_OVERLAY.getFilename());
            final Path path4 = path.resolve(IconOverlayIndex.WARNING_OVERLAY.getFilename());
            final Path path5 = path.resolve(IconOverlayIndex.IGNORED_OVERLAY.getFilename());
            final Path path6 = path.resolve(IconOverlayIndex.LOCKED_OVERLAY.getFilename());
            this.logFine("Registering icons");
            this.nc.addSocketOpenListener(new SocketOpenListener(){

                @Override
                public void onSocketOpen() {
                    FileBrowserIntegration.this.iconControl.registerIconWithId(path2.toString(), IconOverlayIndex.OK_OVERLAY.getLabel(), String.valueOf(IconOverlayIndex.OK_OVERLAY.getIndex()));
                    FileBrowserIntegration.this.iconControl.registerIconWithId(path3.toString(), IconOverlayIndex.SYNCING_OVERLAY.getLabel(), String.valueOf(IconOverlayIndex.SYNCING_OVERLAY.getIndex()));
                    FileBrowserIntegration.this.iconControl.registerIconWithId(path4.toString(), IconOverlayIndex.WARNING_OVERLAY.getLabel(), String.valueOf(IconOverlayIndex.WARNING_OVERLAY.getIndex()));
                    FileBrowserIntegration.this.iconControl.registerIconWithId(path5.toString(), IconOverlayIndex.IGNORED_OVERLAY.getLabel(), String.valueOf(IconOverlayIndex.IGNORED_OVERLAY.getIndex()));
                    FileBrowserIntegration.this.iconControl.registerIconWithId(path6.toString(), IconOverlayIndex.LOCKED_OVERLAY.getLabel(), String.valueOf(IconOverlayIndex.LOCKED_OVERLAY.getIndex()));
                    FileBrowserIntegration.this.iconControl.enableFileIcons();
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    arrayList.add("/");
                    try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get("/Volumes", new String[0]));){
                        for (Path object : directoryStream) {
                            if (Files.isDirectory(object, new LinkOption[0])) {
                                arrayList.add(object.toString() + "/");
                                continue;
                            }
                            FileBrowserIntegration.this.logFine("Ignoring " + object.toString());
                        }
                        for (String string : arrayList) {
                            FileBrowserIntegration.this.logInfo("Base directory for Finder Sync: " + string);
                        }
                    }
                    catch (IOException | RuntimeException exception) {
                        FileBrowserIntegration.this.logWarning("Error while determening the base volume paths to register for Finder Sync. " + exception, exception);
                    }
                    FileBrowserIntegration.this.nc.setFilterFolders(arrayList.toArray(new String[0]));
                }
            });
            if (!this.nc.connect()) {
                this.logWarning("Could not connect to finder sync.");
                return false;
            }
            this.logFine("Connected to finder sync.");
            try {
                this.logFine("Auto enabling extension.");
                String[] stringArray = new String[]{"pluginkit", "-e", "use", "-i", "com.liferay.nativity.LiferayFinderSync"};
                Runtime.getRuntime().exec(stringArray);
            }
            catch (Exception exception) {
                this.logWarning("Could not activate FinderSync extension automatically! " + exception);
            }
            return true;
        }
        catch (Exception exception) {
            this.logWarning("Could not start finder sync. " + exception);
            return false;
        }
    }

    private boolean fbWindows() {
        try {
            if (!this.nc.connect()) {
                this.logWarning("Could not connect to shell extensions!");
                return false;
            }
            this.nc.setFilterFolder("");
            this.iconControl.enableFileIcons();
            this.logFine("Connected to shell extensions.");
            return true;
        }
        catch (RuntimeException runtimeException) {
            this.logWarning("Could not start shell extensions. " + runtimeException);
            return false;
        }
    }

    public void shutdown() {
        FileIconControlUtil.getFileIconControl(this.nc, this.iconOverlayHandler).disableFileIcons();
        this.getController().getFolderRepository().getLocking().removeListener(this.updateListener);
        this.getController().getFolderRepository().removeFolderRepositoryListener(this.updateListener);
        this.getController().getTransferManager().removeListener(this.updateListener);
        FolderRepository folderRepository = this.getController().getFolderRepository();
        for (Folder folder : folderRepository.getFolders()) {
            folder.removeFolderListener(this.updateListener);
        }
    }
}

