/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.transfer;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Constants;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderRepository;
import de.dal33t.powerfolder.disk.problem.NoSpaceOnFileStoreProblem;
import de.dal33t.powerfolder.event.ListenerSupportFactory;
import de.dal33t.powerfolder.event.TransferManagerEvent;
import de.dal33t.powerfolder.event.TransferManagerListener;
import de.dal33t.powerfolder.event.api.DownloadedFile;
import de.dal33t.powerfolder.event.api.UploadedFile;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FileInfoKey;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.message.AbortUpload;
import de.dal33t.powerfolder.message.DownloadQueued;
import de.dal33t.powerfolder.message.FileChunk;
import de.dal33t.powerfolder.message.RequestDownload;
import de.dal33t.powerfolder.message.TransferStatus;
import de.dal33t.powerfolder.net.ConnectionHandler;
import de.dal33t.powerfolder.transfer.BandwidthLimiter;
import de.dal33t.powerfolder.transfer.BandwidthProvider;
import de.dal33t.powerfolder.transfer.BandwidthStatsRecorder;
import de.dal33t.powerfolder.transfer.CoalescedBandwidthStat;
import de.dal33t.powerfolder.transfer.Download;
import de.dal33t.powerfolder.transfer.DownloadManager;
import de.dal33t.powerfolder.transfer.DownloadManagerFactory;
import de.dal33t.powerfolder.transfer.MetaFolderDataHandler;
import de.dal33t.powerfolder.transfer.MultiSourceDownloadManager;
import de.dal33t.powerfolder.transfer.Transfer;
import de.dal33t.powerfolder.transfer.TransferProblem;
import de.dal33t.powerfolder.transfer.Upload;
import de.dal33t.powerfolder.transfer.swarm.FileRecordProvider;
import de.dal33t.powerfolder.transfer.swarm.VolatileFileRecordProvider;
import de.dal33t.powerfolder.util.Filter;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.NamedThreadFactory;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StreamUtils;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.TransferCounter;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.Validate;
import de.dal33t.powerfolder.util.Visitor;
import de.dal33t.powerfolder.util.WrapperExecutorService;
import de.dal33t.powerfolder.util.compare.MemberComparator;
import de.dal33t.powerfolder.util.compare.ReverseComparator;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TransferManager
extends PFComponent {
    public static final long PARTIAL_TRANSFER_DELAY = 5000L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_MINUTE = 60000L;
    private static final int INCOMPLETE_TRANSFERS_FILE_DELETE_DAYS_THRESHOLD = 30;
    private static final DecimalFormat CPS_FORMAT = new DecimalFormat("#,###,###,###.##");
    private volatile boolean started = false;
    private Thread myThread;
    private final List<Upload> queuedUploads;
    private final List<Upload> activeUploads;
    private final List<Upload> completedUploads;
    private final ConcurrentMap<FileInfo, DownloadManager> dlManagers;
    private final ConcurrentMap<Member, Integer> downloadsCount;
    private final List<Download> pendingDownloads;
    private final ConcurrentMap<FileInfoKey, DownloadManager> completedDownloads;
    private final Object waitTrigger = new Object();
    private boolean transferCheckTriggered;
    private final Lock uploadsLock = new ReentrantLock();
    private final Object downloadRequestLock = new Object();
    private FileRecordProvider fileRecordProvider;
    private ExecutorService threadPool;
    private final TransferCounter uploadCounter;
    private final TransferCounter downloadCounter;
    private final TransferCounter totalUploadTrafficCounter;
    private final TransferCounter totalDownloadTrafficCounter;
    private final BandwidthProvider bandwidthProvider;
    private final BandwidthLimiter sharedLANInputHandler;
    private final BandwidthLimiter sharedWANInputHandler;
    private final BandwidthLimiter sharedLANOutputHandler;
    private final BandwidthLimiter sharedWANOutputHandler;
    private final TransferManagerListener listenerSupport;
    private DownloadManagerFactory downloadManagerFactory = MultiSourceDownloadManager.factory;
    private BandwidthStatsRecorder statsRecorder;
    private final AtomicBoolean recalculatingAutomaticRates = new AtomicBoolean();
    private ReentrantLock scriptLock = new ReentrantLock();

    public TransferManager(Controller controller) {
        super(controller);
        this.queuedUploads = new CopyOnWriteArrayList<Upload>();
        this.activeUploads = new CopyOnWriteArrayList<Upload>();
        this.completedUploads = new CopyOnWriteArrayList<Upload>();
        this.dlManagers = Util.createConcurrentHashMap();
        this.pendingDownloads = new CopyOnWriteArrayList<Download>();
        this.completedDownloads = Util.createConcurrentHashMap();
        this.downloadsCount = Util.createConcurrentHashMap();
        this.uploadCounter = new TransferCounter();
        this.downloadCounter = new TransferCounter();
        this.totalUploadTrafficCounter = new TransferCounter();
        this.totalDownloadTrafficCounter = new TransferCounter();
        this.listenerSupport = ListenerSupportFactory.createListenerSupport(TransferManagerListener.class);
        this.bandwidthProvider = new BandwidthProvider(this.getController().getThreadPool());
        this.statsRecorder = new BandwidthStatsRecorder(this.getController());
        this.bandwidthProvider.addBandwidthStatListener(this.statsRecorder);
        this.sharedWANOutputHandler = BandwidthLimiter.WAN_OUTPUT_BANDWIDTH_LIMITER;
        this.sharedWANInputHandler = BandwidthLimiter.WAN_INPUT_BANDWIDTH_LIMITER;
        this.sharedLANOutputHandler = BandwidthLimiter.LAN_OUTPUT_BANDWIDTH_LIMITER;
        this.sharedLANInputHandler = BandwidthLimiter.LAN_INPUT_BANDWIDTH_LIMITER;
        this.checkConfigCPS(ConfigurationEntry.UPLOAD_LIMIT_WAN, 0L);
        this.checkConfigCPS(ConfigurationEntry.DOWNLOAD_LIMIT_WAN, 0L);
        this.checkConfigCPS(ConfigurationEntry.UPLOAD_LIMIT_LAN, 0L);
        this.checkConfigCPS(ConfigurationEntry.DOWNLOAD_LIMIT_LAN, 0L);
        this.setUploadCPSForWAN(this.getConfigCPS(ConfigurationEntry.UPLOAD_LIMIT_WAN));
        this.setDownloadCPSForWAN(this.getConfigCPS(ConfigurationEntry.DOWNLOAD_LIMIT_WAN));
        this.setUploadCPSForLAN(this.getConfigCPS(ConfigurationEntry.UPLOAD_LIMIT_LAN));
        this.setDownloadCPSForLAN(this.getConfigCPS(ConfigurationEntry.DOWNLOAD_LIMIT_LAN));
    }

    private void checkConfigCPS(ConfigurationEntry configurationEntry, long l) {
        String string = configurationEntry.getValue(this.getController());
        if (string == null) {
            configurationEntry.setValue(this.getController(), Long.toString(l / 1024L));
        }
    }

    private long getConfigCPS(ConfigurationEntry configurationEntry) {
        String string = configurationEntry.getValue(this.getController());
        long l = 0L;
        if (string != null) {
            try {
                l = (long)Double.parseDouble(string) * 1024L;
                if (l < 0L) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.logWarning("Illegal value for kByte." + configurationEntry + " '" + string + "'");
            }
        }
        return l;
    }

    public void printStats() {
        long l = this.totalDownloadTrafficCounter.getBytesTransferred() + this.totalUploadTrafficCounter.getBytesTransferred();
        long l2 = this.downloadCounter.getBytesTransferred() + this.uploadCounter.getBytesTransferred();
        long l3 = l - l2;
        this.logInfo("Total: " + Format.formatBytes(l) + ", Payload: " + Format.formatBytes(l2) + ". Overhead: " + l3 * 100L / l2 + "%");
    }

    public void start() {
        if (!ConfigurationEntry.TRANSFER_MANAGER_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            this.logWarning("Not starting TransferManager. disabled by config");
            return;
        }
        this.fileRecordProvider = new VolatileFileRecordProvider(this.getController());
        this.bandwidthProvider.start();
        this.threadPool = new WrapperExecutorService(Executors.newCachedThreadPool(new NamedThreadFactory("TMThread-")));
        this.myThread = new Thread((Runnable)new TransferChecker(), "Transfer manager");
        this.myThread.start();
        this.loadDownloads();
        this.cleanupOldTransfers();
        this.getController().scheduleAndRepeat(new PartialTransferStatsUpdater(), 5000L, 5000L);
        this.getController().scheduleAndRepeat(new TransferCleaner(), 60000L, 86400000L);
        this.started = true;
        this.logFine("Started");
    }

    private void cleanupOldTransfers() {
        int n = ConfigurationEntry.UPLOAD_AUTO_CLEANUP_FREQUENCY.getValueInt(this.getController());
        int n2 = n <= 4 ? Constants.CLEANUP_VALUES[n] : Integer.MAX_VALUE;
        for (Upload upload : this.completedUploads) {
            long l = TransferManager.calcDays(upload.getCompletedDate());
            if (l < (long)n2) continue;
            this.logInfo("Auto-cleaning up upload '" + upload.getFile().getRelativeName() + "' (days=" + l + ")");
            this.clearCompletedUpload(upload);
        }
        int n3 = ConfigurationEntry.DOWNLOAD_AUTO_CLEANUP_FREQUENCY.getValueInt(this.getController());
        int n4 = n3 <= 4 ? Constants.CLEANUP_VALUES[n3] : Integer.MAX_VALUE;
        int n5 = 0;
        for (DownloadManager downloadManager : this.completedDownloads.values()) {
            long l = TransferManager.calcDays(downloadManager.getCompletedDate());
            if (downloadManager.getCompletedDate() == null && this.isSevere()) {
                this.logFine("Completed download misses completed date: " + downloadManager.getCompletedDate());
            }
            if (l < (long)n4) continue;
            if (this.isFiner()) {
                this.logFiner("Auto-cleaning up download '" + downloadManager.getFileInfo().getRelativeName() + "' (days=" + l + ")");
            }
            this.clearCompletedDownload(downloadManager);
            ++n5;
        }
        if (n5 > 0) {
            this.logFine("Cleaned up " + n5 + " completed downloads");
        }
    }

    private void cleanIncompletedDownloadFiles() {
        for (Folder folder : this.getController().getFolderRepository().getFolders(true)) {
            this.cleanIncompletedDownloadFiles(folder);
        }
    }

    public void cleanIncompletedDownloadFiles(Folder folder) {
        Path path = folder.getSystemSubDir().resolve("transfers");
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        try {
            this.logFine("Cleaning up " + path);
            PathUtils.deleteIncompletedTransferFiles(path, 30);
        }
        catch (Exception exception) {
            this.logWarning("Unable to clean old transfers files at " + path + " - " + exception.getMessage(), exception);
        }
    }

    private static long calcDays(Date date) {
        if (date == null) {
            return -1L;
        }
        Date date2 = new Date();
        long l = date2.getTime() - date.getTime();
        return l / 86400000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.myThread != null) {
            this.myThread.interrupt();
        }
        if (this.threadPool != null) {
            this.threadPool.shutdownNow();
        }
        for (Upload object : this.activeUploads) {
            object.abort();
            object.shutdown();
        }
        this.bandwidthProvider.shutdown();
        if (this.started) {
            this.storeDownloads();
        }
        Iterator<Upload> iterator = this.dlManagers.values().iterator();
        while (iterator.hasNext()) {
            DownloadManager downloadManager;
            DownloadManager downloadManager2 = downloadManager = (DownloadManager)((Object)iterator.next());
            synchronized (downloadManager2) {
                downloadManager.setBroken(TransferProblem.BROKEN_DOWNLOAD, "shutdown");
            }
        }
        if (this.fileRecordProvider != null) {
            this.fileRecordProvider.shutdown();
            this.fileRecordProvider = null;
        }
        this.statsRecorder.persistStats();
        this.started = false;
        this.logFine("Stopped");
    }

    public void pruneStats() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        Date date = calendar.getTime();
        this.statsRecorder.pruneStats(date);
    }

    public void setSuspendFireEvents(boolean bl) {
        ListenerSupportFactory.setSuspended(this.listenerSupport, bl);
        this.logFine("setSuspendFireEvents: " + bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerTransfersCheck() {
        Object object = this.waitTrigger;
        synchronized (object) {
            this.transferCheckTriggered = true;
            this.waitTrigger.notifyAll();
        }
    }

    public BandwidthProvider getBandwidthProvider() {
        return this.bandwidthProvider;
    }

    public BandwidthLimiter getOutputLimiter(ConnectionHandler connectionHandler) {
        if (connectionHandler.isOnLAN()) {
            return this.sharedLANOutputHandler;
        }
        return this.sharedWANOutputHandler;
    }

    public BandwidthLimiter getInputLimiter(ConnectionHandler connectionHandler) {
        if (connectionHandler.isOnLAN()) {
            return this.sharedLANInputHandler;
        }
        return this.sharedWANInputHandler;
    }

    public TransferStatus getStatus() {
        TransferStatus transferStatus = new TransferStatus();
        transferStatus.activeUploads = this.activeUploads.size();
        transferStatus.queuedUploads = this.queuedUploads.size();
        transferStatus.maxUploadCPS = this.getUploadCPSForWAN();
        transferStatus.currentUploadCPS = (long)this.uploadCounter.calculateCurrentCPS();
        transferStatus.uploadedBytesTotal = this.uploadCounter.getBytesTransferred();
        for (DownloadManager downloadManager : this.dlManagers.values()) {
            for (Download download : downloadManager.getSources()) {
                if (download.isStarted()) {
                    ++transferStatus.activeDownloads;
                    continue;
                }
                ++transferStatus.queuedDownloads;
            }
        }
        transferStatus.maxDownloads = Integer.MAX_VALUE;
        transferStatus.maxDownloadCPS = Double.MAX_VALUE;
        transferStatus.currentDownloadCPS = (long)this.downloadCounter.calculateCurrentCPS();
        transferStatus.downloadedBytesTotal = this.downloadCounter.getBytesTransferred();
        return transferStatus;
    }

    private DownloadManager getDownloadManagerFor(FileInfo fileInfo) {
        Validate.notNull(fileInfo);
        DownloadManager downloadManager = (DownloadManager)this.dlManagers.get(fileInfo);
        if (downloadManager != null && downloadManager.getFileInfo().isVersionDateAndSizeIdentical(fileInfo)) {
            return downloadManager;
        }
        return null;
    }

    void setStarted(Transfer transfer) {
        if (transfer instanceof Upload) {
            this.uploadsLock.lock();
            try {
                this.queuedUploads.remove(transfer);
                this.activeUploads.add((Upload)transfer);
            }
            finally {
                this.uploadsLock.unlock();
            }
            this.fireUploadStarted(new TransferManagerEvent(this, (Upload)transfer));
        } else if (transfer instanceof Download) {
            this.fireDownloadStarted(new TransferManagerEvent(this, (Download)transfer));
        }
        if (this.isFine()) {
            this.logFine("Started: " + transfer);
        }
    }

    public void downloadQueued(Download download, Member member) {
        Reject.noNullElements(download, member);
        this.fireDownloadQueued(new TransferManagerEvent(this, download));
    }

    void uploadBroken(Upload upload, TransferProblem transferProblem) {
        this.uploadBroken(upload, transferProblem, null);
    }

    void downloadBroken(Download download, TransferProblem transferProblem, String string) {
        if (this.isFine()) {
            this.logFine("Download broken: " + download + " " + (Serializable)(transferProblem == null ? "" : transferProblem) + ": " + string);
        }
        download.setTransferProblem(transferProblem);
        download.setProblemInformation(string);
        this.removeDownload(download);
        this.fireDownloadBroken(new TransferManagerEvent(this, download, transferProblem, string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uploadBroken(Upload upload, TransferProblem transferProblem, String string) {
        upload.shutdown();
        if (this.isFine()) {
            this.logFine("Upload broken: " + upload + " " + (Serializable)(transferProblem == null ? "" : transferProblem) + ": " + string);
        }
        this.uploadsLock.lock();
        boolean bl = false;
        try {
            bl = this.queuedUploads.remove(upload);
            bl = bl || this.activeUploads.remove(upload);
        }
        finally {
            this.uploadsLock.unlock();
        }
        if (upload.getPartner().isCompletelyConnected()) {
            if (this.isFine()) {
                this.logFine("Sending abort upload of " + upload);
            }
            upload.getPartner().sendMessagesAsynchron(new AbortUpload(upload.getFile()));
        }
        if (bl) {
            this.fireUploadBroken(new TransferManagerEvent(this, upload));
        }
        this.triggerTransfersCheck();
    }

    public void breakTransfers(FolderInfo folderInfo) {
        Reject.ifNull(folderInfo, "Folderinfo is null");
        if (!this.queuedUploads.isEmpty()) {
            for (Upload object : this.queuedUploads) {
                if (!folderInfo.equals(object.getFile().getFolderInfo())) continue;
                this.uploadBroken(object, TransferProblem.FOLDER_REMOVED, folderInfo.getName());
            }
        }
        if (!this.activeUploads.isEmpty()) {
            for (Upload upload : this.activeUploads) {
                if (!folderInfo.equals(upload.getFile().getFolderInfo())) continue;
                this.uploadBroken(upload, TransferProblem.FOLDER_REMOVED, folderInfo.getName());
            }
        }
        for (DownloadManager downloadManager : this.dlManagers.values()) {
            if (!folderInfo.equals(downloadManager.getFileInfo().getFolderInfo())) continue;
            downloadManager.setBroken(TransferProblem.FOLDER_REMOVED, folderInfo.getName());
        }
    }

    public void breakTransfers(Member member) {
        if (!this.queuedUploads.isEmpty()) {
            for (Upload object : this.queuedUploads) {
                if (!member.equals(object.getPartner())) continue;
                this.uploadBroken(object, TransferProblem.NODE_DISCONNECTED, member.getNick());
            }
        }
        if (!this.activeUploads.isEmpty()) {
            for (Upload upload : this.activeUploads) {
                if (!member.equals(upload.getPartner())) continue;
                this.uploadBroken(upload, TransferProblem.NODE_DISCONNECTED, member.getNick());
            }
        }
        for (DownloadManager downloadManager : this.dlManagers.values()) {
            for (Download download : downloadManager.getSources()) {
                if (!member.equals(download.getPartner())) continue;
                download.setBroken(TransferProblem.NODE_DISCONNECTED, member.getNick());
            }
        }
    }

    public void breakTransfers(FileInfo fileInfo) {
        Reject.ifNull(fileInfo, "FileInfo is null");
        if (!this.queuedUploads.isEmpty()) {
            for (Upload object : this.queuedUploads) {
                if (!fileInfo.equals(object.getFile())) continue;
                this.uploadBroken(object, TransferProblem.FILE_CHANGED, fileInfo.getRelativeName());
            }
        }
        if (!this.activeUploads.isEmpty()) {
            for (Upload upload : this.activeUploads) {
                if (!fileInfo.equals(upload.getFile())) continue;
                upload.abort();
                this.uploadBroken(upload, TransferProblem.FILE_CHANGED, fileInfo.getRelativeName());
            }
        }
        for (DownloadManager downloadManager : this.dlManagers.values()) {
            if (!fileInfo.equals(downloadManager.getFileInfo())) continue;
            downloadManager.setBroken(TransferProblem.FILE_CHANGED, fileInfo.getRelativeName());
        }
    }

    void setCompleted(DownloadManager downloadManager) {
        assert (downloadManager.isDone());
        FileInfo fileInfo = downloadManager.getFileInfo();
        Folder folder = fileInfo.getFolder(this.getController().getFolderRepository());
        if (folder != null) {
            boolean bl;
            do {
                if (!(bl = this.abortUploadsOf(fileInfo))) continue;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (bl);
            assert (this.getActiveUploads(fileInfo).isEmpty());
            if (folder.scanDownloadFile(fileInfo, downloadManager.getTempFile())) {
                if (StringUtils.isNotBlank(folder.getDownloadScript())) {
                    Runnable object2 = () -> {
                        if (ConfigurationEntry.EVENT_API_URL_DOWNLOADED_FILE_CLIENT.hasNonBlankValue(this.getController())) {
                            new DownloadedFile(this.getController()).of(fileInfo).happened(false);
                        }
                        this.executeDownloadScript(fileInfo, folder, downloadManager);
                    };
                    this.doWork(object2);
                }
            } else {
                this.logWarning("Scanning of completed file failed: " + fileInfo.toDetailString() + " at " + downloadManager.getTempFile());
                downloadManager.setBroken(TransferProblem.FILE_CHANGED, "Scanning of completed file failed: " + fileInfo.toDetailString());
                return;
            }
        }
        this.completedDownloads.put(new FileInfoKey(fileInfo, FileInfoKey.Type.VERSION_DATE_SIZE), downloadManager);
        for (Download download : downloadManager.getSources()) {
            download.setCompleted();
        }
        this.removeDownloadManager(downloadManager);
        boolean bl = downloadManager.getFileInfo().getFolderInfo().isMetaFolder();
        boolean bl2 = bl = bl || ConfigurationEntry.DOWNLOAD_AUTO_CLEANUP_FREQUENCY.getValueInt(this.getController()) == 0 || PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()) == false && !ConfigurationEntry.DOWNLOAD_AUTO_CLEANUP_FREQUENCY.hasValue(this.getController());
        if (bl) {
            if (this.isFiner()) {
                this.logFiner("Auto-cleaned " + downloadManager.getSources());
            }
            this.clearCompletedDownload(downloadManager);
        }
        if (fileInfo.getFolderInfo().isMetaFolder()) {
            MetaFolderDataHandler metaFolderDataHandler = new MetaFolderDataHandler(this.getController());
            metaFolderDataHandler.handleMetaFolderFileInfo(fileInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDownloadScript(FileInfo fileInfo, Folder folder, DownloadManager downloadManager) {
        Object object;
        Reject.ifBlank(folder.getDownloadScript(), "Download script is not set");
        Path path = fileInfo.getDiskFile(this.getController().getFolderRepository());
        String string = folder.getDownloadScript();
        string = string.replace("$file", path.toAbsolutePath().toString());
        string = string.replace("$path", path.getParent().toString());
        string = string.replace("$folderpath", folder.getLocalBase().toAbsolutePath().toString());
        StringBuilder stringBuilder = new StringBuilder();
        for (Download object2 : downloadManager.getSources()) {
            object = object2.getPartner();
            if (object != null) {
                stringBuilder.append(((Member)object).getNick());
            }
            stringBuilder.append(',');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        string = string.replace("$sources", stringBuilder);
        try {
            this.scriptLock.lock();
            this.logInfo("Begin executing command: " + string);
            Process process = Runtime.getRuntime().exec(string);
            this.getController().schedule(() -> process.destroy(), 20000L);
            byte[] byArray = StreamUtils.readIntoByteArray(process.getInputStream());
            object = new String(byArray);
            byte[] byArray2 = StreamUtils.readIntoByteArray(process.getErrorStream());
            String string2 = new String(byArray2);
            int n = process.waitFor();
            this.logInfo("Executed command finished (exit value: " + n + "): " + string + " | stdout: " + (String)object + ", stderr: " + string2);
        }
        catch (IOException iOException) {
            this.logSevere("Unable to execute script after download. '" + folder.getDownloadScript() + "' file: " + path + ", command: " + string + ". " + iOException, iOException);
        }
        catch (InterruptedException interruptedException) {
            this.logSevere("Abnormal termination of script after download. '" + folder.getDownloadScript() + "' file: " + path + ", command: " + string + ". " + interruptedException, interruptedException);
        }
        finally {
            this.scriptLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean abortUploadsOf(FileInfo fileInfo) {
        this.uploadsLock.lock();
        boolean bl = false;
        try {
            for (Upload object : this.activeUploads) {
                if (!object.getFile().equals(fileInfo)) continue;
                bl = this.abortUpload(fileInfo, object.getPartner()) || bl;
            }
            LinkedList linkedList = new LinkedList();
            for (Upload upload : this.queuedUploads) {
                if (!upload.getFile().equals(fileInfo)) continue;
                bl = true;
                linkedList.add(upload);
            }
            this.queuedUploads.removeAll(linkedList);
        }
        finally {
            this.uploadsLock.unlock();
        }
        return bl;
    }

    private List<Upload> getActiveUploads(FileInfo fileInfo) {
        ArrayList<Upload> arrayList = new ArrayList<Upload>();
        for (Upload upload : this.activeUploads) {
            if (!upload.getFile().equals(fileInfo)) continue;
            arrayList.add(upload);
        }
        return arrayList;
    }

    public int countActiveUploads(Folder folder) {
        int n = 0;
        for (Upload upload : this.activeUploads) {
            if (!upload.getFile().getFolderInfo().equals(folder.getInfo())) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCompleted(Transfer transfer) {
        FileInfo fileInfo = transfer.getFile();
        if (transfer instanceof Download) {
            boolean bl;
            this.fireDownloadCompleted(new TransferManagerEvent(this, (Download)transfer));
            this.downloadsCount.remove(transfer.getPartner());
            int n = this.countActiveAndQueuedDownloads(transfer.getPartner());
            boolean bl2 = bl = n == 0;
            if (!bl) {
                if (transfer.getPartner().isOnLAN()) {
                    bl = n <= 12;
                } else {
                    boolean bl3 = bl = n <= 5;
                }
            }
            if (bl) {
                this.getController().getFolderRepository().getFileRequestor().triggerFileRequesting(fileInfo.getFolderInfo());
            } else if (this.isFiner()) {
                this.logFiner("Not triggering file requestor. " + n + " more dls from " + transfer.getPartner());
            }
        } else if (transfer instanceof Upload) {
            boolean bl;
            transfer.setCompleted();
            this.uploadsLock.lock();
            boolean bl4 = false;
            try {
                bl4 = this.queuedUploads.remove(transfer);
                bl4 = this.activeUploads.remove(transfer) || bl4;
                this.completedUploads.add((Upload)transfer);
            }
            finally {
                this.uploadsLock.unlock();
            }
            if (bl4) {
                this.fireUploadCompleted(new TransferManagerEvent(this, (Upload)transfer));
                if (ConfigurationEntry.EVENT_API_URL_UPLOADED_FILE_CLIENT.hasNonBlankValue(this.getController())) {
                    new UploadedFile(this.getController()).of(transfer.getFile()).happened(true);
                }
            }
            boolean bl5 = bl = (bl = transfer.getFile().getFolderInfo().isMetaFolder()) || ConfigurationEntry.UPLOAD_AUTO_CLEANUP_FREQUENCY.getValueInt(this.getController()) == 0;
            if (bl) {
                if (this.isFiner()) {
                    this.logFiner("Auto-cleaned " + transfer);
                }
                this.clearCompletedUpload((Upload)transfer);
            }
        }
        this.triggerTransfersCheck();
        if (this.isFiner()) {
            this.logFiner("Completed: " + transfer);
        }
    }

    public void updateSpeedLimits() {
        this.bandwidthProvider.setLimitBPS(this.sharedLANOutputHandler, this.getUploadCPSForLAN());
        this.bandwidthProvider.setLimitBPS(this.sharedWANOutputHandler, this.getUploadCPSForWAN());
        this.bandwidthProvider.setLimitBPS(this.sharedLANInputHandler, this.getDownloadCPSForLAN());
        this.bandwidthProvider.setLimitBPS(this.sharedWANInputHandler, this.getDownloadCPSForWAN());
    }

    public void setUploadCPSForWAN(long l) {
        ConfigurationEntry.UPLOAD_LIMIT_WAN.setValue(this.getController(), String.valueOf(l / 1024L));
        this.updateSpeedLimits();
        this.logFine("Upload limit: " + Format.formatBytesShort(this.getUploadCPSForWAN()) + "/s");
    }

    public long getUploadCPSForWAN() {
        return Integer.parseInt(ConfigurationEntry.UPLOAD_LIMIT_WAN.getValue(this.getController())) * 1024;
    }

    public void setDownloadCPSForWAN(long l) {
        ConfigurationEntry.DOWNLOAD_LIMIT_WAN.setValue(this.getController(), String.valueOf(l / 1024L));
        this.updateSpeedLimits();
        this.logFine("Download limit: " + Format.formatBytesShort(this.getDownloadCPSForWAN()) + "/s");
    }

    public long getDownloadCPSForWAN() {
        return ConfigurationEntry.DOWNLOAD_LIMIT_WAN.getValueInt(this.getController()) * 1024;
    }

    public void setUploadCPSForLAN(long l) {
        ConfigurationEntry.UPLOAD_LIMIT_LAN.setValue(this.getController(), String.valueOf(l / 1024L));
        this.updateSpeedLimits();
        this.logFine("LAN Upload limit: " + Format.formatBytesShort(this.getUploadCPSForLAN()) + "/s");
    }

    public long getUploadCPSForLAN() {
        return ConfigurationEntry.UPLOAD_LIMIT_LAN.getValueInt(this.getController()) * 1024;
    }

    public void setDownloadCPSForLAN(long l) {
        ConfigurationEntry.DOWNLOAD_LIMIT_LAN.setValue(this.getController(), String.valueOf(l / 1024L));
        this.updateSpeedLimits();
        this.logFine("LAN Download limit: " + Format.formatBytesShort(this.getDownloadCPSForLAN()) + "/s");
    }

    public long getDownloadCPSForLAN() {
        return Integer.parseInt(ConfigurationEntry.DOWNLOAD_LIMIT_LAN.getValue(this.getController())) * 1024;
    }

    int getMaxFileChunkSize() {
        return ConfigurationEntry.TRANSFERS_MAX_FILE_CHUNK_SIZE.getValueInt(this.getController());
    }

    int getMaxRequestsQueued() {
        return ConfigurationEntry.TRANSFERS_MAX_REQUESTS_QUEUED.getValueInt(this.getController());
    }

    public TransferCounter getUploadCounter() {
        return this.uploadCounter;
    }

    public TransferCounter getTotalUploadTrafficCounter() {
        return this.totalUploadTrafficCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Upload queueUpload(Member member, RequestDownload requestDownload) {
        boolean bl;
        boolean bl2;
        if (this.isFine()) {
            this.logFine("Received download request from " + member + ": " + requestDownload);
        }
        if (requestDownload == null || requestDownload.file == null) {
            throw new NullPointerException("Downloadrequest/File is null");
        }
        if (Constants.DB_FILENAME.equalsIgnoreCase(requestDownload.file.getRelativeName()) || Constants.DB_BACKUP_FILENAME.equalsIgnoreCase(requestDownload.file.getRelativeName())) {
            this.logSevere(member.getNick() + " has illegally requested to download a folder database file");
            return null;
        }
        Folder folder = requestDownload.file.getFolder(this.getController().getFolderRepository());
        if (folder == null) {
            this.logFine("Received illegal download request from " + member.getNick() + ". Not longer on folder " + requestDownload.file.getFolderInfo());
            return null;
        }
        if (!folder.hasReadPermission(member)) {
            this.logInfo("No Read permission for " + member.getAccountInfo() + " device " + member + " on " + folder);
            return null;
        }
        if (this.dlManagers.containsKey(requestDownload.file)) {
            this.logFine("Not queuing upload, active download of the file is in progress.");
            return null;
        }
        FolderRepository folderRepository = this.getController().getFolderRepository();
        Path path = requestDownload.file.getDiskFile(folderRepository);
        boolean bl3 = bl2 = path != null && requestDownload.file.inSyncWithDisk(path);
        if (!bl2) {
            if (path == null) {
                return null;
            }
            if (folder.isDeviceDisconnected() || folder.checkIfDeviceDisconnected()) {
                return null;
            }
            if (folder.scanAllowedNow()) {
                try {
                    folder.scanChangedFile(requestDownload.file);
                }
                catch (IllegalStateException illegalStateException) {
                    this.logWarning(requestDownload.file.toDetailString() + ": Unable to queue file for upload. " + illegalStateException);
                }
                catch (RuntimeException runtimeException) {
                    this.logWarning(requestDownload.file.toDetailString() + ": Unable to queue file for upload. " + runtimeException, runtimeException);
                }
            } else if (this.isWarning()) {
                if (Files.exists(path, new LinkOption[0])) {
                    try {
                        this.logWarning("File not in sync with disk: '" + requestDownload.file.toDetailString() + "', disk file at " + Files.getLastModifiedTime(path, new LinkOption[0]).toMillis());
                    }
                    catch (IOException iOException) {
                        this.logFine("Could not access modification time of file " + path.toAbsolutePath().toString());
                    }
                } else {
                    this.logFine("File was requested, but not found: " + requestDownload.file.toDetailString());
                }
            }
            return null;
        }
        FileInfo fileInfo = requestDownload.file.getLocalFileInfo(folderRepository);
        boolean bl4 = bl = fileInfo != null && fileInfo.isVersionDateAndSizeIdentical(requestDownload.file);
        if (!bl) {
            this.logWarning("File not in sync with db: '" + requestDownload.file.toDetailString() + "', but I have " + (fileInfo != null ? fileInfo.toDetailString() : "none"));
            return null;
        }
        Upload upload = new Upload(this, member, requestDownload);
        if (upload.isBroken()) {
            return null;
        }
        this.uploadsLock.lock();
        Upload upload2 = null;
        try {
            int n = this.activeUploads.indexOf(upload);
            if (n >= 0) {
                upload2 = this.activeUploads.get(n);
                this.activeUploads.remove(n);
            }
            if ((n = this.queuedUploads.indexOf(upload)) >= 0) {
                if (upload2 != null) {
                    throw new IllegalStateException("Found illegal upload. is in list of queued AND active uploads: " + upload2);
                }
                upload2 = this.queuedUploads.get(n);
                this.queuedUploads.remove(n);
            }
            this.logFine("Queued: " + upload + ", startOffset: " + requestDownload.startOffset + ", to: " + member);
            this.queuedUploads.add(upload);
        }
        finally {
            this.uploadsLock.unlock();
        }
        this.fireUploadRequested(new TransferManagerEvent(this, upload));
        if (upload2 != null) {
            if (this.isFine()) {
                this.logFine("Received already known download request for " + requestDownload.file + " from " + member.getNick() + ", overwriting old request");
            }
            upload2.abort();
            upload2.shutdown();
            this.uploadBroken(upload2, TransferProblem.OLD_UPLOAD, member.getNick());
        }
        this.triggerTransfersCheck();
        this.getController().schedule(() -> {
            if (!(upload.isStarted() || upload.isCompleted() || upload.isBroken() || upload.isAborted())) {
                member.sendMessageAsynchron(new DownloadQueued(upload.getFile()));
            } else if (this.isFiner()) {
                this.logFiner("Optimization. Did not send DownloadQueued message for " + upload.getFile() + " to " + upload.getPartner());
            }
        }, 500L);
        return upload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean abortUpload(FileInfo fileInfo, Member member) {
        if (fileInfo == null) {
            throw new NullPointerException("Unable to abort upload, file is null");
        }
        if (member == null) {
            throw new NullPointerException("Unable to abort upload, to-member is null");
        }
        Upload upload = null;
        for (Upload upload2 : this.queuedUploads) {
            if (!upload2.getFile().isVersionDateAndSizeIdentical(fileInfo) || !member.equals(upload2.getPartner())) continue;
            this.uploadsLock.lock();
            try {
                this.queuedUploads.remove(upload2);
            }
            finally {
                this.uploadsLock.unlock();
            }
            upload2.abort();
            upload = upload2;
        }
        for (Upload upload2 : this.activeUploads) {
            if (!upload2.getFile().isVersionDateAndSizeIdentical(fileInfo) || !member.equals(upload2.getPartner())) continue;
            this.uploadsLock.lock();
            try {
                this.activeUploads.remove(upload2);
            }
            finally {
                this.uploadsLock.unlock();
            }
            upload2.abort();
            upload = upload2;
        }
        if (upload != null) {
            this.fireUploadAborted(new TransferManagerEvent(this, upload));
            this.triggerTransfersCheck();
            return true;
        }
        if (this.isFine()) {
            this.logFine("Upload to abort not found: " + fileInfo + " to " + member);
        }
        return false;
    }

    public FileRecordProvider getFileRecordManager() {
        return this.fileRecordProvider;
    }

    void perfomUpload(Runnable runnable) {
        if (!this.threadPool.isTerminated() && !this.threadPool.isShutdown()) {
            this.threadPool.submit(runnable);
        }
    }

    void doWork(Runnable runnable) {
        if (!this.threadPool.isTerminated() && !this.threadPool.isShutdown()) {
            this.threadPool.submit(runnable);
        }
    }

    public int countActiveUploads() {
        return this.activeUploads.size();
    }

    public Collection<Upload> getActiveUploads() {
        return Collections.unmodifiableCollection(this.activeUploads);
    }

    public List<Upload> getCompletedUploadsCollection() {
        return Collections.unmodifiableList(this.completedUploads);
    }

    public int countQueuedUploads() {
        return this.queuedUploads.size();
    }

    public int countLiveUploads() {
        return this.activeUploads.size() + this.queuedUploads.size();
    }

    public int countAllUploads() {
        return this.activeUploads.size() + this.queuedUploads.size() + this.completedUploads.size();
    }

    public int countUploadsOn(Folder folder) {
        int n = 0;
        for (Upload upload : this.activeUploads) {
            if (!upload.getFile().getFolderInfo().equals(folder.getInfo())) continue;
            ++n;
        }
        for (Upload upload : this.queuedUploads) {
            if (!upload.getFile().getFolderInfo().equals(folder.getInfo())) continue;
            ++n;
        }
        return n;
    }

    public Collection<Upload> getQueuedUploads() {
        return Collections.unmodifiableCollection(this.queuedUploads);
    }

    public boolean uploadingTo(Member member) {
        return this.uploadingToSize(member) >= 0L;
    }

    public long uploadingToSize(Member member) {
        long l = 0L;
        boolean bl = false;
        for (Upload upload : this.activeUploads) {
            if (!member.equals(upload.getPartner())) continue;
            l += upload.getFile().getSize();
            bl = true;
        }
        if (!bl) {
            return -1L;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDownload(Download download) {
        DownloadManager downloadManager = download.getDownloadManager();
        if (downloadManager == null) {
            return;
        }
        DownloadManager downloadManager2 = downloadManager;
        synchronized (downloadManager2) {
            this.downloadsCount.remove(download.getPartner());
            if (downloadManager.hasSource(download)) {
                try {
                    downloadManager.removeSource(download);
                }
                catch (Exception exception) {
                    this.logSevere("Unable to remove download: " + download, exception);
                }
                if (!downloadManager.hasSources()) {
                    if (downloadManager.isDone()) {
                        this.logFine("No further sources in that manager, Not removing it because it's already done");
                    } else {
                        this.logFine("No further sources, removing " + downloadManager);
                        downloadManager.setBroken(TransferProblem.BROKEN_DOWNLOAD, "Out of sources for download");
                    }
                }
            }
        }
    }

    public TransferCounter getDownloadCounter() {
        return this.downloadCounter;
    }

    public TransferCounter getTotalDownloadTrafficCounter() {
        return this.totalDownloadTrafficCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enquePendingDownload(Download download) {
        FileInfo fileInfo;
        Validate.notNull(download);
        FileInfo fileInfo2 = download.getFile();
        if (download.isRequestedAutomatic()) {
            this.logFiner("Not adding pending download, is a auto-dl: " + fileInfo2);
            return false;
        }
        if (!this.getController().getFolderRepository().hasJoinedFolder(fileInfo2.getFolderInfo())) {
            this.logWarning("Not adding pending download, not on folder: " + fileInfo2);
            return false;
        }
        Folder folder = fileInfo2.getFolder(this.getController().getFolderRepository());
        FileInfo fileInfo3 = fileInfo = folder != null ? folder.getFile(fileInfo2) : null;
        if (fileInfo != null && fileInfo2.isVersionDateAndSizeIdentical(fileInfo)) {
            this.logWarning("Not adding pending download, already have: " + fileInfo2);
            return false;
        }
        boolean bl = true;
        List<Download> list = this.pendingDownloads;
        synchronized (list) {
            if (!this.pendingDownloads.contains(download) && !this.dlManagers.containsKey(download.getFile())) {
                bl = false;
                this.pendingDownloads.add(0, download);
            }
        }
        if (!bl) {
            this.logFine("Pending download added for: " + fileInfo2);
            return true;
        }
        return false;
    }

    public DownloadManagerFactory getDownloadManagerFactory() {
        return this.downloadManagerFactory;
    }

    public void setDownloadManagerFactory(DownloadManagerFactory downloadManagerFactory) {
        this.downloadManagerFactory = downloadManagerFactory;
    }

    public DownloadManager downloadNewestVersion(FileInfo fileInfo) {
        return this.downloadNewestVersion(fileInfo, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadManager downloadNewestVersion(FileInfo fileInfo, boolean bl) {
        Serializable serializable = null;
        boolean bl2 = false;
        boolean bl3 = false;
        Object object = this.downloadRequestLock;
        synchronized (object) {
            Serializable serializable2;
            Object object2;
            long l;
            FileInfo fileInfo2;
            FileInfo fileInfo3;
            Folder folder;
            block25: {
                folder = fileInfo.getFolder(this.getController().getFolderRepository());
                if (folder == null) {
                    return null;
                }
                if (!this.started) {
                    return null;
                }
                if (folder.isDeviceDisconnected()) {
                    return null;
                }
                if (folder.getDiskItemFilter().isExcluded(fileInfo)) {
                    return null;
                }
                if (!fileInfo.isValid()) {
                    return null;
                }
                FileInfo fileInfo4 = fileInfo.getNewestVersion(folder);
                fileInfo3 = folder.getFile(fileInfo);
                FileInfo fileInfo5 = fileInfo2 = fileInfo4 != null ? fileInfo4 : fileInfo;
                if (fileInfo3 != null && !fileInfo2.isNewerThan(fileInfo3)) {
                    if (this.isFiner()) {
                        this.logFiner("NOT requesting download, already has latest file in own db: " + fileInfo.toDetailString());
                    }
                    return null;
                }
                if (fileInfo2.inSyncWithDisk(fileInfo.getDiskFile(this.getController().getFolderRepository()))) {
                    if (this.isFiner()) {
                        this.logFiner("NOT requesting download, file seems already to exists on disk: " + fileInfo.toDetailString());
                    }
                    return null;
                }
                l = -1L;
                try {
                    object2 = Files.getFileStore(folder.getLocalBase());
                    l = ((FileStore)object2).getUsableSpace();
                }
                catch (Throwable throwable) {
                    this.logInfo("Could not get the usable space for " + folder.toString() + " located at " + folder.getLocalBase().toString());
                    if (!folder.checkIfDeviceDisconnected()) break block25;
                    return null;
                }
            }
            if (l > 0L && fileInfo2.getSize() > l) {
                folder.addProblem(new NoSpaceOnFileStoreProblem(folder.getInfo()));
                return null;
            }
            object2 = this.getSourcesWithFreeUploadCapacity(fileInfo);
            LinkedList<Member> linkedList = null;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Member member = (Member)iterator.next();
                serializable2 = member.getFile(fileInfo);
                if (serializable2 == null || !fileInfo2.isVersionDateAndSizeIdentical((FileInfo)serializable2)) continue;
                if (linkedList == null) {
                    linkedList = new LinkedList<Member>();
                }
                linkedList.add(member);
            }
            if (linkedList != null) {
                for (Member member : linkedList) {
                    serializable2 = new Download(this, fileInfo2, bl);
                    if (this.isFiner()) {
                        this.logFiner("Best source for " + fileInfo + " is " + member);
                    }
                    if (fileInfo3 != null && fileInfo3.getModifiedDate().after(fileInfo2.getModifiedDate()) && !fileInfo3.isDeleted() && this.isFine()) {
                        this.logFine("Requesting older file: " + fileInfo2.toDetailString() + ", local: " + fileInfo3.toDetailString() + ", localIsNewer: " + fileInfo3.isNewerThan(fileInfo2));
                    }
                    if (fileInfo2.isNewerAvailable(this.getController().getFolderRepository())) {
                        this.logFine("Downloading old version while newer is available: " + fileInfo3);
                    }
                    serializable = serializable2;
                    bl3 = this.requestDownload((Download)serializable2, member);
                }
            }
            if (linkedList == null && !bl) {
                serializable = new Download(this, fileInfo2, false);
                bl2 = this.enquePendingDownload((Download)serializable);
            }
        }
        if (bl3) {
            this.fireDownloadRequested(new TransferManagerEvent(this, (Download)serializable));
        }
        if (bl2) {
            this.firePendingDownloadEnqueud(new TransferManagerEvent(this, (Download)serializable));
            return null;
        }
        return this.getActiveDownload(fileInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestDownload(Download download, Member member) {
        DownloadManager downloadManager;
        Object object;
        FileInfo fileInfo = download.getFile();
        ConcurrentMap<FileInfo, DownloadManager> concurrentMap = this.dlManagers;
        synchronized (concurrentMap) {
            object = this.getActiveDownload(member, fileInfo);
            if (object != null) {
                if (this.isFiner()) {
                    this.logFiner("Already downloading " + fileInfo.toDetailString() + " from " + member);
                }
                return false;
            }
            if (fileInfo.isVersionDateAndSizeIdentical(fileInfo.getFolder(this.getController().getFolderRepository()).getFile(fileInfo))) {
                if (this.isFiner()) {
                    this.logFiner("Not requesting download, already have latest file version: " + fileInfo.toDetailString());
                }
                return false;
            }
            downloadManager = (DownloadManager)this.dlManagers.get(fileInfo);
            if (downloadManager == null || !fileInfo.isVersionDateAndSizeIdentical(downloadManager.getFileInfo())) {
                if (downloadManager != null) {
                    if (!downloadManager.isDone()) {
                        if (this.isFine()) {
                            this.logFine("Aborting download. Got active download of different file version: " + downloadManager);
                        }
                        downloadManager.abortAndCleanup();
                    }
                    return false;
                }
                try {
                    downloadManager = this.downloadManagerFactory.createDownloadManager(this.getController(), fileInfo, download.isRequestedAutomatic());
                    downloadManager.init(false);
                }
                catch (IOException iOException) {
                    this.logWarning("IOException while initializing download of " + fileInfo.toDetailString() + ": " + iOException);
                    return false;
                }
                if (this.dlManagers.put(fileInfo, downloadManager) != null) {
                    throw new AssertionError((Object)"Found old manager!");
                }
            }
        }
        if (this.abortUploadsOf(fileInfo)) {
            this.logFine("Aborted uploads of file to be downloaded: " + fileInfo.toDetailString());
        }
        boolean bl = false;
        object = downloadManager;
        synchronized (object) {
            if (fileInfo.isVersionDateAndSizeIdentical(fileInfo.getFolder(this.getController().getFolderRepository()).getFile(fileInfo))) {
                if (this.isFine()) {
                    this.logFine("Aborting download, already have latest file version: " + fileInfo.toDetailString());
                }
                downloadManager.abort();
                return false;
            }
            if (downloadManager.getSourceFor(member) == null && !downloadManager.isDone() && downloadManager.canAddSource(member)) {
                if (this.isFine()) {
                    this.logFine("Requesting " + fileInfo.toDetailString() + " from " + member);
                }
                if (fileInfo.isNewerThan(downloadManager.getFileInfo())) {
                    this.logSevere("Requested newer download: " + download + " than " + downloadManager);
                }
                this.pendingDownloads.remove(download);
                this.downloadsCount.remove(member);
                download.setPartner(member);
                download.setDownloadManager(downloadManager);
                bl = downloadManager.addSource(download);
            }
        }
        if (bl) {
            if (this.isFiner()) {
                this.logFiner("File really was requested!" + download.getFile().toDetailString());
            }
            return true;
        }
        return false;
    }

    public List<Member> getSourcesFor(FileInfo fileInfo) {
        return this.getSourcesFor0(fileInfo, false, true);
    }

    public List<Member> getSourcesForAnyVersion(FileInfo fileInfo) {
        return this.getSourcesFor0(fileInfo, false, false);
    }

    private List<Member> getSourcesWithFreeUploadCapacity(FileInfo fileInfo) {
        return this.getSourcesFor0(fileInfo, true, true);
    }

    private List<Member> getSourcesFor0(FileInfo fileInfo, boolean bl, boolean bl2) {
        Reject.ifNull(fileInfo, "File is null");
        Folder folder = fileInfo.getFolder(this.getController().getFolderRepository());
        if (folder == null) {
            return Collections.emptyList();
        }
        ArrayList<Member> arrayList = null;
        for (Member member : folder.getMembersAsCollection()) {
            FileInfo fileInfo2 = member.getFile(fileInfo);
            if (!member.isCompletelyConnected() || member.isMySelf() || fileInfo2 == null || bl && !this.hasUploadCapacity(member) || bl2 && fileInfo.getVersion() != fileInfo2.getVersion()) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Member>();
            }
            arrayList.add(member);
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        Collections.shuffle(arrayList);
        Collections.sort(arrayList, new ReverseComparator<Member>(MemberComparator.BY_UPLOAD_AVAILIBILITY));
        return arrayList;
    }

    public void abortAllAutodownloads(Folder folder) {
        int n = 0;
        for (DownloadManager downloadManager : this.getActiveDownloads()) {
            boolean bl = folder.getInfo().equals(downloadManager.getFileInfo().getFolderInfo());
            if (!bl || !downloadManager.isRequestedAutomatic()) continue;
            downloadManager.abort();
            ++n;
        }
        this.logFine("Aborted " + n + " downloads on " + folder);
    }

    public void abortDownloads(Visitor<DownloadManager> visitor) {
        int n = 0;
        for (DownloadManager downloadManager : this.getActiveDownloads()) {
            if (!visitor.visit(downloadManager)) continue;
            downloadManager.abortAndCleanup();
            ++n;
        }
        if (n > 0 && this.isFine()) {
            this.logFine("Aborted " + n + " downloads");
        }
    }

    void downloadManagerAborted(DownloadManager downloadManager) {
        if (downloadManager.isRequestedAutomatic()) {
            if (this.isFine()) {
                this.logFine("Aborted download: " + downloadManager);
            }
        } else {
            this.logWarning("Aborted download: " + downloadManager);
        }
        this.removeDownloadManager(downloadManager);
    }

    void downloadManagerBroken(DownloadManager downloadManager, TransferProblem transferProblem, String string) {
        Download download;
        this.removeDownloadManager(downloadManager);
        if (!downloadManager.isRequestedAutomatic() && this.enquePendingDownload(download = new Download(this, downloadManager.getFileInfo(), downloadManager.isRequestedAutomatic()))) {
            this.firePendingDownloadEnqueud(new TransferManagerEvent(this, download));
        }
    }

    private void removeDownloadManager(DownloadManager downloadManager) {
        assert (downloadManager.isDone()) : "Manager to remove is NOT done!";
        this.dlManagers.remove(downloadManager.getFileInfo(), downloadManager);
    }

    void downloadAborted(Download download) {
        this.pendingDownloads.remove(download);
        this.removeDownload(download);
        this.fireDownloadAborted(new TransferManagerEvent(this, download));
    }

    public void abortDownload(FileInfo fileInfo, Member member) {
        Reject.ifNull(fileInfo, "FileInfo is null");
        Reject.ifNull(member, "From is null");
        Download download = this.getActiveDownload(member, fileInfo);
        if (download != null) {
            assert (download.getPartner().equals(member));
            if (this.isFiner()) {
                this.logFiner("downloading changed file, aborting it! " + fileInfo.toDetailString() + " " + member);
            }
            download.abort(false);
        } else {
            for (Download download2 : this.pendingDownloads) {
                if (!download2.getFile().equals(fileInfo) || download2.getPartner() == null || !download2.getPartner().equals(member)) continue;
                if (this.isFiner()) {
                    this.logFiner("Aborting pending download! " + fileInfo.toDetailString() + " " + member);
                }
                download2.abort(false);
            }
        }
    }

    public void clearCompletedDownload(DownloadManager downloadManager) {
        if (this.completedDownloads.remove(new FileInfoKey(downloadManager.getFileInfo(), FileInfoKey.Type.VERSION_DATE_SIZE)) == null) {
            this.logWarning(downloadManager.getFileInfo().toDetailString() + ": Completed download manager not found: " + downloadManager);
        }
        for (Download download : downloadManager.getSources()) {
            this.fireCompletedDownloadRemoved(new TransferManagerEvent(this, download));
        }
    }

    public void clearCompletedUpload(Upload upload) {
        if (this.completedUploads.remove(upload)) {
            this.fireCompletedUploadRemoved(new TransferManagerEvent(this, upload));
        }
    }

    public void chunkAdded(Download download, FileChunk fileChunk) {
        Reject.noNullElements(download, fileChunk);
        this.downloadCounter.chunkTransferred(fileChunk);
    }

    public boolean isDownloading(FileInfo fileInfo) {
        return this.isDownloadingActive(fileInfo) || this.isDownloadingPending(fileInfo);
    }

    public boolean isDownloadingActive(FileInfo fileInfo) {
        return this.dlManagers.containsKey(fileInfo);
    }

    public boolean isDownloadingPending(FileInfo fileInfo) {
        Reject.ifNull(fileInfo, "File is null");
        for (Download download : this.pendingDownloads) {
            if (!download.getFile().equals(fileInfo)) continue;
            return true;
        }
        return false;
    }

    public boolean isUploading(FileInfo fileInfo) {
        for (Upload upload : this.activeUploads) {
            if (!upload.getFile().equals(fileInfo)) continue;
            return true;
        }
        for (Upload upload : this.queuedUploads) {
            if (!upload.getFile().equals(fileInfo)) continue;
            return true;
        }
        return false;
    }

    public boolean isUploadActive(FileInfo fileInfo, boolean bl) {
        for (Upload upload : this.activeUploads) {
            if (bl && upload.getPartner().isOnLAN() || !upload.getFile().equals(fileInfo)) continue;
            return true;
        }
        return false;
    }

    public Upload getUpload(Member member, FileInfo fileInfo) {
        for (Upload upload : this.activeUploads) {
            if (!upload.getFile().isVersionDateAndSizeIdentical(fileInfo) || !upload.getPartner().equals(member)) continue;
            return upload;
        }
        for (Upload upload : this.queuedUploads) {
            if (!upload.getFile().isVersionDateAndSizeIdentical(fileInfo) || !upload.getPartner().equals(member)) continue;
            return upload;
        }
        return null;
    }

    public Download getCompletedDownload(Member member, FileInfo fileInfo) {
        DownloadManager downloadManager = this.getCompletedDownload(fileInfo);
        if (downloadManager == null) {
            return null;
        }
        Download download = downloadManager.getSourceFor(member);
        if (download == null) {
            return null;
        }
        assert (download.getPartner().equals(member));
        return download;
    }

    public DownloadManager getCompletedDownload(FileInfo fileInfo) {
        return (DownloadManager)this.completedDownloads.get(new FileInfoKey(fileInfo, FileInfoKey.Type.VERSION_DATE_SIZE));
    }

    public Download getActiveDownload(Member member, FileInfo fileInfo) {
        DownloadManager downloadManager = this.getDownloadManagerFor(fileInfo);
        if (downloadManager == null) {
            return null;
        }
        Download download = downloadManager.getSourceFor(member);
        if (download == null) {
            return null;
        }
        assert (download.getPartner().equals(member));
        return download;
    }

    public DownloadManager getActiveDownload(FileInfo fileInfo) {
        return this.getDownloadManagerFor(fileInfo);
    }

    public Download getPendingDownload(FileInfo fileInfo) {
        for (Download download : this.pendingDownloads) {
            if (!fileInfo.equals(download.getFile())) continue;
            return download;
        }
        return null;
    }

    public int countNumberOfDownloads(Folder folder) {
        Reject.ifNull(folder, "Folder is null");
        int n = 0;
        for (DownloadManager downloadManager : this.dlManagers.values()) {
            for (Download download : downloadManager.getSources()) {
                if (!download.getFile().getFolderInfo().equals(folder.getInfo())) continue;
                ++n;
            }
        }
        return n;
    }

    public int getNumberOfDownloadsFrom(Member member) {
        if (member == null) {
            throw new NullPointerException("From is null");
        }
        int n = 0;
        for (DownloadManager downloadManager : this.dlManagers.values()) {
            if (downloadManager.getSourceFor(member) == null) continue;
            ++n;
        }
        return n;
    }

    public Collection<Download> getPendingDownloads() {
        return Collections.unmodifiableCollection(this.pendingDownloads);
    }

    public Collection<DownloadManager> getActiveDownloads() {
        return Collections.unmodifiableCollection(this.dlManagers.values());
    }

    public int countCompletedDownloads() {
        return this.completedDownloads.size();
    }

    public int countCompletedDownloads(Folder folder) {
        int n = 0;
        for (DownloadManager downloadManager : this.completedDownloads.values()) {
            Folder folder2 = downloadManager.getFileInfo().getFolder(this.getController().getFolderRepository());
            if (folder2 == null || !folder2.getInfo().equals(folder.getInfo())) continue;
            ++n;
        }
        return n;
    }

    public int countActiveDownloads(Folder folder) {
        int n = 0;
        for (DownloadManager downloadManager : this.dlManagers.values()) {
            Folder folder2 = downloadManager.getFileInfo().getFolder(this.getController().getFolderRepository());
            if (folder2 == null || !folder2.getInfo().equals(folder.getInfo())) continue;
            ++n;
        }
        return n;
    }

    public Collection<DownloadManager> getCompletedDownloadsCollection() {
        return Collections.unmodifiableCollection(this.completedDownloads.values());
    }

    public List<DownloadManager> getCompletedDownloadsCollection(Filter<DownloadManager> filter) {
        Reject.ifNull(filter, "Filter");
        if (this.completedDownloads.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DownloadManager> arrayList = new ArrayList<DownloadManager>();
        for (DownloadManager downloadManager : this.completedDownloads.values()) {
            if (!filter.accept(downloadManager)) continue;
            arrayList.add(downloadManager);
        }
        return arrayList;
    }

    public boolean isCompletedDownload(FileInfo fileInfo) {
        return this.completedDownloads.get(new FileInfoKey(fileInfo, FileInfoKey.Type.VERSION_DATE_SIZE)) != null;
    }

    public int countActiveDownloads() {
        return this.dlManagers.size();
    }

    public int countTotalDownloads() {
        return this.countActiveDownloads() + this.pendingDownloads.size() + this.completedDownloads.size();
    }

    public boolean hasUploadCapacity(Member member) {
        int n = this.countActiveAndQueuedDownloads(member);
        int n2 = member.isOnLAN() ? 50 : 20;
        return n < n2;
    }

    private int countActiveAndQueuedDownloads(Member member) {
        Integer n = (Integer)this.downloadsCount.get(member);
        if (n != null) {
            return n;
        }
        int n2 = 0;
        for (DownloadManager downloadManager : this.dlManagers.values()) {
            for (Download download : downloadManager.getSources()) {
                if (!download.getPartner().equals(member) || download.isCompleted() || download.isBroken()) continue;
                ++n2;
            }
        }
        this.downloadsCount.put(member, n2);
        return n2;
    }

    private void loadDownloads() {
        Path path = Controller.getMiscFilesLocation().resolve(this.getController().getConfigName() + ".transfers");
        if (Files.notExists(path, new LinkOption[0])) {
            this.logFine("No downloads to restore, " + path.toAbsolutePath() + " does not exists");
            return;
        }
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(path.toAbsolutePath().toString()));){
            List list = (List)objectInputStream.readObject();
            Collections.reverse(list);
            if (list.size() > 10000) {
                this.logWarning("Got many completed downloads (" + list.size() + "). Cleanup is recommended");
            }
            HashMap<FileInfo, List> hashMap = new HashMap<FileInfo, List>();
            for (Object e : list) {
                Download download = (Download)e;
                download.init(this);
                if (download.isCompleted()) {
                    List list2 = hashMap.computeIfAbsent(download.getFile(), fileInfo -> new ArrayList(1));
                    DownloadManager downloadManager = null;
                    for (DownloadManager downloadManager2 : list2) {
                        if (!downloadManager2.getFileInfo().isVersionDateAndSizeIdentical(download.getFile())) continue;
                        downloadManager = downloadManager2;
                        break;
                    }
                    if (downloadManager == null) {
                        downloadManager = this.downloadManagerFactory.createDownloadManager(this.getController(), download.getFile(), download.isRequestedAutomatic());
                        downloadManager.init(true);
                        this.completedDownloads.put(new FileInfoKey(downloadManager.getFileInfo(), FileInfoKey.Type.VERSION_DATE_SIZE), downloadManager);
                        list2.add(downloadManager);
                    }
                    if (download.getPartner() == null) continue;
                    download.setDownloadManager(downloadManager);
                    if (!downloadManager.canAddSource(download.getPartner())) continue;
                    downloadManager.addSource(download);
                    continue;
                }
                if (!download.isPending() || !this.enquePendingDownload(download)) continue;
                this.firePendingDownloadEnqueud(new TransferManagerEvent(this, download));
            }
            this.logFine("Loaded " + list.size() + " downloads");
        }
        catch (IOException iOException) {
            this.logWarning("Unable to load pending downloads", iOException);
            try {
                Files.delete(path);
            }
            catch (IOException iOException2) {
                this.logSevere("Unable to delete transfer file!");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logSevere("Unable to load pending downloads", classNotFoundException);
            try {
                Files.delete(path);
            }
            catch (IOException iOException) {
                this.logSevere("Unable to delete pending downloads file!");
            }
        }
        catch (ClassCastException classCastException) {
            this.logSevere("Unable to load pending downloads", classCastException);
            try {
                Files.delete(path);
            }
            catch (IOException iOException) {
                this.logSevere("Unable to delete pending downloads file!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeDownloads() {
        LinkedList<Download> linkedList = new LinkedList<Download>(this.pendingDownloads);
        int n = this.countActiveDownloads();
        int n2 = this.completedDownloads.size();
        for (DownloadManager downloadManager : this.dlManagers.values()) {
            linkedList.add(new Download(this, downloadManager.getFileInfo(), downloadManager.isRequestedAutomatic()));
        }
        for (DownloadManager downloadManager : this.completedDownloads.values()) {
            linkedList.addAll(downloadManager.getSources());
        }
        this.logFiner("Storing " + linkedList.size() + " downloads (" + n + " pending, " + n2 + " completed)");
        Path path = Controller.getMiscFilesLocation().resolve(this.getController().getConfigName() + ".transfers");
        if (Files.notExists(path.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                this.logSevere("Failed to create misc directory! " + iOException);
            }
        }
        boolean bl = Thread.interrupted();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            objectOutputStream.writeObject(linkedList);
        }
        catch (IOException iOException) {
            this.logWarning("Unable to store pending downloads. " + (Path)path + ": " + iOException);
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void clearCompletedDownload(FileInfo fileInfo) {
        FileInfoKey fileInfoKey = new FileInfoKey(fileInfo, FileInfoKey.Type.VERSION_DATE_SIZE);
        DownloadManager downloadManager = (DownloadManager)this.completedDownloads.remove(fileInfoKey);
        if (downloadManager == null) {
            return;
        }
        for (Download download : downloadManager.getSources()) {
            this.fireCompletedDownloadRemoved(new TransferManagerEvent(this, download));
        }
    }

    public Set<CoalescedBandwidthStat> getBandwidthStats() {
        return this.statsRecorder.getBandwidthStats();
    }

    public void abortAllDownloads() {
        for (DownloadManager downloadManager : this.dlManagers.values()) {
            downloadManager.abort();
        }
    }

    public void abortAllUploads() {
        for (Upload upload : this.activeUploads) {
            this.uploadBroken(upload, TransferProblem.PAUSED);
        }
        for (Upload upload : this.queuedUploads) {
            this.uploadBroken(upload, TransferProblem.PAUSED);
        }
    }

    public void checkActiveTranfersForExcludes() {
        Folder folder;
        FileInfo fileInfo;
        for (DownloadManager object : this.dlManagers.values()) {
            fileInfo = object.getFileInfo();
            folder = fileInfo.getFolder(this.getController().getFolderRepository());
            if (folder == null || !folder.getDiskItemFilter().isExcluded(fileInfo)) continue;
            this.logInfo("Aborting download, file is now excluded from sync: " + fileInfo);
            this.breakTransfers(fileInfo);
        }
        for (Upload upload : this.queuedUploads) {
            fileInfo = upload.getFile();
            folder = fileInfo.getFolder(this.getController().getFolderRepository());
            if (folder == null || !folder.getDiskItemFilter().isExcluded(fileInfo)) continue;
            this.logInfo("Aborting upload, file is now excluded from sync: " + fileInfo);
            this.breakTransfers(fileInfo);
        }
        for (Upload upload : this.activeUploads) {
            fileInfo = upload.getFile();
            folder = fileInfo.getFolder(this.getController().getFolderRepository());
            if (folder == null || !folder.getDiskItemFilter().isExcluded(fileInfo)) continue;
            this.logInfo("Aborting upload, file is now excluded from sync: " + fileInfo);
            this.breakTransfers(fileInfo);
        }
    }

    private void checkDownloads() {
        if (this.isFiner()) {
            this.logFiner("Checking " + this.countActiveDownloads() + " download(s)");
        }
        for (DownloadManager downloadManager : this.dlManagers.values()) {
            try {
                this.downloadNewestVersion(downloadManager.getFileInfo(), downloadManager.isRequestedAutomatic());
                for (Download download : downloadManager.getSources()) {
                    if (download.isCompleted() || !download.isBroken()) continue;
                    download.setBroken(TransferProblem.BROKEN_DOWNLOAD, "isBroken()");
                }
            }
            catch (RuntimeException runtimeException) {
                this.logWarning("While checking downloads. " + runtimeException, runtimeException);
            }
        }
    }

    private void checkQueuedUploads() {
        if (this.isFiner()) {
            this.logFiner("Checking " + this.queuedUploads.size() + " queued uploads");
        }
        int n = 0;
        int n2 = 0;
        for (Upload upload : this.queuedUploads) {
            try {
                long l;
                boolean bl;
                if (upload.isBroken()) {
                    this.uploadBroken(upload, TransferProblem.BROKEN_UPLOAD);
                    ++n;
                    continue;
                }
                long l2 = this.uploadingToSize(upload.getPartner());
                if (l2 == -1L) {
                    bl = false;
                    l2 = 0L;
                } else {
                    bl = true;
                }
                long l3 = l = upload.getPartner().isOnLAN() ? 0xA00000L : 0x200000L;
                if (bl && (l2 += upload.getFile().getSize()) > l) continue;
                if (bl && this.isFiner()) {
                    this.logFiner("Starting another upload to " + upload.getPartner().getNick() + ". Total size to upload to: " + Format.formatBytesShort(l2));
                }
                if (upload.isAborted()) {
                    this.logFine("Not starting aborted: " + upload);
                    continue;
                }
                if (upload.getPartner().isOnLAN() || !this.isUploadActive(upload.getFile(), true)) {
                    this.logFiner("Starting upload: " + upload);
                    upload.start();
                    ++n2;
                    continue;
                }
                this.logFine("Waiting with Internet upload of file " + upload.getFile() + ". Already upload to an Internet device");
            }
            catch (Exception exception) {
                this.logSevere("Exception while cheking queued uploads. " + exception, exception);
            }
        }
        if (this.isFiner()) {
            this.logFiner("Started " + n2 + " upload(s), " + n + " broken upload(s)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPendingDownloads() {
        if (this.isFiner()) {
            this.logFiner("Checking " + this.pendingDownloads.size() + " pending downloads");
        }
        for (Download download : this.pendingDownloads) {
            try {
                Object object;
                boolean bl;
                FileInfo fileInfo = download.getFile();
                boolean bl2 = bl = this.getDownloadManagerFor(fileInfo) == null;
                if (bl && this.getController().getFolderRepository().hasJoinedFolder(fileInfo.getFolderInfo())) {
                    object = this.downloadNewestVersion(fileInfo, download.isRequestedAutomatic());
                    if (object == null) continue;
                    this.logFine("Pending download restored: " + fileInfo + " from " + (DownloadManager)object);
                    List<Download> list = this.pendingDownloads;
                    synchronized (list) {
                        this.pendingDownloads.remove(download);
                        continue;
                    }
                }
                if (download.getDownloadManager() == null || download.getDownloadManager().isDone()) continue;
                this.logWarning("Pending download removed: " + fileInfo);
                object = this.pendingDownloads;
                synchronized (object) {
                    this.pendingDownloads.remove(download);
                }
            }
            catch (Exception exception) {
                this.logSevere("Exception while cheking pending downloads. " + exception, exception);
            }
        }
    }

    public FutureTask<Object> getRecalculateAutomaticRate() {
        return new FutureTask<Object>(new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                if (TransferManager.this.recalculatingAutomaticRates.getAndSet(true)) {
                    return null;
                }
                boolean bl = TransferManager.this.getController().isPaused();
                TransferManager.this.getController().setPaused(true);
                try {
                    long l;
                    Date date = new Date();
                    long l2 = 0L;
                    long l3 = 1047552L;
                    boolean bl2 = false;
                    Date date2 = new Date();
                    long l4 = 261888L;
                    boolean bl3 = TransferManager.this.countActiveUploads() == 0 && TransferManager.this.testAvailabilityUpload(l4);
                    Date date3 = new Date();
                    long l5 = date2.getTime() - date.getTime();
                    long l6 = date3.getTime() - date2.getTime();
                    if (bl2) {
                        l2 = l5 > 0L ? l3 * 1000L / l5 : 0L;
                    }
                    long l7 = l = l6 > 0L ? l4 * 1000L / l6 : 0L;
                    if (bl2) {
                        TransferManager.this.logFine("Test availability download rate " + Format.formatBytesShort(l2) + "/s");
                    }
                    if (bl3) {
                        TransferManager.this.logFine("Test availability upload rate " + Format.formatBytesShort(l) + "/s");
                    }
                    long l8 = 90L * l2 / 100L;
                    long l9 = 90L * l / 100L;
                    TransferManager.this.logInfo("Speed test finished: Download " + Format.formatBytesShort(l2) + "/s, Upload " + Format.formatBytesShort(l) + "/s");
                    if (l < 10240L) {
                        l = 0L;
                    }
                    if (l2 < 102400L || l2 < l) {
                        l2 = 0L;
                    }
                    if (bl2) {
                        TransferManager.this.setDownloadCPSForWAN(l8);
                    } else {
                        TransferManager.this.setDownloadCPSForWAN(0L);
                    }
                    if (bl3) {
                        TransferManager.this.setUploadCPSForWAN(l9);
                    }
                }
                finally {
                    TransferManager.this.recalculatingAutomaticRates.set(false);
                    TransferManager.this.getController().setPaused(bl);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testAvailabilityUpload(long l) {
        try {
            String string = this.getController().getOSClient().getWebURL() + "/testavailability?action=upload";
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(true);
            String string2 = "---------------------------313223033317673";
            uRLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string2);
            try (PrintWriter printWriter = null;){
                printWriter = new PrintWriter(new OutputStreamWriter(uRLConnection.getOutputStream(), "UTF-8"));
                printWriter.println("--" + string2);
                printWriter.println("Content-Disposition: form-data; name=\"upload\"");
                printWriter.println("Content-Type: text/plain; charset=UTF-8");
                printWriter.println();
                String string3 = "action";
                printWriter.println(string3);
                printWriter.println("--" + string2);
                printWriter.println("Content-Disposition: form-data; name=\"fileToUpload\"; filename=\"file.txt\"");
                printWriter.println("Content-Type: text/plain; charset=UTF-8");
                printWriter.println();
                int n = 0;
                while ((long)n < l) {
                    printWriter.write(88);
                    ++n;
                }
                printWriter.println();
                printWriter.println("--" + string2 + "--");
                printWriter.println();
            }
            int n = ((HttpURLConnection)uRLConnection).getResponseCode();
            return n == 200;
        }
        catch (Exception exception) {
            this.logWarning("Test availability upload failed: " + exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testAvailabilityDownload(long l) {
        BufferedReader bufferedReader = null;
        try {
            String string = this.getController().getOSClient().getWebURL() + "/testavailability?action=download&size=" + l;
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            while (bufferedReader.readLine() != null) {
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            this.logWarning("Test availability download failed: " + exception);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logTransfer(boolean bl, boolean bl2, long l, FileInfo fileInfo, Member member) {
        Object object;
        Object object2 = "";
        if (member != null) {
            object2 = (bl ? " from " : " to ") + "'" + member.getNick() + "'";
        }
        String string = "-";
        if (l > 1000L) {
            double d = fileInfo.getSize();
            d /= 1024.0;
            d /= (double)l;
            d *= 1000.0;
            object = CPS_FORMAT;
            synchronized (object) {
                string = CPS_FORMAT.format(d);
            }
        }
        if (this.isInfo()) {
            String string2 = bl ? "Download" : "Upload";
            String string3 = bl2 ? "aborted: " : "completed: ";
            object = string2 + " " + string3;
            object = (String)object + Format.formatDecimal(fileInfo.getSize()) + " bytes in " + l / 1000L + "s (" + string + " kByte/s): " + fileInfo + (String)object2;
            if (fileInfo.getFolderInfo().isMetaFolder()) {
                this.logFine((String)object);
            } else {
                this.logInfo((String)object);
            }
        }
    }

    public void addListener(TransferManagerListener transferManagerListener) {
        ListenerSupportFactory.addListener(this.listenerSupport, transferManagerListener);
    }

    public void removeListener(TransferManagerListener transferManagerListener) {
        ListenerSupportFactory.removeListener(this.listenerSupport, transferManagerListener);
    }

    private void fireUploadStarted(TransferManagerEvent transferManagerEvent) {
        this.listenerSupport.uploadStarted(transferManagerEvent);
    }

    private void fireUploadAborted(TransferManagerEvent transferManagerEvent) {
        this.listenerSupport.uploadAborted(transferManagerEvent);
    }

    private void fireUploadBroken(TransferManagerEvent transferManagerEvent) {
        this.listenerSupport.uploadBroken(transferManagerEvent);
    }

    private void fireUploadCompleted(TransferManagerEvent transferManagerEvent) {
        this.listenerSupport.uploadCompleted(transferManagerEvent);
    }

    private void fireUploadRequested(TransferManagerEvent transferManagerEvent) {
        this.listenerSupport.uploadRequested(transferManagerEvent);
    }

    private void fireDownloadAborted(TransferManagerEvent transferManagerEvent) {
        this.listenerSupport.downloadAborted(transferManagerEvent);
    }

    private void fireDownloadBroken(TransferManagerEvent transferManagerEvent) {
        this.listenerSupport.downloadBroken(transferManagerEvent);
    }

    private void fireDownloadCompleted(TransferManagerEvent transferManagerEvent) {
        this.listenerSupport.downloadCompleted(transferManagerEvent);
    }

    private void fireDownloadQueued(TransferManagerEvent transferManagerEvent) {
        this.listenerSupport.downloadQueued(transferManagerEvent);
    }

    private void fireDownloadRequested(TransferManagerEvent transferManagerEvent) {
        this.listenerSupport.downloadRequested(transferManagerEvent);
    }

    private void fireDownloadStarted(TransferManagerEvent transferManagerEvent) {
        this.listenerSupport.downloadStarted(transferManagerEvent);
    }

    private void fireCompletedDownloadRemoved(TransferManagerEvent transferManagerEvent) {
        this.listenerSupport.completedDownloadRemoved(transferManagerEvent);
    }

    private void fireCompletedUploadRemoved(TransferManagerEvent transferManagerEvent) {
        this.listenerSupport.completedUploadRemoved(transferManagerEvent);
    }

    private void firePendingDownloadEnqueud(TransferManagerEvent transferManagerEvent) {
        this.listenerSupport.pendingDownloadEnqueued(transferManagerEvent);
    }

    private class TransferChecker
    implements Runnable {
        private TransferChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long l = 10000L;
            int n = 0;
            while (!Thread.currentThread().isInterrupted()) {
                if (TransferManager.this.getController().isPaused()) {
                    TransferManager.this.logFine("Paused.");
                } else {
                    if (TransferManager.this.isFiner()) {
                        TransferManager.this.logFiner("Checking uploads/downloads");
                    }
                    TransferManager.this.checkQueuedUploads();
                    TransferManager.this.checkPendingDownloads();
                    TransferManager.this.checkDownloads();
                    if (n % 2 == 0 && TransferManager.this.isFine()) {
                        TransferManager.this.logFine("Transfers: " + TransferManager.this.countActiveDownloads() + " download(s), " + Format.formatDecimal(TransferManager.this.getDownloadCounter().calculateCurrentKBS()) + " kByte/s, " + TransferManager.this.activeUploads.size() + " active upload(s), " + TransferManager.this.queuedUploads.size() + " in queue, " + Format.formatDecimal(TransferManager.this.getUploadCounter().calculateCurrentKBS()) + " kByte/s");
                    }
                    ++n;
                }
                try {
                    Thread.sleep(10L);
                    Object object = TransferManager.this.waitTrigger;
                    synchronized (object) {
                        if (!TransferManager.this.transferCheckTriggered) {
                            TransferManager.this.waitTrigger.wait(l);
                        }
                        TransferManager.this.transferCheckTriggered = false;
                    }
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }

    private class PartialTransferStatsUpdater
    extends TimerTask {
        private PartialTransferStatsUpdater() {
        }

        @Override
        public void run() {
            Object object;
            FolderRepository folderRepository = TransferManager.this.getController().getFolderRepository();
            for (Serializable serializable : TransferManager.this.dlManagers.keySet()) {
                Folder folder;
                object = (DownloadManager)TransferManager.this.dlManagers.get(serializable);
                if (object == null || (folder = folderRepository.getFolder(((FileInfo)serializable).getFolderInfo())) == null) continue;
                folder.getStatistic().putPartialSyncStat((FileInfo)serializable, TransferManager.this.getController().getMySelf(), object.getCounter().getBytesTransferred());
            }
            for (Serializable serializable : TransferManager.this.activeUploads) {
                object = ((Transfer)serializable).getFile().getFolder(folderRepository);
                if (object == null) continue;
                ((Folder)object).getStatistic().putPartialSyncStat(((Transfer)serializable).getFile(), ((Transfer)serializable).getPartner(), ((Transfer)serializable).getCounter().getBytesTransferred());
            }
        }
    }

    private class TransferCleaner
    extends TimerTask {
        private TransferCleaner() {
        }

        @Override
        public void run() {
            TransferManager.this.cleanupOldTransfers();
            TransferManager.this.cleanIncompletedDownloadFiles();
        }
    }
}

