/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.transfer;

import de.dal33t.powerfolder.transfer.BandwidthLimiter;
import de.dal33t.powerfolder.transfer.LimitedStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LimitedOutputStream
extends FilterOutputStream
implements LimitedStream {
    protected BandwidthLimiter limiter;

    public LimitedOutputStream(BandwidthLimiter bandwidthLimiter, OutputStream outputStream) {
        super(outputStream);
        this.limiter = bandwidthLimiter;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            long l;
            try {
                l = this.limiter.requestBandwidth(n2);
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(interruptedException.toString());
            }
            this.out.write(byArray, n, (int)l);
            n = (int)((long)n + l);
            n2 = (int)((long)n2 - l);
        }
    }

    public void write(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        while (n2 > 0) {
            long l = n2;
            if (!bl) {
                try {
                    l = this.limiter.requestBandwidth(n2);
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException.toString());
                }
            }
            this.out.write(byArray, n, (int)l);
            n = (int)((long)n + l);
            n2 = (int)((long)n2 - l);
        }
    }

    @Override
    public void write(int n) throws IOException {
        try {
            this.limiter.requestBandwidth(1L);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.toString());
        }
        this.out.write(n);
    }

    @Override
    public BandwidthLimiter getBandwidthLimiter() {
        return this.limiter;
    }

    @Override
    public void setBandwidthLimiter(BandwidthLimiter bandwidthLimiter) {
        this.limiter = bandwidthLimiter;
    }
}

