/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.task;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.task.PersistentTask;
import de.dal33t.powerfolder.task.SendMessageTask;
import de.dal33t.powerfolder.util.Waiter;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PersistentTaskManager
extends PFComponent {
    private static final Logger log = Logger.getLogger(PersistentTaskManager.class.getName());
    private static final int WAIT_PENDING_TASKS_TIMEOUT_SECONDS = 30;
    private List<PersistentTask> tasks;
    private List<PersistentTask> pendingTasks;
    private volatile boolean shuttingDown = false;

    public PersistentTaskManager(Controller controller) {
        super(controller);
    }

    private Path getTaskFile() {
        String string = this.getController().getConfigName() + ".tasks";
        Path path = Controller.getMiscFilesLocation().resolve(string);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            return path;
        }
        catch (IOException iOException) {
            this.logFine("Could not create parent directory for task file. " + iOException);
            return null;
        }
    }

    public synchronized void start() {
        this.shuttingDown = false;
        this.pendingTasks = new Vector<PersistentTask>();
        Path path = this.getTaskFile();
        if (path != null && Files.exists(path, new LinkOption[0])) {
            this.logFine("Loading taskfile: " + path);
            try (ObjectInputStream objectInputStream = new ObjectInputStream(Files.newInputStream(path, new OpenOption[0]));){
                this.tasks = new LinkedList<PersistentTask>();
                PersistentTask persistentTask = null;
                while (true) {
                    try {
                        persistentTask = (PersistentTask)objectInputStream.readObject();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.logSevere("ClassNotFoundException", classNotFoundException);
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        this.logSevere("ClassCastException", classCastException);
                        continue;
                    }
                    if (persistentTask == null) break;
                    if (this.tasks.contains(persistentTask)) continue;
                    this.tasks.add(persistentTask);
                }
                objectInputStream.close();
                this.logInfo("Loaded " + this.tasks.size() + " tasks.");
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.logSevere("FileNotFoundException", fileNotFoundException);
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
                this.logSevere("IOException", iOException);
            }
            catch (ClassCastException classCastException) {
                this.logSevere("ClassCastException", classCastException);
            }
        } else {
            this.logFine("No taskfile found - probably first start of PF.");
        }
        if (this.tasks == null) {
            this.tasks = new LinkedList<PersistentTask>();
        }
        for (PersistentTask persistentTask : this.tasks.toArray(new PersistentTask[this.tasks.size()])) {
            try {
                persistentTask.init(this);
            }
            catch (RuntimeException runtimeException) {
                this.logSevere("RuntimeException", runtimeException);
                this.tasks.remove(persistentTask);
            }
        }
    }

    public synchronized void shutdown() {
        this.shuttingDown = true;
        if (this.tasks == null || this.pendingTasks == null) {
            this.logFine("Shutdown before initialization!");
            return;
        }
        this.waitForPendingTasks();
        for (PersistentTask object : this.tasks) {
            try {
                object.shutdown();
            }
            catch (RuntimeException runtimeException) {
                this.logSevere("RuntimeException", runtimeException);
            }
        }
        Path path = this.getTaskFile();
        try (ObjectOutputStream fileNotFoundException = new ObjectOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            this.logInfo("There are " + this.tasks.size() + " tasks not completed yet.");
            for (PersistentTask persistentTask : this.tasks) {
                fileNotFoundException.writeUnshared(persistentTask);
            }
        }
        catch (FileNotFoundException iOException) {
            this.logSevere("FileNotFoundException", iOException);
        }
        catch (IOException iOException) {
            this.logSevere("IOException", iOException);
        }
    }

    public boolean isStarted() {
        return this.tasks != null;
    }

    public synchronized void scheduleTask(final PersistentTask persistentTask) {
        if (this.tasks == null) {
            log.log(Level.SEVERE, "Unable to schedule task, taskmanager not initialized! Task: " + persistentTask, new RuntimeException("here"));
            return;
        }
        if (!this.tasks.contains(persistentTask) && !this.shuttingDown) {
            if (this.isFine()) {
                this.logFine("Adding " + persistentTask);
            }
            this.tasks.add(persistentTask);
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        persistentTask.init(PersistentTaskManager.this);
                    }
                    finally {
                        PersistentTaskManager.this.pendingTasks.remove(persistentTask);
                        PersistentTaskManager persistentTaskManager = PersistentTaskManager.this;
                        synchronized (persistentTaskManager) {
                            PersistentTaskManager.this.notify();
                        }
                    }
                }
            };
            this.pendingTasks.add(persistentTask);
            this.getController().getThreadPool().execute(runnable);
        }
    }

    public synchronized void removeTask(PersistentTask persistentTask) {
        boolean bl = this.shuttingDown;
        this.shuttingDown = true;
        if (this.pendingTasks.contains(persistentTask)) {
            this.pendingTasks.remove(persistentTask);
        } else {
            this.waitForPendingTasks();
        }
        if (!bl) {
            persistentTask.shutdown();
            this.tasks.remove(persistentTask);
        } else {
            this.logInfo(persistentTask + " shouldn't call remove() in shutdown(), it will automatically be removed!");
        }
        this.shuttingDown = bl;
    }

    public synchronized void purgeAllTasks() {
        boolean bl = this.shuttingDown;
        this.shuttingDown = true;
        this.waitForPendingTasks();
        while (!this.tasks.isEmpty()) {
            this.tasks.remove(0).shutdown();
        }
        this.shuttingDown = bl;
    }

    public synchronized boolean hasTasks() {
        return !this.tasks.isEmpty();
    }

    public synchronized int activeTaskCount() {
        return this.tasks.size();
    }

    public synchronized boolean hasSendMessageTask() {
        if (this.tasks == null) {
            return false;
        }
        for (PersistentTask persistentTask : this.tasks) {
            if (!(persistentTask instanceof SendMessageTask)) continue;
            if (this.isFiner()) {
                this.logFiner("Found pending message(s). total active tasks: " + this.tasks.size());
            }
            return true;
        }
        return false;
    }

    private void waitForPendingTasks() {
        Waiter waiter = new Waiter(30000L);
        while (!this.pendingTasks.isEmpty() && !waiter.isTimeout()) {
            waiter.waitABit();
        }
        if (!this.pendingTasks.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("The following tasks are blocking:");
            for (PersistentTask persistentTask : this.pendingTasks) {
                stringBuilder.append(' ').append(persistentTask);
            }
            stringBuilder.append(" and will be removed.");
            this.logWarning(stringBuilder.toString());
            this.tasks.removeAll(this.pendingTasks);
            this.pendingTasks.clear();
        }
    }
}

