/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.task;

import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.clientserver.RemoteCallException;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.task.ServerRemoteCallTask;
import de.dal33t.powerfolder.util.Reject;
import java.util.Objects;
import java.util.logging.Logger;

public class FolderRenameTask
extends ServerRemoteCallTask {
    private static final Logger LOG = Logger.getLogger(FolderRenameTask.class.getName());
    private static final long serialVersionUID = 100L;
    private FolderInfo newFolderInfo;
    private MemberInfo initiator;

    public FolderRenameTask(FolderInfo folderInfo, Member member) {
        super(30);
        Reject.ifNull(folderInfo, "newFolderInfo");
        Reject.ifNull(member, "initiator");
        this.newFolderInfo = folderInfo;
        this.initiator = member.getInfo();
    }

    @Override
    protected boolean executeRemoteCall(ServerClient serverClient) throws Exception {
        try {
            boolean bl = this.rename(serverClient);
            return bl;
        }
        finally {
            this.remove();
        }
    }

    private boolean rename(ServerClient serverClient) {
        Folder folder = this.newFolderInfo.getFolder(this.getController());
        if (folder == null) {
            LOG.warning(this.newFolderInfo + ": not found for rename.");
            return true;
        }
        if (this.getController().getMySelf().isServer()) {
            LOG.warning(folder + ": Not renaming to new folder name. Rename on server is done differently");
            return true;
        }
        if (folder.getInfo().getVersion() == this.newFolderInfo.getVersion() && folder.getInfo().getName().equals(this.newFolderInfo.getName())) {
            LOG.fine(folder + ": Not renaming to folder. Already done: " + this.newFolderInfo + " from " + this.initiator);
            return true;
        }
        if (folder.getInfo().getVersion() >= this.newFolderInfo.getVersion()) {
            LOG.warning(folder + ": Not renaming to new folder name. Remote version not higher: " + this.newFolderInfo + " at " + this.initiator);
            return true;
        }
        if (!folder.hasAdminPermission(this.initiator.getNode(this.getController(), true))) {
            LOG.warning(folder + ": Initiator " + this.initiator + " has no folder admin permission to rename to: " + this.newFolderInfo);
            return true;
        }
        if (folder.checkIfDeviceDisconnected()) {
            LOG.warning(folder + ": Currently disconnected. Waiting for reconnect of storage @ " + folder.getLocalBase());
            return false;
        }
        LOG.info("Renaming local " + folder.getInfo() + " to remote: " + this.newFolderInfo + " by " + this.initiator);
        String string = null;
        try {
            if (!serverClient.getAccount().hasOwnerPermission(folder.getInfo())) {
                string = this.getController().getOSClient().getFolderService(folder.getInfo()).getOwnerDisplayname(folder.getInfo());
            }
        }
        catch (RemoteCallException remoteCallException) {
            LOG.warning(folder + ": Unable to retrieve owner name. " + remoteCallException);
        }
        return this.getController().getFolderRepository().renameFolder(this.newFolderInfo, true, string);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FolderRenameTask folderRenameTask = (FolderRenameTask)object;
        return Objects.equals(this.newFolderInfo, folderRenameTask.newFolderInfo) && Objects.equals(this.initiator, folderRenameTask.initiator) && this.newFolderInfo.getVersion() == folderRenameTask.newFolderInfo.getVersion();
    }

    public int hashCode() {
        return Objects.hash(this.newFolderInfo, this.initiator, this.newFolderInfo.getVersion());
    }
}

