/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.security;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.protocol.PermissionInfoProto;
import de.dal33t.powerfolder.protocol.PermissionTypeProto;
import de.dal33t.powerfolder.protocol.StringMessageProto;
import de.dal33t.powerfolder.security.Group;
import de.dal33t.powerfolder.security.Permission;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Logger;

public class GroupAdminPermission
implements Permission,
D2DObject {
    private static final Logger LOG = Logger.getLogger(GroupAdminPermission.class.getName());
    private static final long serialVersionUID = 100L;
    public static final String ID_SEPARATOR = "_GP_";
    private String groupOID;
    private Group group;

    public GroupAdminPermission(Group group) {
        Reject.ifNull(group, "group is null");
        this.groupOID = group.getOID();
        this.group = group;
    }

    public GroupAdminPermission(String string) {
        Reject.ifBlank(string, "GroupID is blank");
        this.groupOID = string;
    }

    public GroupAdminPermission(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    @Override
    public boolean implies(Permission permission) {
        return false;
    }

    @Override
    public String getId() {
        return this.groupOID + ID_SEPARATOR + this.getClass().getSimpleName();
    }

    public String getGroupOID() {
        return this.groupOID;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.groupOID == null ? 0 : this.groupOID.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Permission)) {
            return false;
        }
        Permission permission = (Permission)object;
        return Util.equals(this.getId(), permission.getId());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.groupOID == null && this.group != null) {
            this.groupOID = this.group.getOID();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.group == null && this.groupOID != null) {
            this.group = new Group(this.groupOID, "-unknown-");
        }
        objectOutputStream.defaultWriteObject();
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        PermissionInfoProto.PermissionInfo permissionInfo;
        if (abstractMessage instanceof PermissionInfoProto.PermissionInfo && (permissionInfo = (PermissionInfoProto.PermissionInfo)abstractMessage).getObjectsList().size() == 1) {
            try {
                Any any = permissionInfo.getObjects(0);
                String string = any.getTypeUrl().split("/")[1];
                if (string.equals("StringMessage")) {
                    StringMessageProto.StringMessage stringMessage = any.unpack(StringMessageProto.StringMessage.class);
                    this.groupOID = stringMessage.getValue();
                }
            }
            catch (InvalidProtocolBufferException | NullPointerException exception) {
                LOG.severe("Cannot unpack message: " + exception);
            }
        }
    }

    @Override
    public AbstractMessage toD2D() {
        PermissionInfoProto.PermissionInfo.Builder builder = PermissionInfoProto.PermissionInfo.newBuilder();
        builder.setClazzName("PermissionInfo");
        StringMessageProto.StringMessage.Builder builder2 = StringMessageProto.StringMessage.newBuilder();
        builder2.setClazzName("StringMessage");
        builder2.setValue(this.groupOID);
        builder.addObjects(Any.pack(builder2.build()));
        builder.setPermissionType(PermissionTypeProto.PermissionType.GROUP_ADMIN);
        return builder.build();
    }
}

