/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.security;

import de.dal33t.powerfolder.security.Account;
import de.dal33t.powerfolder.util.StackDump;
import java.io.Serializable;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Embeddable;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Embeddable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class AuditFields
implements Serializable {
    private static final long serialVersionUID = 100L;
    private static final String SEPARATOR = "|";
    private Date creationDate;
    private String creationAccount;
    private Date modifiedDate;
    private String modifiedAccount;

    public void setCreatedNowBy(Account account) {
        this.creationAccount = this.toAccountField(account);
        this.creationDate = new Date();
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getCreationAccountOID() {
        return this.getOID(this.creationAccount);
    }

    public String getCreationAccountUsername() {
        return this.getUsername(this.creationAccount);
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public String getModifiedAccountOID() {
        return this.getOID(this.modifiedAccount);
    }

    public String getModifiedAccountUsername() {
        return this.getUsername(this.modifiedAccount);
    }

    public void setModifiedNowBy(Account account) {
        this.modifiedAccount = this.toAccountField(account);
        this.modifiedDate = new Date();
    }

    private String getUsername(String string) {
        if (string == null) {
            return null;
        }
        return string.split(SEPARATOR)[1];
    }

    private String getOID(String string) {
        if (string == null) {
            return null;
        }
        return string.split(SEPARATOR)[0];
    }

    private String toAccountField(Account account) {
        if (account == null) {
            return null;
        }
        if (account.getUsername() == null) {
            Logger.getLogger(AuditFields.class.getName()).log(Level.WARNING, "Audit user account username is null", new StackDump());
            return null;
        }
        return account.getOID() + SEPARATOR + account.getUsername();
    }
}

