/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.pro.E;

import de.dal33t.powerfolder.EncryptionPolicy;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.message.EncryptionChallenge;
import de.dal33t.powerfolder.message.EncryptionSetup;
import de.dal33t.powerfolder.message.Identity;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.message.Problem;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.net.ConnectionHandler;
import de.dal33t.powerfolder.pro.F.B;
import de.dal33t.powerfolder.pro.F.D;
import de.dal33t.powerfolder.pro.F.G;
import de.dal33t.powerfolder.util.ByteSerializer;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.SimpleCache;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class F
extends PFComponent {
    private B \u00ff;
    private final Object \u00fd = new Object();
    private final Object \u0104 = new Object();
    private EncryptionChallenge \u0100;
    private EncryptionSetup \u00fb;
    private EncryptionSetup \u0106;
    private Cipher \u00fe;
    private Cipher \u0103;
    private ConnectionHandler \u00fc;
    private ByteSerializer \u0102;
    private ReentrantLock \u0105;
    private static final SimpleCache<MemberInfo, MemberInfo> \u0101 = new SimpleCache(1L, TimeUnit.DAYS);

    public F(B b, ConnectionHandler connectionHandler, ByteSerializer byteSerializer) {
        super(b.getController());
        Reject.ifNull(connectionHandler, "Connection Handler is null");
        Reject.ifNull(byteSerializer, "Serializer is null");
        this.\u0102 = byteSerializer;
        this.\u00fc = connectionHandler;
        this.\u00ff = b;
        this.\u0105 = new ReentrantLock();
    }

    public PublicKey \u00de() {
        return this.\u0100 != null ? this.\u0100.publicKey : null;
    }

    public boolean \u00e1() {
        return this.\u0106 != null && this.\u00fb != null;
    }

    public EncryptionSetup \u00e2() {
        return this.\u0106;
    }

    public EncryptionChallenge \u00d4() {
        return this.\u0100;
    }

    public EncryptionSetup \u00df() {
        return this.\u00fb;
    }

    public void \u00db() throws ConnectionException {
        try {
            this.\u00d5();
        }
        catch (G g) {
            this.\u00fc.sendMessagesAsynchron(new Problem(g.getMessage(), true, 666));
            throw new ConnectionException(g.getMessage(), g);
        }
    }

    public boolean \u00d8() {
        boolean bl;
        if (!this.\u00fc.isEncrypted()) {
            return true;
        }
        if (this.\u0100 == null) {
            return false;
        }
        try {
            this.\u0100.validateIdentity(this.\u00fc.getMyMagicId());
            bl = true;
        }
        catch (G g) {
            this.logWarning("Error while validating identity of " + this.\u00fc.getIdentity() + ": " + g);
            bl = false;
        }
        bl = bl && this.\u00ff.A(this.\u00fc);
        Identity identity = this.\u00fc.getIdentity();
        if (bl) {
            if (this.isFiner()) {
                this.logFiner("Successfully validated identity/public key: " + identity.getNick());
            }
        } else if (this.isWarning()) {
            if (\u0101.getValidEntry(identity.getMemberInfo()) == null) {
                this.logWarning("Failed to validate identity/public key: " + identity.getNick() + " @ " + this.\u00fc.getRemoteAddress());
            } else {
                this.logFine("Failed to validate identity/public key: " + identity.getNick() + " @ " + this.\u00fc.getRemoteAddress());
            }
            \u0101.put(identity.getMemberInfo(), identity.getMemberInfo());
        }
        if (!bl) {
            this.\u00fc.sendMessagesAsynchron(new Problem("Unable to validate identity", true, 666));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void \u00da() {
        this.\u0105.lock();
        this.\u00fb = null;
        this.\u0106 = null;
        this.\u00fe = null;
        this.\u0103 = null;
        this.\u0102 = null;
        this.\u0105.unlock();
        Object object = this.\u00fd;
        synchronized (object) {
            this.\u00fd.notifyAll();
        }
        object = this.\u0104;
        synchronized (object) {
            this.\u0104.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean B(Message message) throws G {
        if (message instanceof EncryptionChallenge) {
            this.\u0100 = (EncryptionChallenge)message;
            Object object = this.\u0104;
            synchronized (object) {
                this.\u0104.notifyAll();
            }
            return true;
        }
        if (message instanceof EncryptionSetup) {
            try {
                this.\u0105.lockInterruptibly();
                this.\u00fb = (EncryptionSetup)message;
                this.\u00d9();
            }
            catch (RuntimeException runtimeException) {
                throw new G(runtimeException);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.\u0105.unlock();
            }
            Object object = this.\u00fd;
            synchronized (object) {
                this.\u00fd.notifyAll();
            }
            return true;
        }
        return false;
    }

    public Object A(byte[] byArray, int n) throws ClassNotFoundException, ConnectionException {
        boolean bl = !this.\u00fc.isOnLAN();
        Identity identity = this.\u00fc.getIdentity();
        if (identity != null && identity.isUseCompressedStream() != null) {
            bl = identity.isUseCompressedStream();
        }
        try {
            byte[] byArray2 = this.\u00fc.isEncrypted() ? this.\u0103.doFinal(byArray, 0, n) : byArray;
            return ByteSerializer.deserializeStatic(byArray2, bl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (Exception exception) {
            throw new ConnectionException("Unable to receive message from peer, connection closed. " + exception, exception).with(this.\u00fc);
        }
    }

    public byte[] C(Message message) throws ConnectionException {
        try {
            this.\u0105.lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.\u0102 == null) {
            if (this.\u0105.isHeldByCurrentThread()) {
                this.\u0105.unlock();
            }
            throw new ConnectionException("Encryption support has already been shut down");
        }
        try {
            byte[] byArray;
            boolean bl = this.\u00fc.getMyIdentity().isUseCompressedStream();
            if (this.\u00e1() && !(message instanceof EncryptionSetup)) {
                byArray = this.\u0102.serialize(message, bl, 8);
                if (this.\u00fe == null) {
                    this.logWarning("Got message: " + message + ". is enc? " + this.\u00e1() + ". remote encset: " + this.\u00fb);
                }
                byArray = this.\u00fe.doFinal(byArray);
            } else {
                byArray = this.\u0102.serialize(message, bl, -1);
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (Exception exception) {
            throw new ConnectionException("Unable to send message to peer, connection closed. " + exception, exception).with(this.\u00fc);
        }
        finally {
            if (this.\u0105.isHeldByCurrentThread()) {
                this.\u0105.unlock();
            }
        }
    }

    private EncryptionPolicy \u00e3() {
        if (this.\u00fc.isOnLAN()) {
            return this.\u00ff.g();
        }
        return this.\u00ff.j();
    }

    private EncryptionPolicy \u00d6() {
        return this.\u0100 != null ? this.\u0100.policy : EncryptionPolicy.NOT_AVAILABLE;
    }

    private void \u00d5() throws G {
        if (!this.\u00fc.isConnected()) {
            throw new G("Remote peer disconnected while initializing encryption");
        }
        Identity identity = this.\u00fc.getIdentity();
        if (identity == null) {
            throw new G("Remote peer disconnected while initializing encryption");
        }
        if (!identity.isSupportsEncryption()) {
            if (EncryptionPolicy.REQUIRED.equals((Object)this.\u00e3())) {
                throw new G("Encrypted connection required, remote side does not support encryption. Disconnecting");
            }
            if (this.isFiner()) {
                this.logFiner("Initializing NON-encrypted connection to: " + this.\u00fc.getRemoteAddress());
            }
            return;
        }
        if (identity.isSupportsEncryption()) {
            EncryptionChallenge encryptionChallenge = new EncryptionChallenge(this.\u00e3(), this.\u00ff.i(), this.\u00fc.getRemoteMagicId());
            if (this.isFiner()) {
                this.logFiner("Sending encryption challenge:" + encryptionChallenge);
            }
            this.\u00fc.sendMessagesAsynchron(encryptionChallenge);
            this.\u00e0();
        }
        boolean bl = this.\u00dd();
        if (this.isFiner()) {
            this.logFiner("Initializing connection to: " + this.\u00fc.getRemoteAddress() + ", encryption: " + bl);
        }
        if (!bl) {
            return;
        }
        SecretKey secretKey = D.C();
        this.\u00fe = D.A(secretKey);
        this.\u0106 = new EncryptionSetup(secretKey, this.\u00ff.i().getPrivate(), this.\u00de());
        this.\u00fc.sendMessagesAsynchron(this.\u0106);
        this.\u00dc();
    }

    private boolean \u00dd() throws G {
        boolean bl;
        if (this.isFiner()) {
            this.logFiner("My policy: " + this.\u00e3() + ", remote policy: " + this.\u00d6());
        }
        if (EncryptionPolicy.REQUIRED.equals((Object)this.\u00e3())) {
            bl = true;
            if (EncryptionPolicy.NOT_AVAILABLE.equals((Object)this.\u00d6())) {
                throw new G("Encrypted connection required, remote side does not support encryption. Disconnecting");
            }
        } else if (EncryptionPolicy.PREFERRED.equals((Object)this.\u00e3())) {
            bl = !this.\u00d6().equals((Object)EncryptionPolicy.NOT_AVAILABLE);
        } else if (EncryptionPolicy.NOT_REQUIRED.equals((Object)this.\u00e3())) {
            bl = this.\u00d6().equals((Object)EncryptionPolicy.REQUIRED) || this.\u00d6().equals((Object)EncryptionPolicy.PREFERRED);
        } else if (EncryptionPolicy.NOT_AVAILABLE.equals((Object)this.\u00e3())) {
            bl = false;
            if (EncryptionPolicy.REQUIRED.equals((Object)this.\u00d6())) {
                throw new G("Encrypted connection required by remote side, but locally disabled. Disconnecting");
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private void \u00d9() throws G {
        Reject.ifNull(this.\u0100, "Remote encryption challlenge is null");
        Reject.ifNull(this.\u00fb, "Remote encryption setup is null");
        PublicKey publicKey = this.\u00de();
        PrivateKey privateKey = this.\u00ff.i().getPrivate();
        SecretKey secretKey = this.\u00fb.decryptSessionKey(privateKey, publicKey);
        if (this.isFiner()) {
            this.logFiner("Received session key: " + secretKey);
        }
        this.\u0103 = D.D(secretKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void \u00e0() throws G {
        Object object = this.\u0104;
        synchronized (object) {
            if (this.\u0100 == null) {
                try {
                    this.\u0104.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    this.logFiner(interruptedException);
                }
            }
        }
        if (this.\u0100 == null) {
            throw new G("Did not receive encryption challenge after 60s");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void \u00dc() throws G {
        Object object = this.\u00fd;
        synchronized (object) {
            if (this.\u00fb == null) {
                try {
                    this.\u00fd.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    this.logFiner(interruptedException);
                }
            }
        }
        if (this.\u00fb == null) {
            throw new G("Did not receive encryption setup after 60s");
        }
    }
}

