/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message.clientserver;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.d2d.D2DRequestMessage;
import de.dal33t.powerfolder.d2d.D2DRequestToServer;
import de.dal33t.powerfolder.d2d.NodeEvent;
import de.dal33t.powerfolder.protocol.LoginRequestProto;
import java.util.ArrayList;
import java.util.Collection;

public class LoginRequest
extends D2DRequestMessage
implements D2DRequestToServer {
    protected String username;
    protected String password;
    protected String token;
    private long tosVersion;
    private Collection<String> nodeIds;

    public LoginRequest() {
    }

    public LoginRequest(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getToken() {
        return this.token;
    }

    public long getTosVersion() {
        return this.tosVersion;
    }

    public Collection<String> getNodeIds() {
        return this.nodeIds;
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof LoginRequestProto.LoginRequest) {
            LoginRequestProto.LoginRequest loginRequest = (LoginRequestProto.LoginRequest)abstractMessage;
            this.requestCode = loginRequest.getRequestCode();
            this.username = loginRequest.getUsername();
            this.password = loginRequest.getPassword();
            this.token = loginRequest.getToken();
            this.tosVersion = loginRequest.getTosVersion();
            this.nodeIds = new ArrayList<String>();
        }
    }

    @Override
    public AbstractMessage toD2D() {
        LoginRequestProto.LoginRequest.Builder builder = LoginRequestProto.LoginRequest.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        if (this.requestCode != null) {
            builder.setRequestCode(this.getRequestCode());
        }
        if (this.username != null) {
            builder.setUsername(this.getUsername());
        }
        if (this.password != null) {
            builder.setPassword(this.getPassword());
        }
        if (this.token != null) {
            builder.setToken(this.getToken());
        }
        builder.setTosVersion(this.tosVersion);
        return builder.build();
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.username != null && this.password != null;
    }

    @Override
    public NodeEvent getNodeEvent() {
        return NodeEvent.LOGIN_REQUEST;
    }
}

