/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message.clientserver;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.StatusCode;
import de.dal33t.powerfolder.d2d.D2DEvent;
import de.dal33t.powerfolder.d2d.D2DReplyMessage;
import de.dal33t.powerfolder.d2d.NodeEvent;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.protocol.FileInfoProto;
import de.dal33t.powerfolder.protocol.FileListReplyProto;
import java.util.Collection;

public class FileListReply
extends D2DReplyMessage
implements D2DEvent {
    private Collection<FileInfo> fileInfos;

    public FileListReply() {
    }

    public FileListReply(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    public FileListReply(String string, StatusCode statusCode, Collection<FileInfo> collection) {
        this.replyCode = string;
        this.replyStatusCode = statusCode;
        this.fileInfos = collection;
    }

    public Collection<FileInfo> getFileInfos() {
        return this.fileInfos;
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof FileListReplyProto.FileListReply) {
            FileListReplyProto.FileListReply fileListReply = (FileListReplyProto.FileListReply)abstractMessage;
            this.replyCode = fileListReply.getReplyCode();
            this.replyStatusCode = StatusCode.getEnum(fileListReply.getReplyStatusCode());
            for (FileInfoProto.FileInfo fileInfo : fileListReply.getFileInfosList()) {
                if (fileInfo.getClazzName().equals("DirectoryInfo")) {
                    this.fileInfos.add(new DirectoryInfo(fileInfo));
                    continue;
                }
                this.fileInfos.add(new FileInfo(fileInfo));
            }
        }
    }

    @Override
    public AbstractMessage toD2D() {
        FileListReplyProto.FileListReply.Builder builder = FileListReplyProto.FileListReply.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        if (this.replyCode != null) {
            builder.setReplyCode(this.replyCode);
        }
        builder.setReplyStatusCode(this.replyStatusCode.getCode());
        if (this.fileInfos != null) {
            for (FileInfo fileInfo : this.fileInfos) {
                builder.addFileInfos((FileInfoProto.FileInfo)fileInfo.toD2D());
            }
        }
        return builder.build();
    }

    @Override
    public NodeEvent getNodeEvent() {
        return NodeEvent.FILE_LIST_REPLY;
    }
}

