/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message.clientserver;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.activity.domain.ActivityType;
import de.dal33t.powerfolder.d2d.D2DRequestMessage;
import de.dal33t.powerfolder.d2d.D2DRequestToServer;
import de.dal33t.powerfolder.d2d.NodeEvent;
import de.dal33t.powerfolder.protocol.ActivityListRequestProto;
import java.util.Date;

public class ActivityListRequest
extends D2DRequestMessage
implements D2DRequestToServer {
    private String accountId;
    private ActivityType activityType;
    private Date startDate;

    public ActivityListRequest() {
    }

    public ActivityListRequest(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    public String getAccountId() {
        return this.accountId;
    }

    public ActivityType getActivityType() {
        return this.activityType;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof ActivityListRequestProto.ActivityListRequest) {
            ActivityListRequestProto.ActivityListRequest activityListRequest = (ActivityListRequestProto.ActivityListRequest)abstractMessage;
            this.requestCode = activityListRequest.getRequestCode();
            this.accountId = activityListRequest.getAccountId();
            this.activityType = ActivityType.getEnum(activityListRequest.getActivityType());
            this.startDate = new Date(activityListRequest.getStartDate());
        }
    }

    @Override
    public AbstractMessage toD2D() {
        ActivityListRequestProto.ActivityListRequest.Builder builder = ActivityListRequestProto.ActivityListRequest.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        if (this.requestCode != null) {
            builder.setRequestCode(this.requestCode);
        }
        if (this.accountId != null) {
            builder.setAccountId(this.accountId);
        }
        if (this.activityType != null) {
            builder.setActivityType(this.getActivityType().toD2D());
        }
        if (this.startDate != null) {
            builder.setStartDate(this.getStartDate().getTime());
        }
        return builder.build();
    }

    @Override
    public NodeEvent getNodeEvent() {
        return NodeEvent.ACTIVITY_LIST_REQUEST;
    }
}

