/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.d2d.D2DEvent;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.d2d.NodeEvent;
import de.dal33t.powerfolder.disk.DiskItemFilter;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.DiskItem;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.message.FolderFilesChangedExt;
import de.dal33t.powerfolder.message.FolderRelatedMessage;
import de.dal33t.powerfolder.protocol.FileInfoProto;
import de.dal33t.powerfolder.protocol.FolderFilesChangedProto;
import de.dal33t.powerfolder.protocol.FolderInfoProto;
import de.dal33t.powerfolder.transfer.TransferManager;
import de.dal33t.powerfolder.util.Reject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FolderFilesChanged
extends FolderRelatedMessage
implements D2DObject,
D2DEvent {
    private static final Logger log = Logger.getLogger(FolderFilesChanged.class.getName());
    private static final long serialVersionUID = 100L;
    protected FileInfo[] added;
    @Deprecated
    protected FileInfo[] removed;

    protected FolderFilesChanged() {
    }

    FolderFilesChanged(FolderInfo folderInfo) {
        this.folder = folderInfo;
    }

    FolderFilesChanged(FolderInfo folderInfo, FileInfo[] fileInfoArray) {
        Reject.ifNull(folderInfo, "Folder is null");
        Reject.ifNull(fileInfoArray, "Added files is null");
        this.folder = folderInfo;
        this.added = fileInfoArray;
    }

    protected FolderFilesChanged(FileInfo fileInfo) {
        Reject.ifNull(fileInfo, "Fileinfo is null");
        this.folder = fileInfo.getFolderInfo();
        if (fileInfo.isDeleted()) {
            this.removed = new FileInfo[]{fileInfo};
        } else {
            this.added = new FileInfo[]{fileInfo};
        }
    }

    protected FolderFilesChanged(FileInfo fileInfo, boolean bl) {
        Reject.ifNull(fileInfo, "Fileinfo is null");
        this.folder = fileInfo.getFolderInfo();
        this.added = new FileInfo[]{fileInfo};
    }

    public static FolderFilesChanged create(FileInfo fileInfo, boolean bl) {
        if (bl) {
            return new FolderFilesChangedExt(fileInfo);
        }
        return new FolderFilesChanged(fileInfo);
    }

    public static FolderFilesChanged[] create(FolderInfo folderInfo, Collection<FileInfo> collection, DiskItemFilter diskItemFilter, boolean bl) {
        Reject.ifNull(folderInfo, "Folder info is null");
        Reject.ifNull(collection, "Files is null");
        Reject.ifNull(diskItemFilter, "FileInfoFilter is null");
        Reject.ifTrue(false, "Unable to split filelist. nFilesPerMessage: 500");
        if (collection.isEmpty()) {
            return null;
        }
        ArrayList<D2DObject> arrayList = new ArrayList<D2DObject>(collection.size() / 500);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        FileInfo[] fileInfoArray = new FileInfo[Math.min(500, collection.size())];
        for (D2DObject d2DObject : collection) {
            FolderFilesChanged folderFilesChanged;
            if (diskItemFilter.isExcluded((DiskItem)((Object)d2DObject))) continue;
            if (d2DObject.isDiretory()) {
                ++n3;
            }
            fileInfoArray[n2] = d2DObject;
            if (++n2 < fileInfoArray.length) continue;
            ++n;
            if (bl) {
                folderFilesChanged = new FolderFilesChangedExt(folderInfo);
                folderFilesChanged.added = fileInfoArray;
            } else {
                folderFilesChanged = new FolderFilesChanged(folderInfo);
                if (fileInfoArray.length > 0 && fileInfoArray[0].isDeleted()) {
                    folderFilesChanged.removed = fileInfoArray;
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Legacy/Removed: " + folderFilesChanged);
                    }
                } else {
                    folderFilesChanged.added = fileInfoArray;
                }
            }
            arrayList.add(folderFilesChanged);
            fileInfoArray = new FileInfo[500];
            n2 = 0;
        }
        if (n2 == 0 && arrayList.isEmpty()) {
            return null;
        }
        if (n2 != 0 && n2 < fileInfoArray.length) {
            D2DObject d2DObject;
            FileInfo[] fileInfoArray2 = new FileInfo[n2];
            System.arraycopy(fileInfoArray, 0, fileInfoArray2, 0, fileInfoArray2.length);
            ++n;
            if (bl) {
                d2DObject = new FolderFilesChangedExt(folderInfo);
                ((FolderFilesChanged)d2DObject).added = fileInfoArray2;
            } else {
                d2DObject = new FolderFilesChanged(folderInfo);
                if (fileInfoArray.length > 0 && fileInfoArray[0].isDeleted()) {
                    ((FolderFilesChanged)d2DObject).removed = fileInfoArray2;
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Legacy/Removed: " + (FolderFilesChanged)d2DObject);
                    }
                } else {
                    ((FolderFilesChanged)d2DObject).added = fileInfoArray2;
                }
            }
            arrayList.add(d2DObject);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Splitted folder files change into " + arrayList.size() + ", deltas: " + n + ", folder: " + folderInfo + ", files: " + collection.size() + ", dirs: " + n3 + "\nSplitted msgs: " + arrayList);
        }
        return arrayList.toArray(new FolderFilesChanged[arrayList.size()]);
    }

    @Deprecated
    public FileInfo[] getRemoved() {
        return this.removed;
    }

    public FileInfo[] getFiles() {
        return this.added;
    }

    public String toString() {
        if (this.removed != null) {
            return "FolderFilesChanged " + this.folder + ": " + (this.removed != null ? this.removed.length : 0) + " (removed/legacy) files";
        }
        return "FolderFilesChanged " + this.folder + ": " + (this.added != null ? this.added.length : 0) + " files";
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof FolderFilesChangedProto.FolderFilesChanged) {
            FolderFilesChangedProto.FolderFilesChanged folderFilesChanged = (FolderFilesChangedProto.FolderFilesChanged)abstractMessage;
            int n = 0;
            this.added = new FileInfo[folderFilesChanged.getFileInfosCount()];
            for (FileInfoProto.FileInfo fileInfo : folderFilesChanged.getFileInfosList()) {
                if (fileInfo.getClazzName().equals("DirectoryInfo")) {
                    this.added[n++] = new DirectoryInfo(fileInfo);
                    continue;
                }
                this.added[n++] = new FileInfo(fileInfo);
            }
            this.folder = new FolderInfo(folderFilesChanged.getFolderInfo());
        }
    }

    @Override
    public AbstractMessage toD2D() {
        FolderFilesChangedProto.FolderFilesChanged.Builder builder = FolderFilesChangedProto.FolderFilesChanged.newBuilder();
        builder.setClazzName("FolderFilesChanged");
        for (FileInfo fileInfo : this.added) {
            builder.addFileInfos((FileInfoProto.FileInfo)fileInfo.toD2D());
        }
        builder.setFolderInfo((FolderInfoProto.FolderInfo)this.folder.toD2D());
        return builder.build();
    }

    @Override
    public void handle(Member member) {
        FolderInfo folderInfo = this.folder;
        if (folderInfo == null) {
            return;
        }
        Folder folder = member.getController().getFolderRepository().getFolder(folderInfo);
        if (folder == null) {
            return;
        }
        TransferManager transferManager = member.getController().getTransferManager();
        if (this.getFiles() != null) {
            for (int i = 0; i < this.getFiles().length; ++i) {
                transferManager.abortDownload(this.getFiles()[i], member);
            }
        }
        folder.fileListChanged(member, this);
        member.fireMessageToListeners(this);
    }

    @Override
    public NodeEvent getNodeEvent() {
        return NodeEvent.FOLDER_FILES_CHANGED;
    }
}

