/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import de.dal33t.powerfolder.StatusCode;
import de.dal33t.powerfolder.d2d.D2DEvent;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.d2d.NodeEvent;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.message.LimitBandwidth;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.protocol.FileInfoProto;
import de.dal33t.powerfolder.protocol.FilePartReplyProto;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Validate;
import java.io.IOException;
import java.io.ObjectInputStream;

public class FileChunk
extends Message
implements LimitBandwidth,
D2DObject,
D2DEvent {
    private static final long serialVersionUID = 100L;
    public FileInfo file;
    public long offset;
    public byte[] data;

    public FileChunk() {
    }

    public FileChunk(FileInfo fileInfo, long l, byte[] byArray) {
        this.file = fileInfo;
        this.offset = l;
        this.data = byArray;
        this.validate();
    }

    public String toString() {
        return "FileChunk: " + this.file + " (" + Format.formatDecimal(this.file.getSize()) + " total bytes), offset: " + this.offset + ", chunk size: " + this.data.length;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.validate();
    }

    private void validate() {
        Reject.noNullElements(this.file, this.data);
        Validate.isTrue(this.offset >= 0L);
        Validate.isTrue(this.offset + (long)this.data.length <= this.file.getSize());
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof FilePartReplyProto.FilePartReply) {
            FilePartReplyProto.FilePartReply filePartReply = (FilePartReplyProto.FilePartReply)abstractMessage;
            this.file = new FileInfo(filePartReply.getFileInfo());
            this.offset = filePartReply.getOffset();
            this.data = filePartReply.getData().toByteArray();
        }
    }

    @Override
    public AbstractMessage toD2D() {
        FilePartReplyProto.FilePartReply.Builder builder = FilePartReplyProto.FilePartReply.newBuilder();
        builder.setClazzName("FilePartReply");
        builder.setFileInfo((FileInfoProto.FileInfo)this.file.toD2D());
        builder.setOffset(this.offset);
        builder.setData(ByteString.copyFrom(this.data));
        builder.setReplyStatusCode(StatusCode.OK.getCode());
        return builder.build();
    }

    @Override
    public NodeEvent getNodeEvent() {
        return NodeEvent.FILE_PART_REPLY;
    }
}

