/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.light;

import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.util.Base64;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.os.OSUtil;
import java.io.IOException;
import java.io.ObjectInput;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FileInfoFactory {
    private static final Logger LOG = Logger.getLogger(FileInfoFactory.class.getName());
    private static final String[] ILLEGAL_WINDOWS_CHARS = new String[]{"|", "?", "\"", "*", "<", ":", ">", "\r"};

    private FileInfoFactory() {
    }

    public static FileInfo readExt(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        FileInfo fileInfo = n == 0 ? new FileInfo() : new DirectoryInfo();
        fileInfo.readExternal(objectInput);
        return fileInfo;
    }

    public static FileInfo lookupInstance(FolderInfo folderInfo, String string) {
        return FileInfoFactory.lookupInstance(folderInfo, string, false);
    }

    public static DirectoryInfo lookupDirectory(FolderInfo folderInfo, String string) {
        return (DirectoryInfo)FileInfoFactory.lookupInstance(folderInfo, string, true);
    }

    public static FileInfo lookupInstance(FolderInfo folderInfo, String string, boolean bl) {
        if (bl) {
            return new DirectoryInfo(folderInfo, string, null, null);
        }
        return new FileInfo(folderInfo, string, null, null);
    }

    public static FileInfo lookupInstance(Folder folder, Path path) {
        String string = FileInfoFactory.buildFileName(folder.getLocalBase(), path);
        return FileInfoFactory.lookupInstance(folder.getInfo(), string, Files.isDirectory(path, new LinkOption[0]));
    }

    public static FileInfo lookupInstanceForTest(FolderInfo folderInfo, String string, Date date) {
        return new FileInfo(folderInfo, string, date, null);
    }

    public static FileInfo changedFolderInfo(FileInfo fileInfo, FolderInfo folderInfo) {
        Reject.ifNull(fileInfo, "Original FileInfo is null");
        if (fileInfo.isLookupInstance()) {
            return FileInfoFactory.lookupInstance(folderInfo, fileInfo.getRelativeName());
        }
        if (fileInfo.getFolderInfo().equals(folderInfo)) {
            return fileInfo;
        }
        if (fileInfo.isFile()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Corrected FolderInfo on " + fileInfo.toDetailString());
            }
            return new FileInfo(fileInfo.getRelativeName(), fileInfo.getOID(), fileInfo.getSize(), fileInfo.getModifiedBy(), fileInfo.getModifiedByAccount(), fileInfo.getModifiedDate(), fileInfo.getVersion(), fileInfo.getHashes(), fileInfo.isDeleted(), fileInfo.getTags(), folderInfo.intern());
        }
        if (fileInfo.isDiretory()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Corrected DirectoryInfo on " + fileInfo.toDetailString());
            }
            return new DirectoryInfo(fileInfo.getRelativeName(), fileInfo.getOID(), fileInfo.getModifiedBy(), fileInfo.getModifiedByAccount(), fileInfo.getModifiedDate(), fileInfo.getVersion(), fileInfo.getHashes(), fileInfo.isDeleted(), fileInfo.getTags(), folderInfo.intern());
        }
        throw new IllegalArgumentException("Illegal original FileInfo: " + fileInfo.getClass() + ": " + fileInfo.toDetailString());
    }

    public static FileInfo changeModifiedAccount(FileInfo fileInfo, AccountInfo accountInfo) {
        Reject.ifNull(fileInfo, "Original FileInfo is null");
        if (fileInfo.getModifiedByAccount() != null && accountInfo != null && Util.equals(accountInfo.getUsername(), fileInfo.getModifiedByAccount().getUsername()) && Util.equals(accountInfo.getDisplayName(), fileInfo.getModifiedByAccount().getDisplayName())) {
            return fileInfo;
        }
        if (fileInfo.isFile()) {
            if (fileInfo.isLookupInstance()) {
                return new FileInfo(fileInfo.getFolderInfo(), fileInfo.getRelativeName(), fileInfo.getModifiedDate(), accountInfo);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Corrected AccountInfo on " + fileInfo.toDetailString());
            }
            return new FileInfo(fileInfo.getRelativeName(), fileInfo.getOID(), fileInfo.getSize(), fileInfo.getModifiedBy(), accountInfo, fileInfo.getModifiedDate(), fileInfo.getVersion(), fileInfo.getHashes(), fileInfo.isDeleted(), fileInfo.getTags(), fileInfo.getFolderInfo());
        }
        if (fileInfo.isDiretory()) {
            if (fileInfo.isLookupInstance()) {
                return new DirectoryInfo(fileInfo.getFolderInfo(), fileInfo.getRelativeName(), fileInfo.getModifiedDate(), accountInfo);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Corrected AccountInfo on " + fileInfo.toDetailString());
            }
            return new DirectoryInfo(fileInfo.getRelativeName(), fileInfo.getOID(), fileInfo.getModifiedBy(), accountInfo, fileInfo.getModifiedDate(), fileInfo.getVersion(), fileInfo.getHashes(), fileInfo.isDeleted(), fileInfo.getTags(), fileInfo.getFolderInfo());
        }
        throw new IllegalArgumentException("Illegal original FileInfo: " + fileInfo.getClass() + ": " + fileInfo.toDetailString());
    }

    public static FileInfo setOID(FileInfo fileInfo, String string) {
        Reject.ifNull(fileInfo, "FileInfo");
        if (StringUtils.isNotBlank(fileInfo.getOID())) {
            LOG.warning("Overwriting existing OID: " + fileInfo.getOID() + " of " + fileInfo.toDetailString());
        }
        if (fileInfo instanceof DirectoryInfo) {
            return new DirectoryInfo(fileInfo.getRelativeName(), string, fileInfo.getModifiedBy(), fileInfo.getModifiedByAccount(), fileInfo.getModifiedDate(), fileInfo.getVersion(), fileInfo.getHashes(), fileInfo.isDeleted(), fileInfo.getTags(), fileInfo.getFolderInfo());
        }
        return new FileInfo(fileInfo.getRelativeName(), string, fileInfo.getSize(), fileInfo.getModifiedBy(), fileInfo.getModifiedByAccount(), fileInfo.getModifiedDate(), fileInfo.getVersion(), fileInfo.getHashes(), fileInfo.isDeleted(), fileInfo.getTags(), fileInfo.getFolderInfo());
    }

    public static FileInfo unmarshallExistingFile(FolderInfo folderInfo, String string, String string2, long l, MemberInfo memberInfo, AccountInfo accountInfo, Date date, int n, String string3, boolean bl, String string4) {
        if (bl) {
            return new DirectoryInfo(string, string2, memberInfo, accountInfo, date, n, string3, false, string4, folderInfo);
        }
        return new FileInfo(string, string2, l, memberInfo, accountInfo, date, n, string3, false, string4, folderInfo);
    }

    public static FileInfo unmarshallDeletedFile(FolderInfo folderInfo, String string, String string2, MemberInfo memberInfo, AccountInfo accountInfo, Date date, int n, String string3, boolean bl, String string4) {
        if (bl) {
            return new DirectoryInfo(string, string2, memberInfo, accountInfo, date, n, string3, true, string4, folderInfo);
        }
        return new FileInfo(string, string2, 0L, memberInfo, accountInfo, date, n, string3, true, string4, folderInfo);
    }

    public static FileInfo newFile(Folder folder, Path path, String string, MemberInfo memberInfo, AccountInfo accountInfo, String string2, boolean bl, String string3) {
        long l = new Date().getTime();
        long l2 = 0L;
        try {
            l = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException iOException) {
            LOG.fine(iOException.toString());
        }
        if (bl) {
            return new DirectoryInfo(FileInfoFactory.buildFileName(folder.getLocalBase(), path), string, memberInfo, accountInfo, new Date(l), 0, string2, false, string3, folder.getInfo());
        }
        try {
            l2 = Files.size(path);
        }
        catch (IOException iOException) {
            LOG.fine(iOException.toString());
        }
        return new FileInfo(FileInfoFactory.buildFileName(folder.getLocalBase(), path), string, l2, memberInfo, accountInfo, new Date(l), 0, string2, false, string3, folder.getInfo());
    }

    public static FileInfo modifiedFile(FileInfo fileInfo, Folder folder, Path path, MemberInfo memberInfo, AccountInfo accountInfo, String string) {
        Reject.ifNull(fileInfo, "Original FileInfo is null");
        Reject.ifTrue(fileInfo.isLookupInstance(), "Cannot modify template FileInfo!");
        Reject.ifNull(folder, "Folder is null");
        String string2 = FileInfoFactory.buildFileName(folder.getLocalBase(), path);
        if (fileInfo.getRelativeName().equals(string2)) {
            string2 = fileInfo.getRelativeName();
        }
        boolean bl = Files.isDirectory(path, new LinkOption[0]);
        try {
            if (fileInfo.isFile()) {
                if (bl) {
                    return new DirectoryInfo(string2, fileInfo.getOID(), memberInfo, accountInfo, new Date(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis()), fileInfo.getVersion() + 1, string, false, fileInfo.getTags(), fileInfo.getFolderInfo());
                }
                return new FileInfo(string2, fileInfo.getOID(), Files.size(path), memberInfo, accountInfo, new Date(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis()), fileInfo.getVersion() + 1, string, false, fileInfo.getTags(), fileInfo.getFolderInfo());
            }
            if (fileInfo.isDiretory()) {
                if (!bl) {
                    return new FileInfo(string2, fileInfo.getOID(), Files.size(path), memberInfo, accountInfo, new Date(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis()), fileInfo.getVersion() + 1, string, false, fileInfo.getTags(), fileInfo.getFolderInfo());
                }
                return new DirectoryInfo(string2, fileInfo.getOID(), memberInfo, accountInfo, new Date(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis()), fileInfo.getVersion() + 1, string, false, fileInfo.getTags(), fileInfo.getFolderInfo());
            }
            throw new IllegalArgumentException("Illegal original FileInfo: " + fileInfo.getClass() + ": " + fileInfo.toDetailString());
        }
        catch (IOException iOException) {
            LOG.warning(iOException.toString());
            return null;
        }
    }

    public static FileInfo deletedFile(FileInfo fileInfo, MemberInfo memberInfo, AccountInfo accountInfo, Date date) {
        Reject.ifNull(fileInfo, "Original FileInfo is null");
        Reject.ifTrue(fileInfo.isLookupInstance(), "Cannot delete template FileInfo!");
        if (fileInfo.isFile()) {
            return new FileInfo(fileInfo.getRelativeName(), fileInfo.getOID(), fileInfo.getSize(), memberInfo, accountInfo, date, fileInfo.getVersion() + 1, fileInfo.getHashes(), true, fileInfo.getTags(), fileInfo.getFolderInfo());
        }
        if (fileInfo.isDiretory()) {
            return new DirectoryInfo(fileInfo.getRelativeName(), fileInfo.getOID(), memberInfo, accountInfo, date, fileInfo.getVersion() + 1, fileInfo.getHashes(), true, fileInfo.getTags(), fileInfo.getFolderInfo());
        }
        throw new IllegalArgumentException("Illegal original FileInfo: " + fileInfo.getClass() + ": " + fileInfo.toDetailString());
    }

    public static FileInfo archivedFile(FolderInfo folderInfo, String string, String string2, long l, MemberInfo memberInfo, AccountInfo accountInfo, Date date, int n, String string3, String string4) {
        return new FileInfo(string, string2, l, memberInfo, accountInfo, date, n, string3, false, string4, folderInfo);
    }

    public static DirectoryInfo createBaseDirectoryInfo(FolderInfo folderInfo) {
        return new DirectoryInfo(folderInfo, "", null, null);
    }

    public static String encodeIllegalChars(String string) {
        Object object = string;
        if (OSUtil.isWindowsSystem()) {
            Object object2;
            char c;
            for (String string2 : ILLEGAL_WINDOWS_CHARS) {
                if (!((String)object).contains(string2)) continue;
                Object object3 = Base64.encodeString(string2);
                object3 = ((String)object3).replace("=", "");
                object3 = "$%" + (String)object3 + "%$";
                object = ((String)object).replace(string2, (CharSequence)object3);
            }
            if (((String)object).length() > 1 && ((c = ((String)object).charAt(((String)object).length() - 1)) == ' ' || c == '.')) {
                Object object4 = Base64.encodeString(String.valueOf(((String)object).charAt(((String)object).length() - 1)));
                object4 = ((String)object4).replace("=", "");
                object4 = "$%" + (String)object4 + "%$";
                object = ((String)object).substring(0, ((String)object).length() - 1);
                object = (String)object + (String)object4;
            }
            if (((String)object).contains(" /")) {
                object2 = Base64.encodeString(" ");
                object2 = ((String)object2).replace("=", "");
                object2 = "$%" + (String)object2 + "%$";
                object = ((String)object).replace(" /", (String)object2 + "/");
            }
            if (((String)object).contains("./")) {
                object2 = Base64.encodeString(".");
                object2 = ((String)object2).replace("=", "");
                object2 = "$%" + (String)object2 + "%$";
                object = ((String)object).replace("./", (String)object2 + "/");
            }
        }
        return object;
    }

    public static String decodeIllegalChars(String string) {
        Object object = string;
        if (OSUtil.isWindowsSystem()) {
            int n;
            int n2 = 0;
            while ((n2 = ((String)object).indexOf("$%", n2)) >= 0 && (n = ((String)object).indexOf("%$", n2)) >= 0 && n >= n2 + 2) {
                String string2 = ((String)object).substring(n2 + 2, n);
                try {
                    String string3 = Base64.decodeString(string2 + "==");
                    object = ((String)object).substring(0, n2) + string3 + ((String)object).substring(n + 2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    break;
                }
                catch (RuntimeException runtimeException) {
                    LOG.log(Level.WARNING, "Exception while decoding filename: " + string + ". " + runtimeException, runtimeException);
                    break;
                }
            }
        }
        return object;
    }

    public static String buildFileName(Path path, Path path2) {
        Reject.ifNull(path, "Base directory is null");
        Reject.ifNull(path2, "File is null");
        if (path2.equals(path)) {
            return "";
        }
        Object object = FileInfoFactory.decodeIllegalChars(path2.getFileName().toString());
        if (((String)object).endsWith("/")) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        Path path3 = path2.getParent();
        while (!path.equals(path3)) {
            if (path3 == null) {
                throw new IllegalArgumentException("Local file seems not to be in a subdir of the local powerfolder copy. Basedir: " + path + ", file: " + path2);
            }
            if (path3.getFileName() == null) {
                throw new IllegalArgumentException("Local file seems not to be in a subdir of the local powerfolder copy. Cannot access parent. Basedir: " + path + ", file: " + path2 + ", parent: " + path3);
            }
            object = FileInfoFactory.decodeIllegalChars(path3.getFileName().toString()) + "/" + (String)object;
            path3 = path3.getParent();
        }
        if (((String)object).endsWith("/")) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        while (((String)object).startsWith("/")) {
            object = ((String)object).substring(1);
        }
        return object;
    }
}

