/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.event;

import de.dal33t.powerfolder.event.CoreListener;
import de.dal33t.powerfolder.event.ListenerSupportFactory;
import de.dal33t.powerfolder.event.NodeManagerListener;
import de.dal33t.powerfolder.event.WeakCoreListener;
import de.dal33t.powerfolder.util.Profiling;
import de.dal33t.powerfolder.util.ProfilingEntry;
import java.awt.EventQueue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

class ListenerSupportInvocationHandler<T>
implements InvocationHandler {
    private static final Logger LOG = Logger.getLogger(ListenerSupportInvocationHandler.class.getName());
    private static final int WARN_IF_MORE_LISTENERS = 144;
    private Class<T> listenerInterface;
    private List<CoreListener> listenersNonEDT;
    private List<WeakCoreListener> weakListenersNonEDT;
    private List<CoreListener> listenersInEDT;
    private List<WeakCoreListener> weaklistenersInEDT;
    private boolean suspended;

    ListenerSupportInvocationHandler(Class<T> clazz) {
        this.listenerInterface = clazz;
        this.listenersInEDT = new CopyOnWriteArrayList<CoreListener>();
        this.listenersNonEDT = new CopyOnWriteArrayList<CoreListener>();
        this.weakListenersNonEDT = new CopyOnWriteArrayList<WeakCoreListener>();
        this.weaklistenersInEDT = new CopyOnWriteArrayList<WeakCoreListener>();
    }

    void addListener(CoreListener coreListener) {
        if (this.checkListener(coreListener)) {
            int n = 0;
            if (coreListener.fireInEventDispatchThread()) {
                this.listenersInEDT.add(coreListener);
                n = this.listenersInEDT.size();
            } else {
                this.listenersNonEDT.add(coreListener);
                n = this.listenersNonEDT.size();
            }
            if (LOG.isLoggable(Level.WARNING) && n > 144 && n % 144 == 0) {
                LOG.warning(n + " listeners of " + this.listenerInterface.getName() + " registered");
            }
        }
    }

    void addWeakListener(CoreListener coreListener) {
        if (this.checkListener(coreListener)) {
            int n = 0;
            WeakCoreListener weakCoreListener = new WeakCoreListener(coreListener, this);
            if (coreListener.fireInEventDispatchThread()) {
                this.weaklistenersInEDT.add(weakCoreListener);
                n = this.weaklistenersInEDT.size();
                if (n % 10 == 0) {
                    for (WeakCoreListener weakCoreListener2 : this.weaklistenersInEDT) {
                        if (weakCoreListener2.isValid()) continue;
                        this.weaklistenersInEDT.remove(weakCoreListener2);
                    }
                }
                n = this.weaklistenersInEDT.size();
            } else {
                this.weakListenersNonEDT.add(weakCoreListener);
                n = this.weakListenersNonEDT.size();
                if (n % 10 == 0) {
                    for (WeakCoreListener weakCoreListener3 : this.weakListenersNonEDT) {
                        if (weakCoreListener3.isValid()) continue;
                        this.weakListenersNonEDT.remove(weakCoreListener3);
                    }
                }
                n = this.weakListenersNonEDT.size();
            }
            if (LOG.isLoggable(Level.WARNING) && n > 144 && n % 610 == 0 && !this.listenerInterface.equals(NodeManagerListener.class)) {
                LOG.log(Level.WARNING, n + " weak listeners of " + this.listenerInterface.getName() + " registered");
            }
        }
    }

    void removeListener(CoreListener coreListener) {
        block10: {
            block9: {
                CoreListener coreListener2;
                if (!(coreListener instanceof WeakCoreListener)) break block9;
                if (!this.weaklistenersInEDT.isEmpty()) {
                    for (WeakCoreListener weakCoreListener : this.weaklistenersInEDT) {
                        coreListener2 = weakCoreListener.getRef();
                        if ((coreListener2 == null || !coreListener2.equals(coreListener)) && !weakCoreListener.equals(coreListener)) continue;
                        this.weaklistenersInEDT.remove(weakCoreListener);
                    }
                }
                if (this.weakListenersNonEDT.isEmpty()) break block10;
                for (WeakCoreListener weakCoreListener : this.weakListenersNonEDT) {
                    coreListener2 = weakCoreListener.getRef();
                    if ((coreListener2 == null || !coreListener2.equals(coreListener)) && !weakCoreListener.equals(coreListener)) continue;
                    this.weakListenersNonEDT.remove(weakCoreListener);
                }
                break block10;
            }
            if (this.checkListener(coreListener)) {
                boolean bl = this.listenersInEDT.remove(coreListener);
                boolean bl2 = bl = this.listenersNonEDT.remove(coreListener) || bl;
                if (!bl) {
                    CoreListener coreListener3;
                    if (!this.weaklistenersInEDT.isEmpty()) {
                        for (WeakCoreListener weakCoreListener : this.weaklistenersInEDT) {
                            coreListener3 = weakCoreListener.getRef();
                            if ((coreListener3 == null || !coreListener3.equals(coreListener)) && !weakCoreListener.equals(coreListener)) continue;
                            this.weaklistenersInEDT.remove(weakCoreListener);
                        }
                    }
                    if (!this.weakListenersNonEDT.isEmpty()) {
                        for (WeakCoreListener weakCoreListener : this.weakListenersNonEDT) {
                            coreListener3 = weakCoreListener.getRef();
                            if ((coreListener3 == null || !coreListener3.equals(coreListener)) && !weakCoreListener.equals(coreListener)) continue;
                            this.weakListenersNonEDT.remove(weakCoreListener);
                        }
                    }
                }
            }
        }
    }

    void removeAllListeners() {
        this.listenersInEDT.clear();
        this.listenersNonEDT.clear();
        this.weaklistenersInEDT.clear();
        this.weakListenersNonEDT.clear();
    }

    private boolean checkListener(CoreListener coreListener) {
        if (coreListener == null) {
            throw new NullPointerException("Listener is null");
        }
        if (!this.listenerInterface.isInstance(coreListener)) {
            throw new IllegalArgumentException("Listener '" + coreListener + "' is not an instance of support listener interface '" + this.listenerInterface.getName() + "'");
        }
        return true;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (this.listenersInEDT.isEmpty() && this.listenersNonEDT.isEmpty() && this.weaklistenersInEDT.isEmpty() && this.weakListenersNonEDT.isEmpty()) {
            return false;
        }
        if (method.getName().equals("fireInEventDispatchThread")) {
            return false;
        }
        if (!this.suspended) {
            if (!this.listenersInEDT.isEmpty()) {
                this.fireToEDTListeners(method, objectArray);
            }
            if (!this.listenersNonEDT.isEmpty()) {
                this.fireToNonEDTListeners(method, objectArray);
            }
            if (!this.weaklistenersInEDT.isEmpty()) {
                this.fireToWeakEDTListeners(method, objectArray);
            }
            if (!this.weakListenersNonEDT.isEmpty()) {
                this.fireToWeakNonEDTListeners(method, objectArray);
            }
        }
        return false;
    }

    private void fireToNonEDTListeners(Method method, Object[] objectArray) {
        for (CoreListener coreListener : this.listenersNonEDT) {
            this.fire(method, objectArray, coreListener);
        }
    }

    private void fireToEDTListeners(final Method method, final Object[] objectArray) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (CoreListener coreListener : ListenerSupportInvocationHandler.this.listenersInEDT) {
                    ListenerSupportInvocationHandler.this.fire(method, objectArray, coreListener);
                }
            }
        };
        if (!ListenerSupportFactory.AWT_AVAILABLE || EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeLater(runnable);
            }
            catch (Exception exception) {
                LOG.fine(exception.toString());
            }
        }
    }

    private void fireToWeakNonEDTListeners(Method method, Object[] objectArray) {
        for (WeakCoreListener weakCoreListener : this.weakListenersNonEDT) {
            if (weakCoreListener.isValid()) {
                this.fire(method, objectArray, weakCoreListener);
                continue;
            }
            this.weakListenersNonEDT.remove(weakCoreListener);
        }
    }

    private void fireToWeakEDTListeners(final Method method, final Object[] objectArray) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (WeakCoreListener weakCoreListener : ListenerSupportInvocationHandler.this.weaklistenersInEDT) {
                    if (weakCoreListener.isValid()) {
                        ListenerSupportInvocationHandler.this.fire(method, objectArray, weakCoreListener);
                        continue;
                    }
                    ListenerSupportInvocationHandler.this.weaklistenersInEDT.remove(weakCoreListener);
                }
            }
        };
        if (!ListenerSupportFactory.AWT_AVAILABLE || EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fire(Method method, Object[] objectArray, WeakCoreListener weakCoreListener) {
        ProfilingEntry profilingEntry = null;
        if (Profiling.ENABLED) {
            profilingEntry = Profiling.start(weakCoreListener.getRef().getClass(), method.getName());
        }
        try {
            weakCoreListener.invoke(null, method, objectArray);
        }
        catch (Throwable throwable) {
            try {
                ListenerSupportFactory.LOG.log(Level.WARNING, "Received an exception from listener '" + weakCoreListener + "': " + throwable, throwable);
                ListenerSupportFactory.LOG.log(Level.FINER, "", throwable);
            }
            catch (Throwable throwable2) {
                Profiling.end(profilingEntry, 50);
                throw throwable2;
            }
            Profiling.end(profilingEntry, 50);
        }
        Profiling.end(profilingEntry, 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fire(Method method, Object[] objectArray, CoreListener coreListener) {
        ProfilingEntry profilingEntry = null;
        if (Profiling.ENABLED) {
            profilingEntry = Profiling.start(coreListener.getClass(), method.getName());
        }
        try {
            method.invoke((Object)coreListener, objectArray);
        }
        catch (Exception exception) {
            ListenerSupportFactory.LOG.log(Level.WARNING, "Received an exception from listener '" + coreListener + "': " + exception, exception);
            ListenerSupportFactory.LOG.log(Level.FINER, "", exception);
        }
        finally {
            Profiling.end(profilingEntry, 50);
        }
    }

    void setSuspended(boolean bl) {
        this.suspended = bl;
    }
}

