/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.event;

import de.dal33t.powerfolder.event.CoreListener;
import de.dal33t.powerfolder.event.ListenerSupportInvocationHandler;
import de.dal33t.powerfolder.util.Util;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.logging.Logger;

public class ListenerSupportFactory {
    static final Logger LOG = Logger.getLogger(ListenerSupportFactory.class.getName());
    static final boolean AWT_AVAILABLE = Util.isAwtAvailable();

    public static <T> T createListenerSupport(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("Listener interface is empty");
        }
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("Listener interface class is not an java Interface!");
        }
        ClassLoader classLoader = clazz.getClassLoader();
        ListenerSupportInvocationHandler<T> listenerSupportInvocationHandler = new ListenerSupportInvocationHandler<T>(clazz);
        Object object = Proxy.newProxyInstance(classLoader, new Class[]{clazz}, listenerSupportInvocationHandler);
        LOG.finer("Created event listener support for interface '" + clazz.getName() + "'");
        return (T)object;
    }

    public static void setSuspended(Object object, boolean bl) {
        if (object == null) {
            throw new NullPointerException("Listener support is null");
        }
        if (!Proxy.isProxyClass(object.getClass())) {
            throw new IllegalArgumentException("Listener support is not valid. Seems not to be created with createListenerSupport.");
        }
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(object);
        if (!(invocationHandler instanceof ListenerSupportInvocationHandler)) {
            throw new IllegalArgumentException("Listener support is not valid. Seems not to be created with createListenerSupport.");
        }
        ListenerSupportInvocationHandler listenerSupportInvocationHandler = (ListenerSupportInvocationHandler)invocationHandler;
        listenerSupportInvocationHandler.setSuspended(bl);
    }

    public static void addListener(CoreListener coreListener, CoreListener coreListener2) {
        ListenerSupportFactory.addListener(coreListener, coreListener2, false);
    }

    public static void addListener(CoreListener coreListener, CoreListener coreListener2, boolean bl) {
        if (coreListener == null) {
            throw new NullPointerException("Listener support is null");
        }
        if (!Proxy.isProxyClass(coreListener.getClass())) {
            throw new IllegalArgumentException("Listener support is not valid. Seems not to be created with createListenerSupport.");
        }
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(coreListener);
        if (invocationHandler instanceof ListenerSupportInvocationHandler) {
            ListenerSupportInvocationHandler listenerSupportInvocationHandler = (ListenerSupportInvocationHandler)invocationHandler;
            if (bl) {
                listenerSupportInvocationHandler.addWeakListener(coreListener2);
            } else {
                listenerSupportInvocationHandler.addListener(coreListener2);
            }
        } else {
            throw new IllegalArgumentException("Listener support is not valid. Seems not to be created with createListenerSupport.");
        }
    }

    public static void removeListener(Object object, CoreListener coreListener) {
        if (object == null) {
            throw new NullPointerException("Listener support is null");
        }
        if (!Proxy.isProxyClass(object.getClass())) {
            throw new IllegalArgumentException("Listener support is not valid. Seems not to be created with createListenerSupport.");
        }
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(object);
        if (!(invocationHandler instanceof ListenerSupportInvocationHandler)) {
            throw new IllegalArgumentException("Listener support is not valid. Seems not to be created with createListenerSupport.");
        }
        ListenerSupportInvocationHandler listenerSupportInvocationHandler = (ListenerSupportInvocationHandler)invocationHandler;
        listenerSupportInvocationHandler.removeListener(coreListener);
    }

    public static void removeAllListeners(Object object) {
        if (object == null) {
            throw new NullPointerException("Listener support is null");
        }
        if (!Proxy.isProxyClass(object.getClass())) {
            throw new IllegalArgumentException("Listener support is not valid. Seems not to be created with createListenerSupport.");
        }
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(object);
        if (!(invocationHandler instanceof ListenerSupportInvocationHandler)) {
            throw new IllegalArgumentException("Listener support is not valid. Seems not to be created with createListenerSupport.");
        }
        ListenerSupportInvocationHandler listenerSupportInvocationHandler = (ListenerSupportInvocationHandler)invocationHandler;
        listenerSupportInvocationHandler.removeAllListeners();
    }
}

