/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.domain;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FileInfoFactory;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.FolderInfoFactory;
import de.dal33t.powerfolder.light.ServerInfo;
import de.dal33t.powerfolder.message.clientserver.ShareLinkInfo;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.security.FolderReadPermission;
import de.dal33t.powerfolder.security.FolderReadWritePermission;
import de.dal33t.powerfolder.util.IdGenerator;
import de.dal33t.powerfolder.util.LoginUtil;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Util;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class FileLink
implements Serializable {
    private static final long serialVersionUID = 100L;
    public static final String FILE_LINK_PREFIX = "fi";
    public static final String PROPERTYNAME_ID = "id";
    public static final String PROPERTYNAME_RELATIVE_NAME = "relativeName";
    public static final String PROPERTYNAME_CREATION_DATE = "creationDate";
    public static final String PROPERTYNAME_FOLDER_INFO = "folderInfo";
    @Id
    private String id;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="folderInfo_id")
    private FolderInfo folderInfo;
    @Index(name="IDX_FIL_REL_NAME")
    @Column(length=1024)
    private String relativeName;
    @Deprecated
    private String accountUsername;
    @Embedded
    private AccountInfo creator;
    @Deprecated
    private boolean publicAccess;
    @Type(type="permissionType")
    private FolderPermission publicPermission;
    @Column(nullable=true)
    private Date expirationDate;
    private Date creationDate;
    private int downloads;
    private int maxDownloads;
    private String password;

    protected FileLink() {
    }

    public FileLink(FileInfo fileInfo, boolean bl) {
        Reject.ifNull(fileInfo, "FileInfo");
        Reject.ifNull(fileInfo.getFolderInfo(), "FolderInfo");
        this.folderInfo = fileInfo.getFolderInfo();
        this.relativeName = fileInfo.getRelativeName();
        this.maxDownloads = -1;
        this.id = bl ? IdGenerator.generateFileLinkRandomID() : IdGenerator.generateFileLinkID(fileInfo);
        this.creationDate = new Date();
    }

    public FileLink(ShareLinkInfo shareLinkInfo) {
        this.downloads = shareLinkInfo.getDownloads();
        this.expirationDate = shareLinkInfo.getExpirationDate();
        this.relativeName = shareLinkInfo.getFileRelativePath();
        this.folderInfo = FolderInfoFactory.lookupInstance(shareLinkInfo.getFolderId());
        this.id = shareLinkInfo.getId();
        this.maxDownloads = shareLinkInfo.getMaxDownloads();
        this.password = shareLinkInfo.getPassword();
        this.publicPermission = shareLinkInfo.isUploadEnabled() ? FolderPermission.readWrite(this.folderInfo) : FolderPermission.read(this.folderInfo);
        this.creationDate = new Date();
    }

    public String getId() {
        return this.id;
    }

    public FolderInfo getFolderInfo() {
        return this.folderInfo;
    }

    public String getRelativeName() {
        return this.relativeName;
    }

    public String getFilenameOnly() {
        int n = this.relativeName.lastIndexOf(47);
        if (n > -1) {
            return this.relativeName.substring(n + 1);
        }
        return this.relativeName;
    }

    public String getExtension() {
        String string = this.getFilenameOnly();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1).toUpperCase();
    }

    public String getLinkURI() {
        return "/getlink/" + this.id + "/" + Util.encodeForURL(this.getFilenameOnly());
    }

    public String getDownloadURI() {
        return "/dl/" + this.id + "/" + Util.encodeForURL(this.getFilenameOnly());
    }

    public FileInfo getFileInfo(Controller controller) {
        FileInfo fileInfo;
        FileInfo fileInfo2 = FileInfoFactory.lookupDirectory(this.folderInfo, this.relativeName);
        Folder folder = this.folderInfo.getFolder(controller);
        if (folder != null && (fileInfo = folder.getFile(fileInfo2)) != null) {
            fileInfo2 = fileInfo;
        }
        return fileInfo2;
    }

    public String getDisplayName() {
        if (StringUtils.isBlank(this.relativeName)) {
            return this.folderInfo.getName();
        }
        int n = this.relativeName.lastIndexOf(47);
        if (n > -1) {
            return this.relativeName.substring(n + 1);
        }
        return this.relativeName;
    }

    public Path getDiskFile(Controller controller) {
        Reject.ifNull(controller, "Controller");
        DirectoryInfo directoryInfo = FileInfoFactory.lookupDirectory(this.folderInfo, this.relativeName);
        return directoryInfo.getDiskFile(controller.getFolderRepository());
    }

    public FolderPermission getPublicPermission() {
        return this.publicPermission;
    }

    public void setPublicPermission(FolderPermission folderPermission, boolean bl) {
        if (!bl || folderPermission == null) {
            this.publicPermission = null;
        } else {
            Reject.ifFalse(folderPermission instanceof FolderReadPermission || folderPermission instanceof FolderReadWritePermission, "Permission");
            this.publicPermission = folderPermission;
        }
    }

    public boolean hasPublicPermission(FolderPermission folderPermission) {
        if (this.publicPermission == null) {
            return folderPermission == null;
        }
        return this.publicPermission.equals(folderPermission) || this.publicPermission.implies(folderPermission);
    }

    public int getDownloads() {
        return this.downloads;
    }

    public void increaseDownloads() {
        ++this.downloads;
    }

    public int getMaxDownloads() {
        return this.maxDownloads;
    }

    public void setMaxDownloads(int n) {
        this.maxDownloads = n;
    }

    public boolean isDownloadLimitHit() {
        return this.maxDownloads >= 0 && this.downloads >= this.maxDownloads;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date date) {
        this.expirationDate = date;
    }

    public boolean isExpired() {
        if (this.expirationDate == null) {
            return false;
        }
        return this.expirationDate.getTime() <= System.currentTimeMillis();
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getAccountUsername() {
        if (this.creator == null) {
            return this.accountUsername;
        }
        return this.creator.getUsername();
    }

    public AccountInfo getCreator() {
        return this.creator;
    }

    public void setCreator(AccountInfo accountInfo) {
        this.creator = accountInfo;
    }

    public void setPassword(String string) {
        if (StringUtils.isBlank(string)) {
            this.password = null;
            return;
        }
        this.password = LoginUtil.hashAndSalt(string);
    }

    public boolean isPasswordProtected() {
        return StringUtils.isNotBlank(this.password);
    }

    public boolean isCorrectPassword(String string) {
        return LoginUtil.matches(Util.toCharArray(string), this.password);
    }

    public String toString() {
        return "FileLink [id=" + this.id + ", folderInfo=" + this.folderInfo + ", relativeName=" + this.relativeName + ", publicPermission=" + this.publicPermission + ", expirationDate=" + this.expirationDate + ", downloads=" + this.downloads + ", maxDownloads=" + this.maxDownloads + ", password=" + (this.password == null ? "no" : "yes") + "]";
    }

    public ShareLinkInfo toShareLinkInfo(ServerInfo serverInfo) {
        ShareLinkInfo shareLinkInfo = new ShareLinkInfo();
        shareLinkInfo.setDownloads(this.downloads);
        shareLinkInfo.setExpirationDate(this.expirationDate);
        shareLinkInfo.setFileRelativePath(this.relativeName);
        if (this.folderInfo != null) {
            shareLinkInfo.setFolderId(this.folderInfo.getId());
        }
        shareLinkInfo.setId(this.id);
        shareLinkInfo.setMaxDownloads(this.maxDownloads);
        shareLinkInfo.setPassword(this.password);
        if (this.publicPermission instanceof FolderReadWritePermission) {
            shareLinkInfo.setUploadEnabled(true);
        } else {
            shareLinkInfo.setUploadEnabled(false);
        }
        shareLinkInfo.setUrl(serverInfo.getURL(this.getLinkURI()));
        return shareLinkInfo;
    }
}

