/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.distribution;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.distribution.AbstractDistribution;
import de.dal33t.powerfolder.skin.Origin;
import de.dal33t.powerfolder.ui.LookAndFeelSupport;
import de.dal33t.powerfolder.ui.dialog.ConfigurationLoaderDialog;
import de.dal33t.powerfolder.util.ConfigurationLoader;

public class PowerFolderPro
extends AbstractDistribution {
    @Override
    public String getName() {
        return "PowerFolder Pro";
    }

    @Override
    public String getBinaryName() {
        return "PowerFolder";
    }

    @Override
    public void init(Controller controller) {
        super.init(controller);
        this.loadPreConfigFromClasspath(this.getController(), null);
        ConfigurationLoader.loadAndMergeFromInstaller(controller);
        boolean bl = ConfigurationEntry.CONFIG_PROMPT_SERVER_IF_PF_COM.getValueBoolean(this.getController());
        if (bl && ServerClient.isPowerFolderCloud(this.getController()) && controller.isUIEnabled()) {
            try {
                LookAndFeelSupport.setLookAndFeel(new Origin().getLookAndFeel());
            }
            catch (Exception exception) {
                this.logSevere("Failed to set look and feel", exception);
            }
            new ConfigurationLoaderDialog(controller).openAndWait();
        }
    }

    @Override
    public boolean allowSkinChange() {
        return true;
    }
}

