/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk.dao;

import de.dal33t.powerfolder.disk.DiskItemFilter;
import de.dal33t.powerfolder.disk.dao.FileInfoCriteria;
import de.dal33t.powerfolder.disk.dao.FileInfoDAO;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.FileHistory;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.logging.Loggable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class FileInfoDAOHashMapImpl
extends Loggable
implements FileInfoDAO {
    private final ConcurrentMap<String, Domain> domains = Util.createConcurrentHashMap(4);
    private String selfDomain;
    private DiskItemFilter filter;

    public FileInfoDAOHashMapImpl(String string, DiskItemFilter diskItemFilter) {
        this.selfDomain = string;
        this.filter = diskItemFilter;
        if (diskItemFilter == null) {
            this.filter = new DiskItemFilter();
        }
    }

    @Override
    public int count(String string, boolean bl, boolean bl2) {
        Domain domain = this.getDomain(string);
        if (bl2) {
            int n = 0;
            for (FileInfo fileInfo : domain.files.keySet()) {
                if (!this.filter.isRetained(fileInfo) || fileInfo.isDeleted()) continue;
                ++n;
            }
            if (bl) {
                for (FileInfo fileInfo : domain.directories.keySet()) {
                    if (!this.filter.isRetained(fileInfo) || fileInfo.isDeleted()) continue;
                    ++n;
                }
            }
            return n;
        }
        return domain.files.size() + (bl ? domain.directories.size() : 0);
    }

    @Override
    public int countInSync(String string, boolean bl, boolean bl2) {
        FileInfo fileInfo;
        Domain domain = this.getDomain(string);
        int n = 0;
        for (FileInfo fileInfo2 : domain.files.values()) {
            if (this.filter.isExcluded(fileInfo2) || fileInfo2.isDeleted() || !FileInfoDAOHashMapImpl.inSync(fileInfo2, fileInfo = this.findNewestVersion(fileInfo2, this.domains.keySet()))) continue;
            ++n;
        }
        if (bl) {
            for (FileInfo fileInfo2 : domain.directories.values()) {
                if (this.filter.isExcluded(fileInfo2) || fileInfo2.isDeleted() || !FileInfoDAOHashMapImpl.inSync(fileInfo2, fileInfo = this.findNewestVersion(fileInfo2, this.domains.keySet()))) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    public long bytesInSync(String string) {
        Domain domain = this.getDomain(string);
        long l = 0L;
        for (FileInfo fileInfo : domain.files.values()) {
            FileInfo fileInfo2;
            if (this.filter.isExcluded(fileInfo) || fileInfo.isDeleted() || !FileInfoDAOHashMapImpl.inSync(fileInfo, fileInfo2 = this.findNewestVersion(fileInfo, this.domains.keySet()))) continue;
            l += fileInfo.getSize();
        }
        return l;
    }

    private static boolean inSync(FileInfo fileInfo, FileInfo fileInfo2) {
        if (fileInfo2 == null) {
            throw new NullPointerException("Newest FileInfo not found of " + fileInfo.toDetailString());
        }
        if (fileInfo == null) {
            return false;
        }
        return !fileInfo2.isNewerThan(fileInfo);
    }

    @Override
    public void delete(String string, FileInfo fileInfo) {
        if (this.isFiner()) {
            this.logFiner(fileInfo.getFolderInfo() + ": Deleting in " + string + " " + fileInfo.toDetailString());
        }
        if (fileInfo.isFile()) {
            this.getDomain(string).files.remove(fileInfo);
        } else {
            this.getDomain(string).directories.remove(fileInfo);
        }
    }

    @Override
    public void deleteDomain(String string, int n) {
        String string2;
        String string3 = string2 = StringUtils.isBlank(string) ? this.selfDomain : string;
        if (this.isFiner()) {
            this.logFiner("Deleting domain " + string + ". newInitialSize=" + n);
        }
        this.domains.remove(string2);
        if (n > 0) {
            this.domains.put(string2, new Domain(n));
            if (this.isFiner()) {
                this.logFiner("Created new domain (" + string2 + ") with initial capacity " + n);
            }
        }
    }

    @Override
    public FileInfo find(FileInfo fileInfo, String string) {
        FileInfo fileInfo2 = (FileInfo)this.getDomain(string).files.get(fileInfo);
        if (fileInfo2 != null) {
            return fileInfo2;
        }
        return (FileInfo)this.getDomain(string).directories.get(fileInfo);
    }

    @Override
    public FileInfo findNewestByOID(String string, String ... stringArray) {
        Reject.ifBlank(string, "OID");
        FileInfo fileInfo = null;
        for (String string2 : stringArray) {
            Domain domain = this.getDomain(string2);
            for (FileInfo fileInfo2 : domain.files.values()) {
                if (StringUtils.isBlank(fileInfo2.getOID()) || !fileInfo2.getOID().equals(string) || fileInfo != null && !fileInfo2.isNewerThan(fileInfo)) continue;
                fileInfo = fileInfo2;
            }
            for (FileInfo fileInfo2 : domain.directories.values()) {
                if (StringUtils.isBlank(fileInfo2.getOID()) || !fileInfo2.getOID().equals(string) || fileInfo != null && !fileInfo2.isNewerThan(fileInfo)) continue;
                fileInfo = fileInfo2;
            }
        }
        return fileInfo;
    }

    @Override
    public FileInfo findNewestByHash(String string, String ... stringArray) {
        Reject.ifBlank(string, "Hash");
        FileInfo fileInfo = null;
        for (String string2 : stringArray) {
            Domain domain = this.getDomain(string2);
            for (FileInfo fileInfo2 : domain.files.values()) {
                if (!fileInfo2.isMatchingHash(string) || fileInfo != null && !fileInfo2.isNewerThan(fileInfo)) continue;
                fileInfo = fileInfo2;
            }
            for (FileInfo fileInfo2 : domain.directories.values()) {
                if (!fileInfo2.isMatchingHash(string) || fileInfo != null && !fileInfo2.isNewerThan(fileInfo)) continue;
                fileInfo = fileInfo2;
            }
        }
        return fileInfo;
    }

    @Override
    public Collection<FileInfo> findAllFiles(String string) {
        return Collections.unmodifiableCollection(this.getDomain(string).files.values());
    }

    @Override
    public Collection<DirectoryInfo> findAllDirectories(String string) {
        return Collections.unmodifiableCollection(this.getDomain(string).directories.values());
    }

    @Override
    public FileInfo findNewestVersion(FileInfo fileInfo, String ... stringArray) {
        return this.findNewestVersion(fileInfo, Arrays.asList(stringArray));
    }

    private FileInfo findNewestVersion(FileInfo fileInfo, Collection<String> collection) {
        FileInfo fileInfo2 = null;
        for (String string : collection) {
            Domain domain = this.getDomain(string);
            FileInfo fileInfo3 = (FileInfo)domain.files.get(fileInfo);
            if (fileInfo3 == null) {
                fileInfo3 = (FileInfo)domain.directories.get(fileInfo);
            }
            if (fileInfo3 == null || !fileInfo3.isValid() || fileInfo2 != null && !fileInfo3.isNewerThan(fileInfo2)) continue;
            fileInfo2 = fileInfo3;
        }
        return fileInfo2;
    }

    @Override
    public void stop() {
        if (this.isFiner()) {
            this.logFiner("Stopping. Clearing domains");
        }
        this.domains.clear();
    }

    @Override
    public void store(String string, FileInfo ... fileInfoArray) {
        this.store(string, Arrays.asList(fileInfoArray));
    }

    @Override
    public void store(String string, Collection<FileInfo> collection) {
        Domain domain = this.getDomain(string);
        for (FileInfo fileInfo : collection) {
            if (fileInfo.isFile()) {
                if (this.isFiner()) {
                    this.logFiner("Storing file: " + fileInfo.toDetailString());
                }
                domain.files.put(fileInfo, fileInfo);
                domain.directories.remove(fileInfo);
                continue;
            }
            if (this.isFiner()) {
                this.logFiner("Storing directory: " + fileInfo.toDetailString());
            }
            domain.directories.put((DirectoryInfo)fileInfo, (DirectoryInfo)fileInfo);
            domain.files.remove(fileInfo);
        }
    }

    @Override
    public Collection<FileInfo> findInDirectory(String string, DirectoryInfo directoryInfo, boolean bl) {
        FileInfoCriteria fileInfoCriteria = new FileInfoCriteria();
        fileInfoCriteria.addDomain(string);
        fileInfoCriteria.setPath(directoryInfo);
        fileInfoCriteria.setRecursive(bl);
        return this.findFiles(fileInfoCriteria);
    }

    @Override
    public Collection<FileInfo> findInDirectory(String string, String string2, boolean bl) {
        FileInfoCriteria fileInfoCriteria = new FileInfoCriteria();
        fileInfoCriteria.addDomain(string);
        fileInfoCriteria.setPath(string2);
        fileInfoCriteria.setRecursive(bl);
        return this.findFiles(fileInfoCriteria);
    }

    @Override
    public Collection<FileInfo> findFiles(FileInfoCriteria fileInfoCriteria) {
        Reject.ifTrue(fileInfoCriteria.getDomains().isEmpty(), "No domains/members selected in criteria");
        Object object = fileInfoCriteria.getPath();
        if (object == null) {
            object = "";
        }
        if (((String)object).equals("/")) {
            object = "";
        }
        if (((String)object).length() > 0 && !((String)object).endsWith("/")) {
            object = (String)object + "/";
        }
        boolean bl = fileInfoCriteria.isRecursive();
        HashSet<FileInfo> hashSet = new HashSet<FileInfo>();
        for (String string : fileInfoCriteria.getDomains()) {
            Domain domain = this.getDomain(string);
            if (domain == null) continue;
            if (fileInfoCriteria.getType() == FileInfoCriteria.Type.DIRECTORIES_ONLY || fileInfoCriteria.getType() == FileInfoCriteria.Type.FILES_AND_DIRECTORIES) {
                for (FileInfo fileInfo : domain.directories.values()) {
                    if (fileInfoCriteria.getMaxResults() > 0 && hashSet.size() >= fileInfoCriteria.getMaxResults()) {
                        return hashSet;
                    }
                    if (!this.isInSubDir(fileInfo, (String)object, bl) || Util.equalsRelativeName(fileInfo.getRelativeName(), (String)object) || hashSet.contains(fileInfo) || !this.matches(fileInfo, fileInfoCriteria.getKeyWords())) continue;
                    hashSet.add(fileInfo);
                }
            }
            if (fileInfoCriteria.getType() != FileInfoCriteria.Type.FILES_ONLY && fileInfoCriteria.getType() != FileInfoCriteria.Type.FILES_AND_DIRECTORIES) continue;
            for (FileInfo fileInfo : domain.files.values()) {
                if (fileInfoCriteria.getMaxResults() > 0 && hashSet.size() >= fileInfoCriteria.getMaxResults()) {
                    return hashSet;
                }
                if (!this.isInSubDir(fileInfo, (String)object, bl) || hashSet.contains(fileInfo) || !this.matches(fileInfo, fileInfoCriteria.getKeyWords())) continue;
                hashSet.add(fileInfo);
            }
        }
        return hashSet;
    }

    @Override
    public Collection<FileInfo> findFilesFast(FileInfoCriteria fileInfoCriteria) {
        Reject.ifTrue(fileInfoCriteria.getDomains().isEmpty(), "No domains/members selected in criteria");
        Object object = fileInfoCriteria.getPath();
        if (object == null || ((String)object).equals("/")) {
            object = "";
        }
        if (((String)object).length() > 0 && !((String)object).endsWith("/")) {
            object = (String)object + "/";
        }
        HashSet<FileInfo> hashSet = new HashSet<FileInfo>();
        block0: for (String string : fileInfoCriteria.getDomains()) {
            Domain domain = this.getDomain(string);
            if (domain == null) continue;
            if (fileInfoCriteria.getMaxResults() > 0 && hashSet.size() >= fileInfoCriteria.getMaxResults()) break;
            for (FileInfo fileInfo : domain.directories.values()) {
                if (fileInfoCriteria.getMaxResults() > 0 && hashSet.size() >= fileInfoCriteria.getMaxResults()) break;
                if (fileInfo.isDeleted() && !fileInfoCriteria.includeDeleted() || !this.isInSubDir(fileInfo, (String)object, fileInfoCriteria.isRecursive()) || Util.equalsRelativeName(fileInfo.getRelativeName(), (String)object) || hashSet.contains(fileInfo) || !this.matchesName(fileInfo, fileInfoCriteria.getKeyWords())) continue;
                hashSet.add(fileInfo);
            }
            if (fileInfoCriteria.getType() != FileInfoCriteria.Type.FILES_ONLY && fileInfoCriteria.getType() != FileInfoCriteria.Type.FILES_AND_DIRECTORIES) continue;
            for (FileInfo fileInfo : domain.files.values()) {
                if (fileInfoCriteria.getMaxResults() > 0 && hashSet.size() >= fileInfoCriteria.getMaxResults()) continue block0;
                if (fileInfo.isDeleted() && !fileInfoCriteria.includeDeleted() || !this.isInSubDir(fileInfo, (String)object, fileInfoCriteria.isRecursive()) || hashSet.contains(fileInfo) || !this.matchesName(fileInfo, fileInfoCriteria.getKeyWords())) continue;
                hashSet.add(fileInfo);
            }
        }
        return hashSet;
    }

    @Override
    public FileHistory getFileHistory(FileInfo fileInfo) {
        return null;
    }

    @Override
    public boolean hasDomainWithFiles(String string) {
        String string2 = StringUtils.isBlank(string) ? this.selfDomain : string;
        Domain domain = (Domain)this.domains.get(string2);
        if (domain == null) {
            return false;
        }
        return !domain.files.isEmpty() || !domain.directories.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Domain getDomain(String string) {
        String string2 = StringUtils.isBlank(string) ? this.selfDomain : string;
        ConcurrentMap<String, Domain> concurrentMap = this.domains;
        synchronized (concurrentMap) {
            Domain domain = (Domain)this.domains.get(string2);
            if (domain != null) {
                return domain;
            }
            if (this.isFiner()) {
                this.logFiner("Domain '" + string2 + "' created");
            }
            domain = new Domain(500);
            this.domains.put(string2, domain);
            return domain;
        }
    }

    private boolean matches(FileInfo fileInfo, Set<String> set) {
        if (set.isEmpty()) {
            return true;
        }
        String string = fileInfo.getRelativeName().toLowerCase();
        for (String string2 : set) {
            if (string.contains(string2)) continue;
            return false;
        }
        return true;
    }

    private boolean matchesName(FileInfo fileInfo, Set<String> set) {
        if (set.isEmpty()) {
            return true;
        }
        String string = fileInfo.getFilenameOnly().toLowerCase();
        for (String string2 : set) {
            if (string.contains(string2)) continue;
            return false;
        }
        return true;
    }

    private boolean isInSubDir(FileInfo fileInfo, String string, boolean bl) {
        if (!fileInfo.getRelativeName().startsWith(string)) {
            return false;
        }
        if (bl) {
            return true;
        }
        int n = string.length() + 1;
        int n2 = fileInfo.getRelativeName().indexOf(47, n);
        return n2 < 0;
    }

    private static class Domain {
        private final ConcurrentMap<FileInfo, FileInfo> files;
        private final ConcurrentMap<DirectoryInfo, DirectoryInfo> directories = Util.createConcurrentHashMap(4);

        public Domain(int n) {
            this.files = Util.createConcurrentHashMap(n);
        }

        public String toString() {
            return "Domain: " + this.files.size() + " files, " + this.directories.size() + " dirs";
        }
    }
}

