/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk.dao;

import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class FileInfoCriteria {
    private List<String> domains = new LinkedList<String>();
    private String path;
    private boolean recursive;
    private Type type = Type.FILES_AND_DIRECTORIES;
    private Set<String> keyWords = new HashSet<String>();
    private int maxResults = -1;
    private boolean includeDeleted = false;

    public List<String> getDomains() {
        return this.domains;
    }

    public void addDomain(String string) {
        if (!this.domains.contains(string)) {
            this.domains.add(string);
        }
    }

    public void addMember(Member member) {
        this.addDomain(member.getId());
    }

    public void addMySelf(Folder folder) {
        this.addMember(folder.getController().getMySelf());
    }

    public void addConnectedAndMyself(Folder folder) {
        this.addMySelf(folder);
        for (Member member : folder.getMembersAsCollection()) {
            if (!member.isCompletelyConnected()) continue;
            this.addMember(member);
        }
    }

    public void addWriteMembersAndMyself(Folder folder) {
        this.addMySelf(folder);
        for (Member member : folder.getMembersAsCollection()) {
            if (!member.isCompletelyConnected() || !folder.hasWritePermission(member)) continue;
            this.addMember(member);
        }
    }

    public void clearDomains() {
        this.domains.clear();
    }

    public void addKeyWord(String string) {
        if (StringUtils.isBlank(string)) {
            return;
        }
        this.keyWords.add(string.trim().toLowerCase());
    }

    public Set<String> getKeyWords() {
        return Collections.unmodifiableSet(this.keyWords);
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int n) {
        this.maxResults = n;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public void setPath(DirectoryInfo directoryInfo) {
        this.setPath(directoryInfo != null ? directoryInfo.getRelativeName() : null);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        Reject.ifNull((Object)type, "Type is null");
        this.type = type;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    public boolean includeDeleted() {
        return this.includeDeleted;
    }

    public void setIncludeDeleted(boolean bl) {
        this.includeDeleted = bl;
    }

    public String toString() {
        return "FileInfoCriteria [domains=" + this.domains + ", type=" + this.type + ", path=" + this.path + ", keyWords=" + this.keyWords + ", recursive=" + this.recursive + ", maxResults=" + this.maxResults + "]";
    }

    public static enum Type {
        FILES_AND_DIRECTORIES,
        FILES_ONLY,
        DIRECTORIES_ONLY;

    }
}

