/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Constants;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Feature;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.d2d.D2DSocketConnectionHandler;
import de.dal33t.powerfolder.disk.DiskItemFilter;
import de.dal33t.powerfolder.disk.EncryptedFileSystemUtils;
import de.dal33t.powerfolder.disk.FileArchiver;
import de.dal33t.powerfolder.disk.FolderException;
import de.dal33t.powerfolder.disk.FolderRepository;
import de.dal33t.powerfolder.disk.FolderScanner;
import de.dal33t.powerfolder.disk.FolderSettings;
import de.dal33t.powerfolder.disk.FolderStatistic;
import de.dal33t.powerfolder.disk.FolderWatcher;
import de.dal33t.powerfolder.disk.Locking;
import de.dal33t.powerfolder.disk.ScanResult;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.disk.dao.FileInfoCriteria;
import de.dal33t.powerfolder.disk.dao.FileInfoDAO;
import de.dal33t.powerfolder.disk.dao.FileInfoDAOHashMapImpl;
import de.dal33t.powerfolder.disk.problem.DeviceDisconnectedProblem;
import de.dal33t.powerfolder.disk.problem.FileConflictProblem;
import de.dal33t.powerfolder.disk.problem.FileProblemHelper;
import de.dal33t.powerfolder.disk.problem.FolderDatabaseProblem;
import de.dal33t.powerfolder.disk.problem.FolderReadOnlyProblem;
import de.dal33t.powerfolder.disk.problem.Problem;
import de.dal33t.powerfolder.disk.problem.ProblemListener;
import de.dal33t.powerfolder.disk.problem.TooLongFilenameProblem;
import de.dal33t.powerfolder.disk.problem.UnsynchronizedFolderProblem;
import de.dal33t.powerfolder.event.FolderEvent;
import de.dal33t.powerfolder.event.FolderListener;
import de.dal33t.powerfolder.event.FolderMembershipEvent;
import de.dal33t.powerfolder.event.FolderMembershipListener;
import de.dal33t.powerfolder.event.ListenerSupportFactory;
import de.dal33t.powerfolder.event.api.DeletedFile;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.DiskItem;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FileInfoFactory;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.FolderInfoFactory;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.message.FileList;
import de.dal33t.powerfolder.message.FileRequestCommand;
import de.dal33t.powerfolder.message.FolderFilesChanged;
import de.dal33t.powerfolder.message.Invitation;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.message.MessageProducer;
import de.dal33t.powerfolder.message.ScanCommand;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.security.Permission;
import de.dal33t.powerfolder.transfer.MetaFolderDataHandler;
import de.dal33t.powerfolder.transfer.TransferPriorities;
import de.dal33t.powerfolder.util.ArchiveMode;
import de.dal33t.powerfolder.util.Convert;
import de.dal33t.powerfolder.util.DateUtil;
import de.dal33t.powerfolder.util.Debug;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.SimpleCache;
import de.dal33t.powerfolder.util.StackDump;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.UserDirectories;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.Visitor;
import de.dal33t.powerfolder.util.Waiter;
import de.dal33t.powerfolder.util.compare.FileInfoComparator;
import de.dal33t.powerfolder.util.compare.ReverseComparator;
import de.dal33t.powerfolder.util.logging.LoggingManager;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.Win32.WinUtils;
import de.dal33t.powerfolder.util.pattern.DefaultExcludes;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class Folder
extends PFComponent {
    private static final String LAST_SYNC_INFO_FILENAME = "Last_sync";
    public static final String METAFOLDER_MEMBERS = "Members";
    public static final String METAFOLDER_LOCKS_DIR = "locks";
    public static final String FOLDER_STATISTIC = "FolderStatistic";
    private static final int FIVE_MINUTES = 300;
    private Path localBase;
    private Path commitDir;
    private FileInfoDAO dao;
    private Date lastScan;
    private Date lastSyncDate;
    private ScanResult.ResultState lastScanResultState;
    private Date lastDBMaintenance;
    private final Object dbAccessLock = new Object();
    private final DiskItemFilter diskItemFilter;
    private final TransferPriorities transferPriorities;
    private final Object scanLock = new Object();
    private final Map<Member, Member> members;
    private FolderInfo currentInfo;
    private SyncProfile syncProfile;
    private String configEntryId;
    private volatile boolean hasOwnDatabase;
    private volatile boolean shutdown;
    private boolean scanForced;
    private volatile boolean dirty;
    private final FolderStatistic statistic;
    private volatile FileArchiver archiver;
    private FolderWatcher watcher;
    private final FolderListener folderListenerSupport;
    private final FolderMembershipListener folderMembershipListenerSupport;
    private boolean deviceDisconnected;
    private String downloadScript;
    private final ProblemListener problemListenerSupport;
    private final List<Problem> problems;
    private boolean syncPatterns;
    private int syncWarnSeconds;
    private Persister persister;
    private ScheduledFuture<?> persisterFuture;
    private boolean isMovedFolder;
    private static final long HAS_PERMISSION_CACHE_TIMEOUT = 987L;
    private final SimpleCache<Member, Boolean> hasReadCache = new SimpleCache(987L, TimeUnit.MILLISECONDS);
    private final SimpleCache<Member, Boolean> hasWriteCache = new SimpleCache(987L, TimeUnit.MILLISECONDS);

    Folder(Controller controller, FolderInfo folderInfo, FolderSettings folderSettings) {
        super(controller);
        Object object;
        Object object2;
        String string;
        boolean bl;
        Reject.ifNull(folderSettings.getSyncProfile(), "Sync profile is null");
        this.currentInfo = folderInfo.isLookupInstance() ? FolderInfoFactory.unmarshallExistingFolder(folderInfo.id, folderInfo.getName(), 0, folderInfo.getParent()).intern() : folderInfo.intern(true);
        this.folderListenerSupport = ListenerSupportFactory.createListenerSupport(FolderListener.class);
        this.folderMembershipListenerSupport = ListenerSupportFactory.createListenerSupport(FolderMembershipListener.class);
        this.problemListenerSupport = ListenerSupportFactory.createListenerSupport(ProblemListener.class);
        this.hasOwnDatabase = false;
        this.dirty = false;
        this.problems = new CopyOnWriteArrayList<Problem>();
        Path path2 = folderSettings.getLocalBaseDir();
        boolean bl2 = bl = EncryptedFileSystemUtils.isCryptoInstance(path2) || EncryptedFileSystemUtils.endsWithEncryptionSuffix(path2);
        if (path2.isAbsolute()) {
            if (Files.notExists(path2, new LinkOption[0]) && bl) {
                this.logWarning("%s: Could not find base directory %s. Auto creating it", folderInfo, path2.toString());
                try {
                    Files.createDirectories(path2, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (bl && !folderInfo.isMetaFolder()) {
                try {
                    boolean bl3 = EncryptedFileSystemUtils.isInitializationRequired(path2);
                    if (bl3) {
                        this.logFine("Masterkey file or encrypted files missing/not complete for encrypted folder at storage location " + path2 + ". Decryption not possible! Auto creating new encrypted container!");
                        try {
                            EncryptedFileSystemUtils.getCryptoPath(path2).getFileSystem().close();
                        }
                        catch (FileSystemNotFoundException fileSystemNotFoundException) {
                            // empty catch block
                        }
                    }
                    this.localBase = EncryptedFileSystemUtils.getEncryptedFileSystem(this.getController(), path2);
                }
                catch (IOException | RuntimeException exception) {
                    throw new IllegalStateException("Could not initialize CryptoFileSystem for folder " + folderInfo.getName(), exception);
                }
            }
            this.localBase = path2;
        } else {
            this.localBase = this.getController().getFolderRepository().getFoldersBasedir().resolve(path2);
            this.logFine("Original path: " + path2 + ". Chosen relative path: " + this.localBase);
        }
        if (Files.notExists(this.localBase, new LinkOption[0]) && bl) {
            this.logWarning("Could NOT find storage location for folder %s with localbase %s. Auto creating storage location!", folderInfo.getName(), this.localBase.toString());
            try {
                Files.createDirectories(this.localBase, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Reject.ifTrue(this.localBase.equals(this.getController().getFolderRepository().getFoldersBasedir()), "Folder cannot be located at base directory for all folders");
        if (!EncryptedFileSystemUtils.isCryptoInstance(this.localBase) && this.localBase.getFileName() != null && ((string = this.localBase.getFileName().toString()).equals("/encDir".substring(1)) || this.localBase.toString().equals("/encDir"))) {
            this.logSevere("Could not initialize CryptoFileSystem for folder " + folderInfo.getName() + " with physical localBase " + path2);
            throw new IllegalStateException("localBase of encrypted folder " + folderInfo.getName() + " invalid!");
        }
        if (folderSettings.getCommitDir() != null) {
            this.commitDir = folderSettings.getCommitDir().isAbsolute() ? folderSettings.getCommitDir() : this.getController().getFolderRepository().getFoldersBasedir().resolve(folderSettings.getCommitDir());
        }
        this.syncProfile = folderSettings.getSyncProfile();
        this.downloadScript = folderSettings.getDownloadScript();
        this.syncPatterns = folderSettings.isSyncPatterns();
        this.syncWarnSeconds = folderSettings.getSyncWarnSeconds();
        this.configEntryId = folderSettings.getConfigEntryId();
        try {
            this.checkBaseDir(false);
            this.logFine("Opened " + this.toString() + " at '" + this.localBase.toAbsolutePath() + "'");
        }
        catch (FolderException folderException) {
            if (this.currentInfo.isMetaFolder()) {
                this.logFine(this.toString() + ": Unable to access base directory " + this.localBase.toAbsolutePath() + ": " + folderException);
            } else {
                this.logWarning(this.toString() + ": Unable to access base directory " + this.localBase.toAbsolutePath() + ": " + folderException);
            }
            this.deviceDisconnected = true;
        }
        DirectoryStream.Filter<Path> filter = path -> !this.isSystemSubDir((Path)path);
        if (!this.deviceDisconnected && PathUtils.isEmptyDir(this.localBase, filter)) {
            this.hasOwnDatabase = true;
        }
        this.transferPriorities = new TransferPriorities();
        this.diskItemFilter = new DiskItemFilter();
        this.initFileInfoDAO();
        this.checkIfDeviceDisconnected();
        this.members = new ConcurrentHashMap<Member, Member>();
        this.loadMetadata();
        List<String> list = this.diskItemFilter.getPatterns();
        if (StringUtils.isNotBlank(folderSettings.getExcludes())) {
            object2 = folderSettings.getExcludes().contains(",") ? "," : ";";
            for (String string2 : object = folderSettings.getExcludes().split((String)object2)) {
                if (!StringUtils.isNotBlank(string2)) continue;
                this.diskItemFilter.addPattern(string2);
            }
        }
        this.members.put(controller.getMySelf(), controller.getMySelf());
        this.statistic = new FolderStatistic(this);
        if (!this.currentInfo.isMetaFolder()) {
            PathUtils.maintainDesktopIni(this.getController(), this.localBase);
        }
        this.recommendScanOnNextMaintenance();
        if (this.isFine()) {
            if (this.hasOwnDatabase) {
                this.logFiner("Has own database (" + this.getName() + ")? " + this.hasOwnDatabase);
            } else {
                this.logFine("Has own database (" + this.getName() + ")? " + this.hasOwnDatabase);
            }
        }
        if (this.hasOwnDatabase) {
            this.writeFilelist(this.getMySelf());
        }
        this.persister = new Persister();
        this.persisterFuture = this.getController().scheduleAndRepeat(this.persister, 1000L, 1000L * (long)ConfigurationEntry.FOLDER_DB_PERSIST_TIME.getValueInt(this.getController()).intValue());
        this.archiver = ArchiveMode.FULL_BACKUP.getInstance(this);
        this.archiver.setVersionsPerFile(folderSettings.getVersions());
        this.watcher = new FolderWatcher(this);
        object2 = this.diskItemFilter.getPatterns();
        if (!object2.equals(list)) {
            this.triggerPersist();
        }
        if (Files.notExists((Path)(object = this.getSystemSubDir().resolve(FOLDER_STATISTIC)), new LinkOption[0])) {
            this.statistic.calculate0();
        }
        this.updateInfo(this.currentInfo);
    }

    public void addProblemListener(ProblemListener problemListener) {
        Reject.ifNull(problemListener, "Listener is null");
        ListenerSupportFactory.addListener(this.problemListenerSupport, problemListener);
    }

    public void removeProblemListener(ProblemListener problemListener) {
        Reject.ifNull(problemListener, "Listener is null");
        ListenerSupportFactory.removeListener(this.problemListenerSupport, problemListener);
    }

    public void addProblem(Problem problem) {
        if (this.problems.contains(problem)) {
            return;
        }
        this.problems.add(problem);
        this.problemListenerSupport.problemAdded(problem);
        if (!this.getController().isShuttingDown()) {
            this.getController().setPaused(this.getController().isPaused());
        }
        if (this.isWarning() && !this.currentInfo.isMetaFolder()) {
            this.logWarning(this + ": Added " + problem);
        }
    }

    public void removeProblem(Problem problem) {
        boolean bl = this.problems.remove(problem);
        if (bl) {
            this.problemListenerSupport.problemRemoved(problem);
        } else if (this.isFine()) {
            this.logFine("Problem was not removed: " + problem);
        }
    }

    @Deprecated
    public void removeAllProblems() {
        ArrayList<Problem> arrayList = new ArrayList<Problem>(this.problems);
        this.problems.clear();
        for (Problem problem : arrayList) {
            this.problemListenerSupport.problemRemoved(problem);
        }
    }

    public int countProblems() {
        return this.problems.size();
    }

    public List<Problem> getProblems() {
        return Collections.unmodifiableList(this.problems);
    }

    public void setArchiveVersions(int n) {
        int n2 = this.archiver.getVersionsPerFile();
        if (n2 == n) {
            return;
        }
        this.archiver.setVersionsPerFile(n);
        String string = "f." + this.configEntryId + ".versions";
        this.getController().getConfig().put(string, String.valueOf(n));
        this.getController().saveConfig();
        this.fireArchiveSettingsChanged();
    }

    public FileArchiver getFileArchiver() {
        return this.archiver;
    }

    public FolderWatcher getFolderWatcher() {
        return this.watcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitScanResult(ScanResult scanResult) {
        Object object;
        if (this.shutdown) {
            this.logFine(this.getName() + ": Already shutdown: Not commitScanResult: " + scanResult);
            return;
        }
        Object object2 = this.scanLock;
        synchronized (object2) {
            object = this.dbAccessLock;
            synchronized (object) {
                if (this.isFiner()) {
                    this.logFiner("Adding " + scanResult.getNewFiles().size() + " to directory");
                }
                this.store(this.getMySelf(), scanResult.newFiles);
                this.store(this.getMySelf(), scanResult.deletedFiles);
                this.store(this.getMySelf(), scanResult.restoredFiles);
                this.store(this.getMySelf(), scanResult.changedFiles);
            }
        }
        boolean bl = this.hasOwnDatabase;
        this.hasOwnDatabase = true;
        if (this.isInfo() || this.isFine()) {
            object = this + ": Scanned " + scanResult.getTotalFilesCount() + " total, " + scanResult.getChangedFiles().size() + " changed, " + scanResult.getNewFiles().size() + " new, " + scanResult.getRestoredFiles().size() + " restored, " + scanResult.getDeletedFiles().size() + " removed, " + scanResult.getProblemFiles().size() + " problems";
            if (scanResult.isChangeDetected() && !this.currentInfo.isMetaFolder()) {
                this.logInfo((String)object);
            } else {
                this.logFine((String)object);
            }
        }
        this.fireScanResultCommited(scanResult);
        if (scanResult.isChangeDetected()) {
            this.findSameFilesOnRemote();
            this.setDBDirty();
            this.broadcastFolderChanges(scanResult);
            if (!this.currentInfo.isMetaFolder()) {
                try {
                    object = this.getController().getFolderRepository().getLocking();
                    for (FileInfo fileInfo : scanResult.newFiles) {
                        ((Locking)object).handlePotentialLockfile(fileInfo);
                    }
                    for (FileInfo fileInfo : scanResult.deletedFiles) {
                        ((Locking)object).handlePotentialLockfile(fileInfo);
                    }
                    for (FileInfo fileInfo : scanResult.restoredFiles) {
                        ((Locking)object).handlePotentialLockfile(fileInfo);
                    }
                    for (FileInfo fileInfo : scanResult.changedFiles) {
                        ((Locking)object).handlePotentialLockfile(fileInfo);
                    }
                }
                catch (RuntimeException runtimeException) {
                    this.logWarning("Unable to automatically lock/unlock office files in: " + this + ". " + runtimeException, runtimeException);
                }
            }
        }
        if (this.isFiner()) {
            this.logFiner("commitScanResult DONE");
        }
        if (!bl) {
            this.getController().getFolderRepository().getFileRequestor().triggerFileRequesting(this.currentInfo);
        }
    }

    public boolean hasOwnDatabase() {
        return this.hasOwnDatabase;
    }

    public DiskItemFilter getDiskItemFilter() {
        return this.diskItemFilter;
    }

    public void addPattern(String string) {
        this.diskItemFilter.addPattern(string);
        this.triggerPersist();
    }

    public void removePattern(String string) {
        this.diskItemFilter.removePattern(string);
        this.triggerPersist();
    }

    public TransferPriorities getTransferPriorities() {
        return this.transferPriorities;
    }

    public ScanResult.ResultState getLastScanResultState() {
        return this.lastScanResultState;
    }

    private void checkBaseDir(boolean bl) throws FolderException {
        if (Files.notExists(this.localBase, new LinkOption[0])) {
            if ((OSUtil.isMacOS() || OSUtil.isLinux()) && this.localBase.toAbsolutePath().toString().toLowerCase().startsWith("/volumes")) {
                throw new FolderException(this.currentInfo, "Unmounted volume not available at " + this.localBase.toAbsolutePath());
            }
            throw new FolderException(this.currentInfo, "Local base dir not available " + this.localBase.toAbsolutePath());
        }
        if (!Files.isDirectory(this.localBase, new LinkOption[0])) {
            if (!bl) {
                this.logSevere("Not able to create folder " + this.getName() + ", (sub) dir (" + this.localBase + ") is no dir");
            }
            throw new FolderException(this.currentInfo, Translation.get("foldercreate.error.unable_to_open", this.localBase.toAbsolutePath().toString()));
        }
        FolderRepository folderRepository = this.getController().getFolderRepository();
        if (folderRepository.getFoldersBasedir().equals(this.localBase)) {
            throw new FolderException(this.currentInfo, Translation.get("foldercreate.error.it_is_base_dir", this.localBase.toAbsolutePath().toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scanDownloadFile(FileInfo fileInfo, Path path) {
        boolean bl;
        block11: {
            Path path2;
            if (this.shutdown) {
                this.logFine(this.getName() + ": Already shutdown: Not scanDownloadFile: " + fileInfo.toDetailString() + " from " + path);
                return false;
            }
            UserPrincipal userPrincipal = null;
            try {
                Path path3;
                this.watcher.addIgnoreFile(fileInfo);
                if (Feature.NTFS_PRESERVE_FILE_OWNER.isEnabled() && (path3 = fileInfo.getDiskFile(this.getController().getFolderRepository())) != null) {
                    try {
                        userPrincipal = Files.getOwner(path3, new LinkOption[0]);
                    }
                    catch (IOException iOException) {
                        this.logFine("Unable to retrieve owner from file: " + path3, iOException);
                    }
                }
                bl = this.scanDownloadFile0(fileInfo, path);
                if (userPrincipal == null || (path2 = fileInfo.getDiskFile(this.getController().getFolderRepository())) == null) break block11;
            }
            catch (Throwable throwable) {
                Path path4;
                if (userPrincipal != null && (path4 = fileInfo.getDiskFile(this.getController().getFolderRepository())) != null) {
                    try {
                        Files.setOwner(path4, userPrincipal);
                    }
                    catch (IOException iOException) {
                        this.logFine("Unable to set owner of file: " + path4 + " to " + userPrincipal, iOException);
                    }
                }
                this.watcher.removeIgnoreFile(fileInfo);
                throw throwable;
            }
            try {
                Files.setOwner(path2, userPrincipal);
            }
            catch (IOException iOException) {
                this.logFine("Unable to set owner of file: " + path2 + " to " + userPrincipal, iOException);
            }
        }
        this.watcher.removeIgnoreFile(fileInfo);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean scanDownloadFile0(FileInfo var1_1, Path var2_2) {
        var3_3 = var1_1.getDiskFile(this.getController().getFolderRepository());
        if (Files.notExists(var3_3.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(var3_3.getParent(), new FileAttribute[0]);
            }
            catch (IOException var4_4) {
                // empty catch block
            }
        }
        if (!Files.isDirectory(var3_3.getParent(), new LinkOption[0])) {
            var4_5 = false;
            try {
                var5_7 = Files.newDirectoryStream(var3_3);
                try {
                    var6_14 = var5_7.iterator();
                    if (Files.isRegularFile(var3_3.getParent(), new LinkOption[0]) && !var6_14.hasNext()) {
                        Files.delete(var3_3.getParent());
                        Files.createDirectories(var3_3.getParent(), new FileAttribute[0]);
                        var4_5 = true;
                    }
                }
                finally {
                    if (var5_7 != null) {
                        var5_7.close();
                    }
                }
            }
            catch (IOException var5_8) {
                var4_5 = false;
            }
            if (!var4_5) {
                this.logWarning("Unable to scan downloaded file. Parent dir is not a directory: " + var3_3 + ". " + var1_1.toDetailString());
                return false;
            }
        }
        var4_6 = this.scanLock;
        synchronized (var4_6) {
            try {
                Files.setLastModifiedTime(var2_2, FileTime.fromMillis(var1_1.getModifiedDate().getTime()));
            }
            catch (IOException var5_9) {
                if (this.isWarning() && !var1_1.inSyncWithDisk(var3_3)) {
                    this.logWarning("Failed to set modified date on tempfile " + var2_2 + " to " + var1_1.getModifiedDate() + ": " + var5_9);
                } else if (this.isFine()) {
                    this.logFine("Failed to set modified date on tempfile " + var2_2 + " to " + var1_1.getModifiedDate() + ": " + var5_9);
                }
                return false;
            }
            if (Files.exists(var3_3, new LinkOption[0])) {
                var5_7 = this.archiver;
                if (var5_7 != null) {
                    try {
                        var6_14 = var1_1.getLocalFileInfo(this.getController().getFolderRepository());
                        if (var6_14 != null) {
                            if (ConfigurationEntry.CONFLICT_DETECTION.getValueBoolean(this.getController()).booleanValue() && !this.currentInfo.isMetaFolder()) {
                                try {
                                    this.doSimpleConflictDetection(var1_1, (FileInfo)var6_14, var3_3);
                                }
                                catch (Exception var7_18) {
                                    this.logSevere("Problem withe conflict detection. " + var7_18);
                                }
                            }
                            var5_7.archive((FileInfo)var6_14, var3_3, false);
                        }
                        this.logFileOperation("UPDATED", (FileInfo)var6_14, var1_1);
                    }
                    catch (IOException var6_16) {
                        if (this.isWarning() && !var1_1.inSyncWithDisk(var3_3)) {
                            this.logWarning("Unable to archive old file " + var3_3 + ". " + var6_16);
                        } else if (this.isFine()) {
                            this.logFine("Unable to archive old file " + var3_3 + ". " + var6_16);
                        }
                        return false;
                    }
                }
            } else {
                this.logFileOperation("ADDED", null, var1_1);
            }
            if (!ConfigurationEntry.FOLDER_COPY_AFTER_TRANSFER.getValueBoolean(this.getController()).booleanValue()) {
                try {
                    Files.move(var2_2, var3_3, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    if (!ConfigurationEntry.WDNAS_CLIENT.getValueBoolean(this.getController()).booleanValue()) ** GOTO lbl128
                    var5_7 = new HashSet<PosixFilePermission>();
                    var5_7.add(PosixFilePermission.OWNER_READ);
                    var5_7.add(PosixFilePermission.OWNER_WRITE);
                    var5_7.add(PosixFilePermission.OWNER_EXECUTE);
                    var5_7.add(PosixFilePermission.GROUP_READ);
                    var5_7.add(PosixFilePermission.GROUP_WRITE);
                    var5_7.add(PosixFilePermission.GROUP_EXECUTE);
                    var5_7.add(PosixFilePermission.OTHERS_READ);
                    var5_7.add(PosixFilePermission.OTHERS_WRITE);
                    var5_7.add(PosixFilePermission.OTHERS_EXECUTE);
                    Files.setPosixFilePermissions(var3_3.getParent(), (Set<PosixFilePermission>)var5_7);
                    Files.setPosixFilePermissions(var3_3, (Set<PosixFilePermission>)var5_7);
                    this.logInfo("Successfully set POSIX file permissions on file " + var3_3);
                }
                catch (IOException var5_10) {
                    this.logWarning(var1_1 + ": Was not able to move tempfile " + var2_2.toAbsolutePath() + " to " + var3_3.toAbsolutePath() + ". " + var1_1.toDetailString() + ". " + var5_10);
                    if (PathUtils.isFilenameTooLong(var5_10)) {
                        this.logWarning(var1_1.toDetailString() + ": moving file to local list of ignored files to prevent further download attempts");
                        this.addPattern(var1_1.getRelativeName());
                        this.addProblem(new TooLongFilenameProblem(var1_1));
                    }
                    return false;
                }
            } else {
                try {
                    Files.copy(var2_2, var3_3, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                }
                catch (IOException var5_11) {
                    this.logWarning("Unable to store completed download " + var3_3.toAbsolutePath() + ". " + var5_11.getMessage() + ". " + var1_1.toDetailString() + ". " + var5_11);
                    this.logFiner(var5_11);
                    return false;
                }
                try {
                    Files.setLastModifiedTime(var3_3, FileTime.fromMillis(var1_1.getModifiedDate().getTime()));
                }
                catch (IOException var5_12) {
                    this.logWarning("Failed to set modified date on targetfile " + var3_3 + " to " + var1_1.getModifiedDate() + ". " + var5_12);
                    return false;
                }
                try {
                    Files.deleteIfExists(var2_2);
                }
                catch (IOException var5_13) {
                    this.logWarning("Unable to remove temp file: " + var2_2 + ". " + var5_13);
                }
            }
lbl128:
            // 4 sources

            var5_7 = this.dbAccessLock;
            synchronized (var5_7) {
                this.store(this.getMySelf(), new FileInfo[]{this.correctFolderInfo(var1_1)});
                this.fileChanged(new FileInfo[]{var1_1});
            }
        }
        return true;
    }

    private FileInfo doSimpleConflictDetection(FileInfo fileInfo, FileInfo fileInfo2, Path path) {
        boolean bl = fileInfo2.getVersion() == fileInfo.getVersion() && fileInfo.isNewerThan(fileInfo2) && fileInfo2.getVersion() + fileInfo.getVersion() != 0;
        bl |= fileInfo2.getVersion() <= fileInfo.getVersion() && DateUtil.isNewerFileDateCrossPlattform(fileInfo2.getModifiedDate(), fileInfo.getModifiedDate());
        if (fileInfo2.getSize() == 0L) {
            return null;
        }
        if (bl) {
            if ("eml".equalsIgnoreCase(fileInfo.getExtension())) {
                return null;
            }
            this.logWarning("Conflict detected on file " + fileInfo.toDetailString() + ". old: " + fileInfo2.toDetailString());
            Object object = "_";
            object = (String)object + fileInfo2.getVersion();
            object = (String)object + "_";
            object = (String)object + DateFormat.getDateTimeInstance().format(fileInfo2.getModifiedDate());
            object = ((String)object).replaceAll(" ", "_");
            Object object2 = fileInfo.getFilenameOnly();
            int n = ((String)object2).lastIndexOf(46);
            object2 = n >= 0 ? ((String)object2).substring(0, n) + (String)object + ((String)object2).substring(n) : (String)object2 + (String)object;
            Path path2 = path.getParent().resolve(PathUtils.removeInvalidFilenameChars((String)object2));
            try {
                Files.copy(path, path2, new CopyOption[0]);
                FileInfo fileInfo3 = FileInfoFactory.lookupInstance(this, path2);
                this.scanChangedFile(fileInfo3);
            }
            catch (IOException iOException) {
                this.logWarning("Unable to create copy of conflicting file to " + path2 + ". " + iOException);
                this.addProblem(new FileConflictProblem(fileInfo));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scanLocalFiles() {
        ScanResult scanResult;
        Map<FileInfo, List<Problem>> map;
        boolean bl;
        if (this.shutdown) {
            this.logFine(this.getName() + ": Already shutdown: Not scanLocalFiles");
            return false;
        }
        this.checkIfDeviceDisconnected();
        FolderScanner folderScanner = this.getController().getFolderRepository().getFolderScanner();
        do {
            map = this.scanLock;
            synchronized (map) {
                scanResult = folderScanner.scanFolder(this);
            }
            boolean bl2 = bl = ScanResult.ResultState.BUSY == scanResult.getResultState();
            if (!bl) continue;
            this.logFine("Folder scanner is busy, waiting...");
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                this.logFiner(interruptedException);
                return false;
            }
        } while (bl);
        if (this.checkIfDeviceDisconnected()) {
            if (this.isFiner()) {
                this.logFiner("Device disconnected while scanning folder: " + this.localBase);
            }
            return false;
        }
        try {
            if (!this.shutdown && scanResult.getResultState() == ScanResult.ResultState.SCANNED) {
                map = scanResult.getProblemFiles();
                for (Map.Entry<FileInfo, List<Problem>> entry : map.entrySet()) {
                    for (Problem problem : entry.getValue()) {
                        this.addProblem(problem);
                    }
                }
                this.commitScanResult(scanResult);
                this.lastScan = new Date();
                boolean bl3 = true;
                return bl3;
            }
            boolean bl4 = false;
            return bl4;
        }
        finally {
            this.lastScanResultState = scanResult.getResultState();
            this.checkLastSyncDate();
        }
    }

    private boolean autoScanRequired() {
        if (this.syncProfile.isManualSync() || EncryptedFileSystemUtils.isCryptoInstance(this.localBase) || EncryptedFileSystemUtils.endsWithEncryptionSuffix(this.localBase)) {
            return false;
        }
        Date date = this.lastScan;
        if (date == null) {
            return true;
        }
        if (this.syncProfile.isInstantSync()) {
            long l = (System.currentTimeMillis() - date.getTime()) / 1000L;
            int n = this.getKnownItemCount();
            int n2 = (int)(6L * (long)n / 1000L);
            int n3 = this.syncProfile.getSecondsBetweenScans();
            if (n3 < 0) {
                return false;
            }
            if (n2 < n3) {
                n2 = n3;
            }
            if (this.watcher.isSupported()) {
                if (!this.syncProfile.isCustom() && n2 > 300) {
                    n2 = 300;
                }
            } else {
                n2 = n3;
            }
            if (l < (long)n2) {
                if (this.isFiner()) {
                    this.logFiner("Skipping regular scan");
                }
                return false;
            }
        } else if (this.syncProfile.isDailySync()) {
            if (!this.shouldDoDailySync()) {
                if (this.isFiner()) {
                    this.logFiner("Skipping daily scan");
                }
                return false;
            }
        } else if (this.syncProfile.isPeriodicSync()) {
            long l = (System.currentTimeMillis() - date.getTime()) / 1000L;
            if (l < (long)this.syncProfile.getSecondsBetweenScans()) {
                if (this.isFiner()) {
                    this.logFiner("Skipping regular scan");
                }
                return false;
            }
        } else {
            this.logSevere("Do not know what sort of sync to do!!! Folder = " + this.getName() + ", instant = " + this.syncProfile.getConfiguration().isInstantSync() + ", daily = " + this.syncProfile.getConfiguration().isDailySync() + ", periodic = " + this.syncProfile.getConfiguration().isDailySync());
        }
        return true;
    }

    private boolean shouldDoDailySync() {
        int n;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(this.lastScan);
        int n2 = gregorianCalendar.get(6);
        if (this.isFiner()) {
            this.logFiner("Last scanned " + gregorianCalendar.getTime());
        }
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(new Date());
        int n3 = gregorianCalendar2.get(6);
        if (n2 == n3 && gregorianCalendar.get(1) == gregorianCalendar2.get(1)) {
            if (this.isFiner()) {
                this.logFiner("Skipping daily scan (already scanned today)");
            }
            return false;
        }
        int n4 = this.syncProfile.getConfiguration().getDailyHour();
        if (n4 > (n = gregorianCalendar2.get(11))) {
            if (this.isFiner()) {
                this.logFiner("Skipping daily scan (not correct time) " + n4 + " > " + n);
            }
            return false;
        }
        int n5 = this.syncProfile.getConfiguration().getDailyDay();
        int n6 = gregorianCalendar2.get(7);
        if (n5 != 0) {
            if (n5 == 8) {
                if (n6 == 7 || n6 == 1) {
                    if (this.isFiner()) {
                        this.logFiner("Skipping daily scan (not weekday)");
                    }
                    return false;
                }
            } else if (n5 == 9) {
                if (n6 != 7 && n6 != 1) {
                    if (this.isFiner()) {
                        this.logFiner("Skipping daily scan (not weekend)");
                    }
                    return false;
                }
            } else if (n6 != n5) {
                if (this.isFiner()) {
                    this.logFiner("Skipping daily scan (not correct day)");
                }
                return false;
            }
        }
        return true;
    }

    public FileInfo scanChangedFile(AccountInfo accountInfo, FileInfo fileInfo) {
        if (accountInfo != null) {
            fileInfo = FileInfoFactory.changeModifiedAccount(fileInfo, accountInfo);
        }
        return this.scanChangedFile(fileInfo);
    }

    public FileInfo scanChangedFile(FileInfo fileInfo) {
        Reject.ifNull(fileInfo, "FileInfo is null");
        if (this.shutdown) {
            this.logFine(this.getName() + ": Already shutdown: Not scanChangedFile: " + fileInfo);
            return null;
        }
        FileInfo fileInfo2 = this.scanChangedFile0(fileInfo);
        if (fileInfo2 != null) {
            FileInfo fileInfo3 = this.findSameFile(fileInfo2);
            if (fileInfo3 != null) {
                fileInfo2 = fileInfo3;
            }
            this.fileChanged(fileInfo2);
        }
        return fileInfo2;
    }

    public void scanAllParentDirectories(FileInfo fileInfo) {
        if (this.shutdown) {
            this.logFine(this.getName() + ": Already shutdown: Not scanAllParentDirectories: " + fileInfo.toDetailString());
            return;
        }
        FileInfo fileInfo2 = fileInfo.getDirectory();
        if ((fileInfo2 = this.getFile(fileInfo2)) == null || !fileInfo2.isDeleted()) {
            return;
        }
        DirectoryInfo directoryInfo = this.getBaseDirectoryInfo();
        int n = 0;
        while (!fileInfo2.equals(directoryInfo)) {
            if (this.isFiner()) {
                this.logFiner("Scanning parent dir: " + fileInfo2);
            }
            this.scanChangedFile(fileInfo2);
            fileInfo2 = fileInfo2.getDirectory();
            if (n++ <= 10000) continue;
            break;
        }
    }

    void scanChangedFiles(final List<FileInfo> list) {
        Reject.ifNull(list, "FileInfo collection is null");
        if (this.shutdown) {
            this.logFine(this.getName() + ": Already shutdown: Not scanChangedFiles (" + list.size() + "): " + list);
            return;
        }
        boolean bl = this.isRevertLocalChanges();
        int n = 0;
        Iterator<FileInfo> iterator = list.iterator();
        while (iterator.hasNext()) {
            FileInfo fileInfo = iterator.next();
            if (this.shutdown) {
                this.logFine(this.getName() + ": Already shutdown: Not scanChangedFiles (" + list.size() + "): " + list);
                return;
            }
            FileInfo fileInfo2 = this.scanChangedFile0(fileInfo);
            if (fileInfo2 == null) {
                iterator.remove();
                continue;
            }
            if (bl && this.checkRevertLocalChanges(fileInfo2)) {
                iterator.remove();
                continue;
            }
            FileInfo fileInfo3 = this.findSameFile(fileInfo2);
            if (fileInfo3 != null) {
                fileInfo2 = fileInfo3;
            }
            list.set(n, fileInfo2);
            ++n;
        }
        if (!list.isEmpty()) {
            this.fireFilesChanged(list);
            this.setDBDirty();
            this.broadcastMessages(new MessageProducer(){

                @Override
                public Message[] getMessages(boolean bl) {
                    return FolderFilesChanged.create(Folder.this.currentInfo, list, Folder.this.diskItemFilter, bl);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private FileInfo scanChangedFile0(FileInfo fileInfo) {
        FileInfo fileInfo2;
        long l;
        Path path;
        block42: {
            FileInfo fileInfo3;
            if (this.shutdown) {
                this.logFine(this.getName() + ": Already shutdown: Not scanChangedFile0: " + fileInfo.toDetailString());
                return null;
            }
            if (this.isFiner()) {
                this.logFiner("Scanning file: " + fileInfo + ", folderId: " + fileInfo);
            }
            if ((path = this.getDiskFile(fileInfo)).getFileName().toString().equals(Constants.DB_FILENAME) || path.getFileName().toString().equals(Constants.DB_BACKUP_FILENAME)) {
                this.logFiner("Ignoring folder database file: " + path);
                return null;
            }
            l = System.currentTimeMillis();
            try {
                boolean bl;
                Date date;
                long l2;
                MemberInfo memberInfo;
                Object object = this.scanLock;
                // MONITORENTER : object
                Object object2 = this.dbAccessLock;
                // MONITORENTER : object2
                fileInfo2 = this.getFile(fileInfo);
                if (fileInfo2 != null) break block42;
                if (this.isFiner()) {
                    this.logFiner("Scan new file: " + fileInfo.toDetailString());
                }
                if ((memberInfo = fileInfo.getModifiedBy()) == null) {
                    memberInfo = this.getMySelf().getInfo();
                }
                Member member = memberInfo.getNode(this.getController(), false);
                AccountInfo accountInfo = fileInfo.getModifiedByAccount();
                if (accountInfo == null) {
                    AccountInfo accountInfo2 = accountInfo = member != null ? member.getAccountInfo() : null;
                }
                if (accountInfo == null) {
                    accountInfo = this.getMySelf().getAccountInfo();
                }
                if (fileInfo.isLookupInstance()) {
                    l2 = 0L;
                    date = new Date();
                    bl = Files.notExists(path, new LinkOption[0]);
                } else {
                    l2 = fileInfo.getSize();
                    date = fileInfo.getModifiedDate();
                    bl = fileInfo.isDeleted();
                }
                if (member != null) {
                    memberInfo = member.getInfo();
                }
                if (Files.exists(path, new LinkOption[0])) {
                    try {
                        date = new Date(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis());
                        l2 = Files.size(path);
                    }
                    catch (IOException iOException) {
                        this.logWarning("Could not read file meta data. " + iOException.getMessage());
                        date = new Date(0L);
                        l2 = 0L;
                    }
                }
                String string = fileInfo.getOID();
                String string2 = null;
                String string3 = fileInfo.getTags();
                fileInfo = bl ? FileInfoFactory.unmarshallDeletedFile(this.currentInfo, fileInfo.getRelativeName(), string, memberInfo, accountInfo, date, fileInfo.getVersion(), string2, Files.isDirectory(path, new LinkOption[0]), string3) : FileInfoFactory.unmarshallExistingFile(this.currentInfo, fileInfo.getRelativeName(), string, l2, memberInfo, accountInfo, date, fileInfo.getVersion(), string2, Files.isDirectory(path, new LinkOption[0]), string3);
                this.store(this.getMySelf(), fileInfo);
                if (PathUtils.isDesktopIni(path)) {
                    this.makeFolderIcon(path);
                }
                if (this.isFiner()) {
                    this.logFiner(this.toString() + ": Local file scanned: " + fileInfo.toDetailString());
                }
                this.checkFile(fileInfo);
                this.logFileOperation("ADDED", null, fileInfo);
                fileInfo3 = fileInfo;
                // MONITOREXIT : object2
                // MONITOREXIT : object
            }
            catch (Throwable throwable) {
                long l3 = System.currentTimeMillis() - l;
                if (this.isWarning() && l3 > 60000L) {
                    this.logWarning("Scanning file took " + l3 / 1000L + "s: " + fileInfo.toDetailString());
                }
                try {
                    if (this.currentInfo.isMetaFolder()) throw throwable;
                    this.getController().getFolderRepository().getLocking().handlePotentialLockfile(fileInfo);
                    throw throwable;
                }
                catch (RuntimeException runtimeException) {
                    this.logWarning("Unable to automatically lock/unlock office file: " + fileInfo.toDetailString() + ". " + runtimeException, runtimeException);
                }
                throw throwable;
            }
            long l4 = System.currentTimeMillis() - l;
            if (this.isWarning() && l4 > 60000L) {
                this.logWarning("Scanning file took " + l4 / 1000L + "s: " + fileInfo.toDetailString());
            }
            try {
                if (this.currentInfo.isMetaFolder()) return fileInfo3;
                this.getController().getFolderRepository().getLocking().handlePotentialLockfile(fileInfo);
                return fileInfo3;
            }
            catch (RuntimeException runtimeException) {
                this.logWarning("Unable to automatically lock/unlock office file: " + fileInfo.toDetailString() + ". " + runtimeException, runtimeException);
            }
            return fileInfo3;
        }
        FileInfo fileInfo4 = fileInfo2.syncFromDiskIfRequired(this, path, fileInfo.getModifiedByAccount());
        if (fileInfo4 != null) {
            this.store(this.getMySelf(), fileInfo4);
            if (this.isFiner()) {
                this.logFiner("Scan file changed: " + fileInfo4.toDetailString());
            }
            this.checkFile(fileInfo4);
        } else {
            if (this.isFiner()) {
                this.logFiner("Scan file unchanged: " + fileInfo2.toDetailString());
            }
            this.checkFile(fileInfo2);
        }
        if (fileInfo4 != null) {
            if (fileInfo4.isDeleted()) {
                this.logFileOperation("DELETED", fileInfo2, fileInfo4);
            } else if (fileInfo4 != fileInfo2 && fileInfo2.isDeleted() && !fileInfo4.isDeleted()) {
                this.logFileOperation("RESTORED", fileInfo2, fileInfo4);
            } else {
                this.logFileOperation("CHANGED", fileInfo2, fileInfo4);
            }
        }
        FileInfo fileInfo5 = fileInfo4;
        // MONITOREXIT : object2
        // MONITOREXIT : object
        long l5 = System.currentTimeMillis() - l;
        if (this.isWarning() && l5 > 60000L) {
            this.logWarning("Scanning file took " + l5 / 1000L + "s: " + fileInfo.toDetailString());
        }
        try {
            if (this.currentInfo.isMetaFolder()) return fileInfo5;
            this.getController().getFolderRepository().getLocking().handlePotentialLockfile(fileInfo);
            return fileInfo5;
        }
        catch (RuntimeException runtimeException) {
            this.logWarning("Unable to automatically lock/unlock office file: " + fileInfo.toDetailString() + ". " + runtimeException, runtimeException);
        }
        return fileInfo5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanDirectory(FileInfo fileInfo, Path path) {
        Object object;
        block21: {
            Reject.ifNull(fileInfo, "DirInfo is null");
            Reject.ifTrue(fileInfo.isLookupInstance(), "Scanning lookup instances not implemented");
            if (this.shutdown) {
                this.logFine(this.getName() + ": Already shutdown: Not scanning directory: " + fileInfo.toDetailString() + " at " + path);
                return;
            }
            if (this.isFiner()) {
                this.logFiner("Scanning dir: " + fileInfo.toDetailString());
            }
            if (!fileInfo.getFolderInfo().equals(this.currentInfo)) {
                this.logSevere("Unable to scan directory. not on folder: " + fileInfo.toDetailString());
                return;
            }
            if (path.equals(this.getSystemSubDir0())) {
                this.logFine("Ignoring system subdirectory: " + path);
                return;
            }
            Path path2 = fileInfo.getDiskFile(this.getController().getFolderRepository());
            if (!path2.equals(path)) {
                this.logWarning("Metadata mismatch: " + fileInfo.toDetailString() + ". Expected at " + path2 + ". Got " + path);
            }
            if (PathUtils.isReplicatedSubdir(path)) {
                this.logWarning("Unable to scan directory. Replication found: " + path);
                return;
            }
            if (this.isDeviceDisconnected()) {
                return;
            }
            this.watcher.addIgnoreFile(fileInfo);
            try {
                object = this.scanLock;
                synchronized (object) {
                    block20: {
                        if (!fileInfo.isDeleted()) break block20;
                        try {
                            Files.deleteIfExists(path);
                            break block21;
                        }
                        catch (IOException iOException) {
                            this.logSevere("Unable to deleted directory: " + path + ". " + fileInfo.toDetailString() + ". " + iOException);
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 6, 7] lbl34 : MonitorExitStatement: MONITOREXIT : var4_4
                            this.watcher.removeIgnoreFile(fileInfo);
                            return;
                        }
                    }
                    if (Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0]) && Files.size(path) == 0L) {
                        Files.delete(path);
                    }
                    Files.createDirectories(path, new FileAttribute[0]);
                    Files.setLastModifiedTime(path, FileTime.fromMillis(fileInfo.getModifiedDate().getTime()));
                }
            }
            catch (IOException iOException) {
                this.logInfo("Could not delete " + path + ". " + iOException);
            }
            finally {
                this.watcher.removeIgnoreFile(fileInfo);
            }
        }
        object = this.correctFolderInfo(fileInfo);
        this.store(this.getMySelf(), new FileInfo[]{object});
        this.setDBDirty();
        this.broadcastMessages(arg_0 -> Folder.lambda$scanDirectory$1((FileInfo)object, arg_0));
    }

    private void checkFile(FileInfo fileInfo) {
        List<Problem> list = FileProblemHelper.getProblems(this.getController(), fileInfo);
        for (Problem problem : list) {
            this.addProblem(problem);
        }
    }

    private FileInfo correctFolderInfo(FileInfo fileInfo) {
        FileInfo fileInfo2 = FileInfoFactory.changedFolderInfo(fileInfo, this.currentInfo);
        TransferPriorities.TransferPriority transferPriority = this.transferPriorities.getPriority(fileInfo2);
        this.transferPriorities.setPriority(fileInfo2, transferPriority);
        return fileInfo2;
    }

    public boolean isKnown(FileInfo fileInfo) {
        return this.hasFile(fileInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copy(FileInfo fileInfo, Path path) {
        Reject.ifNull(fileInfo, "sourceFile");
        Reject.ifNull(path, "destinationFilePath");
        Reject.ifTrue(Files.exists(path, new LinkOption[0]), path + ": already existing");
        Path path2 = fileInfo.getDiskFile(this.getController().getFolderRepository());
        FileInfo fileInfo2 = FileInfoFactory.lookupInstance(this, path);
        Reject.ifFalse(Files.exists(path2, new LinkOption[0]), path2 + " does not exist");
        Reject.ifTrue(PathUtils.isSubdirectory(path2, path), path + " must not be a subdirectory of " + path2);
        try {
            this.watcher.addIgnoreFile(fileInfo2);
            PathUtils.recursiveCopyVisitor(path2, path);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            this.logWarning(this + ": Unable to copy " + fileInfo + " to " + path + ". " + iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            this.watcher.removeIgnoreFile(fileInfo2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInfo removeFileLocal(FileInfo fileInfo, AccountInfo accountInfo) {
        if (this.shutdown) {
            this.logFine(this.getName() + ": Already shutdown: Not removeFileLocal: " + fileInfo.toDetailString());
            return null;
        }
        if (this.isFiner()) {
            this.logFiner("Remove file local: " + fileInfo + ", Folder equal ? " + Util.equals(fileInfo.getFolderInfo(), this.currentInfo));
        }
        if (!this.isKnown(fileInfo)) {
            if (this.isWarning()) {
                this.logWarning("Tried to remove a unknown file: " + fileInfo.toDetailString());
            }
            return null;
        }
        if (fileInfo.isFile()) {
            this.getController().getTransferManager().breakTransfers(fileInfo);
        }
        Path path = this.getDiskFile(fileInfo);
        boolean bl = false;
        Object object = this.scanLock;
        synchronized (object) {
            block17: {
                FileInfo fileInfo2;
                block19: {
                    if (path == null || !Files.exists(path, new LinkOption[0])) break block17;
                    if (!this.deleteFile(fileInfo, path) && (fileInfo.isDiretory() || Files.isDirectory(path, new LinkOption[0]))) {
                        try {
                            this.watcher.addIgnoreFile(fileInfo);
                            this.deleteFileRecursive(fileInfo, path);
                            this.recommendScanOnNextMaintenance();
                        }
                        catch (IOException iOException) {
                            this.logWarning(this + ": Unable to delete local directory. " + path.toAbsolutePath() + ". " + fileInfo.toDetailString());
                            FileInfo fileInfo3 = null;
                            return fileInfo3;
                        }
                        finally {
                            this.watcher.removeIgnoreFile(fileInfo);
                        }
                    }
                    if ((fileInfo2 = this.getFile(fileInfo)) != null) break block19;
                    return null;
                }
                FileInfo fileInfo4 = fileInfo2.syncFromDiskIfRequired(this, path, accountInfo);
                boolean bl2 = bl = fileInfo4 != null;
                if (bl) {
                    this.logFileOperation("DELETED", fileInfo2, fileInfo4);
                    this.store(this.getMySelf(), fileInfo4);
                    return fileInfo4;
                }
                break block17;
                finally {
                }
            }
            return null;
        }
    }

    public void removeFilesLocal(AccountInfo accountInfo, FileInfo ... fileInfoArray) {
        this.removeFilesLocal(accountInfo, Arrays.asList(fileInfoArray));
    }

    public void removeFilesLocal(FileInfo ... fileInfoArray) {
        this.removeFilesLocal(null, Arrays.asList(fileInfoArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilesLocal(AccountInfo accountInfo, Collection<FileInfo> collection) {
        Reject.ifNull(collection, "Files null");
        if (collection.isEmpty()) {
            return;
        }
        if (this.shutdown) {
            this.logFine(this.getName() + ": Already shutdown: Not removeFilesLocal (" + collection.size() + "): " + collection);
            return;
        }
        final ArrayList<FileInfo> arrayList = new ArrayList<FileInfo>();
        ReverseComparator<FileInfo> reverseComparator = new ReverseComparator<FileInfo>(FileInfoComparator.getComparator(2));
        TreeSet<FileInfo> treeSet = new TreeSet<FileInfo>(reverseComparator);
        Object object = this.scanLock;
        synchronized (object) {
            Object object2;
            for (FileInfo fileInfo : collection) {
                if (fileInfo.isDiretory()) {
                    treeSet.add(fileInfo);
                    continue;
                }
                object2 = this.removeFileLocal(fileInfo, accountInfo);
                if (object2 == null) continue;
                arrayList.add((FileInfo)object2);
            }
            for (FileInfo fileInfo : treeSet) {
                object2 = new FileInfoCriteria();
                ((FileInfoCriteria)object2).addMySelf(this);
                ((FileInfoCriteria)object2).setPath((DirectoryInfo)fileInfo);
                this.logInfo("Deleting directory: " + fileInfo);
                this.removeFilesLocal(accountInfo, this.dao.findFiles((FileInfoCriteria)object2));
                FileInfo fileInfo2 = this.removeFileLocal(fileInfo, accountInfo);
                if (fileInfo2 == null) continue;
                arrayList.add(fileInfo2);
            }
        }
        if (!arrayList.isEmpty()) {
            this.fireFilesDeleted(arrayList);
            this.setDBDirty();
            this.broadcastMessages(new MessageProducer(){

                @Override
                public Message[] getMessages(boolean bl) {
                    return FolderFilesChanged.create(Folder.this.currentInfo, arrayList, Folder.this.diskItemFilter, bl);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean erase(FileInfo fileInfo) {
        Reject.ifNull(fileInfo, "fInfo");
        if (this.shutdown) {
            this.logFine(this.getName() + ": Already shutdown: Not erase: " + fileInfo.toDetailString());
            return false;
        }
        Path path = this.getDiskFile(fileInfo);
        Object object = this.scanLock;
        synchronized (object) {
            Object object2 = this.dbAccessLock;
            synchronized (object2) {
                if (this.deleteFile(fileInfo, path)) {
                    this.dao.delete(null, fileInfo);
                    this.logFileOperation("DELETED", fileInfo, null);
                    return true;
                }
                this.logWarning("Unable to erase: " + path + ". " + fileInfo);
                return false;
            }
        }
    }

    public void changeModifiedAccountFor(FileInfo fileInfo) {
        this.dao.store(null, fileInfo);
        this.setDBDirty();
    }

    private void initFileInfoDAO() {
        if (this.dao != null) {
            this.dao.stop();
        }
        this.dao = new FileInfoDAOHashMapImpl(this.getMySelf().getId(), this.diskItemFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean loadFolderDB(Path path) {
        Object object = this.scanLock;
        synchronized (object) {
            if (Files.notExists(path, new LinkOption[0])) {
                this.logFine(this + ": Database file not found: " + path.toAbsolutePath());
                return false;
            }
            try (ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));){
                FileInfo[] fileInfoArray = (FileInfo[])objectInputStream.readObject();
                MemberInfo[] memberInfoArray = this.dbAccessLock;
                synchronized (this.dbAccessLock) {
                    void object2;
                    boolean i = false;
                    while (object2 < fileInfoArray.length) {
                        FileInfo fileInfo = fileInfoArray[object2];
                        fileInfoArray[object2] = this.correctFolderInfo(fileInfo);
                        if (fileInfo != fileInfoArray[object2]) {
                            this.setDBDirty();
                        }
                        ++object2;
                    }
                    this.dao.deleteDomain(null, fileInfoArray.length);
                    this.dao.store(null, fileInfoArray);
                    // ** MonitorExit[memberInfoArray] (shouldn't be in output)
                    this.hasOwnDatabase = true;
                    memberInfoArray = (MemberInfo[])objectInputStream.readObject();
                    this.logFiner("Loading " + memberInfoArray.length + " members");
                    for (MemberInfo memberInfo : memberInfoArray) {
                        boolean bl;
                        Member member = memberInfo.getNode(this.getController(), true);
                        if (member.isMySelf()) continue;
                        boolean bl2 = bl = member.isServer() && !this.getController().getOSClient().isClusterServer(member) && !this.getController().getOSClient().isFederatedServer(member);
                        if (member.isConnected() && bl) {
                            if (this.members.containsKey(member)) continue;
                            this.logFine("(I) Not joining connected server " + member.getNick() + " into folder " + this.getName());
                            continue;
                        }
                        this.join0(member, !this.getController().isStarted());
                    }
                    for (Member member : this.getConnectedMembers()) {
                        if (member.getPeer() instanceof D2DSocketConnectionHandler) continue;
                        if (this.hasReadPermission(member)) {
                            member.sendMessagesAsynchron(FileList.create(this, this.supportExternalizable(member)));
                            continue;
                        }
                        if (this.isFine()) {
                            this.logFine("Creating empty FileList for " + this.currentInfo + " to send to " + member + " while loading folder db.", new StackDump());
                        }
                        member.sendMessagesAsynchron(FileList.createEmpty(this.currentInfo, this.supportExternalizable(member)));
                    }
                    try {
                        Object outOfMemoryError = objectInputStream.readObject();
                        for (FileInfo fileInfo : (Collection)outOfMemoryError) {
                            this.diskItemFilter.addPattern(fileInfo.getRelativeName());
                            if (!this.isFiner()) continue;
                            this.logFiner("ignore@" + fileInfo.getRelativeName());
                        }
                    }
                    catch (EOFException eOFException) {
                        this.logFiner("No ignore list");
                    }
                    catch (Exception exception) {
                        this.logSevere("read ignore error: " + this + exception.getMessage(), exception);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        this.logWarning("Read ignore error: " + this + " on " + path + ": " + outOfMemoryError.getMessage());
                    }
                    try {
                        Object object3 = objectInputStream.readObject();
                        if (object3 instanceof Date) {
                            this.lastScan = (Date)object3;
                            if (this.isFiner()) {
                                this.logFiner("lastScan " + this.lastScan);
                            }
                        }
                    }
                    catch (EOFException eOFException) {
                        this.logFine("No last scan date");
                    }
                    catch (Exception exception) {
                        this.logSevere("read ignore error: " + this + exception.getMessage(), exception);
                    }
                    this.logFine("Loaded folder database (" + fileInfoArray.length + " files) from " + path.toAbsolutePath());
                }
            }
            catch (Exception exception) {
                this.logWarning(this + ": Unable to read database file: " + path.toAbsolutePath() + ". " + exception);
                this.logFiner(exception);
                return false;
            }
            {
            }
        }
        return true;
    }

    private void loadMetadata() {
        this.loadFolderDB();
        this.loadLastSyncDate();
        this.diskItemFilter.loadPatternsFrom(this.getSystemSubDir0().resolve("ignore.patterns"), false);
    }

    private void loadFolderDB() {
        if (this.loadFolderDB(this.getSystemSubDir0().resolve(Constants.DB_FILENAME))) {
            return;
        }
        if (this.loadFolderDB(this.getSystemSubDir0().resolve(Constants.DB_BACKUP_FILENAME))) {
            return;
        }
        this.logFine("Unable to read folder db, even from backup. Maybe new folder?");
    }

    public void shutdown() {
        if (this.isFine()) {
            this.logFine("Shutting down " + this);
        }
        this.shutdown = true;
        if (ConfigurationEntry.FOLDER_WATCHER_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            this.watcher.remove();
        }
        if (this.dirty) {
            this.persist();
        }
        if (this.diskItemFilter.isDirty() && !this.checkIfDeviceDisconnected()) {
            this.diskItemFilter.savePatternsTo(this.getSystemSubDir().resolve("ignore.patterns"), true);
            this.savePatternsToMetaFolder();
        }
        this.getController().removeScheduled(this.persister);
        this.getController().removeScheduled(this.persisterFuture);
        this.dao.stop();
        this.removeAllListeners();
        ListenerSupportFactory.removeAllListeners(this.folderListenerSupport);
        ListenerSupportFactory.removeAllListeners(this.folderMembershipListenerSupport);
        this.diskItemFilter.removeAllListener();
    }

    public Date getLastSyncDate() {
        return this.lastSyncDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean storeFolderDB() {
        FileInfo[] fileInfoArray;
        Object object;
        Path path = this.getSystemSubDir().resolve(Constants.DB_FILENAME + PathUtils.removeInvalidFilenameChars(this.getController().getMySelf().getId()) + ".writing");
        try {
            object = new Waiter(5000L);
            while (Files.exists(path, new LinkOption[0]) && !((Waiter)object).isTimeout()) {
                Files.delete(path);
                boolean bl = Files.exists(path, new LinkOption[0]);
                this.logInfo("Deleted existing DB tmp file " + path + " for folder " + this.getName() + "/" + this.getId() + ". Deleted? " + bl);
                if (!bl) continue;
                ((Waiter)object).waitABit();
            }
            fileInfoArray = this.getSystemSubDir().resolve(Constants.DB_BACKUP_FILENAME);
            Files.deleteIfExists((Path)fileInfoArray);
        }
        catch (IOException iOException) {
            this.logWarning("Unable to delete DB- file backup/temp file from folder: " + this.getName() + "/" + System.identityHashCode(this) + ". Reason: " + iOException);
        }
        object = this.getSystemSubDir().resolve(Constants.DB_FILENAME);
        try {
            Object object2 = this.dbAccessLock;
            synchronized (object2) {
                FileInfo fileInfo;
                Collection<FileInfo> collection = this.dao.findAllFiles(null);
                Collection<DirectoryInfo> collection2 = this.dao.findAllDirectories(null);
                fileInfoArray = new FileInfo[collection.size() + collection2.size()];
                int n = 0;
                Iterator<FileInfo> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    fileInfoArray[n] = fileInfo = iterator.next();
                    ++n;
                }
                iterator = collection2.iterator();
                while (iterator.hasNext()) {
                    fileInfoArray[n] = fileInfo = (DirectoryInfo)iterator.next();
                    ++n;
                }
            }
            try {
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                this.logWarning("Failed to create temp database file " + path + " for folder: " + this.getName() + "/" + System.identityHashCode(this) + ". Reason: " + iOException);
                return false;
            }
            object2 = new ObjectOutputStream(Files.newOutputStream(path, new OpenOption[0]));
            try {
                ((ObjectOutputStream)object2).writeObject(fileInfoArray);
                ((ObjectOutputStream)object2).writeObject(Convert.asMemberInfos(this.getMembersAsCollection().toArray(new Member[0])));
                ((ObjectOutputStream)object2).writeObject(new ArrayList());
                if (this.lastScan == null) {
                    if (this.isFiner()) {
                        this.logFiner("write default time: " + new Date());
                    }
                    ((ObjectOutputStream)object2).writeObject(new Date());
                } else {
                    if (this.isFiner()) {
                        this.logFiner("write lastScan: " + this.lastScan);
                    }
                    ((ObjectOutputStream)object2).writeObject(this.lastScan);
                }
            }
            finally {
                ((ObjectOutputStream)object2).close();
            }
            boolean bl = true;
            if (Files.exists((Path)object, new LinkOption[0])) {
                try {
                    Files.delete((Path)object);
                    Files.move(path, (Path)object, new CopyOption[0]);
                    bl = false;
                }
                catch (IOException iOException) {
                    bl = true;
                }
            }
            if (bl) {
                try {
                    PathUtils.copyFile(path, (Path)object);
                    Files.deleteIfExists(path);
                }
                catch (IOException iOException) {
                    this.logWarning("Failed to copy database file: " + (Path)object + ", temp file: " + path + " for folder " + this.getName() + "/" + System.identityHashCode(this));
                    return false;
                }
            }
            if (this.isFine()) {
                this.logFine(this + ": Successfully wrote folder database file (" + fileInfoArray.length + " disk items)");
            }
            return true;
        }
        catch (IOException iOException) {
            this.logWarning(this + ": Unable to write database file " + object.toAbsolutePath() + " for folder " + this.getName() + "/" + System.identityHashCode(this));
            this.logFiner(iOException);
            return false;
        }
    }

    private boolean maintainFolderDBrequired() {
        if (this.getKnownItemCount() == 0) {
            return false;
        }
        if (this.lastDBMaintenance == null) {
            return true;
        }
        return this.lastDBMaintenance.getTime() + (long)ConfigurationEntry.DB_MAINTENANCE_SECONDS.getValueInt(this.getController()).intValue() * 1000L < System.currentTimeMillis();
    }

    public void maintainFolderDB(long l) {
        Object object;
        if (this.shutdown) {
            this.logFine(this.getName() + ": Already shutdown: Not maintainFolderDB: " + l);
            return;
        }
        Date date = new Date(l);
        int n = this.getKnownItemCount();
        if (this.isFiner()) {
            this.logFiner("Maintaining folder db, known files: " + n + ". Expiring deleted files older than " + date);
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        LinkedList<FileInfo> linkedList = new LinkedList<FileInfo>();
        for (FileInfo fileInfo : this.dao.findAllFiles(null)) {
            Member member;
            ++n4;
            if (!fileInfo.isDeleted()) {
                object = this.members.keySet().iterator();
                while (object.hasNext()) {
                    boolean bl;
                    member = object.next();
                    FileInfo fileInfo2 = member.getFile(fileInfo);
                    if (fileInfo2 == null || fileInfo2.getVersion() != fileInfo.getVersion() || fileInfo2.isVersionDateAndSizeIdentical(fileInfo)) continue;
                    boolean bl2 = fileInfo2.getModifiedDate().equals(fileInfo.getModifiedDate());
                    boolean bl3 = !bl2 && fileInfo2.getModifiedDate().before(fileInfo.getModifiedDate());
                    boolean bl4 = bl = fileInfo2.getSize() < fileInfo.getSize();
                    if (!bl3 && (!bl2 || !bl) || linkedList.contains(fileInfo)) continue;
                    linkedList.add(fileInfo);
                    if (!this.isInfo() || this.currentInfo.isMetaFolder()) continue;
                    this.logInfo("Fixing file entry. Local: " + fileInfo.toDetailString() + ".\n@" + member.getNick() + ": " + fileInfo2.toDetailString());
                }
                continue;
            }
            if (fileInfo.getModifiedDate().before(date)) {
                if (this.archiver.hasArchivedFileInfo(fileInfo)) continue;
                ++n2;
                this.dao.delete(null, fileInfo);
                object = this.members.values().iterator();
                while (object.hasNext()) {
                    member = object.next();
                    this.dao.delete(member.getId(), fileInfo);
                }
                if (!this.isFiner()) continue;
                this.logFiner("FileInfo expired: " + fileInfo.toDetailString());
                continue;
            }
            ++n3;
        }
        if (!linkedList.isEmpty()) {
            for (int i = 0; i < linkedList.size(); ++i) {
                FileInfo fileInfo;
                fileInfo = (FileInfo)linkedList.get(i);
                object = FileInfoFactory.unmarshallExistingFile(this.currentInfo, fileInfo.getRelativeName(), fileInfo.getOID(), fileInfo.getSize(), fileInfo.getModifiedBy(), fileInfo.getModifiedByAccount(), fileInfo.getModifiedDate(), fileInfo.getVersion() + 1, fileInfo.getHashes(), fileInfo.isDiretory(), fileInfo.getTags());
                linkedList.set(i, (FileInfo)object);
            }
            this.store(this.getMySelf(), linkedList);
            this.filesChanged(linkedList);
        }
        if (n2 > 0 || linkedList.size() > 0) {
            this.setDBDirty();
            this.logFine("Maintained folder db, " + n + " known files, " + n2 + " expired FileInfos, " + linkedList.size() + " fixed entries. Expiring deleted files older than " + date);
            this.statistic.scheduleCalculate();
        } else if (this.isFiner()) {
            this.logFiner("Maintained folder db, " + n + " known files, " + n2 + " expired FileInfos. Expiring deleted files older than " + date);
        }
        this.lastDBMaintenance = new Date();
        long l2 = Runtime.getRuntime().maxMemory() / 4181L;
        if ((long)n4 > l2 && n4 - n3 * 2 < 0) {
            object = new FolderDatabaseProblem(this.currentInfo);
            if (!this.getProblems().contains(object)) {
                this.addProblem(new FolderDatabaseProblem(this.currentInfo));
            }
        }
        if (!this.currentInfo.isMetaFolder() && (object = this.getController().getFolderRepository().getMetaFolder(this.currentInfo)) != null && object != this) {
            ((Folder)object).maintainFolderDB(l);
        }
    }

    private boolean isRevertLocalChanges() {
        boolean bl = this.hasReadPermission(this.getMySelf()) && !this.hasWritePermission(this.getMySelf());
        return bl || this.syncProfile.equals(SyncProfile.BACKUP_TARGET);
    }

    private void checkRevertLocalChanges() {
        if (!this.isRevertLocalChanges()) {
            for (Problem problem : this.getProblems()) {
                if (!(problem instanceof FolderReadOnlyProblem)) continue;
                this.removeProblem(problem);
            }
            return;
        }
        if (this.isFine()) {
            this.logFine("Checking revert on my files");
        }
        boolean bl = false;
        for (FileInfo fileInfo : this.dao.findAllFiles(null)) {
            bl |= this.checkRevertLocalChanges(fileInfo);
        }
        if (bl) {
            this.getController().getFolderRepository().getFileRequestor().triggerFileRequesting(this.currentInfo);
            this.syncRemoteDeletedFiles(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkRevertLocalChanges(FileInfo fileInfo) {
        if (this.shutdown) {
            this.logFine(this.getName() + ": Already shutdown: Not checkRevertLocalChanges: " + fileInfo.toDetailString());
            return false;
        }
        if (this.diskItemFilter.getPatterns().isEmpty() || this.diskItemFilter.isExcluded(fileInfo)) {
            return false;
        }
        if (!this.hasCompleteFileListOfAtLeastOneMember()) {
            return false;
        }
        FileInfo fileInfo2 = fileInfo.getNewestVersion(this);
        if (fileInfo2 != null && !fileInfo.isNewerThan(fileInfo2)) {
            return false;
        }
        if (!this.hasCompleteFileListOfAtLeastOneMember()) {
            return false;
        }
        Path path = fileInfo.getDiskFile(this.getController().getFolderRepository());
        if (path == null) {
            return false;
        }
        if (this.isWarning() && !this.currentInfo.isMetaFolder()) {
            this.logWarning("Reverting local change: " + fileInfo.toDetailString() + ". File not found on remote side. Newest version: " + fileInfo2);
        }
        try {
            this.getFolderWatcher().addIgnoreFile(fileInfo);
            Object object = this.scanLock;
            synchronized (object) {
                if (Files.exists(path, new LinkOption[0])) {
                    this.archiver.archive(fileInfo, path, false);
                    Files.deleteIfExists(path);
                }
                if (!this.currentInfo.isMetaFolder()) {
                    this.addProblem(new FolderReadOnlyProblem(this, this.archiver.getArchiveDir().resolve(fileInfo.getRelativeName())));
                }
                this.dao.delete(null, fileInfo);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            this.logWarning("Unable to revert changes on file " + path + ". Cannot overwrite local change. " + iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            this.getFolderWatcher().removeIgnoreFile(fileInfo);
        }
    }

    private boolean hasCompleteFileListOfAtLeastOneMember() {
        boolean bl = false;
        for (Member member : this.getConnectedMembers()) {
            if (!this.hasWritePermission(member) || !member.hasCompleteFileListFor(this.currentInfo)) continue;
            if (this.getDAO().count(member.getId(), false, false) == 0 && this.getKnownItemCount() > 0) {
                this.logInfo(this + ": Empty filelist from " + member + ". Known local items " + this.getKnownItemCount());
                continue;
            }
            bl = true;
            break;
        }
        return bl;
    }

    @Deprecated
    private Path createTimestampedCopy(Path path) throws IOException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        Object object = PathUtils.removeInvalidFilenameChars(simpleDateFormat.format(new Date()).replace(":", "_"));
        object = (String)object + " ";
        object = (String)object + path.getFileName().toString();
        Path path2 = path.getParent().resolve((String)object);
        this.addPattern("*" + (String)object);
        Files.copy(path, path2, new CopyOption[0]);
        return path2;
    }

    private void makeFolderIcon(Path path) {
        if (path == null) {
            throw new NullPointerException("File (desktop.ini) is null");
        }
        if (!OSUtil.isWindowsSystem()) {
            this.logFiner("Not a windows system, ignoring folder icon. " + path.toAbsolutePath());
            return;
        }
        this.logFiner("Setting icon of " + path.getParent().toAbsolutePath());
        PathUtils.setAttributesOnWindows(path, true, true);
    }

    public void removeDesktopShortcut() {
        Object object = this.getName();
        if (this.getController().isVerbose()) {
            object = "[" + this.getMySelf().getNick() + "] " + (String)object;
        }
        Util.removeDesktopShortcut((String)object);
    }

    public String getDownloadScript() {
        return this.downloadScript;
    }

    public void setDownloadScript(String string) {
        if (Util.equals(this.downloadScript, string)) {
            return;
        }
        this.downloadScript = string;
        String string2 = "f." + this.configEntryId + ".dlscript";
        String string3 = string != null ? string : "";
        this.getController().getConfig().put(string2, string3);
        this.logInfo("Download script set to '" + string3 + "'");
        this.getController().saveConfig();
    }

    public SyncProfile getSyncProfile() {
        return this.syncProfile;
    }

    public void setSyncProfile(SyncProfile syncProfile) {
        this.setSyncProfile(syncProfile, true);
    }

    public void setSyncProfile(SyncProfile syncProfile, boolean bl) {
        Reject.ifNull(syncProfile, "Unable to set null sync profile");
        if (this.syncProfile.equals(syncProfile)) {
            return;
        }
        this.logFine("Setting " + syncProfile.getName());
        this.syncProfile = syncProfile;
        if (!this.currentInfo.isMetaFolder()) {
            String string = "f." + this.configEntryId + ".syncprofile";
            this.getController().getConfig().put(string, this.syncProfile.getFieldList());
            if (bl) {
                this.getController().saveConfig();
            }
        }
        if (!this.syncProfile.isAutodownload()) {
            this.getController().getTransferManager().abortAllAutodownloads(this);
        }
        if (this.syncProfile.isAutodownload()) {
            this.getController().getFolderRepository().getFileRequestor().triggerFileRequesting(this.currentInfo);
        }
        if (this.syncProfile.isSyncDeletion()) {
            this.triggerSyncRemoteDeletedFiles(this.members.keySet(), false);
        }
        this.watcher.reconfigure(this.syncProfile);
        this.recommendScanOnNextMaintenance();
        this.fireSyncProfileChanged();
    }

    public void recommendScanOnNextMaintenance() {
        this.recommendScanOnNextMaintenance(false);
    }

    public void recommendScanOnNextMaintenance(boolean bl) {
        if (this.scanAllowedNow() || bl) {
            if (this.isFiner()) {
                this.logFiner("recommendScanOnNextMaintenance");
            }
            this.scanForced = true;
            this.lastScan = null;
        }
    }

    public boolean scanAllowedNow() {
        return !this.syncProfile.isManualSync() && !this.syncProfile.isDailySync() && !this.getController().isPaused() || this.currentInfo.isMetaFolder();
    }

    void maintain() {
        if (this.isFiner()) {
            this.logFiner("Maintaining '" + this.getName() + "' (forced? " + this.scanForced + ")");
        }
        boolean bl = this.scanForced;
        this.scanForced = false;
        if ((bl || this.autoScanRequired()) && this.scanLocalFiles()) {
            this.checkRevertLocalChanges();
        }
        if (this.maintainFolderDBrequired()) {
            long l = System.currentTimeMillis() - 1000L * (long)ConfigurationEntry.MAX_FILEINFO_DELETED_AGE_SECONDS.getValueInt(this.getController()).intValue();
            this.maintainFolderDB(l);
        }
    }

    public boolean isMaintenanceRequired() {
        return this.scanForced || this.autoScanRequired() || this.maintainFolderDBrequired();
    }

    private boolean join0(MemberInfo memberInfo) {
        boolean bl;
        if (memberInfo.isInvalid(this.getController())) {
            return false;
        }
        Member member = memberInfo.getNode(this.getController(), true);
        if (member.isMySelf()) {
            return false;
        }
        Date date = new Date(System.currentTimeMillis() - 1296000000L);
        boolean bl2 = bl = memberInfo.getLastConnectTime() == null || memberInfo.getLastConnectTime().before(date);
        if (bl) {
            this.logFine(member + " was offline too long. Hiding in memberslist: " + member + " last seen online: " + memberInfo.getLastConnectTime());
            return false;
        }
        return this.join(member);
    }

    public boolean join(Member member) {
        if (!member.isServer()) {
            boolean bl = this.hasReadPermission(member);
            boolean bl2 = this.hasReadPermission(this.getMySelf());
            if (!bl || !bl2) {
                if (bl) {
                    if (this.isFine()) {
                        String string = this.getName() + ": Not joining " + member + " / " + member.getAccountInfo() + ". Myself got no read permission";
                        if (this.getController().isStarted() && member.isCompletelyConnected() && this.getController().getOSClient().isConnected() && this.getController().getOSClient().isLoggedIn()) {
                            this.logWarning(string);
                        } else {
                            this.logFine(string);
                        }
                    }
                } else if (this.isFine()) {
                    String string = this.getName() + ": Not joining " + member + " / " + member.getAccountInfo() + " no read permission";
                    if (this.getController().isStarted() && member.isCompletelyConnected() && this.getController().getOSClient().isConnected()) {
                        this.logWarning(string);
                    } else {
                        this.logFine(string);
                    }
                }
                if (member.isCompletelyConnected()) {
                    if (this.isFine()) {
                        this.logFine("Creating empty FileList for " + this.currentInfo + " to send to " + member + " while joining folder. MemberRead " + bl + " mySelfRead " + bl2, new StackDump());
                    }
                    if (!(member.getPeer() instanceof D2DSocketConnectionHandler)) {
                        member.sendMessagesAsynchron(FileList.createEmpty(this.currentInfo, this.supportExternalizable(member)));
                    }
                }
                return false;
            }
        }
        this.join0(member, false);
        return true;
    }

    private boolean join0(Member member, boolean bl) {
        Message[] messageArray;
        boolean bl2;
        Reject.ifNull(member, "Member is null, unable to join");
        boolean bl3 = bl2 = this.members.put(member, member) != null;
        if (!bl2 && this.isInfo() && !bl && !this.currentInfo.isMetaFolder()) {
            Object object = messageArray = member.isConnected() ? Level.INFO : Level.FINE;
            if (this.isLog((Level)messageArray)) {
                this.logIt((Level)messageArray, this + ": Member " + member.getNick() + " joined (connected? " + member.isConnected() + ")", null);
            }
        }
        if (!bl) {
            if (!bl2 && member.isCompletelyConnected() && !(member.getPeer() instanceof D2DSocketConnectionHandler)) {
                this.waitForScan();
                if (this.hasOwnDatabase) {
                    messageArray = FileList.create(this, this.supportExternalizable(member));
                } else {
                    messageArray = new Message[1];
                    if (this.isFine()) {
                        this.logFine("Creating empty FileList for " + this.currentInfo + " to send to " + member + " while joining folder. No folder db.", new StackDump());
                    }
                    messageArray[0] = FileList.createEmpty(this.getInfo(), this.supportExternalizable(member));
                }
                member.sendMessagesAsynchron(messageArray);
            }
            if (!bl2) {
                this.fireMemberJoined(member);
                this.updateMetaFolderMembers();
                this.setDBDirty();
            }
        }
        return !bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMetaFolderMembers() {
        if (this.currentInfo.isMetaFolder()) {
            return;
        }
        if (this.shutdown) {
            this.logFine(this.getName() + ": Already shutdown: Not updateMetaFolderMembers");
            return;
        }
        FolderRepository folderRepository = this.getController().getFolderRepository();
        Folder folder = folderRepository.getMetaFolder(this.currentInfo);
        if (folder == null) {
            this.logFine("Could not yet find metaFolder for " + this.currentInfo);
            return;
        }
        if (folder.deviceDisconnected) {
            this.logFine("Not writing members. Meta folder disconnected.");
            return;
        }
        if (!this.hasWritePermission(this.getMySelf())) {
            this.logFine("Not writing members. No permission.");
            return;
        }
        Object object = folder.scanLock;
        synchronized (object) {
            Path path = folder.localBase.resolve(METAFOLDER_MEMBERS);
            FileInfo fileInfo = FileInfoFactory.lookupInstance(folder, path);
            Map<String, MemberInfo> map = this.readMetaFolderMembers(fileInfo);
            HashMap<String, MemberInfo> hashMap = new HashMap<String, MemberInfo>(map);
            for (MemberInfo object2 : map.values()) {
                boolean bl;
                Member member = object2.getNode(this.getController(), true);
                if (this.members.containsKey(member) || !object2.isOnSameNetwork(this.getController())) continue;
                boolean bl2 = bl = member.isServer() && !this.getController().getOSClient().isClusterServer(member) && !this.getController().getOSClient().isFederatedServer(member);
                if (member.isConnected() && bl) {
                    this.logFine("(U) Not joining connected server " + member.getNick() + " into folder " + this.getName());
                    continue;
                }
                if (!this.join0(object2)) continue;
                this.logInfo("Discovered new " + object2);
            }
            for (Member member : this.members.keySet()) {
                map.put(member.getId(), member.getInfo());
            }
            boolean bl = false;
            if (hashMap.size() == map.size()) {
                for (String string : map.keySet()) {
                    if (hashMap.containsKey(string)) continue;
                    bl = true;
                    break;
                }
            } else {
                bl = true;
            }
            if (bl && !this.checkIfDeviceDisconnected()) {
                this.writewMetaFolderMembers(map, fileInfo);
                folder.scanChangedFile(fileInfo);
            }
        }
    }

    private Map<String, MemberInfo> readMetaFolderMembers(FileInfo fileInfo) {
        if (this.isFine()) {
            this.logFine("Loading metafolder members from " + fileInfo + ".");
        }
        TreeMap<String, MemberInfo> treeMap = new TreeMap<String, MemberInfo>();
        Path path = fileInfo.getDiskFile(this.getController().getFolderRepository());
        if (path == null || Files.notExists(path, new LinkOption[0])) {
            return treeMap;
        }
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));){
            treeMap.putAll((Map)objectInputStream.readObject());
        }
        catch (IOException | ClassNotFoundException exception) {
            this.logFine("Unable to read members file " + fileInfo + ". Ignoring. " + exception);
        }
        catch (RuntimeException runtimeException) {
            this.logWarning("Exception while read members file " + fileInfo + ". Ignoring. " + runtimeException);
        }
        if (this.isFine()) {
            this.logFine("Loaded " + treeMap.size() + " metafolder members.");
        }
        return treeMap;
    }

    private void writewMetaFolderMembers(Map<String, MemberInfo> map, FileInfo fileInfo) {
        Object object;
        Object object2;
        if (this.isFine()) {
            this.logFine("Saving " + map.size() + " metafolder member(s) to " + fileInfo + ".");
        }
        if (this.isFiner()) {
            object2 = map.values().iterator();
            while (object2.hasNext()) {
                object = (MemberInfo)object2.next();
                this.logFiner("Saved " + ((MemberInfo)object).getNick());
            }
        }
        if ((object2 = fileInfo.getDiskFile(this.getController().getFolderRepository())) == null) {
            return;
        }
        try {
            object = new ObjectOutputStream(new BufferedOutputStream(Files.newOutputStream((Path)object2, new OpenOption[0])));
            try {
                ((ObjectOutputStream)object).writeObject(map);
            }
            finally {
                ((ObjectOutputStream)object).close();
            }
        }
        catch (IOException iOException) {
            this.logWarning(this.getName() + ": Unable to write Members meta info to " + fileInfo.getDiskFile(this.getController().getFolderRepository()) + ". " + iOException);
        }
        catch (RuntimeException runtimeException) {
            this.logWarning(this.getName() + ": Unable to write Members meta info to " + fileInfo.getDiskFile(this.getController().getFolderRepository()) + ". " + runtimeException, runtimeException);
        }
    }

    public boolean waitForScan() {
        if (!this.isScanning()) {
            return true;
        }
        if (this.isFine()) {
            this.logFine("Waiting to complete scan of " + this.getName());
        }
        ScanResult.ResultState resultState = this.lastScanResultState;
        while (this.isScanning() && resultState == this.lastScanResultState) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        this.logFine("Scan completed. Continue with connect.");
        return true;
    }

    public void remove(Member member) {
        if (this.members.remove(member) == null) {
            return;
        }
        this.logFine(this + " left by " + member);
        this.dao.deleteDomain(member.getId(), -1);
        this.fireMemberLeft(member);
    }

    public void removeDeletedFileInfo(FileInfo fileInfo) {
        Reject.ifFalse(fileInfo.isDeleted(), "Should only be removing deleted infos.");
        this.dao.delete(null, fileInfo);
        this.setDBDirty();
    }

    public boolean isStarted() {
        return !this.shutdown;
    }

    public boolean isInSync() {
        if (this.isTransferring()) {
            return false;
        }
        return this.statistic.getHarmonizedSyncPercentage() >= 100.0;
    }

    public boolean isTransferring() {
        return this.isDownloading() || this.isUploading();
    }

    public boolean isScanning() {
        return this.getController().getFolderRepository().getFolderScanner().getCurrentScanningFolder() == this;
    }

    public boolean isDownloading() {
        return this.getController().getTransferManager().countNumberOfDownloads(this) > 0;
    }

    public boolean isUploading() {
        return this.getController().getTransferManager().countUploadsOn(this) > 0;
    }

    public void triggerSyncRemoteDeletedFiles(final Collection<Member> collection, final boolean bl) {
        this.getController().getIOProvider().startIO(new Runnable(){

            @Override
            public void run() {
                Folder.this.syncRemoteDeletedFiles(collection, bl);
            }
        });
    }

    public void syncRemoteDeletedFiles(boolean bl) {
        this.syncRemoteDeletedFiles(this.members.keySet(), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncRemoteDeletedFiles(Collection<Member> collection, boolean bl) {
        if (collection.isEmpty()) {
            return;
        }
        if (this.shutdown) {
            this.logFine(this.getName() + ": Already shutdown: Not syncRemoteDeletedFiles (" + collection.size() + "): " + collection);
            return;
        }
        if (this.isFine()) {
            this.logFine("Deleting files, which are deleted by trusted nodes. con-members: " + Arrays.asList(this.getConnectedMembers()));
        }
        final ArrayList<FileInfo> arrayList = new ArrayList<FileInfo>();
        for (Member member : collection) {
            Collection<DirectoryInfo> collection2;
            if (!member.isCompletelyConnected()) continue;
            if (!this.hasWritePermission(member)) {
                if (!this.isFine()) continue;
                this.logFine("Not syncing deletions. " + member + " / " + member.getAccountInfo() + " no write permission");
                continue;
            }
            Collection<FileInfo> collection3 = this.getFilesAsCollection(member);
            if (collection3 != null) {
                if (this.isFiner()) {
                    this.logFiner("RemoteFileDeletion sync. Member '" + member.getNick() + "' has " + collection3.size() + " possible files");
                }
                int n = 0;
                for (FileInfo fileInfo : collection3) {
                    this.handleFileDeletion(fileInfo, bl, member, arrayList, 0);
                    if (++n % 100 == 0 && !member.isCompletelyConnected()) {
                        this.logFine("Device " + member.getNick() + " disconnected while syncing deletions.");
                        break;
                    }
                    if (!this.shutdown) continue;
                    this.logFine(this.getName() + ": Already shutdown: Not syncRemoteDeletedFiles (" + collection.size() + "): " + fileInfo.toDetailString());
                    return;
                }
            }
            if ((collection2 = this.getDirectoriesAsCollection(member)) == null) continue;
            if (this.isFiner()) {
                this.logFiner("RemoteDirDeletion sync. Member '" + member.getNick() + "' has " + collection2.size() + " possible files");
            }
            ArrayList<DirectoryInfo> arrayList2 = new ArrayList<DirectoryInfo>(collection2);
            arrayList2.sort(new ReverseComparator<FileInfo>(FileInfoComparator.getComparator(2)));
            int n = 0;
            Object object = this.scanLock;
            synchronized (object) {
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    FileInfo fileInfo = (FileInfo)iterator.next();
                    this.handleFileDeletion(fileInfo, bl, member, arrayList, 0);
                    if (++n % 100 != 0 || member.isCompletelyConnected()) continue;
                    this.logFine("Device " + member.getNick() + " disconnected while syncing deletions.");
                    break;
                }
            }
        }
        if (!arrayList.isEmpty()) {
            this.fireFilesDeleted(arrayList);
            this.setDBDirty();
            this.broadcastMessages(new MessageProducer(){

                @Override
                public Message[] getMessages(boolean bl) {
                    return FolderFilesChanged.create(Folder.this.currentInfo, arrayList, Folder.this.diskItemFilter, bl);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void handleFileDeletion(FileInfo fileInfo, boolean bl, Member member, List<FileInfo> list, int n) {
        try {
            boolean bl2;
            if (!fileInfo.isDeleted()) {
                return;
            }
            if (this.shutdown) {
                this.logFine(this.getName() + ": Already shutdown: Not handleFileDeletion: " + fileInfo.toDetailString() + " received from " + member);
                return;
            }
            boolean bl3 = bl2 = this.syncProfile.isSyncDeletion() || bl;
            if (!bl2) {
                return;
            }
            FileInfo fileInfo2 = this.getFile(fileInfo);
            if (fileInfo2 != null && !fileInfo.isNewerThan(fileInfo2)) {
                return;
            }
            if (this.diskItemFilter.isExcluded(fileInfo)) {
                return;
            }
            if (fileInfo2 == null) {
                long l = System.currentTimeMillis() - 1000L * (long)ConfigurationEntry.MAX_FILEINFO_DELETED_AGE_SECONDS.getValueInt(this.getController()).intValue();
                if (fileInfo.getModifiedDate().getTime() > l) {
                    if (this.isFine()) {
                        this.logFine("Taking over deletion file info: " + fileInfo.toDetailString());
                    }
                    fileInfo = this.correctFolderInfo(fileInfo);
                    this.store(this.getMySelf(), fileInfo);
                    fileInfo2 = this.getFile(fileInfo);
                    list.add(fileInfo2);
                }
                return;
            }
            if (fileInfo2.isDeleted()) {
                if (fileInfo.isNewerThan(fileInfo2)) {
                    if (this.isFine()) {
                        this.logFine("Taking over new deletion file info: " + fileInfo.toDetailString());
                    }
                    fileInfo = this.correctFolderInfo(fileInfo);
                    this.store(this.getMySelf(), fileInfo);
                    fileInfo2 = this.getFile(fileInfo);
                    list.add(fileInfo2);
                }
                return;
            }
            Path path = fileInfo2.getDiskFile(this.getController().getFolderRepository());
            if (!fileInfo2.inSyncWithDisk(path)) {
                if (this.isFine()) {
                    this.logFine("Not deleting file from member " + member + ", local file not in sync with disk: " + fileInfo2.toDetailString() + " at " + path.toAbsolutePath());
                }
                if (this.isDeviceDisconnected() || this.checkIfDeviceDisconnected()) {
                    return;
                }
                if (this.scanAllowedNow() && (fileInfo2 = this.scanChangedFile(fileInfo2)) != null && n < 10) {
                    if (fileInfo.getFolderInfo().isMetaFolder() && fileInfo2.inSyncWithDisk(path)) {
                        MetaFolderDataHandler metaFolderDataHandler = new MetaFolderDataHandler(this.getController());
                        metaFolderDataHandler.handleMetaFolderFileInfo(fileInfo);
                    }
                    this.handleFileDeletion(fileInfo, bl, member, list, ++n);
                }
                return;
            }
            if (fileInfo.isFile()) {
                this.getController().getTransferManager().breakTransfers(fileInfo);
            }
            if (Files.exists(path, new LinkOption[0])) {
                Object object = this.scanLock;
                synchronized (object) {
                    if (fileInfo2.isDiretory()) {
                        if (this.isFine()) {
                            this.logFine("Deleting directory from remote: " + fileInfo2.toDetailString());
                        }
                        this.logFileOperation("DELETED", fileInfo2, fileInfo);
                        this.watcher.addIgnoreFile(fileInfo2);
                        try {
                            Files.delete(path);
                        }
                        catch (IOException iOException) {
                            Object object2;
                            Object object3;
                            FileInfoCriteria fileInfoCriteria = new FileInfoCriteria();
                            fileInfoCriteria.addMySelf(this);
                            fileInfoCriteria.setPath((DirectoryInfo)fileInfo2);
                            Collection<FileInfo> collection = this.getDAO().findFiles(fileInfoCriteria);
                            for (FileInfo object4 : collection) {
                                if (object4.isDeleted()) continue;
                                object3 = fileInfo.getModifiedByAccount();
                                if (object3 == null) {
                                    object3 = member.getAccountInfo();
                                }
                                this.removeFileLocal(object4, (AccountInfo)object3);
                                if (!this.isInfo()) continue;
                                this.logInfo("Deleted file in deleted directory: " + object4.toDetailString() + ". Directory: " + object4.toDetailString() + ". Message: " + iOException);
                            }
                            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
                                Iterator iterator = directoryStream.iterator();
                                while (iterator.hasNext()) {
                                    object3 = (Path)iterator.next();
                                    object2 = object3.toString().toLowerCase();
                                    if (!((String)object2).endsWith("thumbs.db") && !((String)object2).endsWith(".ds_store") && !((String)object2).endsWith("desktop.ini") && !((String)object2).startsWith("~$") && !((String)object2).startsWith(".~lock.")) continue;
                                    Files.delete((Path)object3);
                                }
                            }
                            catch (IOException iOException2) {
                                this.logFine("Unable to delete files in deleted directory " + path + ": " + iOException2.getMessage());
                                this.watcher.removeIgnoreFile(fileInfo2);
                                return;
                            }
                            try {
                                Files.delete(path);
                            }
                            catch (IOException iOException3) {
                                if (this.isWarning()) {
                                    void var14_25;
                                    boolean bl4 = false;
                                    object3 = new StringBuilder();
                                    ((StringBuilder)object3).append("[");
                                    try {
                                        object2 = Files.newDirectoryStream(path);
                                        try {
                                            Iterator iterator = object2.iterator();
                                            while (iterator.hasNext()) {
                                                Path path2 = (Path)iterator.next();
                                                ((StringBuilder)object3).append(path2.toString());
                                                ((StringBuilder)object3).append(", ");
                                                ++var14_25;
                                            }
                                        }
                                        finally {
                                            if (object2 != null) {
                                                object2.close();
                                            }
                                        }
                                    }
                                    catch (IOException iOException2) {
                                        this.logInfo(iOException2.getMessage());
                                    }
                                    ((StringBuilder)object3).append("]");
                                    object2 = var14_25 > 0 ? ((StringBuilder)object3).toString() : "(unable to access)";
                                    this.logFine("Unable to delete directory locally: " + path + ". Info: " + fileInfo2.toDetailString() + ". contents: " + (String)object2);
                                }
                                this.watcher.removeIgnoreFile(fileInfo2);
                                return;
                            }
                        }
                        finally {
                            this.watcher.removeIgnoreFile(fileInfo2);
                        }
                    } else if (fileInfo2.isFile()) {
                        if (!this.deleteFile(fileInfo2, path, fileInfo)) {
                            this.logWarning("Unable to delete local file " + path.toAbsolutePath() + ". " + fileInfo2.toDetailString());
                            if (n < 10) {
                                this.handleFileDeletion(fileInfo, bl, member, list, ++n);
                            }
                            return;
                        }
                        if (fileInfo.getFolderInfo().isMetaFolder()) {
                            MetaFolderDataHandler metaFolderDataHandler = new MetaFolderDataHandler(this.getController());
                            metaFolderDataHandler.handleMetaFolderFileInfo(fileInfo);
                        }
                    } else {
                        this.logSevere("Unable to apply remote deletion: " + fileInfo2.toDetailString());
                    }
                }
            }
            list.add(fileInfo);
            this.store(this.getMySelf(), fileInfo);
            this.logFileOperation("DELETED", fileInfo2, fileInfo);
        }
        catch (IllegalStateException illegalStateException) {
            this.logWarning(fileInfo.toDetailString() + ": Unable to locally delete deleted file. " + illegalStateException);
        }
        catch (RuntimeException runtimeException) {
            this.logWarning(fileInfo.toDetailString() + ": Unable to locally delete deleted file. " + runtimeException, runtimeException);
        }
    }

    void logFileOperation(String string, FileInfo fileInfo, FileInfo fileInfo2) {
        Object object = "Item\t";
        object = (String)object + string;
        object = (String)object + "\t";
        if (fileInfo2 != null) {
            object = (String)object + "now:\t";
            object = (String)object + fileInfo2.toDetailString();
            object = (String)object + "\t";
        }
        if (fileInfo != null) {
            object = (String)object + "was:\t";
            object = (String)object + fileInfo.toDetailString();
        }
        if (this.currentInfo.isMetaFolder()) {
            this.logFine((String)object);
        } else {
            this.logInfo((String)object);
        }
    }

    public void broadcastMessages(Message ... messageArray) {
        for (Member member : this.getMembersAsCollection()) {
            if (this.shutdown) {
                this.logFine(this.getName() + ": Already shutdown: Not broadcastMessages: " + messageArray);
                return;
            }
            if (!member.isCompletelyConnected()) continue;
            member.sendMessagesAsynchron(messageArray);
        }
    }

    public void broadcastMessages(MessageProducer messageProducer) {
        Message[] messageArray = null;
        Message[] messageArray2 = null;
        for (Member member : this.getMembersAsCollection()) {
            if (this.shutdown) {
                this.logFine(this.getName() + ": Already shutdown: Not broadcastMessages: " + messageProducer);
                return;
            }
            if (!member.isCompletelyConnected()) continue;
            if (this.supportExternalizable(member)) {
                if (messageArray2 == null) {
                    messageArray2 = messageProducer.getMessages(true);
                }
                if (messageArray2 == null || messageArray2.length <= 0) continue;
                member.sendMessagesAsynchron(messageArray2);
                continue;
            }
            if (messageArray == null) {
                messageArray = messageProducer.getMessages(false);
            }
            if (messageArray == null || messageArray.length <= 0) continue;
            member.sendMessagesAsynchron(messageArray);
        }
    }

    public void handleMetaFolderSyncPatterns(FileInfo fileInfo) {
        if (!this.syncPatterns) {
            this.logFine("Not syncing patterns: " + this.getName());
            return;
        }
        Folder folder = this.getController().getFolderRepository().getMetaFolder(this.currentInfo);
        if (folder == null) {
            this.logWarning("Could not find metaFolder for " + this.currentInfo);
            return;
        }
        Path path = folder.getDiskFile(fileInfo);
        this.logFine("Reading syncPatterns " + path);
        this.diskItemFilter.loadPatternsFrom(path, true);
        this.getController().getTransferManager().checkActiveTranfersForExcludes();
        this.getController().getFolderRepository().getFileRequestor().triggerFileRequesting(this.currentInfo);
    }

    public DirectoryInfo getBaseDirectoryInfo() {
        return FileInfoFactory.createBaseDirectoryInfo(this.currentInfo);
    }

    public void broadcastScanCommand() {
        if (this.isFiner()) {
            this.logFiner("Broadcasting remote scan command");
        }
        ScanCommand scanCommand = new ScanCommand(this.currentInfo);
        this.broadcastMessages(scanCommand);
    }

    public void broadcastFileRequestCommand() {
        if (this.isFiner()) {
            this.logFiner("Broadcasting remote file request command");
        }
        FileRequestCommand fileRequestCommand = new FileRequestCommand(this.currentInfo);
        this.broadcastMessages(fileRequestCommand);
    }

    private void broadcastFolderChanges(final ScanResult scanResult) {
        if (this.getCompletelyConnectedMembersCount() == 0) {
            return;
        }
        if (!scanResult.getNewFiles().isEmpty()) {
            this.broadcastMessages(new MessageProducer(){

                @Override
                public Message[] getMessages(boolean bl) {
                    return FolderFilesChanged.create(Folder.this.currentInfo, scanResult.getNewFiles(), Folder.this.diskItemFilter, bl);
                }
            });
        }
        if (!scanResult.getChangedFiles().isEmpty()) {
            this.broadcastMessages(new MessageProducer(){

                @Override
                public Message[] getMessages(boolean bl) {
                    return FolderFilesChanged.create(Folder.this.currentInfo, scanResult.getChangedFiles(), Folder.this.diskItemFilter, bl);
                }
            });
        }
        if (!scanResult.getDeletedFiles().isEmpty()) {
            this.broadcastMessages(new MessageProducer(){

                @Override
                public Message[] getMessages(boolean bl) {
                    return FolderFilesChanged.create(Folder.this.currentInfo, scanResult.getDeletedFiles(), Folder.this.diskItemFilter, bl);
                }
            });
        }
        if (!scanResult.getRestoredFiles().isEmpty()) {
            this.broadcastMessages(new MessageProducer(){

                @Override
                public Message[] getMessages(boolean bl) {
                    return FolderFilesChanged.create(Folder.this.currentInfo, scanResult.getRestoredFiles(), Folder.this.diskItemFilter, bl);
                }
            });
        }
        if (this.isFine()) {
            this.logFine("Broadcasted folder changes for: " + scanResult);
        }
    }

    public void fileListChanged(Member member, FileList fileList) {
        int n;
        Reject.ifTrue(member.isMySelf(), "Not allowed to process FileList for myself");
        if (this.shutdown) {
            this.logFine(this.getName() + ": Already shutdown: Not fileListChanged: " + fileList + " received from " + member);
            return;
        }
        if (fileList.files != null) {
            for (n = 0; n < fileList.files.length; ++n) {
                FileInfo fileInfo = fileList.files[n];
                fileList.files[n] = FileInfoFactory.changedFolderInfo(fileInfo, this.currentInfo);
            }
        }
        if (fileList.isNull()) {
            if (this.dao.hasDomainWithFiles(member.getId()) && !this.hasWritePermission(this.getController().getMySelf())) {
                this.logWarning("Received empty FileList for " + this + " from " + member + " but there is information about files already. Not deleting previous information!");
                return;
            }
            this.dao.deleteDomain(member.getId(), -1);
            return;
        }
        n = fileList.nFollowingDeltas * fileList.files.length;
        this.store(member, n, fileList.files);
        this.findSameFiles(member, Arrays.asList(fileList.files));
        if (this.syncProfile.isAutodownload() && member.isCompletelyConnected()) {
            if (this.isFiner()) {
                this.logFiner("Triggering file requestor because of new remote file list from " + member);
            }
            this.getController().getFolderRepository().getFileRequestor().triggerFileRequesting(fileList.folder);
        }
        if (this.syncProfile.isSyncDeletion() && member.isCompletelyConnected()) {
            this.syncRemoteDeletedFiles(Collections.singleton(member), false);
        }
        if (!this.getMySelf().isServer() && this.syncProfile.isManualSync()) {
            for (int i = 0; i < fileList.files.length; ++i) {
                FileInfo fileInfo = fileList.files[i];
                FileInfo fileInfo2 = this.getFile(fileInfo);
                Path path = this.getDiskFile(fileInfo);
                if (fileInfo2 != null && (fileInfo.isVersionDateAndSizeIdentical(fileInfo2) || fileInfo2.isNewerThan(fileInfo)) || !fileInfo.inSyncWithDisk(path)) continue;
                this.logInfo("Sync match by metadata: " + fileInfo.toDetailString() + " @ " + path);
                this.store(this.getMySelf(), fileInfo);
            }
        }
        this.writeFilelist(member);
        this.fireRemoteContentsChanged(member, fileList);
    }

    public void fileListChanged(Member member, FolderFilesChanged folderFilesChanged) {
        FileInfo fileInfo;
        FileInfo fileInfo2;
        FileInfo fileInfo3;
        int n;
        Reject.ifTrue(member.isMySelf(), "Not allowed to process FolderFilesChanged for myself");
        if (this.shutdown) {
            this.logFine(this.getName() + ": Already shutdown: Not fileListChanged: " + folderFilesChanged + " received from " + member);
            return;
        }
        if (folderFilesChanged.getFiles() != null) {
            for (n = 0; n < folderFilesChanged.getFiles().length; ++n) {
                fileInfo3 = folderFilesChanged.getFiles()[n];
                folderFilesChanged.getFiles()[n] = FileInfoFactory.changedFolderInfo(fileInfo3, this.currentInfo);
            }
        }
        if (folderFilesChanged.getRemoved() != null) {
            for (n = 0; n < folderFilesChanged.getRemoved().length; ++n) {
                fileInfo3 = folderFilesChanged.getRemoved()[n];
                folderFilesChanged.getRemoved()[n] = FileInfoFactory.changedFolderInfo(fileInfo3, this.currentInfo);
            }
        }
        if (folderFilesChanged.getFiles() != null) {
            this.store(member, folderFilesChanged.getFiles());
            this.findSameFiles(member, Arrays.asList(folderFilesChanged.getFiles()));
        }
        if (folderFilesChanged.getRemoved() != null) {
            this.store(member, folderFilesChanged.getRemoved());
            this.findSameFiles(member, Arrays.asList(folderFilesChanged.getRemoved()));
        }
        int n2 = n = folderFilesChanged.getFiles() != null && folderFilesChanged.getFiles().length == 1 && !folderFilesChanged.getFiles()[0].isDeleted() ? 1 : 0;
        if (this.syncProfile.isAutodownload()) {
            boolean bl = member.isCompletelyConnected();
            if (bl && n != 0) {
                fileInfo2 = this.getFile(folderFilesChanged.getFiles()[0]);
                fileInfo = folderFilesChanged.getFiles()[0];
                if (fileInfo2 != null && !fileInfo.isNewerThan(fileInfo2) && !fileInfo.isDeleted()) {
                    bl = false;
                }
            }
            if (bl) {
                if (this.isFiner()) {
                    this.logFiner("Triggering file requestor because of remote file list change " + folderFilesChanged + " from " + member);
                }
                this.getController().getFolderRepository().getFileRequestor().triggerFileRequesting(folderFilesChanged.folder);
            } else if (this.isFiner()) {
                this.logFiner("Not triggering filerequestor, no new files in remote filelist" + folderFilesChanged + " from " + member);
            }
        }
        if (n == 0 && this.syncProfile.isSyncDeletion() && member.isCompletelyConnected()) {
            this.syncRemoteDeletedFiles(Collections.singleton(member), false);
        }
        if (!this.getMySelf().isServer() && this.syncProfile.isManualSync()) {
            for (int i = 0; i < folderFilesChanged.getFiles().length; ++i) {
                fileInfo2 = folderFilesChanged.getFiles()[i];
                fileInfo = this.getFile(fileInfo2);
                Path path = this.getDiskFile(fileInfo2);
                if (fileInfo != null && (fileInfo2.isVersionDateAndSizeIdentical(fileInfo) || fileInfo.isNewerThan(fileInfo2)) || !fileInfo2.inSyncWithDisk(path)) continue;
                this.logInfo("Sync match by metadata: " + fileInfo2.toDetailString() + " @ " + path);
                this.store(this.getMySelf(), fileInfo2);
            }
        }
        this.fireRemoteContentsChanged(member, folderFilesChanged);
    }

    private void store(Member member, FileInfo ... fileInfoArray) {
        this.store(member, -1, fileInfoArray);
    }

    private void store(Member member, int n, FileInfo ... fileInfoArray) {
        this.store(member, n, Arrays.asList(fileInfoArray));
    }

    private void store(Member member, Collection<FileInfo> collection) {
        this.store(member, -1, collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(Member member, int n, Collection<FileInfo> collection) {
        Object object = this.dbAccessLock;
        synchronized (object) {
            String string;
            String string2 = string = member.isMySelf() ? null : member.getId();
            if (n > 0) {
                this.dao.deleteDomain(string, n);
            }
            this.dao.store(string, collection);
        }
    }

    private boolean findSameFiles(Member member, Collection<FileInfo> collection) {
        Reject.ifNull(collection, "Remote file info list is null");
        if (this.isFiner()) {
            this.logFiner("Triing to find same files in remote list with " + collection.size() + " files from " + member);
        }
        Boolean bl = null;
        LinkedList<FileInfo> linkedList = new LinkedList<FileInfo>();
        for (FileInfo fileInfo : collection) {
            FileInfo fileInfo2 = this.getFile(fileInfo);
            if (fileInfo2 == null || fileInfo2.isDeleted() != fileInfo.isDeleted()) continue;
            boolean bl2 = fileInfo2.getSize() == fileInfo.getSize();
            boolean bl3 = DateUtil.equalsFileDateCrossPlattform(fileInfo2.getModifiedDate(), fileInfo.getModifiedDate());
            boolean bl4 = fileInfo2.getRelativeName().equals(fileInfo.getRelativeName());
            if (fileInfo2.getVersion() < fileInfo.getVersion() && fileInfo.getVersion() > 0) {
                if (!bl2 || !bl3) continue;
                if (bl == null) {
                    bl = this.hasWritePermission(member);
                }
                if (!bl.booleanValue()) {
                    if (this.isFine()) {
                        this.logFine("Not searching same files. " + member + " / " + member.getAccountInfo() + " no write permission");
                    }
                    return false;
                }
                if (this.isFine()) {
                    this.logFine("Found identical file remotely: local " + fileInfo2.toDetailString() + " remote: " + fileInfo.toDetailString() + ". Taking over modification infos");
                }
                linkedList.add(fileInfo);
                continue;
            }
            if (bl4 || !bl3 || !bl2 || fileInfo.getVersion() < fileInfo2.getVersion() || fileInfo2.getRelativeName().compareTo(fileInfo.getRelativeName()) > 0) continue;
            if (bl == null) {
                bl = this.hasWritePermission(member);
            }
            if (!bl.booleanValue()) {
                if (this.isInfo()) {
                    this.logInfo("Not searching same files. " + member + " / " + member.getAccountInfo() + " no write permission");
                }
                return false;
            }
            if (this.isFine()) {
                this.logFine("Found identical file remotely with different name-case: local " + fileInfo2.toDetailString() + " remote: " + fileInfo.toDetailString() + ". Taking over all infos");
            }
            fileInfo = this.correctFolderInfo(fileInfo);
            linkedList.add(fileInfo);
        }
        if (!linkedList.isEmpty()) {
            this.store(this.getMySelf(), linkedList);
            this.filesChanged(linkedList);
            return true;
        }
        return false;
    }

    private void findSameFilesOnRemote() {
        for (Member member : this.getConnectedMembers()) {
            Collection<FileInfo> collection = this.getFilesAsCollection(member);
            if (collection == null) continue;
            this.findSameFiles(member, collection);
        }
    }

    private FileInfo findSameFile(FileInfo fileInfo) {
        for (Member member : this.getConnectedMembers()) {
            FileInfo fileInfo2 = member.getFile(fileInfo);
            if (fileInfo2 == null || !this.findSameFiles(member, Collections.singleton(fileInfo2))) continue;
            return fileInfo.getLocalFileInfo(this.getController().getFolderRepository());
        }
        return null;
    }

    public boolean supportExternalizable(Member member) {
        return member.getProtocolVersion() >= 110;
    }

    private void setDBDirty() {
        this.dirty = true;
    }

    private void triggerPersist() {
        this.getController().schedule(this.persister, 1000L);
    }

    private void persist() {
        int n;
        if (this.checkIfDeviceDisconnected()) {
            if (!this.currentInfo.isMetaFolder()) {
                this.logWarning("Unable to persist database. Storage/Device disconnected: " + this.localBase);
            }
            return;
        }
        this.logFiner("Persisting settings");
        if ((this.hasOwnDatabase || this.getKnownItemCount() > 0) && Files.notExists(this.getSystemSubDir0(), new LinkOption[0])) {
            this.logWarning("Not storing folder database. Local system directory does not exists: " + this.getLocalBase());
            return;
        }
        boolean bl = this.storeFolderDB();
        for (n = 1; !bl && n < 10; ++n) {
            try {
                Thread.sleep(144L * (long)n);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            bl = this.storeFolderDB();
        }
        if (n > 1) {
            if (bl) {
                this.logFine("Was able to write folder database, but only after " + n + " trys.");
            } else {
                this.logWarning("Was NOT able to write folder database, even after " + n + " trys.");
            }
        }
        if (LoggingManager.isLogToFile() && Feature.DEBUG_WRITE_FILELIST_CSV.isEnabled()) {
            for (Member member : this.members.keySet()) {
                this.writeFilelist(member);
            }
        }
        this.dirty = false;
    }

    private void writeFilelist(Member member) {
        if (!LoggingManager.isLogToFile() || Feature.DEBUG_WRITE_FILELIST_CSV.isDisabled()) {
            return;
        }
        Debug.writeFileListCSV(this.getName(), member.getNick(), this.dao.findAllFiles(member.getId()), "FileList of folder " + this.getName() + ", member " + member + ":");
    }

    public Path getLocalBase() {
        return this.localBase;
    }

    public Path getPhysicalDir() {
        if (EncryptedFileSystemUtils.isCryptoInstance(this.localBase)) {
            return EncryptedFileSystemUtils.getPhysicalStorageLocation(this.localBase);
        }
        return this.localBase;
    }

    public Path getCommitDir() {
        return this.commitDir;
    }

    public Path getCommitOrLocalDir() {
        if (this.commitDir != null) {
            return this.commitDir;
        }
        return this.localBase;
    }

    public void setCommitDir(Path path) {
        this.commitDir = path;
        String string = "f." + this.configEntryId + ".commit-dir";
        String string2 = path != null ? path.toAbsolutePath().toString() : "";
        this.getController().getConfig().put(string, string2);
        this.logInfo("Commit dir set to '" + string2 + "'");
        this.getController().saveConfig();
    }

    public Path getSystemSubDir() {
        Path path = this.getSystemSubDir0();
        if (Files.notExists(path, new LinkOption[0])) {
            if (!this.checkIfDeviceDisconnected()) {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                    PathUtils.setAttributesOnWindows(path, true, true);
                }
                catch (IOException iOException) {
                    this.logWarning(iOException.getMessage());
                }
            } else if (!this.deviceDisconnected) {
                this.logSevere("Failed to create system subdir: " + path);
            } else if (this.isFine()) {
                this.logFine("Failed to create system subdir: " + path);
            }
        }
        return path;
    }

    private Path getSystemSubDir0() {
        if (this.localBase.toString().contains(".webdav")) {
            return Controller.getMiscFilesLocation().resolve("foldermeta").resolve(PathUtils.removeInvalidFilenameChars(this.getId())).resolve(Constants.POWERFOLDER_SYSTEM_SUBDIR);
        }
        return this.localBase.resolve(Constants.POWERFOLDER_SYSTEM_SUBDIR);
    }

    public boolean isSystemSubDir(Path path) {
        return Files.isDirectory(path, new LinkOption[0]) && this.getSystemSubDir0().equals(path);
    }

    public boolean isDeviceDisconnected() {
        return this.deviceDisconnected;
    }

    public boolean checkIfDeviceDisconnected() {
        try {
            this.checkBaseDir(true);
        }
        catch (FolderException folderException) {
            if (this.isFine()) {
                if (this.currentInfo.isMetaFolder()) {
                    this.logFiner("invalid local base: " + this.getLocalBase() + " " + folderException);
                } else {
                    this.logFine("invalid local base: " + this.getLocalBase() + " " + folderException);
                }
            }
            return this.setDeviceDisconnected(true);
        }
        if (this.getKnownItemCount() > 0 && (OSUtil.isMacOS() || OSUtil.isLinux()) && !PathUtils.isWebDAVFolder(this.localBase)) {
            boolean bl;
            boolean bl2 = bl = Files.notExists(this.localBase, new LinkOption[0]) || PathUtils.getNumberOfSiblings(this.localBase) == 0;
            if (bl) {
                this.logWarning("Local base empty on linux file system, but has known files. " + this.localBase);
                return this.setDeviceDisconnected(true);
            }
        }
        return this.setDeviceDisconnected(false);
    }

    private boolean setDeviceDisconnected(boolean bl) {
        boolean bl2 = this.deviceDisconnected;
        this.deviceDisconnected = bl;
        boolean bl3 = bl;
        Object object = this.problems.iterator();
        while (object.hasNext()) {
            Problem problem = object.next();
            if (!(problem instanceof DeviceDisconnectedProblem)) continue;
            if (this.deviceDisconnected) {
                bl3 = false;
                continue;
            }
            this.logFine("Device reconnected");
            this.removeProblem(problem);
        }
        if (bl3) {
            if (this.currentInfo.isMetaFolder()) {
                this.logFine(this.toString() + " disconnected storage/device " + this.getLocalBase() + ". Reconnecting...");
            } else {
                this.logWarning(this.toString() + " disconnected storage/device " + this.getLocalBase() + ". Reconnecting...");
            }
            if (!this.getController().getFolderRepository().handleDeviceDisconnected(this)) {
                this.addProblem(new DeviceDisconnectedProblem(this.currentInfo));
            }
        }
        if (bl2 && !this.deviceDisconnected) {
            if (!this.currentInfo.isMetaFolder()) {
                this.logInfo(this.toString() + " storage/device reconnected " + this.localBase);
            }
            this.loadMetadata();
            if (Files.notExists(this.getSystemSubDir(), new LinkOption[0])) {
                try {
                    Files.createDirectories(this.getSystemSubDir(), new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    this.logInfo(iOException.getMessage());
                }
            }
            this.watcher.reconfigure(this.syncProfile);
            this.getController().getFolderRepository().getFileRequestor().triggerFileRequesting(this.currentInfo);
            if (!this.currentInfo.isMetaFolder() && (object = this.getController().getFolderRepository().getMetaFolder(this.currentInfo)) != null) {
                ((Folder)object).checkIfDeviceDisconnected();
            }
        }
        return this.deviceDisconnected;
    }

    public String getName() {
        return this.currentInfo.getName();
    }

    public String getLocalizedName() {
        return this.currentInfo.getLocalizedName();
    }

    public String getConfigEntryId() {
        return this.configEntryId;
    }

    public int getKnownItemCount() {
        return this.dao.count(null, true, false);
    }

    public Collection<FileInfo> getKnownFiles() {
        return this.dao.findAllFiles(null);
    }

    public Collection<DirectoryInfo> getKnownDirectories() {
        return this.dao.findAllDirectories(null);
    }

    private boolean deleteFileRecursive(FileInfo fileInfo, Path path2) throws IOException {
        if (fileInfo.isDiretory() || Files.isDirectory(path2, new LinkOption[0])) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path2, path -> Files.isDirectory(path, new LinkOption[0]));){
                Iterator<Path> iterator = directoryStream.iterator();
                if (iterator.hasNext()) {
                    Path path3 = iterator.next();
                    FileInfo fileInfo2 = FileInfoFactory.lookupInstance(this, path3);
                    FileInfo fileInfo3 = this.getFile(fileInfo2);
                    if (fileInfo3 == null) {
                        fileInfo3 = fileInfo2;
                    }
                    boolean bl = this.deleteFileRecursive(fileInfo3, path3);
                    return bl;
                }
            }
            directoryStream = Files.newDirectoryStream(path2, path -> Files.isRegularFile(path, new LinkOption[0]));
            try {
                for (Path path4 : directoryStream) {
                    FileInfo fileInfo4 = FileInfoFactory.lookupInstance(this, path4);
                    FileInfo fileInfo5 = this.getFile(fileInfo4);
                    if (fileInfo5 == null) {
                        if (this.isFine()) {
                            this.logFine(this + ": Deleting unknown file: " + fileInfo4);
                        }
                        fileInfo5 = FileInfoFactory.newFile(this, path4, null, this.getMySelf().getInfo(), this.getController().getMySelf().getAccountInfo(), null, Files.isDirectory(path4, new LinkOption[0]), null);
                        this.getDAO().store(null, fileInfo5);
                    } else if (this.isFine()) {
                        this.logFine(this + ": Known file found: " + fileInfo4);
                    }
                    this.logFileOperation("DELETED", fileInfo5, fileInfo5);
                    this.deleteFile(fileInfo5, path4);
                }
            }
            finally {
                if (directoryStream != null) {
                    directoryStream.close();
                }
            }
        }
        this.logFileOperation("DELETED", fileInfo, fileInfo);
        return this.deleteFile(fileInfo, path2);
    }

    private boolean deleteFile(FileInfo fileInfo, Path path) {
        return this.deleteFile(fileInfo, path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean deleteFile(FileInfo fileInfo, Path path, FileInfo fileInfo2) {
        Reject.ifNull(fileInfo, "FileInfo is null");
        if (this.shutdown) {
            this.logFine(this.getName() + ": Already shutdown: Not deleteFile: " + fileInfo.toDetailString() + " at " + path);
            return false;
        }
        FileInfo fileInfo3 = this.getFile(fileInfo);
        boolean bl = false;
        try {
            block20: {
                this.watcher.addIgnoreFile(fileInfo);
                Object object = this.scanLock;
                synchronized (object) {
                    if (fileInfo3 != null && fileInfo3.isFile() && Files.exists(path, new LinkOption[0])) {
                        if (this.currentInfo.isMetaFolder() && fileInfo3.getRelativeName().startsWith(METAFOLDER_LOCKS_DIR)) {
                            MetaFolderDataHandler metaFolderDataHandler = new MetaFolderDataHandler(this.getController());
                            metaFolderDataHandler.handleRemoteLockOverwrite(fileInfo2, path);
                        }
                        try {
                            this.archiver.archive(fileInfo3, path, false);
                        }
                        catch (IOException iOException) {
                            this.logWarning("Unable to move file to archive: " + path + ". " + iOException, iOException);
                        }
                    }
                    try {
                        Files.deleteIfExists(path);
                        bl = true;
                    }
                    catch (IOException iOException) {
                        if (iOException instanceof DirectoryNotEmptyException) {
                            this.logFine(this + ": Directory not empty while deleting dir " + path + ". " + iOException);
                        } else if (this.isFine()) {
                            this.logFine("IOException while deleting file " + path + ". " + iOException);
                        }
                        if (this.checkIfDeviceDisconnected()) {
                            this.logWarning("Storage disconnected: Unable to delete file " + path + ". " + iOException);
                            boolean bl2 = false;
                            // MONITOREXIT @DISABLED, blocks:[0, 7, 9, 13] lbl34 : MonitorExitStatement: MONITOREXIT : var6_6
                            this.watcher.removeIgnoreFile(fileInfo);
                            if (!bl) return bl2;
                            if (!ConfigurationEntry.EVENT_API_URL_DELETED_FILE.hasNonBlankValue(this.getController())) return bl2;
                            new DeletedFile(this.getController()).of(fileInfo).happened(true);
                            return bl2;
                        }
                        if (!Files.exists(path, new LinkOption[0])) break block20;
                        this.logFine("Unable to delete file " + path + ". " + iOException);
                        boolean bl3 = false;
                        // MONITOREXIT @DISABLED, blocks:[0, 7, 9] lbl43 : MonitorExitStatement: MONITOREXIT : var6_6
                        this.watcher.removeIgnoreFile(fileInfo);
                        if (!bl) return bl3;
                        if (!ConfigurationEntry.EVENT_API_URL_DELETED_FILE.hasNonBlankValue(this.getController())) return bl3;
                        new DeletedFile(this.getController()).of(fileInfo).happened(true);
                        return bl3;
                    }
                }
            }
            boolean bl4 = true;
            return bl4;
        }
        finally {
            this.watcher.removeIgnoreFile(fileInfo);
            if (bl && ConfigurationEntry.EVENT_API_URL_DELETED_FILE.hasNonBlankValue(this.getController())) {
                new DeletedFile(this.getController()).of(fileInfo).happened(true);
            }
        }
    }

    public Collection<FileInfo> getIncomingFiles() {
        return this.getIncomingFiles(true, -1);
    }

    public Collection<FileInfo> getIncomingFiles(boolean bl) {
        return this.getIncomingFiles(bl, -1);
    }

    public Collection<FileInfo> getIncomingFiles(boolean bl, int n) {
        TreeMap<FileInfo, Object> treeMap = new TreeMap<FileInfo, Object>(new FileInfoComparator(2));
        HashMap<Member, Integer> hashMap = n > 0 ? new HashMap<Member, Integer>(this.getMembersCount()) : null;
        boolean bl2 = this.isRevertLocalChanges();
        for (Member member : this.getMembersAsCollection()) {
            boolean bl3;
            boolean bl4;
            FileInfo fileInfo;
            FileInfo fileInfo2;
            Object object;
            Object object2;
            if (!member.isCompletelyConnected()) continue;
            if (!member.hasCompleteFileListFor(this.currentInfo)) {
                if (!this.isFine()) continue;
                this.logFine("Skipping " + member + " no complete filelist from him");
                continue;
            }
            if (!this.hasWritePermission(member)) {
                if (!this.isFine()) continue;
                this.logFine("Not downloading files. " + member + " / " + member.getAccountInfo() + " no write permission");
                continue;
            }
            Collection<FileInfo> collection = this.getFilesAsCollection(member);
            if (hashMap != null) {
                hashMap.put(member, 0);
            }
            if (collection != null) {
                object2 = collection.iterator();
                while (object2.hasNext()) {
                    object = (FileInfo)object2.next();
                    if (hashMap != null && (Integer)hashMap.get(member) > n || ((FileInfo)object).isDeleted() && !bl) continue;
                    fileInfo2 = this.getFile((FileInfo)object);
                    if (bl2 && fileInfo2 != null && fileInfo2.isNewerThan(fileInfo = ((FileInfo)object).getNewestVersion(this))) {
                        if (!fileInfo.getFolderInfo().isMetaFolder()) {
                            this.logWarning("Local change detected, but has no write permission: " + fileInfo2.toDetailString());
                        }
                        fileInfo2 = null;
                    }
                    fileInfo = (FileInfo)treeMap.get(object);
                    boolean bl5 = fileInfo2 == null;
                    bl4 = fileInfo2 != null && ((FileInfo)object).isNewerThan(fileInfo2);
                    boolean bl6 = bl3 = fileInfo == null || ((FileInfo)object).isNewerThan(fileInfo);
                    if (bl5 && ((FileInfo)object).isDeleted() || !bl5 && (!bl4 || !bl3) || this.diskItemFilter.isExcluded((DiskItem)object)) continue;
                    treeMap.put((FileInfo)object, object);
                    if (hashMap == null) continue;
                    Integer n2 = (Integer)hashMap.get(member);
                    n2 = n2 + 1;
                    hashMap.put(member, n2);
                }
            }
            if ((object2 = this.dao.findAllDirectories(member.getId())) == null) continue;
            object = object2.iterator();
            while (object.hasNext()) {
                boolean bl7;
                fileInfo2 = (DirectoryInfo)object.next();
                if (fileInfo2.isDeleted() && !bl) continue;
                fileInfo = this.getFile(fileInfo2);
                FileInfo fileInfo3 = (FileInfo)treeMap.get(fileInfo2);
                bl4 = fileInfo == null;
                bl3 = fileInfo != null && ((DirectoryInfo)fileInfo2).isNewerThan(fileInfo);
                boolean bl8 = bl7 = fileInfo3 == null || ((DirectoryInfo)fileInfo2).isNewerThan(fileInfo3);
                if (bl4 && fileInfo2.isDeleted() || !bl4 && (!bl3 || !bl7) || this.diskItemFilter.isExcluded(fileInfo2)) continue;
                treeMap.put(fileInfo2, fileInfo2);
            }
        }
        if (treeMap.isEmpty()) {
            this.logFiner("No Incoming files");
        } else if (this.isFine()) {
            this.logFine(this.getName() + ":" + (hashMap != null ? "" : "Aprox. ") + treeMap.size() + " incoming files");
        }
        return Collections.unmodifiableCollection(treeMap.keySet());
    }

    public void visitIncomingFiles(Visitor<FileInfo> visitor) {
        for (Member member : this.getMembersAsCollection()) {
            Object object;
            Object object2;
            if (!member.isCompletelyConnected()) continue;
            if (!member.hasCompleteFileListFor(this.currentInfo)) {
                if (!this.isFine()) continue;
                this.logFine("Skipping " + member + " no complete filelist from him");
                continue;
            }
            if (!this.hasWritePermission(member)) {
                if (!this.isFine()) continue;
                this.logFine("Not downloading files. " + member + " / " + member.getAccountInfo() + " no write permission");
                continue;
            }
            Collection<FileInfo> collection = this.getFilesAsCollection(member);
            if (collection != null) {
                object2 = collection.iterator();
                while (object2.hasNext()) {
                    object = (FileInfo)object2.next();
                    if (this.visitFileIfNewer((FileInfo)object, visitor)) continue;
                    return;
                }
            }
            if ((object2 = this.dao.findAllDirectories(member.getId())) == null) continue;
            object = object2.iterator();
            while (object.hasNext()) {
                FileInfo fileInfo = (FileInfo)object.next();
                if (this.visitFileIfNewer(fileInfo, visitor)) continue;
                return;
            }
        }
    }

    private boolean visitFileIfNewer(FileInfo fileInfo, Visitor<FileInfo> visitor) {
        boolean bl;
        FileInfo fileInfo2 = this.getFile(fileInfo);
        boolean bl2 = fileInfo2 == null;
        boolean bl3 = bl = fileInfo2 != null && fileInfo.isNewerThan(fileInfo2);
        if (bl2 && fileInfo.isDeleted()) {
            return true;
        }
        if ((bl2 || bl) && !this.diskItemFilter.isExcluded(fileInfo)) {
            try {
                return visitor.visit(fileInfo);
            }
            catch (Exception exception) {
                this.logSevere("Error while visiting incoming files. " + exception, exception);
            }
        }
        return true;
    }

    public Collection<FileInfo> getFilesAsCollection(Member member) {
        if (member == null) {
            throw new NullPointerException("Member is null");
        }
        return this.dao.findAllFiles(member.getId());
    }

    public Collection<DirectoryInfo> getDirectoriesAsCollection(Member member) {
        if (member == null) {
            throw new NullPointerException("Member is null");
        }
        return this.dao.findAllDirectories(member.getId());
    }

    public void visitMembers(Visitor<Member> visitor) {
        for (Member member : this.members.keySet()) {
            if (visitor.visit(member)) continue;
            return;
        }
    }

    public void visitMembersConnected(Visitor<Member> visitor) {
        for (Member member : this.members.keySet()) {
            if (!member.isCompletelyConnected() || visitor.visit(member)) continue;
            return;
        }
    }

    public Collection<Member> getMembersAsCollection() {
        return Collections.unmodifiableCollection(this.members.values());
    }

    public int getMembersCount() {
        return this.members.size();
    }

    public int getConnectedMembersCount() {
        int n = 0;
        for (Member member : this.members.values()) {
            if (!member.isConnected()) continue;
            ++n;
        }
        return n;
    }

    public int getCompletelyConnectedMembersCount() {
        int n = 0;
        for (Member member : this.members.values()) {
            if (!member.isCompletelyConnected()) continue;
            ++n;
        }
        return n;
    }

    public Member[] getConnectedMembers() {
        ArrayList<Member> arrayList = new ArrayList<Member>(this.members.size());
        for (Member member : this.getMembersAsCollection()) {
            if (!member.isCompletelyConnected() || member.isMySelf()) continue;
            arrayList.add(member);
        }
        return arrayList.toArray(new Member[0]);
    }

    public boolean hasMember(Member member) {
        if (this.members == null) {
            return false;
        }
        if (member == null) {
            return false;
        }
        return this.members.keySet().contains(member);
    }

    public boolean hasFile(FileInfo fileInfo) {
        return this.getFile(fileInfo) != null;
    }

    public FileInfo getFile(FileInfo fileInfo) {
        Reject.ifNull(fileInfo, "FileInfo is null");
        FileInfo fileInfo2 = this.dao.find(fileInfo, null);
        if (fileInfo2 != null) {
            return fileInfo2;
        }
        if (fileInfo.isBaseDirectory()) {
            return this.getBaseDirectoryInfo();
        }
        return null;
    }

    public Path getDiskFile(FileInfo fileInfo) {
        return this.localBase.resolve(FileInfoFactory.encodeIllegalChars(fileInfo.getRelativeName()));
    }

    public boolean hasUploadCapacity() {
        for (Member member : this.members.values()) {
            if (!this.getController().getTransferManager().hasUploadCapacity(member)) continue;
            return true;
        }
        return false;
    }

    public String getId() {
        return this.currentInfo.id;
    }

    public Date getLastFileChangeDate() {
        return this.statistic.getLastFileChangeDate();
    }

    public Date getLastDBMaintenanceDate() {
        return this.lastDBMaintenance;
    }

    public FolderInfo getInfo() {
        return this.currentInfo;
    }

    void updateInfo(FolderInfo folderInfo) {
        Reject.ifNull(folderInfo, "folderInfo");
        Reject.ifFalse(folderInfo.equals(this.currentInfo), "mismatch");
        if (this.currentInfo != null) {
            Reject.ifFalse(this.currentInfo.getId().equals(folderInfo.getId()), "Unable to update meta data. Folder ID mismatch");
            if (folderInfo.getVersion() < this.currentInfo.getVersion()) {
                this.logWarning("New FolderInfo has lower version. current: " + this.currentInfo + ". new: " + folderInfo, new StackDump());
            }
        }
        if (!folderInfo.isMetaFolder()) {
            if (this.currentInfo.getVersion() != folderInfo.getVersion()) {
                this.logInfo(this + ": updateInfo to " + folderInfo);
            } else {
                this.logFine(this + ": updateInfo to " + folderInfo);
            }
        }
        this.currentInfo = folderInfo.intern(true);
        FolderInfo folderInfo2 = FolderInfoFactory.readFrom(this);
        if (!(folderInfo2 != null && folderInfo2.equals(this.currentInfo) && folderInfo2.getVersion() >= this.currentInfo.getVersion() && Util.equals(folderInfo2.getParent(), this.currentInfo.getParent()) && folderInfo2.getName().equals(this.currentInfo.getName()))) {
            FolderInfoFactory.writeFolderInfo(this);
        }
    }

    public FolderStatistic getStatistic() {
        return this.statistic;
    }

    public FileInfoDAO getDAO() {
        return this.dao;
    }

    public Invitation createInvitation(FolderPermission folderPermission) {
        Invitation invitation = new Invitation(folderPermission);
        invitation.setSuggestedSyncProfile(this.syncProfile);
        if (this.syncProfile.equals(SyncProfile.BACKUP_SOURCE)) {
            invitation.setSuggestedSyncProfile(SyncProfile.BACKUP_TARGET);
        } else if (this.syncProfile.equals(SyncProfile.BACKUP_TARGET)) {
            invitation.setSuggestedSyncProfile(SyncProfile.BACKUP_SOURCE);
        } else if (this.syncProfile.equals(SyncProfile.HOST_FILES)) {
            invitation.setSuggestedSyncProfile(SyncProfile.AUTOMATIC_DOWNLOAD);
        }
        invitation.setSuggestedLocalBase(this.getController(), this.localBase);
        String string = this.getController().getOSClient().getUsername();
        if (StringUtils.isNotBlank(string)) {
            invitation.setInvitorUsername(string);
        }
        return invitation;
    }

    public void addDefaultExcludes() {
        Path path = this.getSystemSubDir().resolve("ignore.patterns");
        boolean bl = Files.notExists(path, new LinkOption[0]);
        boolean bl2 = this.diskItemFilter.isDirty();
        for (DefaultExcludes defaultExcludes : DefaultExcludes.values()) {
            this.addPattern(defaultExcludes.getPattern());
        }
        if (WinUtils.getAppDataCurrentUser() != null && this.localBase.equals(Paths.get(WinUtils.getAppDataCurrentUser(), new String[0]))) {
            this.addPattern("PowerFolder/logs/*");
        }
        if (UserDirectories.getDesktopDirectory() != null && this.localBase.equals(UserDirectories.getDesktopDirectory().getDirectory())) {
            this.addPattern("Boxcryptor/*");
        }
        if (UserDirectories.getDocumentsReported() != null && this.localBase.equals(Paths.get(UserDirectories.getDocumentsReported(), new String[0]))) {
            this.logFine("My documents @ " + UserDirectories.getDocumentsReported());
            this.logFine("Folder @ " + this.localBase.toAbsolutePath());
            this.logWarning("Adding transition ignore patterns for My documents folder");
            Path path2 = this.getController().getFolderRepository().getFoldersBasedir();
            this.addPattern(path2.getFileName().toString() + "*");
            if (UserDirectories.getDocumentsReported() != null) {
                int n = UserDirectories.getDocumentsReported().length();
                if (UserDirectories.getMusicReported() != null && UserDirectories.getMusicReported().startsWith(UserDirectories.getDocumentsReported())) {
                    this.addPattern(UserDirectories.getMusicReported().substring(n + 1) + "*");
                }
                if (UserDirectories.getPicturesReported() != null && UserDirectories.getPicturesReported().startsWith(UserDirectories.getDocumentsReported())) {
                    this.addPattern(UserDirectories.getPicturesReported().substring(n + 1) + "*");
                }
                if (UserDirectories.getVideosReported() != null && UserDirectories.getVideosReported().startsWith(UserDirectories.getDocumentsReported())) {
                    this.addPattern(UserDirectories.getVideosReported().substring(n + 1) + "*");
                }
            }
        }
        if (bl) {
            this.diskItemFilter.savePatternsTo(path, false);
            if (!bl2) {
                try {
                    Files.setLastModifiedTime(path, FileTime.fromMillis(0L));
                }
                catch (IOException iOException) {
                    this.logWarning(iOException.getMessage());
                }
            } else {
                this.savePatternsToMetaFolder();
            }
        }
    }

    private void checkLastSyncDate() {
        boolean bl;
        double d = this.statistic.getHarmonizedSyncPercentage();
        boolean bl2 = bl = Double.compare(d, 100.0) == 0;
        if (bl) {
            this.lastSyncDate = new Date();
            this.storeLastSyncDate();
        }
        if (this.isFiner()) {
            this.logFiner("Harmonized percentage: " + d + ". In sync? " + bl + ". last sync date: " + this.lastSyncDate + " . connected: " + this.getCompletelyConnectedMembersCount());
        }
    }

    private void storeLastSyncDate() {
        if (this.shutdown) {
            return;
        }
        Path path = this.getSystemSubDir0().resolve(LAST_SYNC_INFO_FILENAME);
        if (Files.notExists(this.getSystemSubDir0(), new LinkOption[0])) {
            return;
        }
        try {
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Files.setLastModifiedTime(path, FileTime.fromMillis(this.lastSyncDate.getTime()));
        }
        catch (Exception exception) {
            this.logWarning("Unable to update last synced date to " + path + " " + exception);
        }
    }

    private void loadLastSyncDate() {
        Path path = this.getSystemSubDir0().resolve(LAST_SYNC_INFO_FILENAME);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                this.lastSyncDate = new Date(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis());
            }
            catch (IOException iOException) {
                this.logWarning(iOException.getMessage());
            }
        } else {
            this.lastSyncDate = null;
        }
    }

    public void clearNodeCache(Member member) {
        this.hasReadCache.invalidate(member);
        this.hasWriteCache.invalidate(member);
    }

    public boolean hasReadPermission(Member member) {
        Boolean bl = this.hasReadCache.getValidEntry(member);
        if (bl != null) {
            if (this.hasReadCache.getCacheHits() % 100000 == 0 && this.isFine()) {
                this.logFine("Permission read: " + this.hasReadCache);
            }
            return bl;
        }
        bl = this.hasFolderPermission(member, FolderPermission.read(this.lookupContentFolderInfo()));
        this.hasReadCache.put(member, bl);
        return bl;
    }

    public boolean hasWritePermission(Member member) {
        Boolean bl = this.hasWriteCache.getValidEntry(member);
        if (bl != null) {
            if (this.hasWriteCache.getCacheHits() % 100000 == 0 && this.isFine()) {
                this.logFine("Permission write: " + this.hasWriteCache);
            }
            return bl;
        }
        bl = this.hasFolderPermission(member, FolderPermission.readWrite(this.lookupContentFolderInfo()));
        this.hasWriteCache.put(member, bl);
        return bl;
    }

    public boolean hasAdminPermission(Member member) {
        return this.hasFolderPermission(member, FolderPermission.admin(this.lookupContentFolderInfo()));
    }

    public boolean hasOwnerPermission(Member member) {
        return this.hasFolderPermission(member, FolderPermission.owner(this.lookupContentFolderInfo()));
    }

    private boolean hasFolderPermission(Member member, FolderPermission folderPermission) {
        return this.getController().getSecurityManager().hasPermission(member.getInfo(), (Permission)folderPermission);
    }

    private FolderInfo lookupContentFolderInfo() {
        if (!this.currentInfo.isMetaFolder()) {
            return this.currentInfo;
        }
        return this.currentInfo.lookupContentFolderInfo();
    }

    public String toString() {
        return this.currentInfo.toString();
    }

    public void addMembershipListener(FolderMembershipListener folderMembershipListener) {
        ListenerSupportFactory.addListener(this.folderMembershipListenerSupport, folderMembershipListener);
    }

    public void removeMembershipListener(FolderMembershipListener folderMembershipListener) {
        ListenerSupportFactory.removeListener(this.folderMembershipListenerSupport, folderMembershipListener);
    }

    public void addFolderListener(FolderListener folderListener) {
        ListenerSupportFactory.addListener(this.folderListenerSupport, folderListener);
    }

    public void removeFolderListener(FolderListener folderListener) {
        ListenerSupportFactory.removeListener(this.folderListenerSupport, folderListener);
    }

    private void fireMemberJoined(Member member) {
        FolderMembershipEvent folderMembershipEvent = new FolderMembershipEvent(this, member);
        this.folderMembershipListenerSupport.memberJoined(folderMembershipEvent);
    }

    private void fireMemberLeft(Member member) {
        FolderMembershipEvent folderMembershipEvent = new FolderMembershipEvent(this, member);
        this.folderMembershipListenerSupport.memberLeft(folderMembershipEvent);
    }

    private void fileChanged(FileInfo ... fileInfoArray) {
        this.filesChanged(Arrays.asList(fileInfoArray));
    }

    private void filesChanged(List<FileInfo> list) {
        Reject.ifNull(list, "FileInfo is null");
        for (int i = 0; i < list.size(); ++i) {
            FileInfo fileInfo = list.get(i);
            this.fireFileChanged(fileInfo);
            FileInfo fileInfo2 = this.getFile(fileInfo);
            list.set(i, fileInfo2);
        }
        this.setDBDirty();
        if (list.size() >= 1 || this.diskItemFilter.isRetained(list.get(0))) {
            this.broadcastMessages((boolean bl) -> FolderFilesChanged.create(this.getInfo(), list, this.diskItemFilter, bl));
        }
    }

    private void fireFileChanged(FileInfo fileInfo) {
        if (this.isFiner()) {
            this.logFiner("fireFileChanged: " + this);
        }
        FolderEvent folderEvent = new FolderEvent(this, fileInfo);
        this.folderListenerSupport.fileChanged(folderEvent);
    }

    private void fireFilesChanged(List<FileInfo> list) {
        if (this.isFiner()) {
            this.logFiner("fireFileChanged: " + this);
        }
        FolderEvent folderEvent = new FolderEvent(this, list, true);
        this.folderListenerSupport.fileChanged(folderEvent);
    }

    private void fireFilesDeleted(Collection<FileInfo> collection) {
        if (this.isFiner()) {
            this.logFiner("fireFilesDeleted: " + this);
        }
        FolderEvent folderEvent = new FolderEvent(this, collection);
        this.folderListenerSupport.filesDeleted(folderEvent);
    }

    private void fireRemoteContentsChanged(Member member, FileList fileList) {
        if (this.isFiner()) {
            this.logFiner("fireRemoteContentsChanged: " + this);
        }
        FolderEvent folderEvent = new FolderEvent(this, fileList, member);
        this.folderListenerSupport.remoteContentsChanged(folderEvent);
    }

    private void fireRemoteContentsChanged(Member member, FolderFilesChanged folderFilesChanged) {
        if (this.isFiner()) {
            this.logFiner("fireRemoteContentsChanged: " + this);
        }
        FolderEvent folderEvent = new FolderEvent(this, folderFilesChanged, member);
        this.folderListenerSupport.remoteContentsChanged(folderEvent);
    }

    private void fireSyncProfileChanged() {
        FolderEvent folderEvent = new FolderEvent(this, this.syncProfile);
        this.folderListenerSupport.syncProfileChanged(folderEvent);
    }

    private void fireArchiveSettingsChanged() {
        FolderEvent folderEvent = new FolderEvent(this);
        this.folderListenerSupport.archiveSettingsChanged(folderEvent);
    }

    void fireArchivePurged() {
        FolderEvent folderEvent = new FolderEvent(this);
        this.folderListenerSupport.archivePurged(folderEvent);
    }

    private void fireScanResultCommited(ScanResult scanResult) {
        if (this.isFiner()) {
            this.logFiner("fireScanResultCommited: " + this);
        }
        FolderEvent folderEvent = new FolderEvent(this, scanResult);
        this.folderListenerSupport.scanResultCommitted(folderEvent);
    }

    void notifyStatisticsCalculated() {
        this.checkLastSyncDate();
        this.checkSync();
        FolderEvent folderEvent = new FolderEvent(this);
        this.folderListenerSupport.statisticsCalculated(folderEvent);
    }

    public void clearAllProblemListeners() {
        ListenerSupportFactory.removeAllListeners(this.problemListenerSupport);
    }

    public void checkSync() {
        Object object;
        if (!ConfigurationEntry.FOLDER_SYNC_USE.getValueBoolean(this.getController()).booleanValue()) {
            this.removeUnsyncedProblem();
            return;
        }
        int n = this.syncWarnSeconds;
        if (n == 0) {
            n = ConfigurationEntry.FOLDER_SYNC_WARN_SECONDS.getValueInt(this.getController());
        }
        if (n <= 0) {
            this.removeUnsyncedProblem();
            return;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).add(13, -n);
        Date date = gregorianCalendar.getTime();
        boolean bl = false;
        Member member = this.getMySelf();
        Object object2 = this.members.values().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            double d = this.statistic.getSyncPercentage((Member)object);
            if (((Member)object).equals(member) || Double.compare(d, 100.0) != 0) continue;
            bl = true;
            break;
        }
        if ((object2 = this.lastSyncDate) != null && ((Date)object2).before(date)) {
            if (!bl || !this.isTransferring()) {
                object = null;
                for (Problem problem : this.problems) {
                    if (!(problem instanceof UnsynchronizedFolderProblem)) continue;
                    object = (UnsynchronizedFolderProblem)problem;
                    break;
                }
                if (object == null && PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
                    if (new Date().before(this.lastSyncDate)) {
                        this.logWarning("Last sync date in future: " + this.lastSyncDate);
                    }
                    UnsynchronizedFolderProblem unsynchronizedFolderProblem = new UnsynchronizedFolderProblem(this.currentInfo, (Date)object2);
                    this.addProblem(unsynchronizedFolderProblem);
                }
            }
        } else {
            this.removeUnsyncedProblem();
        }
    }

    private void removeUnsyncedProblem() {
        if (this.problems.isEmpty()) {
            return;
        }
        UnsynchronizedFolderProblem unsynchronizedFolderProblem = null;
        for (Problem problem : this.problems) {
            if (!(problem instanceof UnsynchronizedFolderProblem)) continue;
            unsynchronizedFolderProblem = (UnsynchronizedFolderProblem)problem;
            break;
        }
        if (unsynchronizedFolderProblem != null) {
            this.removeProblem(unsynchronizedFolderProblem);
        }
    }

    public boolean isSyncPatterns() {
        return this.syncPatterns;
    }

    public void setSyncPatterns(boolean bl) {
        this.syncPatterns = bl;
        String string = "f." + this.configEntryId + ".sync-patterns";
        this.getController().getConfig().put(string, String.valueOf(bl));
        this.getController().saveConfig();
    }

    public int getSyncWarnSeconds() {
        return this.syncWarnSeconds;
    }

    public void setSyncWarnSeconds(int n) {
        if (n == this.syncWarnSeconds) {
            return;
        }
        this.syncWarnSeconds = n;
        if (n != 0) {
            this.getController().getConfig().setProperty("f." + this.configEntryId + ".sync-warn-seconds", String.valueOf(n));
        } else {
            this.getController().getConfig().remove("f." + this.configEntryId + ".sync-warn-seconds");
        }
        this.getController().saveConfig();
        this.checkSync();
    }

    private void savePatternsToMetaFolder() {
        if (!this.syncPatterns) {
            return;
        }
        if (this.currentInfo.isMetaFolder()) {
            return;
        }
        FolderRepository folderRepository = this.getController().getFolderRepository();
        Folder folder = folderRepository.getMetaFolder(this.currentInfo);
        if (folder == null) {
            this.logWarning("Could not find metaFolder for " + this.currentInfo);
            return;
        }
        if (folder.deviceDisconnected) {
            this.logFiner("Not writing synced ignored patterns. Meta folder disconnected");
            return;
        }
        Path path = folder.localBase.resolve("ignore.patterns");
        FileInfo fileInfo = FileInfoFactory.lookupInstance(folder, path);
        this.diskItemFilter.savePatternsTo(path, false);
        if (this.isFine()) {
            this.logFine("Saving ignore patterns to Meta folder: " + path);
        }
        folder.scanChangedFile(fileInfo);
    }

    public void cleanupOldArchiveFiles(Date date) {
        this.archiver.cleanupOldArchiveFiles(date);
    }

    private static /* synthetic */ Message[] lambda$scanDirectory$1(FileInfo fileInfo, boolean bl) {
        return new Message[]{FolderFilesChanged.create(fileInfo, bl)};
    }

    private class Persister
    extends TimerTask {
        private Persister() {
        }

        @Override
        public synchronized void run() {
            if (Folder.this.shutdown) {
                return;
            }
            if (Folder.this.dirty) {
                Folder.this.persist();
            }
            if (Folder.this.diskItemFilter.isDirty() && !Folder.this.checkIfDeviceDisconnected()) {
                Folder.this.diskItemFilter.savePatternsTo(Folder.this.getSystemSubDir().resolve("ignore.patterns"), true);
                if (!Folder.this.shutdown) {
                    Folder.this.savePatternsToMetaFolder();
                }
            }
        }

        public String toString() {
            return "FolderPersister for '" + Folder.this;
        }
    }
}

