/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk;

import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.problem.FileProblemHelper;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FileInfoFactory;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.security.Account;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StreamUtils;
import de.dal33t.powerfolder.util.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class FileArchiver {
    private static final Logger log = Logger.getLogger(FileArchiver.class.getName());
    private static final VersionComparator VERSION_COMPARATOR = new VersionComparator();
    private static final Pattern BASE_NAME_PATTERN = Pattern.compile("(.*)_K_\\d+(.*)");
    private static final String SIZE_INFO_FILE = "Size";
    private final Path archiveDirectory;
    private volatile int versionsPerFile;
    private MemberInfo mySelf;
    private Long size;

    public FileArchiver(Path path, MemberInfo memberInfo) {
        Reject.notNull(path, "archiveDirectory");
        Reject.ifNull(memberInfo, "Myself");
        this.archiveDirectory = path;
        this.versionsPerFile = -1;
        this.mySelf = memberInfo;
        this.size = this.loadSize();
    }

    private Long loadSize() {
        Long l;
        block9: {
            Path path = this.archiveDirectory.resolve(SIZE_INFO_FILE);
            if (Files.notExists(path, new LinkOption[0])) {
                return null;
            }
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                byte[] byArray = StreamUtils.readIntoByteArray(inputStream);
                l = Long.valueOf(new String(byArray));
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    log.fine("Unable to read size of archive to " + path + ". " + exception);
                    return null;
                }
            }
            inputStream.close();
        }
        return l;
    }

    public void archive(FileInfo fileInfo, Path path, boolean bl) throws IOException {
        Reject.notNull(fileInfo, "fileInfo");
        Reject.notNull(path, "source");
        if (this.versionsPerFile == 0 && !bl) {
            if (!Files.deleteIfExists(path)) {
                log.warning("Unable to remove old file " + path);
            }
            return;
        }
        Path path2 = this.getArchiveTarget(fileInfo);
        if (Files.exists(path2, new LinkOption[0])) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("File " + fileInfo.toDetailString() + " seems to be archived already, doing nothing.");
            }
            return;
        }
        Long l = this.size;
        try {
            if (Files.notExists(path2.getParent(), new LinkOption[0])) {
                Files.createDirectories(path2.getParent(), new FileAttribute[0]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (Files.exists(path2.getParent(), new LinkOption[0])) {
            boolean bl2 = bl;
            if (!bl2) {
                try {
                    Files.move(path, path2, StandardCopyOption.REPLACE_EXISTING);
                    if (this.size != null && Files.exists(path2, new LinkOption[0])) {
                        this.size = this.size + Files.size(path2);
                    }
                }
                catch (IOException iOException) {
                    if (iOException.getMessage().toLowerCase().contains("too long") || FileProblemHelper.isTooLong(path2.getFileName().toString())) {
                        log.warning("Failed to archive " + path + ": " + iOException.getMessage());
                        return;
                    }
                    log.warning("Failed to rename " + path + ", falling back to copying: " + iOException);
                    bl2 = true;
                }
            }
            if (bl2) {
                long l2 = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
                PathUtils.copyFile(path, path2);
                Files.setLastModifiedTime(path2, FileTime.fromMillis(l2));
                if (this.size != null && Files.exists(path2, new LinkOption[0])) {
                    this.size = this.size + Files.size(path2);
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Archived " + fileInfo.toDetailString() + " from " + path + " to " + path2);
            }
            List<Path> list = FileArchiver.getArchivedFiles(path2.getParent(), fileInfo.getFilenameOnly());
            this.checkArchivedFile(list);
            if (l != null && this.size != null && l.longValue() != this.size.longValue()) {
                this.saveSize();
            }
        } else {
            throw new IOException("Failed to create directory: " + path2.getParent());
        }
    }

    public final Path getArchiveDir() {
        return this.archiveDirectory;
    }

    private void checkArchivedFile(Collection<Path> collection) throws IOException {
        assert (collection != null);
        if (this.versionsPerFile < 0) {
            return;
        }
        if (collection.size() <= this.versionsPerFile) {
            return;
        }
        Path[] pathArray = collection.toArray(new Path[0]);
        Arrays.sort(pathArray, VERSION_COMPARATOR);
        int n = pathArray.length - this.versionsPerFile;
        long l = this.size;
        for (Path path : pathArray) {
            if (n <= 0) break;
            --n;
            long l2 = Files.size(path);
            try {
                Files.delete(path);
                if (this.size != null) {
                    this.size = this.size - l2;
                }
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("checkArchivedFile: Deleted archived file " + path);
            }
            catch (IOException iOException) {
                throw new IOException("Could not delete old version: " + path);
            }
        }
        if (l != this.size) {
            this.saveSize();
        }
    }

    public synchronized boolean maintain() {
        if (Files.notExists(this.archiveDirectory, new LinkOption[0])) {
            return true;
        }
        boolean bl = this.checkRecursive(this.archiveDirectory, new HashSet<Path>());
        this.size = null;
        return bl;
    }

    private boolean checkRecursive(Path path, Set<Path> set) {
        Object object;
        assert (path != null && Files.isDirectory(path, new LinkOption[0]));
        assert (set != null);
        if (path == null || Files.notExists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
            return true;
        }
        boolean bl = true;
        HashSet<Path> hashSet = new HashSet<Path>();
        try {
            object = Files.newDirectoryStream(path);
            try {
                Iterator<Path> iterator = object.iterator();
                while (iterator.hasNext()) {
                    Iterable<Path> iterable = iterator.next();
                    hashSet.add((Path)iterable);
                }
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }
        catch (IOException iOException) {
            log.warning(iOException.toString());
            return false;
        }
        object = new HashMap();
        for (Iterable<Path> iterable : hashSet) {
            String string;
            if (iterable.getFileName().toString().equals(SIZE_INFO_FILE)) continue;
            if (Files.isDirectory(iterable, new LinkOption[0])) {
                boolean bl2 = this.checkRecursive((Path)iterable, set);
                if (bl2) {
                    try {
                        Files.delete(iterable);
                    }
                    catch (IOException iOException) {
                        log.warning(iOException.toString());
                    }
                }
                bl &= bl2;
                continue;
            }
            try {
                string = FileArchiver.getBaseName(iterable);
            }
            catch (RuntimeException runtimeException) {
                log.log(Level.WARNING, iterable + ": Skipping: " + runtimeException.toString());
                continue;
            }
            Path path2 = path.resolve(string);
            set.add(path2);
            LinkedList<Path> linkedList = (LinkedList<Path>)object.get(string);
            if (linkedList == null) {
                linkedList = new LinkedList<Path>();
                object.put(string, linkedList);
            }
            linkedList.add((Path)iterable);
        }
        for (Iterable<Path> iterable : object.values()) {
            try {
                this.checkArchivedFile((Collection<Path>)iterable);
            }
            catch (IOException iOException) {
                bl = false;
                log.log(Level.WARNING, "Failed to check " + (Collection)iterable, iOException);
            }
        }
        return bl;
    }

    private static String getBaseName(Path path) {
        Matcher matcher = BASE_NAME_PATTERN.matcher(path.getFileName().toString());
        if (matcher.matches()) {
            if (matcher.groupCount() == 1) {
                return matcher.group(1);
            }
            if (matcher.groupCount() == 2) {
                return matcher.group(1) + matcher.group(2);
            }
        }
        throw new IllegalArgumentException("File not in archive: " + path);
    }

    private Path getArchiveTarget(FileInfo fileInfo) {
        String string = fileInfo.getRelativeName();
        String[] stringArray = new String[2];
        if (string.contains(".")) {
            int n = string.lastIndexOf(".");
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n);
        } else {
            stringArray[0] = string;
            stringArray[1] = "";
        }
        return this.archiveDirectory.resolve(FileInfoFactory.encodeIllegalChars(stringArray[0]) + "_K_" + fileInfo.getVersion() + FileInfoFactory.encodeIllegalChars(stringArray[1]));
    }

    private Path getOldArchiveTarget(FileInfo fileInfo) {
        return this.archiveDirectory.resolve(FileInfoFactory.encodeIllegalChars(fileInfo.getRelativeName()) + "_K_" + fileInfo.getVersion());
    }

    private String getFileInfoName(Path path) {
        return FileArchiver.buildFileName(this.archiveDirectory, path);
    }

    private static String buildFileName(Path path, Path path2) {
        Object object = FileInfoFactory.decodeIllegalChars(path2.getFileName().toString());
        int n = ((String)object).lastIndexOf("_K_");
        int n2 = ((String)object).lastIndexOf(".");
        if (n >= 0 && n2 >= 0) {
            object = ((String)object).substring(0, n) + ((String)object).substring(n2);
        } else if (n >= 0 && n2 < 0) {
            object = ((String)object).substring(0, n);
        }
        Path path3 = path2.getParent();
        while (!path.equals(path3)) {
            if (path3 == null) {
                throw new IllegalArgumentException("Local file seems not to be in a subdir of the local powerfolder copy");
            }
            object = FileInfoFactory.decodeIllegalChars(path3.getFileName().toString()) + "/" + (String)object;
            path3 = path3.getParent();
        }
        return object;
    }

    private static int getVersionNumber(Path path) {
        String string = path.getFileName().toString();
        String string2 = string.substring(string.lastIndexOf("_K_") + 3);
        if (string2.contains(".")) {
            string2 = string2.substring(0, string2.lastIndexOf("."));
        }
        return Integer.parseInt(string2);
    }

    private static List<Path> getArchivedFiles(Path path, String string) {
        ArrayList<Path> arrayList = new ArrayList<Path>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream) {
                if (!FileArchiver.belongsTo(FileInfoFactory.decodeIllegalChars(path2.getFileName().toString()), string)) continue;
                arrayList.add(path2);
            }
        }
        catch (IOException iOException) {
            log.warning(iOException.toString());
        }
        return arrayList;
    }

    private static boolean belongsTo(String string, String string2) {
        Matcher matcher = BASE_NAME_PATTERN.matcher(string);
        if (matcher.matches()) {
            return Util.equalsRelativeName(matcher.group(1) + matcher.group(2), string2);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasArchivedFileInfo(FileInfo fileInfo) {
        Path path;
        Reject.ifNull(fileInfo, "FileInfo is null");
        try {
            path = this.archiveDirectory.resolve(FileInfoFactory.encodeIllegalChars(fileInfo.getRelativeName())).getParent();
        }
        catch (InvalidPathException invalidPathException) {
            log.warning("Unable to resolve versions for file: " + fileInfo.toDetailString() + ". " + invalidPathException);
            return false;
        }
        if (Files.notExists(path, new LinkOption[0])) {
            return false;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            Path path2;
            String string = fileInfo.getFilenameOnly();
            int n = string.lastIndexOf(46);
            if (n > -1) {
                string = string.substring(0, n);
            }
            string = FileInfoFactory.encodeIllegalChars(string);
            Iterator<Path> iterator = directoryStream.iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!(path2 = iterator.next()).getFileName().toString().startsWith(string));
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            log.warning(iOException.toString());
        }
        return false;
    }

    public List<FileInfo> getArchivedFilesInfos(FileInfo fileInfo) {
        Reject.ifNull(fileInfo, "FileInfo is null");
        Path path = PathUtils.buildFileFromRelativeName(this.archiveDirectory, FileInfoFactory.encodeIllegalChars(fileInfo.getRelativeName())).getParent();
        if (Files.notExists(path, new LinkOption[0])) {
            return Collections.emptyList();
        }
        Path path2 = this.getArchiveTarget(fileInfo);
        List<Path> list = FileArchiver.getArchivedFiles(path2.getParent(), fileInfo.getFilenameOnly());
        if (list == null || list.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<FileInfo> arrayList = new ArrayList<FileInfo>();
        FolderInfo folderInfo = fileInfo.getFolderInfo();
        for (Path path3 : list) {
            try {
                int n = FileArchiver.getVersionNumber(path3);
                Date date = new Date(Files.getLastModifiedTime(path3, new LinkOption[0]).toMillis());
                String string = this.getFileInfoName(path3);
                String string2 = null;
                String string3 = null;
                String string4 = null;
                AccountInfo accountInfo = FileInfo.UNKNOWN_FROM_ARCHIVE;
                FileInfo fileInfo2 = FileInfoFactory.archivedFile(folderInfo, string, string2, Files.size(path3), this.mySelf, accountInfo, date, n, string3, string4);
                arrayList.add(fileInfo2);
            }
            catch (IOException iOException) {
                log.warning(iOException.toString());
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List<FileInfo> getSortedArchivedFilesInfos(FileInfo fileInfo) {
        ArrayList<FileInfo> arrayList = new ArrayList<FileInfo>(this.getArchivedFilesInfos(fileInfo));
        arrayList.sort(Comparator.comparingInt(FileInfo::getVersion));
        return arrayList;
    }

    public Path getArchivedFile(FileInfo fileInfo) {
        Path path;
        Reject.ifNull(fileInfo, "FileInfo is null");
        try {
            path = this.archiveDirectory.resolve(FileInfoFactory.encodeIllegalChars(fileInfo.getRelativeName())).getParent();
        }
        catch (InvalidPathException invalidPathException) {
            log.warning("Unable to resolve versions for file: " + fileInfo.toDetailString() + ". " + invalidPathException);
            return null;
        }
        if (Files.notExists(path, new LinkOption[0])) {
            return null;
        }
        return this.getArchiveTarget(fileInfo);
    }

    public boolean restore(FileInfo fileInfo, Path path) throws IOException {
        Path path2 = this.getArchiveTarget(fileInfo);
        if (Files.notExists(path2, new LinkOption[0])) {
            path2 = this.getOldArchiveTarget(fileInfo);
        }
        if (Files.exists(path2, new LinkOption[0])) {
            log.fine("Restoring " + fileInfo.getRelativeName() + " to " + path.toAbsolutePath());
            if (path.getParent() != null && Files.notExists(path.getParent(), new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            PathUtils.copyFile(path2, path);
            return true;
        }
        return false;
    }

    public int getVersionsPerFile() {
        return this.versionsPerFile;
    }

    public void setVersionsPerFile(int n) {
        this.versionsPerFile = n;
    }

    public synchronized long getSize() {
        if (this.size == null) {
            long l = PathUtils.calculateDirectorySizeAndCount(this.archiveDirectory)[0];
            Path path = this.archiveDirectory.resolve(SIZE_INFO_FILE);
            if (Files.exists(path, new LinkOption[0])) {
                try {
                    l -= Files.size(path);
                }
                catch (IOException iOException) {
                    log.warning(iOException.toString());
                }
            }
            this.size = l;
            this.saveSize();
        }
        return this.size;
    }

    public void purge(Folder folder, Account account) throws IOException {
        Reject.ifFalse(folder.getFileArchiver() == this, "Folder archive mismatch");
        this.purge0(this.archiveDirectory);
        this.size = 0L;
        this.saveSize();
        folder.fireArchivePurged();
        String string = "Successfully cleared versioning of folder " + folder.getName() + " by " + account;
        string = this.size == 0L ? string : string + " (Removed " + FileUtils.byteCountToDisplaySize(this.size) + ")";
        log.info(string);
    }

    public void purge(FileInfo fileInfo, Folder folder, Account account) throws IOException {
        Reject.ifFalse(folder.getFileArchiver() == this, "Folder archive mismatch");
        long l = 0L;
        boolean bl = false;
        if (fileInfo.isDiretory()) {
            this.purge0(this.archiveDirectory.resolve(fileInfo.getRelativeName()));
            bl = true;
        } else {
            for (FileInfo fileInfo2 : this.getArchivedFilesInfos(fileInfo)) {
                Path path = this.getArchivedFile(fileInfo2);
                l += Files.size(path);
                this.purge0(path);
            }
        }
        this.size = !bl && this.size != null ? Long.valueOf(this.size - l) : null;
        this.saveSize();
        folder.fireArchivePurged();
        Object object = "Successfully cleared versioning of " + (fileInfo.isDiretory() ? "Directory" : "File") + fileInfo.getRelativeName() + " by " + account;
        object = bl ? object : (String)object + " (Removed " + FileUtils.byteCountToDisplaySize(l) + ")";
        log.info((String)object);
        if (bl) {
            folder.getController().getIOProvider().startIO(this::getSize);
        }
    }

    private void purge0(Path path) throws IOException {
        PathUtils.recursiveDelete(path);
    }

    public void cleanupOldArchiveFiles(Date date) {
        log.fine("Cleaning up " + this.archiveDirectory + " for files older than " + date);
        if (Files.exists(this.archiveDirectory, new LinkOption[0])) {
            FileArchiver.cleanupOldArchiveFiles(this.archiveDirectory, date);
        }
    }

    private static void cleanupOldArchiveFiles(Path path, Date date) {
        Object object;
        boolean bl = true;
        if (Files.isDirectory(path, new LinkOption[0])) {
            try {
                object = Files.newDirectoryStream(path);
                try {
                    Iterator<Path> iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Path path2 = iterator.next();
                        bl = false;
                        FileArchiver.cleanupOldArchiveFiles(path2, date);
                    }
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                }
            }
            catch (IOException iOException) {
                log.warning(path + ": " + iOException);
            }
        }
        if (bl) {
            try {
                object = new Date(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis());
                if (((Date)object).before(date)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Deleting old archive file " + path + " (" + (Date)object + ")");
                    }
                    try {
                        Files.delete(path);
                    }
                    catch (SecurityException securityException) {
                        log.severe("Could not delete archive file " + path + ". " + securityException);
                    }
                }
            }
            catch (DirectoryNotEmptyException directoryNotEmptyException) {
                log.fine(path + ": Directory not empty, while cleaning up. " + directoryNotEmptyException);
            }
            catch (IOException iOException) {
                log.warning("Could not read modification time of " + path + ". " + iOException);
            }
        }
    }

    private void saveSize() {
        Path path = this.archiveDirectory.resolve(SIZE_INFO_FILE);
        if (this.size == null) {
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException iOException) {
                log.warning("Unable to delete " + path + ". " + iOException);
            }
            return;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(String.valueOf(this.size).getBytes());
        try {
            PathUtils.copyFromStreamToFile(byteArrayInputStream, path);
            PathUtils.setAttributesOnWindows(path, true, true);
        }
        catch (IOException iOException) {
            log.fine("Unable to store size of archive to " + path);
        }
    }

    private static class VersionComparator
    implements Comparator<Path> {
        private VersionComparator() {
        }

        @Override
        public int compare(Path path, Path path2) {
            return FileArchiver.getVersionNumber(path) - FileArchiver.getVersionNumber(path2);
        }
    }
}

