/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.util.IdGenerator;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Reject;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import org.cryptomator.cryptofs.CryptoFileSystem;
import org.cryptomator.cryptofs.CryptoFileSystemProperties;
import org.cryptomator.cryptofs.CryptoFileSystemProvider;
import org.cryptomator.cryptofs.CryptoFileSystemUri;
import org.jetbrains.annotations.NotNull;

public class EncryptedFileSystemUtils {
    static final String DEFAULT_MASTERKEY_FILENAME = "masterkey.cryptomator";
    static final String DEFAULT_MASTERKEY_BACKUP_FILENAME = "masterkey.cryptomator.bkup";
    static final String DEFAULT_ENCRYPTED_ROOT_DIR = "d";

    public static Path getEncryptedFileSystem(@NotNull Controller controller, @NotNull Path path) throws IOException {
        if (EncryptedFileSystemUtils.isCryptoInstance(path)) {
            Path path2 = path.getFileSystem().getPath("/encDir", new String[0]);
            if (Files.notExists(path2, new LinkOption[0])) {
                Files.createDirectories(path2, new FileAttribute[0]);
            }
            return path2;
        }
        try {
            return EncryptedFileSystemUtils.getCryptoPath(path);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            EncryptedFileSystemUtils.isInitializationRequired(path);
            FileSystem fileSystem = EncryptedFileSystemUtils.initCryptoFileSystem(controller, path);
            Path path3 = fileSystem.getPath("/encDir", new String[0]);
            if (Files.notExists(path3, new LinkOption[0])) {
                Files.createDirectories(path3, new FileAttribute[0]);
            }
            return path3;
        }
    }

    static boolean isInitializationRequired(Path path) throws IOException {
        if (EncryptedFileSystemUtils.isCryptoInstance(path) || !EncryptedFileSystemUtils.endsWithEncryptionSuffix(path)) {
            return false;
        }
        if (Files.notExists(path.resolve(DEFAULT_MASTERKEY_FILENAME), new LinkOption[0]) && Files.notExists(path.resolve(DEFAULT_MASTERKEY_BACKUP_FILENAME), new LinkOption[0]) || Files.notExists(path.resolve(DEFAULT_ENCRYPTED_ROOT_DIR), new LinkOption[0])) {
            PathUtils.recursiveDeleteVisitor(path);
            Files.createDirectories(path, new FileAttribute[0]);
            return true;
        }
        return false;
    }

    public static boolean isEncryptionActivated(@NotNull Controller controller) {
        return ConfigurationEntry.ENCRYPTED_STORAGE.getValueBoolean(controller);
    }

    public static boolean isEncryptionActivatedAndDefault(@NotNull Controller controller) {
        return ConfigurationEntry.ENCRYPTED_STORAGE.getValueBoolean(controller) != false && ConfigurationEntry.ENCRYPTED_STORAGE_DEFAULT.getValueBoolean(controller) != false;
    }

    public static boolean endsWithEncryptionSuffix(@NotNull Path path) {
        Reject.ifNull(path, "Path is null");
        return path.getFileName() != null ? path.getFileName().toString().endsWith(".crypto") : false;
    }

    public static boolean isCryptoInstance(@NotNull Path path) {
        Reject.ifNull(path, "path");
        return path.getFileSystem() instanceof CryptoFileSystem;
    }

    @NotNull
    public static Path getPhysicalStorageLocation(@NotNull Path path) {
        Reject.ifNull(path, "path");
        if (!(path.getFileSystem() instanceof CryptoFileSystem)) {
            throw new IllegalArgumentException("FileSystem from " + path + " is not a CryptoFileSystem");
        }
        CryptoFileSystem cryptoFileSystem = (CryptoFileSystem)path.getFileSystem();
        if (cryptoFileSystem != null) {
            return cryptoFileSystem.getPathToVault();
        }
        throw new IllegalArgumentException("FileSystem from " + path + " is not a CryptoFileSystem");
    }

    @NotNull
    public static Path getCryptoPath(@NotNull Path path) {
        URI uRI = CryptoFileSystemUri.create(path, "/encDir");
        return FileSystems.getFileSystem(uRI).provider().getPath(uRI);
    }

    public static void setEncryptionPassphrase(@NotNull Controller controller) {
        if (!ConfigurationEntry.ENCRYPTED_STORAGE_PASSPHRASE.hasValue(controller)) {
            ConfigurationEntry.ENCRYPTED_STORAGE_PASSPHRASE.setValue(controller, IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId());
            controller.saveConfig();
        }
    }

    public static boolean isEmptyCryptoContainerRootDir(@NotNull Path path) {
        return EncryptedFileSystemUtils.isCryptoInstance(path) && path.startsWith("/encDir") && PathUtils.isEmptyDir(path);
    }

    public static boolean checkJCEinstalled() throws NoSuchAlgorithmException {
        return Cipher.getMaxAllowedKeyLength("AES") >= 128;
    }

    private static FileSystem initCryptoFileSystem(Controller controller, Path path) throws IOException {
        return CryptoFileSystemProvider.newFileSystem(path, CryptoFileSystemProperties.cryptoFileSystemProperties().withPassphrase(ConfigurationEntry.ENCRYPTED_STORAGE_PASSPHRASE.getValue(controller)).build());
    }
}

