/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.clientserver;

import com.sun.security.auth.callback.TextCallbackHandler;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.clientserver.AccountService;
import de.dal33t.powerfolder.clientserver.FolderService;
import de.dal33t.powerfolder.clientserver.PublicKeyService;
import de.dal33t.powerfolder.clientserver.RemoteCallException;
import de.dal33t.powerfolder.clientserver.RemoteServiceStubFactory;
import de.dal33t.powerfolder.clientserver.SecurityService;
import de.dal33t.powerfolder.clientserver.ServerClientEvent;
import de.dal33t.powerfolder.clientserver.ServerClientListener;
import de.dal33t.powerfolder.clientserver.ThrowableHandler;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.event.FolderRepositoryAdapter;
import de.dal33t.powerfolder.event.FolderRepositoryEvent;
import de.dal33t.powerfolder.event.ListenerSupportFactory;
import de.dal33t.powerfolder.event.NodeManagerAdapter;
import de.dal33t.powerfolder.event.NodeManagerEvent;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.light.ServerInfo;
import de.dal33t.powerfolder.message.FolderList;
import de.dal33t.powerfolder.message.Identity;
import de.dal33t.powerfolder.message.clientserver.AccountDetails;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.net.ConnectionHandler;
import de.dal33t.powerfolder.net.NodeList;
import de.dal33t.powerfolder.security.Account;
import de.dal33t.powerfolder.security.AdminPermission;
import de.dal33t.powerfolder.security.AnonymousAccount;
import de.dal33t.powerfolder.security.FolderCreatePermission;
import de.dal33t.powerfolder.security.FolderRemovePermission;
import de.dal33t.powerfolder.security.IdPMissingException;
import de.dal33t.powerfolder.security.NotLoggedInException;
import de.dal33t.powerfolder.security.SecurityException;
import de.dal33t.powerfolder.security.Token;
import de.dal33t.powerfolder.util.Base64;
import de.dal33t.powerfolder.util.ConfigurationLoader;
import de.dal33t.powerfolder.util.Convert;
import de.dal33t.powerfolder.util.IdGenerator;
import de.dal33t.powerfolder.util.LoginUtil;
import de.dal33t.powerfolder.util.Pair;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.ProUtil;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.SimpleCache;
import de.dal33t.powerfolder.util.StackDump;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.Waiter;
import de.dal33t.powerfolder.util.net.NetworkUtil;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.Win32.WinUtils;
import edu.kit.scc.dei.ecplean.ECPAuthenticationException;
import edu.kit.scc.dei.ecplean.ECPAuthenticator;
import edu.kit.scc.dei.ecplean.ECPUnauthorizedException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class ServerClient
extends PFComponent {
    public static final String SERVER_NODES_URI = "/client_deployment/server.nodes";
    public static final String SERVER_PUBLIC_KEYS_URI = "/client_deployment/server.public_keys";
    public static final String SAML_EXTERNAL_NON_SAML_USERS = "ext";
    private static final String MEMBER_ID_TEMP_PREFIX = "TEMP_IDENTITY_";
    public static final ThreadLocal<Boolean> SERVER_HANDLE_MESSAGE_THREAD = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private Properties config;
    private Collection<Member> servers = new CopyOnWriteArrayList<Member>();
    private SimpleCache<MemberInfo, Boolean> cachedServerPublicKey = new SimpleCache(1L, TimeUnit.MINUTES);
    private Map<ServerInfo, ServerClient> childClients = Util.createConcurrentHashMap();
    private String username;
    private String passwordObf;
    private String tokenSecret;
    private String shibUsername;
    private String shibToken;
    private String webdavToken;
    private Member server;
    private final MyThrowableHandler throwableHandler = new MyThrowableHandler();
    private final AtomicBoolean loggingIn = new AtomicBoolean();
    private final AtomicBoolean loginExecuted = new AtomicBoolean(false);
    private final AtomicBoolean lastLoginSuccessful = new AtomicBoolean(true);
    private boolean allowServerChange;
    private int recentServerSwitches;
    private Date recentServerSwitch;
    private boolean updateConfig;
    private boolean updateFolders = true;
    private boolean supportsQuickLogin;
    private final Object loginLock = new Object();
    private String lastIdPUsed;
    private int shibbolethUnauthRetriesSkip;
    private AccountDetails accountDetails;
    private SecurityService securityService;
    private AccountService userService;
    private FolderService folderService;
    private PublicKeyService publicKeyService;
    private ServerClientListener listenerSupport;
    private static final long DEFAULT_SERVER_CONNECT_TIMEOUT_MS = 5000L;
    private volatile boolean spawnRetrying = false;
    private static final long HAMMER_TIME = 10000L;
    private static final int HAMMER_HITS = 20;
    private static final long HAMMER_DELAY = 30000L;

    public ServerClient(Controller controller) {
        this(controller, controller.getConfig());
    }

    public ServerClient(Controller controller, Properties properties) {
        super(controller);
        Reject.ifNull(properties, "Config is null");
        this.config = properties;
        String string = ConfigurationEntry.SERVER_NAME.getValue(properties);
        String string2 = ConfigurationEntry.SERVER_HOST.getValue(properties);
        String string3 = ConfigurationEntry.SERVER_NODEID.getValue(properties);
        if (!ConfigurationEntry.SERVER_NODEID.hasValue(properties) && ConfigurationEntry.SERVER_HOST.hasValue(properties)) {
            string3 = null;
        }
        boolean bl = ConfigurationEntry.SERVER_CONFIG_UPDATE.getValueBoolean(properties);
        this.init(controller, properties, string, string2, string3, true, bl);
    }

    public ServerClient(Controller controller, Properties properties, String string, String string2, String string3, boolean bl, boolean bl2) {
        super(controller);
        this.init(controller, properties, string, string2, string3, bl, bl2);
    }

    private void init(Controller controller, Properties properties, String string, String string2, String string3, boolean bl, boolean bl2) {
        this.config = properties;
        this.allowServerChange = bl;
        this.updateConfig = bl2;
        this.supportsQuickLogin = true;
        String string4 = StringUtils.isBlank(string) ? Translation.get("online_storage.connecting") : string;
        boolean bl3 = StringUtils.isBlank(string3);
        Object object = bl3 ? "TEMP_IDENTITY_|" + IdGenerator.makeId() : string3;
        Member member = controller.getNodeManager().getNode((String)object);
        if (member == null) {
            String string5 = this.getController().getNodeManager().getNetworkId();
            MemberInfo memberInfo = new MemberInfo(string4, (String)object, string5);
            member = bl3 ? new Member(this.getController(), memberInfo) : memberInfo.getNode(this.getController(), true);
        }
        if (StringUtils.isNotBlank(string2)) {
            member.getInfo().setConnectAddress(Util.parseConnectionString(string2));
        }
        if (member.getReconnectAddress() == null) {
            this.logSevere("Got server without reconnect address: " + member);
        }
        this.logInfo("Using server: " + member.getNick() + ", ID: " + (String)object + " @ " + member.getReconnectAddress());
        this.init(member, bl);
    }

    private void init(Member member, boolean bl) {
        boolean bl2;
        Reject.ifNull(member, "Server node is null");
        boolean bl3 = bl2 = this.listenerSupport == null;
        if (bl2) {
            this.listenerSupport = ListenerSupportFactory.createListenerSupport(ServerClientListener.class);
        }
        this.setNewServerNode(member);
        this.allowServerChange = bl;
        this.setAnonAccount();
        if (bl2) {
            this.getController().getNodeManager().addNodeManagerListener(new MyNodeManagerListener());
            this.getController().getFolderRepository().addFolderRepositoryListener(new MyFolderRepositoryListener());
        }
    }

    public boolean isKeepLoggedIn() {
        return PreferencesEntry.SERVER_REMEMBER_PASSWORD.getValueBoolean(this.getController());
    }

    public void start() {
        boolean bl = ConfigurationEntry.SERVER_CONNECT_FROM_LAN_TO_INTERNET.getValueBoolean(this.config);
        if (!bl && this.getController().isLanOnly() && !this.server.isOnLAN()) {
            this.logWarning("Not connecting to server: " + this.server + ". Reason: Server not on LAN");
        }
        this.getController().scheduleAndRepeat(new ServerConnectTask(), 3000L, 20000L);
        this.getController().scheduleAndRepeat(new AutoLoginTask(), 10000L, 60000L);
        this.getController().scheduleAndRepeat(new HostingServersConnector(), 10000L, 600000L);
    }

    public static boolean isTempServerNode(Member member) {
        return member.getId().startsWith(MEMBER_ID_TEMP_PREFIX);
    }

    public static boolean isTempServerNode(MemberInfo memberInfo) {
        return memberInfo.id.startsWith(MEMBER_ID_TEMP_PREFIX);
    }

    public boolean isPowerFolderCloud() {
        return ServerClient.isPowerFolderCloud(this.getController());
    }

    public static boolean isPowerFolderCloud(Controller controller) {
        String string = ConfigurationEntry.SERVER_NODEID.getValue(controller);
        String string2 = ConfigurationEntry.SERVER_HOST.getValue(controller);
        return StringUtils.isNotBlank(string) && string.toUpperCase().contains("WEBSERVICE") && StringUtils.isNotBlank(string2) && string2.toLowerCase().contains("powerfolder.com");
    }

    public Member getServer() {
        return this.server;
    }

    public boolean isPrimaryServer(ConnectionHandler connectionHandler) {
        if (connectionHandler.getIdentity() != null && this.server.getInfo().equals(connectionHandler.getIdentity().getMemberInfo())) {
            return true;
        }
        if (ServerClient.isTempServerNode(this.server)) {
            if (this.server.getReconnectAddress().equals(connectionHandler.getRemoteAddress())) {
                return true;
            }
            InetSocketAddress inetSocketAddress = connectionHandler.getRemoteAddress();
            InetSocketAddress inetSocketAddress2 = this.server.getReconnectAddress();
            if (inetSocketAddress == null || inetSocketAddress2 == null) {
                return false;
            }
            InetAddress inetAddress = inetSocketAddress.getAddress();
            InetAddress inetAddress2 = inetSocketAddress2.getAddress();
            if (inetAddress == null || inetAddress2 == null) {
                return false;
            }
            String string = NetworkUtil.getHostAddressNoResolve(inetAddress);
            String string2 = NetworkUtil.getHostAddressNoResolve(inetAddress2);
            int n = inetSocketAddress.getPort();
            int n2 = inetSocketAddress2.getPort();
            return string.equalsIgnoreCase(string2) && n == n2;
        }
        return false;
    }

    public boolean isPrimaryServer(Member member) {
        if (this.server.equals(member)) {
            return true;
        }
        if (ServerClient.isTempServerNode(this.server)) {
            if (this.server.getReconnectAddress() != null && this.server.getReconnectAddress().equals(member.getReconnectAddress())) {
                return true;
            }
            InetSocketAddress inetSocketAddress = member.getReconnectAddress();
            InetSocketAddress inetSocketAddress2 = this.server.getReconnectAddress();
            if (inetSocketAddress == null || inetSocketAddress2 == null) {
                return false;
            }
            InetAddress inetAddress = inetSocketAddress.getAddress();
            InetAddress inetAddress2 = inetSocketAddress2.getAddress();
            if (inetAddress == null || inetAddress2 == null) {
                return false;
            }
            String string = NetworkUtil.getHostAddressNoResolve(inetAddress);
            String string2 = NetworkUtil.getHostAddressNoResolve(inetAddress2);
            int n = inetSocketAddress.getPort();
            int n2 = inetSocketAddress2.getPort();
            return string.equalsIgnoreCase(string2) && n == n2;
        }
        return false;
    }

    public boolean isClusterServer(Member member) {
        return this.isPrimaryServer(member) || this.servers.contains(member);
    }

    public boolean isFederatedServer(Member member) {
        if (this.isClusterServer(member)) {
            return false;
        }
        for (ServerClient serverClient : this.childClients.values()) {
            if (!serverClient.isClusterServer(member)) continue;
            return true;
        }
        return false;
    }

    public ServerClient getChildClient(Member member) {
        if (this.isClusterServer(member)) {
            this.logWarning("Is not federated node: " + member);
            return null;
        }
        for (ServerClient serverClient : this.childClients.values()) {
            if (!serverClient.isClusterServer(member)) continue;
            return serverClient;
        }
        return null;
    }

    public Map<ServerInfo, ServerClient> getChildClients() {
        return Collections.unmodifiableMap(this.childClients);
    }

    public Collection<Member> getServersInCluster() {
        return Collections.unmodifiableCollection(this.servers);
    }

    public void setServer(Member member, boolean bl) {
        Reject.ifNull(member, "Server node is null");
        this.setNewServerNode(member);
        this.allowServerChange = bl;
        if (this.hasUsername() && this.hasCredentials()) {
            this.login0(this.username, this.passwordObf, this.tokenSecret);
        } else {
            this.loginWithLastKnown();
        }
        if (!this.isConnected()) {
            this.server.markForImmediateConnect();
        }
    }

    public boolean isConnected() {
        return this.server.isMySelf() || this.server.isConnected();
    }

    public String getWebURL() {
        String string = Util.removeLastSlashFromURI(ConfigurationEntry.SERVER_WEB_URL.getValue(this.config));
        if (!StringUtils.isBlank(string)) {
            return string;
        }
        if (this.accountDetails != null && this.accountDetails.getAccount() != null && this.accountDetails.getAccount().getServer() != null && !StringUtils.isBlank(this.accountDetails.getAccount().getServer().getWebUrl())) {
            return this.accountDetails.getAccount().getServer().getWebUrl();
        }
        return null;
    }

    public String getWebURL(String string, boolean bl) {
        if (!this.hasWebURL()) {
            return null;
        }
        String string2 = this.getWebURL();
        if (StringUtils.isBlank(string)) {
            string = "";
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (!bl) {
            return string2 + "/" + string;
        }
        Object object = this.getLoginURLWithCredentials();
        try {
            object = ((String)object).contains("?") ? (String)object + "&" : (String)object + "?";
            object = (String)object + "originalURI=" + URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        return object;
    }

    public URI getClientWebSocketURI(String string) {
        if (!this.hasWebURL()) {
            return null;
        }
        String string2 = this.getWebURL();
        if (string2 == null) {
            return null;
        }
        String string3 = string2.replace("http://", "ws://").replace("https://", "wss://");
        try {
            String string4 = Util.removeLastSlashFromURI(string3) + "/websocket_client";
            if (StringUtils.isNotBlank(string4)) {
                string4 = string4 + "/" + string;
            }
            return new URI(string4);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public boolean hasWebURL() {
        return this.getWebURL() != null;
    }

    public boolean supportsWebDAV() {
        if (!this.hasWebURL()) {
            return false;
        }
        return (OSUtil.isWindowsSystem() || OSUtil.isLinux()) && ConfigurationEntry.WEB_DAV_ENABLED.getValueBoolean(this.config) != false;
    }

    public boolean supportsWebLogin() {
        if (!this.hasWebURL()) {
            return false;
        }
        if (ConfigurationEntry.WEB_LOGIN_ALLOWED.getValueBoolean(this.config).booleanValue()) {
            return true;
        }
        if (this.accountDetails == null) {
            return false;
        }
        return this.accountDetails.getAccount().hasPermission(AdminPermission.INSTANCE);
    }

    public String getLoginURLWithCredentials() {
        if (!this.hasWebURL()) {
            return null;
        }
        if (!this.isLoggedIn()) {
            return this.getWebURL();
        }
        try {
            String string = this.getSecurityService().requestOTP();
            if (this.isFine()) {
                this.logFine("Retrieved OTP for " + this.accountDetails.getAccount().getUsername() + ": " + string);
            }
            if (LoginUtil.isOTPValid(string)) {
                return LoginUtil.decorateURL(this.getWebURL("/login", false), null, string);
            }
        }
        catch (Exception exception) {
            this.logFine("Unable to generate OTP. " + exception);
        }
        return this.getWebURL();
    }

    public String getMembersURL(FolderInfo folderInfo) {
        if (!this.hasWebURL()) {
            return null;
        }
        return this.getWebURL("/members/" + Base64.encode4URL(folderInfo.id), false);
    }

    public String getFolderURL(FolderInfo folderInfo) {
        if (!this.hasWebURL()) {
            return null;
        }
        return this.getWebURL("/files/" + Base64.encode4URL(folderInfo.id), false);
    }

    public String getFolderURLWithCredentials(FolderInfo folderInfo) {
        if (!this.supportsWebLogin()) {
            return null;
        }
        String string = this.getFolderURL(folderInfo);
        string = string.replace(this.getWebURL(), "");
        Object object = this.getLoginURLWithCredentials();
        object = ((String)object).contains("?") ? (String)object + "&" : (String)object + "?";
        object = (String)object + "originalURI";
        object = (String)object + "=";
        object = (String)object + string;
        return object;
    }

    public String getFileLinkURL(FileInfo fileInfo) {
        Reject.ifNull(fileInfo, "fileinfo");
        if (!this.hasWebURL()) {
            return null;
        }
        return this.getWebURL("/getlink/" + Base64.encode4URL(fileInfo.getFolderInfo().getId()) + "/" + Util.encodeForURL(fileInfo.getRelativeName()), true);
    }

    public String getFileLinkURLWithCredentials(FileInfo fileInfo) {
        if (!this.supportsWebLogin()) {
            return null;
        }
        String string = this.getFileLinkURL(fileInfo);
        string = string.replace(this.getWebURL(), "");
        Object object = this.getLoginURLWithCredentials();
        object = ((String)object).contains("?") ? (String)object + "&" : (String)object + "?";
        object = (String)object + "originalURI";
        object = (String)object + "=";
        object = (String)object + string;
        return object;
    }

    public String getOpenURL(FileInfo fileInfo) {
        Reject.ifNull(fileInfo, "fileInfo");
        if (!this.hasWebURL()) {
            return null;
        }
        return this.getWebURL("/open/" + Base64.encode4URL(fileInfo.getFolderInfo().getId()) + "/" + Util.encodeForURL(fileInfo.getRelativeName()), true);
    }

    public boolean supportsRecoverPassword() {
        return StringUtils.isNotBlank(this.getRecoverPasswordURL());
    }

    public String getRecoverPasswordURL() {
        if (!this.hasWebURL()) {
            return null;
        }
        if (!ConfigurationEntry.SERVER_RECOVER_PASSWORD_ENABLED.getValueBoolean(this.config).booleanValue()) {
            return null;
        }
        String string = this.getWebURL("/login", false);
        if (StringUtils.isNotBlank(this.username)) {
            string = LoginUtil.decorateURL(string, this.username, (char[])null);
        }
        return string;
    }

    public boolean supportsWebRegistration() {
        return ConfigurationEntry.SERVER_REGISTER_ENABLED.getValueBoolean(this.config);
    }

    public String getRegisterURL() {
        if (!this.supportsWebRegistration()) {
            return null;
        }
        if (!this.hasWebURL()) {
            return null;
        }
        return this.getWebURL("/register", false);
    }

    public String getRegisterURLReferral() {
        Object object = this.getRegisterURL();
        if (StringUtils.isBlank((String)object)) {
            return this.getWebURL();
        }
        if (!this.isLoggedIn()) {
            return object;
        }
        try {
            object = ((String)object).contains("?") ? (String)object + "&" : (String)object + "?";
            return (String)object + "ref=" + URLEncoder.encode(this.getAccount().getOID(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String getActivationURL() {
        return ConfigurationEntry.SERVER_WEB_URL.getDefaultValue() + "/activate";
    }

    public String getAvatarURL(AccountInfo accountInfo, boolean bl) {
        if (!this.hasWebURL()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/avatars/user/");
        stringBuilder.append(accountInfo.getOID());
        if (bl) {
            stringBuilder.append("?thumbnail=true");
        }
        return this.getWebURL(stringBuilder.toString(), false);
    }

    public String getToSURL() {
        return this.getWebURL("tos", true);
    }

    public String getToSFileURL() {
        return this.getWebURL("client_deployment/tos.html", false);
    }

    public String getToSVersionFileURL() {
        return this.getWebURL("client_deployment/tos_version.txt", false);
    }

    public boolean isBackupByDefault() {
        return ConfigurationEntry.SERVER_SYNC_MANDATORY.getValueBoolean(this.getController()) != false || PreferencesEntry.USE_ONLINE_STORAGE.getValueBoolean(this.getController()) != false || this.getController().isBackupOnly() || PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()) == false;
    }

    public boolean isLastLoginKnown() {
        return ConfigurationEntry.SERVER_CONNECT_USERNAME.hasValue(this.config);
    }

    public Account loginWithLastKnown() {
        String string;
        String string2 = null;
        char[] cArray = null;
        String string3 = null;
        if (ConfigurationEntry.SERVER_CONNECT_USERNAME.hasValue(this.config)) {
            string2 = ConfigurationEntry.SERVER_CONNECT_USERNAME.getValue(this.config);
            cArray = LoginUtil.deobfuscate(ConfigurationEntry.SERVER_CONNECT_PASSWORD.getValue(this.config));
            if (cArray == null && StringUtils.isNotBlank(string = ConfigurationEntry.SERVER_CONNECT_PASSWORD_CLEAR.getValue(this.config))) {
                cArray = Util.toCharArray(string);
            }
        }
        if (ConfigurationEntry.SERVER_CONNECT_TOKEN.hasValue(this.config) && Token.isExpired(string3 = ConfigurationEntry.SERVER_CONNECT_TOKEN.getValue(this.config))) {
            string3 = null;
        }
        if (ConfigurationEntry.SERVER_CONNECT_TOKEN_WEBDAV.hasValue(this.config)) {
            this.webdavToken = ConfigurationEntry.SERVER_CONNECT_TOKEN_WEBDAV.getValue(this.config);
            if (Token.isExpired(this.webdavToken)) {
                this.webdavToken = null;
            }
        }
        if (StringUtils.isNotBlank(this.getController().getCLIUsername())) {
            string2 = this.getController().getCLIUsername();
        }
        if (StringUtils.isNotBlank(this.getController().getCLIPassword())) {
            cArray = Util.toCharArray(this.getController().getCLIPassword());
        }
        if (ConfigurationEntry.SERVER_CONNECT_NO_PASSWORD_ALLOWED.getValueBoolean(this.config).booleanValue()) {
            if (StringUtils.isBlank(string2)) {
                string2 = System.getProperty("user.name");
            }
            if (cArray == null || cArray.length == 0) {
                cArray = Util.toCharArray(ProUtil.rtrvePwssd(this.getController(), string2));
            }
        }
        string = System.getProperty("user.name");
        if (StringUtils.isBlank(string2) && (cArray == null || cArray.length == 0) && ConfigurationEntry.KERBEROS_SSO_ENABLED.getValueBoolean(this.config).booleanValue()) {
            string2 = string;
        }
        if (!StringUtils.isBlank(string2)) {
            this.logFine("Logging into server " + this.getServerString() + ". Username: " + string2);
            return this.login0(string2, LoginUtil.obfuscate(cArray), string3);
        }
        this.logFine("Not logging in. Username blank");
        return null;
    }

    public void logout() {
        this.username = null;
        this.passwordObf = null;
        this.tokenSecret = null;
        this.webdavToken = null;
        this.securityService.logout();
        this.saveLastKnowLogin(null, null);
        ConfigurationEntry.SERVER_IDP_LAST_CONNECTED.removeValue(this.getController());
        ConfigurationEntry.SERVER_IDP_LAST_CONNECTED_ECP.removeValue(this.getController());
        this.setAnonAccount();
        this.fireLogin(this.accountDetails);
    }

    public Account login(String string, char[] cArray) {
        ConfigurationEntry.SERVER_CONNECT_TOKEN.removeValue(this.config);
        return this.login0(string, LoginUtil.obfuscate(cArray), null);
    }

    public Account login(String string) {
        return this.login0(null, null, string);
    }

    public Account login(String string, String string2) {
        return this.login0(string, null, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Account login0(String string, String string2, String string3) {
        Object object;
        if (StringUtils.isNotBlank(string)) {
            object = this.isConnected() ? Level.INFO : Level.FINE;
            this.logIt((Level)object, "Logging in with: " + string + (String)(string3 != null ? ". token: " + string3.length() : "") + " to " + this.getServerString(), null);
        } else {
            this.logFine("Login without username");
        }
        object = this.loginLock;
        synchronized (object) {
            Object object2;
            this.loggingIn.set(true);
            String string4 = this.username;
            String string5 = this.passwordObf;
            try {
                boolean bl;
                Object object3;
                boolean bl2;
                block53: {
                    Account account;
                    block50: {
                        this.username = string;
                        this.passwordObf = string2;
                        this.tokenSecret = string3;
                        if (!this.server.isConnected() || !this.hasCredentials()) {
                            this.setAnonAccount();
                            this.fireLogin(this.accountDetails);
                            Account account2 = this.accountDetails.getAccount();
                            return account2;
                        }
                        if (this.isFederatedLogin() && !this.federatedLoginSuccess()) {
                            this.setAnonAccount();
                            this.fireLogin(this.accountDetails, false);
                            Account account3 = this.accountDetails.getAccount();
                            return account3;
                        }
                        this.saveLastKnowLogin(this.username, null);
                        bl2 = false;
                        object2 = LoginUtil.deobfuscate(this.passwordObf);
                        try {
                            block52: {
                                block56: {
                                    block51: {
                                        String string6;
                                        block55: {
                                            block54: {
                                                if (!this.isKerberosLogin()) break block54;
                                                object3 = this.prepareKerberosLogin();
                                                bl2 = this.securityService.login(this.username, (byte[])object3);
                                                break block52;
                                            }
                                            if (!this.isTokenLogin()) break block55;
                                            bl2 = this.securityService.login(this.tokenSecret);
                                            break block52;
                                        }
                                        if (!this.isShibbolethLogin()) break block56;
                                        try {
                                            string6 = ConfigurationEntry.SERVER_IDP_LAST_CONNECTED_ECP.getValue(this.config);
                                            bl = StringUtils.isEqual(this.lastIdPUsed, string6);
                                            boolean bl3 = StringUtils.isEqual(string5, this.passwordObf);
                                            boolean bl4 = StringUtils.isEqual(string4, this.username);
                                            if (this.shibbolethUnauthRetriesSkip != 0 && bl4 && bl3 && bl) {
                                                --this.shibbolethUnauthRetriesSkip;
                                                if (this.isFine()) {
                                                    this.logFine("Skipping login another " + this.shibbolethUnauthRetriesSkip + " times");
                                                }
                                                this.setAnonAccount();
                                                account = this.accountDetails.getAccount();
                                                break block50;
                                            }
                                        }
                                        catch (RuntimeException runtimeException) {
                                            this.logWarning("An error occured skipping shibboleth login: " + runtimeException);
                                            break block51;
                                        }
                                        {
                                            this.lastIdPUsed = string6;
                                            this.shibbolethUnauthRetriesSkip = 0;
                                        }
                                    }
                                    boolean bl5 = this.prepareShibbolethLogin(this.username, (char[])object2, string4 != null && !string4.equals(this.username) || string5 != null && !string5.equals(this.passwordObf));
                                    if (bl5) {
                                        bl2 = this.securityService.login(this.username, (char[])object2);
                                        break block52;
                                    } else if (this.shibUsername != null && this.shibToken != null) {
                                        bl2 = this.securityService.login(this.shibUsername, Util.toCharArray(this.shibToken));
                                        break block52;
                                    } else {
                                        this.logWarning("Neither Shibboleth nor external login possible!");
                                    }
                                    break block52;
                                }
                                bl2 = this.securityService.login(this.username, (char[])object2);
                            }
                            this.lastLoginSuccessful.set(bl2);
                            this.loginExecuted.set(true);
                            break block53;
                        }
                        catch (RemoteCallException remoteCallException) {
                            if (!(remoteCallException.getCause() instanceof NoSuchMethodException)) throw remoteCallException;
                            this.logSevere("Client incompatible with server: Server version too old");
                            throw remoteCallException;
                        }
                    }
                    return account;
                    finally {
                        LoginUtil.clear((char[])object2);
                    }
                }
                if (!bl2) {
                    this.logWarning("Login to " + this.server + " (" + string + ") failed!");
                    this.setAnonAccount();
                    this.fireLogin(this.accountDetails, false);
                    object3 = this.accountDetails.getAccount();
                    return object3;
                }
                object3 = this.securityService.getAccountDetails();
                this.logInfo("Login to " + this.server.getReconnectAddress() + " (" + string + ") result: " + (AccountDetails)object3);
                if (object3 != null) {
                    this.accountDetails = object3;
                    if (this.updateConfig) {
                        if (this.accountDetails.getAccount().getServer() != null) {
                            bl = this.setServerWebURLInConfig(this.accountDetails.getAccount().getServer().getWebUrl());
                            bl = this.setServerHTTPTunnelURLInConfig(this.accountDetails.getAccount().getServer().getHTTPTunnelUrl()) || bl;
                        } else {
                            bl = this.setServerWebURLInConfig(null);
                            boolean bl6 = bl = this.setServerHTTPTunnelURLInConfig(null) || bl;
                        }
                        if (bl) {
                            this.getController().saveConfig();
                        }
                    }
                    if (this.isKeepLoggedIn()) {
                        if (StringUtils.isBlank(this.tokenSecret)) {
                            this.tokenSecret = this.requestAndSaveToken();
                            if (StringUtils.isNotBlank(this.tokenSecret) && !Token.isExpired(this.tokenSecret)) {
                                this.passwordObf = null;
                                ConfigurationEntry.SERVER_CONNECT_TOKEN.setValue(this.config, this.tokenSecret);
                            } else {
                                ConfigurationEntry.SERVER_CONNECT_TOKEN.removeValue(this.config);
                            }
                        }
                        if (StringUtils.isBlank(this.username)) {
                            this.username = this.accountDetails.getAccount().getUsername();
                        }
                        this.saveLastKnowLogin(this.username, this.passwordObf);
                    } else {
                        this.saveLastKnowLogin(this.username, null);
                    }
                    if (Token.isExpired(this.getWebDAVToken())) {
                        this.webdavToken = this.requestWebDAVToken();
                        if (StringUtils.isNotBlank(this.webdavToken) && !Token.isExpired(this.webdavToken)) {
                            ConfigurationEntry.SERVER_CONNECT_TOKEN_WEBDAV.setValue(this.config, this.webdavToken);
                        } else {
                            ConfigurationEntry.SERVER_CONNECT_TOKEN_WEBDAV.removeValue(this.config);
                        }
                    }
                    this.loggingIn.set(false);
                    this.fireLogin(this.accountDetails);
                    this.getController().getIOProvider().startIO(() -> {
                        this.updateLocalSettings(this.accountDetails);
                        if (PreferencesEntry.WEBDAV_ONLY.getValueBoolean(this.getController()).booleanValue()) {
                            String string = this.getWebURL("/webdav", false);
                            char c = this.getController().getDistribution().getBinaryName().charAt(0);
                            if (!WinUtils.isWebDAVAlreadyMapped(this, c)) {
                                WinUtils.mountWebDAV(this, c, string);
                            }
                        }
                    });
                } else {
                    this.setAnonAccount();
                    this.fireLogin(this.accountDetails, false);
                }
                Account account = this.accountDetails.getAccount();
                return account;
            }
            catch (Exception exception) {
                if (!(exception instanceof IdPMissingException)) {
                    this.logWarning("Unable to login: " + exception);
                    if (exception instanceof RuntimeException) {
                        this.logWarning(exception);
                    }
                }
                if (this.isShibbolethLogin()) {
                    this.saveLastKnowLogin(this.username, this.passwordObf);
                }
                this.lastLoginSuccessful.set(false);
                this.setAnonAccount();
                this.fireLogin(this.accountDetails, false);
                object2 = this.accountDetails.getAccount();
                return object2;
            }
            finally {
                this.loggingIn.set(false);
            }
        }
    }

    private String requestAndSaveToken() {
        try {
            String string = this.securityService.requestToken();
            if (StringUtils.isNotBlank(string)) {
                this.logInfo("Received token for client");
                return string;
            }
            this.logWarning("Token generation disabled by server");
        }
        catch (RemoteCallException remoteCallException) {
            if (remoteCallException.getCause() instanceof NoSuchMethodException) {
                this.logWarning("Token generation not supported by server");
            } else {
                this.logWarning("Unable to retrieve token for this device: " + remoteCallException);
            }
        }
        catch (Exception exception) {
            this.logWarning("Unable to retrieve token for this device: " + exception);
        }
        return null;
    }

    private String requestWebDAVToken() {
        try {
            String string = this.securityService.requestWebDAVToken();
            if (StringUtils.isNotBlank(string)) {
                this.logInfo("Received WebDAV token for client");
                return string;
            }
            this.logWarning("WebDAV token generation disabled by server");
        }
        catch (RemoteCallException remoteCallException) {
            if (remoteCallException.getCause() instanceof NoSuchMethodException) {
                this.logWarning("WebDAV token generation not supported by server");
            } else if (remoteCallException.getCause() instanceof ConnectionException) {
                this.logFine("Disconnected while retrieving WebDAV token for this device: " + remoteCallException);
            } else {
                this.logWarning("Unable to retrieve WebDAV token for this device: " + remoteCallException);
            }
        }
        catch (Exception exception) {
            this.logWarning("Unable to retrieve WebDAV token for this device: " + exception);
        }
        return null;
    }

    private boolean hasUsername() {
        return StringUtils.isNotBlank(this.username);
    }

    private boolean hasCredentials() {
        return StringUtils.isNotBlank(this.passwordObf) || this.isTokenLogin() || this.isKerberosLogin();
    }

    public boolean isTokenLogin() {
        return StringUtils.isNotBlank(this.tokenSecret) && StringUtils.isBlank(this.passwordObf);
    }

    private boolean isKerberosLogin() {
        return ConfigurationEntry.KERBEROS_SSO_ENABLED.getValueBoolean(this.config) != false && StringUtils.isBlank(this.passwordObf) && !this.isTokenLogin();
    }

    private boolean isShibbolethLogin() {
        return ConfigurationEntry.SERVER_IDP_DISCO_FEED_URL.hasNonBlankValue(this.config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] prepareKerberosLogin() {
        try {
            Object object;
            Path path = Controller.getTempFilesLocation().resolve("login.conf");
            if (Files.notExists(path, new LinkOption[0])) {
                object = Thread.currentThread().getContextClassLoader().getResourceAsStream("kerberos/login.conf");
                PathUtils.copyFromStreamToFile((InputStream)object, path);
            }
            System.setProperty("java.security.auth.login.config", path.toAbsolutePath().toString());
            System.setProperty("java.security.krb5.realm", ConfigurationEntry.KERBEROS_SSO_REALM.getValue(this.config));
            object = ConfigurationEntry.KERBEROS_SSO_KDC.getValue(this.config);
            System.setProperty("java.security.krb5.kdc", (String)object);
            LoginContext loginContext = new LoginContext("SignedOnUserLoginContext", new TextCallbackHandler());
            loginContext.login();
            Subject subject = loginContext.getSubject();
            this.username = subject.getPrincipals().iterator().next().getName();
            byte[] byArray = Subject.doAs(subject, new ServiceTicketGenerator());
            return byArray;
        }
        catch (Exception exception) {
            this.logWarning("Unable to login: " + exception);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.loggingIn.set(false);
        }
    }

    public boolean isAllowedToRemoveFolders() {
        return ConfigurationEntry.SECURITY_PERMISSIONS_STRICT.getValueBoolean(this.config) == false || this.getAccount().hasPermission(FolderRemovePermission.INSTANCE);
    }

    public boolean isAllowedToCreateFolders() {
        if (this.getAccount().getOSSubscription().getStorageSize() <= 0L) {
            return false;
        }
        if (ConfigurationEntry.SECURITY_PERMISSIONS_STRICT.getValueBoolean(this.config).booleanValue() && !this.getAccount().hasPermission(FolderCreatePermission.INSTANCE)) {
            return false;
        }
        if (this.accountDetails != null) {
            return !this.accountDetails.needsToAgreeToS();
        }
        return true;
    }

    private boolean prepareShibbolethLogin(String string, char[] cArray, boolean bl) {
        String string2 = this.getAndReloadLastConnectedECP();
        if (StringUtils.isBlank(string2)) {
            this.shibUsername = null;
            this.shibToken = null;
            throw new IdPMissingException();
        }
        if (bl) {
            this.shibUsername = null;
            this.shibToken = null;
        } else if (SAML_EXTERNAL_NON_SAML_USERS.equals(string2)) {
            return true;
        }
        boolean bl2 = false;
        try {
            bl2 = this.shibToken != null && this.shibToken.contains(":") && System.currentTimeMillis() <= Long.valueOf(this.shibToken.substring(this.shibToken.indexOf(58) + 1, this.shibToken.length()));
        }
        catch (Exception exception) {
            this.logFine("Unusable Shibboleth Token: " + this.shibToken);
            this.shibUsername = null;
            this.shibToken = null;
        }
        if (StringUtils.isBlank(this.shibUsername) || StringUtils.isBlank(this.shibToken) || !bl2) {
            URI uRI;
            URI uRI2;
            String string3 = this.getWebURL("/login/shibboleth/client/" + this.getController().getMySelf().getId(), false);
            try {
                uRI2 = new URI(string3);
            }
            catch (URISyntaxException uRISyntaxException) {
                this.shibUsername = null;
                this.shibToken = null;
                throw new RuntimeException("Unable to resolve service provider URL: " + string3 + ". " + uRISyntaxException);
            }
            try {
                uRI = new URI(string2);
            }
            catch (Exception exception) {
                this.shibUsername = null;
                this.shibToken = null;
                throw new RuntimeException("Unable to resolve identity provider URL: " + ConfigurationEntry.SERVER_IDP_LAST_CONNECTED_ECP.getValue(this.config) + ". " + exception);
            }
            HttpClientBuilder httpClientBuilder = Util.createHttpClientBuilder(this.getController());
            String string4 = ConfigurationEntry.HTTP_PROXY_USERNAME.getValue(this.getController());
            String string5 = Util.toString(LoginUtil.deobfuscate(ConfigurationEntry.HTTP_PROXY_PASSWORD.getValue(this.getController())));
            ECPAuthenticator eCPAuthenticator = new ECPAuthenticator(httpClientBuilder, string, new String(cArray), uRI, uRI2, string4, string5);
            try {
                String[] stringArray = eCPAuthenticator.authenticate();
                this.shibUsername = stringArray[0];
                this.shibToken = stringArray[1];
            }
            catch (ECPUnauthorizedException eCPUnauthorizedException) {
                this.shibbolethUnauthRetriesSkip = ConfigurationEntry.SERVER_LOGIN_SKIP_RETRY.getValueInt(this.config);
                this.shibUsername = null;
                this.shibToken = null;
                throw new SecurityException(eCPUnauthorizedException);
            }
            catch (ECPAuthenticationException eCPAuthenticationException) {
                this.shibUsername = null;
                this.shibToken = null;
                throw new SecurityException(eCPAuthenticationException);
            }
            catch (RuntimeException runtimeException) {
                this.shibUsername = null;
                this.shibToken = null;
                this.logWarning(runtimeException.getMessage() + ": Fallback to external login.", runtimeException);
            }
        }
        return false;
    }

    private String getAndReloadLastConnectedECP() {
        String string = ConfigurationEntry.SERVER_IDP_LAST_CONNECTED_ECP.getValue(this.config);
        String string2 = ConfigurationEntry.SERVER_IDP_LAST_CONNECTED.getValue(this.config);
        String string3 = ConfigurationEntry.SERVER_IDP_EXTERNAL_NAMES.getValue(this.config);
        if (StringUtils.isBlank(string2)) {
            return string;
        }
        if (SAML_EXTERNAL_NON_SAML_USERS.equals(string2) || StringUtils.isNotBlank(string3) && string3.contains(string2)) {
            return string;
        }
        try {
            String string4 = ConfigurationEntry.SERVER_WEB_URL.getValue(this.getController()) + "/api/idpd?entityID=" + URLEncoder.encode(string2, Convert.UTF8.toString());
            HttpGet httpGet = new HttpGet(string4);
            HttpClientBuilder httpClientBuilder = Util.createHttpClientBuilder(this.getController());
            CloseableHttpClient closeableHttpClient = httpClientBuilder.build();
            HttpResponse httpResponse = closeableHttpClient.execute(httpGet);
            string = EntityUtils.toString(httpResponse.getEntity());
            if (!Util.equals(string, ConfigurationEntry.SERVER_IDP_LAST_CONNECTED_ECP.getValue(this.config))) {
                ConfigurationEntry.SERVER_IDP_LAST_CONNECTED_ECP.setValue(this.config, string);
                this.getController().saveConfig();
            }
        }
        catch (IOException iOException) {
            this.logWarning("Could not retrieve new ECP URL for entity ID " + string2 + ". " + iOException);
        }
        return string;
    }

    private void findAlternativeServer() {
        if (!this.allowServerChange) {
            return;
        }
        if (this.getMySelf().isServer()) {
            return;
        }
        if (this.getController().isShuttingDown() || !this.getController().isStarted()) {
            return;
        }
        if (this.isFine()) {
            this.logFine("findAlternativeServer: " + this.servers);
        }
        ArrayList<Member> arrayList = new ArrayList<Member>(this.servers);
        Collections.shuffle(arrayList);
        for (Member member : arrayList) {
            boolean bl = member.isConnected();
            if (!bl) {
                member.markForImmediateConnect();
            }
            Waiter waiter = new Waiter(500L);
            while (waiter.isTimeout() && !member.isConnected()) {
                waiter.waitABit();
            }
            if (!member.isConnected() || member.equals(this.server)) continue;
            this.logInfo("Switching to new server: " + member);
            try {
                this.setServer(member, this.allowServerChange);
                if (bl) break;
                this.primaryServerConnected(member);
                break;
            }
            catch (Exception exception) {
                this.logWarning("Unable to switch server to " + member.getNick() + ". Searching for new..." + exception);
            }
        }
    }

    public void loadConfigURL(String string) {
        Reject.ifBlank(string, "configURL");
        try {
            boolean bl;
            Properties properties = ConfigurationLoader.loadPreConfiguration(string.trim());
            ConfigurationLoader.merge(properties, this.getController());
            String string2 = (String)properties.get(ConfigurationEntry.NETWORK_ID.getConfigKey());
            String string3 = (String)properties.get(ConfigurationEntry.SERVER_NAME.getConfigKey());
            String string4 = (String)properties.get(ConfigurationEntry.SERVER_HOST.getConfigKey());
            String string5 = (String)properties.get(ConfigurationEntry.SERVER_NODEID.getConfigKey());
            String string6 = (String)properties.get(ConfigurationEntry.SERVER_HTTP_TUNNEL_RPC_URL.getConfigKey());
            String string7 = (String)properties.get(ConfigurationEntry.SERVER_WEB_URL.getConfigKey());
            this.logInfo("Loaded " + properties.size() + " config entries from " + string + " network ID: " + string2);
            if (StringUtils.isBlank(string4)) {
                throw new IOException("Hostname not found");
            }
            String string8 = this.getController().getMySelf().getInfo().networkId;
            this.getController().getMySelf().getInfo().networkId = StringUtils.isNotBlank(string2) ? string2 : ConfigurationEntry.NETWORK_ID.getDefaultValue();
            String string9 = this.isFederatedLogin() ? "ANY" : this.getController().getMySelf().getInfo().networkId;
            boolean bl2 = bl = !Util.equals(string8, string9);
            if (bl) {
                this.getController().getNodeManager().shutdown();
            }
            this.init(this.getController(), this.config, string3, string4, string5, this.allowServerChange, this.updateConfig);
            this.setServerWebURLInConfig(string7);
            this.setServerHTTPTunnelURLInConfig(string6);
            this.setServerInConfig(this.getServer().getInfo());
            ConfigurationEntry.NETWORK_ID.setValue(this.config, string9);
            ConfigurationEntry.CONFIG_URL.setValue(this.config, string);
            this.getController().saveConfig();
            if (bl) {
                this.getController().getNodeManager().start();
            }
            this.connectHostingServers(true);
        }
        catch (Exception exception) {
            this.logWarning("Could not load connection infos from " + string + ": " + exception.getMessage());
        }
    }

    public void loadServerNodes() {
        if (!ConfigurationEntry.SERVER_LOAD_NODES.getValueBoolean(this.getController()).booleanValue()) {
            return;
        }
        String string = this.getWebURL(SERVER_NODES_URI, false);
        String string2 = this.getWebURL(SERVER_PUBLIC_KEYS_URI, false);
        NodeList nodeList = null;
        if (StringUtils.isNotBlank(string)) {
            try {
                nodeList = this.loadNodesFrom(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                this.logWarning(malformedURLException.toString());
            }
        }
        if (StringUtils.isNotBlank(string2)) {
            boolean bl;
            if (nodeList != null) {
                bl = true;
                for (MemberInfo memberInfo : nodeList.getServersSet()) {
                    Boolean bl2 = this.cachedServerPublicKey.getValidEntry(memberInfo);
                    bl &= bl2 != null && bl2 != false;
                    if (memberInfo.getConnectAddress() != null) continue;
                    this.logWarning("Server has empty hostname: " + memberInfo);
                }
            } else {
                bl = false;
            }
            if (!bl) {
                try {
                    this.loadPublicKeysFrom(new URL(string2));
                }
                catch (Exception exception) {
                    this.logWarning(exception.toString(), exception);
                }
            }
        }
    }

    private NodeList loadNodesFrom(URL uRL) {
        try {
            NodeList nodeList = new NodeList();
            nodeList.load(uRL);
            this.logFine("I know " + nodeList.getServersSet().size() + " servers from cluster @ " + uRL + " : " + nodeList.getServersSet());
            if (this.processNodeList(nodeList)) {
                return nodeList;
            }
        }
        catch (IOException iOException) {
            this.logWarning("Unable to load servers from url '" + uRL + "'. " + iOException.getMessage());
            this.logFiner("IOException", iOException);
        }
        catch (ClassCastException classCastException) {
            this.logWarning("Illegal format of servers url '" + uRL);
            this.logFiner("ClassCastException", classCastException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logWarning("Illegal format of servers files '" + uRL);
            this.logFiner("ClassNotFoundException", classNotFoundException);
        }
        return null;
    }

    private boolean processNodeList(NodeList nodeList) {
        this.getController().getNodeManager().queueNewNodes(nodeList.getNodeList().toArray(new MemberInfo[0]));
        for (MemberInfo iterator : nodeList.getFriendsSet()) {
            Member member = iterator.getNode(this.getController(), true);
            member.setFriend(true, null);
        }
        CopyOnWriteArrayList copyOnWriteArrayList = new CopyOnWriteArrayList();
        for (MemberInfo memberInfo : nodeList.getServersSet()) {
            Member member = memberInfo.getNode(this.getController(), true);
            member.updateInfo(memberInfo, true);
            member.setServer(true);
            copyOnWriteArrayList.add(member);
            if (!this.isInfo() || this.servers.contains(member)) continue;
            this.logFine("Added server: " + member);
        }
        for (Member member : this.servers) {
            if (copyOnWriteArrayList.contains(member) || this.isPrimaryServer(member)) continue;
            member.setServer(false);
            this.logFine("Removed server: " + member);
        }
        this.servers = copyOnWriteArrayList;
        return !nodeList.isEmpty();
    }

    private boolean loadPublicKeysFrom(URL uRL) {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(uRL.openStream());
            ArrayList arrayList = new ArrayList((ArrayList)objectInputStream.readObject());
            if (this.isFine()) {
                this.logFine("Received " + arrayList.size() + " server keys from cluster @ " + uRL);
            }
            boolean bl = true;
            for (Pair pair : arrayList) {
                MemberInfo memberInfo = (MemberInfo)pair.getFirst();
                PublicKey publicKey = (PublicKey)pair.getSecond();
                if (ProUtil.addNodeToKeyStore(this.getController(), memberInfo, publicKey)) {
                    this.cachedServerPublicKey.put(memberInfo, Boolean.TRUE);
                    continue;
                }
                this.cachedServerPublicKey.put(memberInfo, Boolean.FALSE);
                bl = false;
            }
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logInfo("Unable to load public keys from " + uRL.toString() + ". Server does not support sending public keys.");
        }
        catch (IOException | ClassCastException | ClassNotFoundException exception) {
            this.logWarning("Unable to load public keys from " + uRL.toString() + ". " + exception);
        }
        return false;
    }

    public boolean isLoggingIn() {
        return this.loggingIn.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForLoginComplete() {
        Object object = this.loginLock;
        synchronized (object) {
        }
    }

    public boolean isLoggedIn() {
        return this.getAccount() != null && this.getAccount().isValid();
    }

    public boolean isLoginExecuted() {
        return this.loginExecuted.get();
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isPasswordEmpty() {
        return StringUtils.isBlank(this.passwordObf);
    }

    public boolean isPasswordRequired() {
        return !this.hasCredentials();
    }

    public char[] getPassword() {
        return LoginUtil.deobfuscate(this.passwordObf);
    }

    public String getWebDAVToken() {
        return this.webdavToken;
    }

    public String getDeviceToken() {
        return this.tokenSecret;
    }

    public String getPasswordClearText() {
        if (this.isTokenLogin()) {
            this.logWarning("Token based authentication doesn't allow clear text passwords", new StackDump());
        }
        char[] cArray = LoginUtil.deobfuscate(this.passwordObf);
        String string = Util.toString(cArray);
        LoginUtil.clear(cArray);
        return string;
    }

    public AccountInfo getAccountInfo() {
        Account account = this.getAccount();
        return account != null && account.isValid() ? account.createInfo() : null;
    }

    public Account getAccount() {
        return this.accountDetails != null ? this.accountDetails.getAccount() : null;
    }

    public AccountDetails getAccountDetails() {
        return this.accountDetails;
    }

    public void refreshAccountDetails(boolean bl) {
        try {
            this.refreshAccountDetails();
        }
        catch (RemoteCallException remoteCallException) {
            this.logWarning("Unable to refresh account details from " + this.getServerString() + ". " + remoteCallException);
            this.logFiner(remoteCallException);
        }
        if (bl) {
            for (ServerClient serverClient : this.childClients.values()) {
                try {
                    if (!serverClient.isConnected()) continue;
                    serverClient.refreshAccountDetails(false);
                }
                catch (RemoteCallException remoteCallException) {
                    this.logWarning("Unable to refresh account details from " + this.getServerString() + ". " + remoteCallException);
                    this.logFiner(remoteCallException);
                }
            }
        }
    }

    public AccountDetails refreshAccountDetails() {
        AccountDetails accountDetails = this.securityService.getAccountDetails();
        if (accountDetails != null) {
            this.accountDetails = accountDetails;
            this.fireAccountUpdates(this.accountDetails);
            this.updateLocalSettings(this.accountDetails);
        } else {
            this.setAnonAccount();
            this.fireLogin(this.accountDetails, false);
        }
        if (this.isFine()) {
            this.logFine("Refreshed " + this.accountDetails);
        }
        return this.accountDetails;
    }

    private void updateLocalSettings(AccountDetails accountDetails) {
        Account account = accountDetails.getAccount();
        this.updateServer(account);
        this.updateFriendsList(account);
        if (this.updateFolders) {
            this.getController().getFolderRepository().updateFolders(accountDetails);
        }
        this.scheduleConnectHostingServers();
        if (!account.getTokens().isEmpty() && !this.getMySelf().isServer()) {
            this.getController().getNodeManager().setNetworkId("ANY");
        }
        this.updateChildClients(account);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateChildClients(Account account) {
        Map<ServerInfo, ServerClient> map = this.childClients;
        synchronized (map) {
            Object object;
            HashMap<ServerInfo, ServerClient> hashMap = new HashMap<ServerInfo, ServerClient>(this.childClients);
            for (ServerInfo serverInfo : account.getTokens().keySet()) {
                ServerClient serverClient;
                object = account.getToken(serverInfo);
                if (Token.isExpired((String)object)) continue;
                if (this.childClients.containsKey(serverInfo)) {
                    serverClient = this.childClients.get(serverInfo);
                    hashMap.remove(serverInfo);
                    if (((String)object).equals(serverClient.getDeviceToken())) continue;
                    this.logInfo("Using new token for " + serverInfo);
                    ConfigurationEntry.SERVER_CONNECT_TOKEN.setValue(serverClient.config, (String)object);
                    serverClient.login((String)object);
                    continue;
                }
                if (this.isFine()) {
                    this.logFine("Starting connect to " + serverInfo);
                }
                if ((serverClient = this.createNewFedClient(serverInfo, (String)object)) == null) {
                    if (!this.spawnRetrying) {
                        this.spawnRetrying = true;
                        this.getController().schedule(() -> {
                            if (!this.getAccount().equals(account)) {
                                return;
                            }
                            this.logInfo("Retry connection to federated services");
                            this.spawnRetrying = false;
                            this.updateChildClients(account);
                        }, 600000L);
                    }
                    return;
                }
                serverClient.loadServerNodes();
                serverClient.start();
                this.childClients.put(serverInfo, serverClient);
                hashMap.remove(serverInfo);
                this.fireChildClientSpawned(serverClient);
                serverClient.loginWithLastKnown();
            }
            for (ServerInfo serverInfo : hashMap.keySet()) {
                object = (ServerClient)hashMap.get(serverInfo);
                if (this.isInfo()) {
                    this.logInfo("Logging out from " + ((ServerClient)object).getServer());
                }
                try {
                    ((ServerClient)object).logout();
                }
                catch (RuntimeException runtimeException) {
                    this.logWarning("Unable to logout from " + ((ServerClient)object).getServer() + ". " + runtimeException);
                }
                this.childClients.remove(serverInfo);
            }
        }
    }

    private ServerClient createNewFedClient(ServerInfo serverInfo, String string) {
        Reject.ifNull(serverInfo, "Service is null");
        Reject.ifBlank(string, "Token missing");
        String string2 = serverInfo.getWebUrl() + "/client_deployment/Default.config";
        try {
            Properties properties = ConfigurationLoader.loadPreConfiguration(string2);
            if (StringUtils.isNotBlank(this.getUsername())) {
                ConfigurationEntry.SERVER_CONNECT_USERNAME.setValue(properties, this.getUsername());
            }
            ConfigurationEntry.SERVER_CONNECT_TOKEN.setValue(properties, string);
            ConfigurationEntry.SERVER_FEDERATED_LOGIN.setValue(properties, false);
            ServerClient serverClient = new ServerClient(this.getController(), properties);
            serverClient.updateFolders = false;
            return serverClient;
        }
        catch (IOException iOException) {
            this.logWarning("Unable to connect to " + serverInfo + ". " + iOException);
            return null;
        }
    }

    private void updateServer(Account account) {
        boolean bl;
        boolean bl2;
        final ServerInfo serverInfo = account.getServer();
        if (serverInfo == null || !this.allowServerChange || serverInfo.isFederatedService()) {
            return;
        }
        boolean bl3 = bl2 = !this.server.getInfo().equals(serverInfo.getNode());
        if (!bl2) {
            return;
        }
        final Member member = serverInfo.getNode().getNode(this.getController(), true);
        boolean bl4 = bl = this.currentlyHammeringServers() || !member.isConnected();
        if (!bl) {
            this.logInfo("Switching from " + this.server.getNick() + " to " + member.getNick());
            this.changeToServer(serverInfo);
        } else {
            if (this.currentlyHammeringServers()) {
                this.logInfo("Switching from " + this.server.getNick() + " to " + member.getNick() + " in 30s");
            } else {
                this.logInfo("Switching from " + this.server.getNick() + " to " + member.getNick() + " after connect");
                member.markForImmediateConnect();
            }
            Waiter waiter = new Waiter(30000L);
            while (!waiter.isTimeout()) {
                try {
                    waiter.waitABit();
                }
                catch (Exception exception) {
                    return;
                }
                if (this.currentlyHammeringServers() || !member.isConnected()) continue;
            }
        }
        if (bl) {
            this.getController().getIOProvider().startIO(new Runnable(){

                @Override
                public void run() {
                    if (!member.isConnected()) {
                        if (!ServerClient.this.isConnected()) {
                            ServerClient.this.logWarning("Unable to connect to server: " + member.getNick() + ". Searching for alternatives...");
                            ServerClient.this.findAlternativeServer();
                        }
                    } else {
                        boolean bl;
                        boolean bl2 = bl = !ServerClient.this.server.getInfo().equals(serverInfo.getNode());
                        if (bl) {
                            ServerClient.this.changeToServer(serverInfo);
                        }
                    }
                }
            });
        }
    }

    private void updateFriendsList(Account account) {
        for (MemberInfo memberInfo : account.getDevices()) {
            Member member = memberInfo.getNode(this.getController(), true);
            if (member.isFriend()) continue;
            member.setFriend(true, null);
        }
    }

    public <T> T getService(Class<T> clazz) {
        return RemoteServiceStubFactory.createRemoteStub(this.getController(), clazz, this.server, this.throwableHandler);
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public SecurityService getSecurityService(FolderInfo folderInfo) {
        Member member = this.findConnectedServerFor(folderInfo);
        if (member == null) {
            return this.securityService;
        }
        return RemoteServiceStubFactory.createRemoteStub(this.getController(), SecurityService.class, member, this.throwableHandler);
    }

    public AccountService getAccountService() {
        return this.userService;
    }

    public FolderService getFolderService() {
        return this.folderService;
    }

    public FolderService getFolderService(FolderInfo folderInfo) {
        Member member = this.findConnectedServerFor(folderInfo);
        if (member == null) {
            if (this.isFine()) {
                this.logFine(folderInfo + ": getFolderService: no connected server found");
            }
            return this.folderService;
        }
        if (this.isFine()) {
            this.logFine(folderInfo + ": getFolderService: connected to " + member);
        }
        return RemoteServiceStubFactory.createRemoteStub(this.getController(), FolderService.class, member, this.throwableHandler);
    }

    private Member findConnectedServerFor(FolderInfo folderInfo) {
        for (Member member : this.getController().getNodeManager().getNodesAsCollection()) {
            boolean bl;
            if (!member.isServer() || !member.isCompletelyConnected()) continue;
            Folder folder = folderInfo.getFolder(this.getController());
            boolean bl2 = bl = folder != null && folder.hasMember(member);
            if (bl || member.hasCompleteFileListFor(folderInfo)) {
                return member;
            }
            if (member.getLastFolderList() == null || !member.getLastFolderList().contains(folderInfo)) continue;
            return member;
        }
        return null;
    }

    public List<Folder> getJoinedCloudFolders() {
        ArrayList<Folder> arrayList = new ArrayList<Folder>();
        for (Folder folder : this.getController().getFolderRepository().getFolders()) {
            if (!this.joinedByCloud(folder)) continue;
            arrayList.add(folder);
        }
        return arrayList;
    }

    public Collection<FolderInfo> getAccountFolders() {
        return this.getAccount().getFolders();
    }

    public boolean joinedByCloud(Folder folder) {
        if (folder.hasMember(this.server)) {
            return true;
        }
        for (Member member : this.servers) {
            if (!folder.hasMember(member)) continue;
            return true;
        }
        for (Member member : folder.getMembersAsCollection()) {
            if (!member.isServer()) continue;
            return true;
        }
        return false;
    }

    public boolean joinedByServer(FolderInfo folderInfo) {
        Folder folder = folderInfo.getFolder(this.getController());
        if (folder != null) {
            return this.joinedByCloud(folder);
        }
        for (Member member : this.servers) {
            FolderList folderList = member.getLastFolderList();
            ConnectionHandler connectionHandler = member.getPeer();
            if (connectionHandler == null || folderList == null || !(member.getPeer().getMember().getProtocolVersion() < 112 ? folderList.contains(folderInfo, connectionHandler.getMyMagicId()) : folderList.contains(folderInfo))) continue;
            return true;
        }
        return false;
    }

    private void scheduleConnectHostingServers() {
        boolean bl = this.currentlyHammeringServers();
        if (bl) {
            this.logWarning("Detected hammering of server/cluster. Throttling reconnect speed. Next try in 30s");
        }
        this.getController().schedule(new HostingServersConnector(), bl ? 30000L : 1000L);
    }

    private void connectHostingServers(boolean bl) {
        if (!(this.isConnected() || this.isLoggingIn() || this.isLoggedIn())) {
            this.findAlternativeServer();
            return;
        }
        if (this.isFiner()) {
            this.logFiner("Connecting to cluster servers");
        }
        if (bl) {
            this.getController().getIOProvider().startIO(() -> this.retrieveAndConnectoClusterServers());
        } else {
            this.retrieveAndConnectoClusterServers();
        }
    }

    private void retrieveAndConnectoClusterServers() {
        try {
            Collection<Object> collection;
            if (!this.isConnected()) {
                this.loadServerNodes();
                return;
            }
            if (!this.isLoggedIn()) {
                return;
            }
            Collection<FolderInfo> collection2 = this.getController().getFolderRepository().getJoinedFolderInfos();
            FolderInfo[] folderInfoArray = collection2.toArray(new FolderInfo[0]);
            if (collection2.size() < 1000) {
                collection = this.getFolderService().getHostingServers(folderInfoArray);
            } else {
                collection = new ArrayList();
                for (Member object : this.getServersInCluster()) {
                    collection.add(object.getInfo());
                }
            }
            if (this.isFine()) {
                this.logFine("Got " + collection.size() + " servers for our " + folderInfoArray.length + " folders: " + collection);
            }
            for (MemberInfo memberInfo : collection) {
                Member member = memberInfo.getNode(this.getController(), false);
                if (member == null) {
                    this.loadServerNodes();
                    member = memberInfo.getNode(this.getController(), false);
                    if (member == null) {
                        this.logWarning("Unable to retrieve new server certificate for " + memberInfo);
                        member = memberInfo.getNode(this.getController(), true);
                    }
                }
                member.updateInfo(memberInfo);
                member.setServer(true);
                if (member.isConnected() || member.isConnecting() || member.equals(this.server)) continue;
                member.markForImmediateConnect();
            }
        }
        catch (Exception exception) {
            this.logWarning("Unable to retrieve servers of cluster." + exception);
        }
    }

    public void setServerInConfig(MemberInfo memberInfo) {
        Reject.ifNull(memberInfo, "Server is null");
        ConfigurationEntry.SERVER_NAME.setValue(this.config, memberInfo.nick);
        Object object = memberInfo.getConnectAddress().getHostName();
        if (memberInfo.getConnectAddress().getPort() != 1337) {
            object = (String)object + ":";
            object = (String)object + memberInfo.getConnectAddress().getPort();
        }
        ConfigurationEntry.SERVER_HOST.setValue(this.config, (String)object);
        if (ServerClient.isTempServerNode(memberInfo)) {
            ConfigurationEntry.SERVER_NODEID.removeValue(this.config);
        } else {
            ConfigurationEntry.SERVER_NODEID.setValue(this.config, memberInfo.id);
        }
    }

    public boolean setServerWebURLInConfig(String string) {
        String string2 = ConfigurationEntry.SERVER_WEB_URL.getValue(this.config);
        if (Util.equals(string2, string)) {
            return false;
        }
        if (StringUtils.isBlank(string)) {
            ConfigurationEntry.SERVER_WEB_URL.removeValue(this.config);
        } else {
            ConfigurationEntry.SERVER_WEB_URL.setValue(this.config, string);
        }
        return true;
    }

    public String getHTTPTunnelURL() {
        return ConfigurationEntry.SERVER_HTTP_TUNNEL_RPC_URL.getValue(this.config);
    }

    private boolean setServerHTTPTunnelURLInConfig(String string) {
        this.logFine("New tunnel URL: " + string);
        String string2 = ConfigurationEntry.SERVER_HTTP_TUNNEL_RPC_URL.getValue(this.config);
        if (Util.equals(string2, string)) {
            return false;
        }
        if (this.getMySelf().isServer()) {
            return false;
        }
        if (StringUtils.isBlank(string)) {
            ConfigurationEntry.SERVER_HTTP_TUNNEL_RPC_URL.removeValue(this.config);
        } else {
            ConfigurationEntry.SERVER_HTTP_TUNNEL_RPC_URL.setValue(this.config, string);
        }
        return true;
    }

    public void addListener(ServerClientListener serverClientListener) {
        ListenerSupportFactory.addListener(this.listenerSupport, serverClientListener);
    }

    public void addWeakListener(ServerClientListener serverClientListener) {
        ListenerSupportFactory.addListener(this.listenerSupport, serverClientListener, true);
    }

    public void removeListener(ServerClientListener serverClientListener) {
        ListenerSupportFactory.removeListener(this.listenerSupport, serverClientListener);
    }

    private void setNewServerNode(Member member) {
        boolean bl;
        if (this.server != null && member != null) {
            boolean bl2 = bl = !this.server.equals(member);
            if (bl) {
                if (this.recentServerSwitch != null && System.currentTimeMillis() - this.recentServerSwitch.getTime() > 10000L) {
                    this.recentServerSwitches = 0;
                }
                this.recentServerSwitch = new Date();
                ++this.recentServerSwitches;
            }
        }
        bl = this.server == null;
        this.server = member;
        this.server.setServer(true);
        if (bl) {
            this.logFine("New primary server: " + this.server.getNick());
        } else {
            this.logInfo("New primary server: " + this.server.getNick());
        }
        this.initializeServiceStubs();
    }

    private boolean currentlyHammeringServers() {
        return this.recentServerSwitch != null && System.currentTimeMillis() - this.recentServerSwitch.getTime() <= 10000L && this.recentServerSwitches >= 20;
    }

    private void initializeServiceStubs() {
        this.securityService = this.getService(SecurityService.class);
        this.userService = this.getService(AccountService.class);
        this.folderService = this.getService(FolderService.class);
        this.publicKeyService = this.getService(PublicKeyService.class);
    }

    private void setAnonAccount() {
        this.accountDetails = new AccountDetails(new AnonymousAccount(), 0L, 0L, null);
    }

    private void saveLastKnowLogin(String string, String string2) {
        if (StringUtils.isNotBlank(string)) {
            ConfigurationEntry.SERVER_CONNECT_USERNAME.setValue(this.config, string);
        } else {
            ConfigurationEntry.SERVER_CONNECT_USERNAME.removeValue(this.config);
        }
        if (this.isKeepLoggedIn() && StringUtils.isNotBlank(string2)) {
            ConfigurationEntry.SERVER_CONNECT_PASSWORD.setValue(this.config, string2);
        } else {
            ConfigurationEntry.SERVER_CONNECT_PASSWORD.removeValue(this.config);
        }
        if (this.config == this.getController().getConfig()) {
            this.getController().saveConfig();
        }
    }

    private void changeToServer(ServerInfo serverInfo) {
        Object object;
        this.logFine("Changing server to " + serverInfo.getNode());
        if (ProUtil.isRunningProVersion() && ProUtil.getPublicKey(this.getController(), serverInfo.getNode()) == null) {
            try {
                object = this.publicKeyService.getPublicKey(serverInfo.getNode());
                if (object != null) {
                    this.logFine("Retrieved new key for server " + serverInfo.getNode() + ". " + (PublicKey)object);
                    ProUtil.addNodeToKeyStore(this.getController(), serverInfo.getNode(), (PublicKey)object);
                }
            }
            catch (RuntimeException runtimeException) {
                this.logWarning("Not changing server. Unable to retrieve new server key for " + serverInfo.getName() + ". " + runtimeException);
                return;
            }
        }
        object = serverInfo.getNode().getNode(this.getController(), true);
        if (this.updateConfig) {
            if (serverInfo.getNode().getConnectAddress() != null) {
                this.setServerInConfig(serverInfo.getNode());
            } else {
                this.setServerInConfig(((Member)object).getInfo());
            }
            this.setServerWebURLInConfig(serverInfo.getWebUrl());
            this.setServerHTTPTunnelURLInConfig(serverInfo.getHTTPTunnelUrl());
            this.getController().saveConfig();
        }
        this.setNewServerNode((Member)object);
        if (!this.isConnected()) {
            this.server.markForImmediateConnect();
            Waiter waiter = new Waiter(1000L);
            while (!waiter.isTimeout() && !this.isConnected()) {
                waiter.waitABit();
            }
            if (this.isConnected() && this.isFine()) {
                this.logFine("Connect success to " + this.server.getNick());
            }
        }
        this.login0(this.username, this.passwordObf, this.tokenSecret);
    }

    private void fireLogin(AccountDetails accountDetails) {
        this.fireLogin(accountDetails, true);
    }

    private void fireLogin(AccountDetails accountDetails, boolean bl) {
        this.listenerSupport.login(new ServerClientEvent(this, accountDetails, bl));
    }

    private void fireAccountUpdates(AccountDetails accountDetails) {
        this.listenerSupport.accountUpdated(new ServerClientEvent(this, accountDetails));
    }

    private void fireChildClientSpawned(ServerClient serverClient) {
        this.listenerSupport.childClientSpawned(new ServerClientEvent(serverClient));
    }

    public boolean showServerInfo() {
        if (this.getController().getDistribution().isBrandedClient()) {
            return false;
        }
        boolean bl = this.isPowerFolderCloud();
        boolean bl2 = ConfigurationEntry.CONFIG_PROMPT_SERVER_IF_PF_COM.getValueBoolean(this.config);
        return bl2 || !bl;
    }

    public String getServerString() {
        Object object;
        if (this.server != null) {
            if (this.server.isMySelf()) {
                object = "myself";
            } else {
                InetSocketAddress inetSocketAddress = this.server.getReconnectAddress();
                object = inetSocketAddress != null ? (inetSocketAddress.getAddress() != null ? NetworkUtil.getHostAddressNoResolve(inetSocketAddress.getAddress()) : inetSocketAddress.getHostName()) : "";
                if (inetSocketAddress != null && inetSocketAddress.getPort() != 1337) {
                    object = (String)object + ":" + inetSocketAddress.getPort();
                }
            }
        } else {
            object = "";
        }
        if (this.hasWebURL()) {
            return this.getWebURL();
        }
        if (StringUtils.isNotBlank((String)object)) {
            return "pf://" + (String)object;
        }
        return "n/a";
    }

    public String toString() {
        return "ServerClient " + (this.username != null ? this.username : "?") + "@" + (String)(this.server != null ? this.server.getNick() + "(" + this.server.getReconnectAddress() + ")" : "n/a");
    }

    public void primaryServerConnected(Member member) {
        ConnectionHandler connectionHandler = member.getPeer();
        Identity identity = connectionHandler != null ? connectionHandler.getIdentity() : null;
        boolean bl = this.supportsQuickLogin = identity != null && identity.isSupportsQuickLogin();
        if (this.supportsQuickLogin) {
            if (this.isFiner()) {
                this.logFiner("Quick login at server supported");
            }
            this.primaryServerConnected0(member);
        } else {
            this.logFine("Quick login at server NOT supported. Using regular login");
        }
    }

    private void primaryServerConnected0(Member member) {
        if (ServerClient.isTempServerNode(this.server)) {
            Member member2 = this.server;
            this.setNewServerNode(member);
            this.getController().getNodeManager().removeNode(member2);
            if (this.updateConfig) {
                this.setServerInConfig(this.server.getInfo());
                this.getController().saveConfig();
            }
            this.logInfo("Got connect to server: " + this.server + " nodeid: " + this.server.getId());
        }
        this.listenerSupport.serverConnected(new ServerClientEvent(this, member));
        if (this.hasUsername() && this.hasCredentials()) {
            try {
                this.login0(this.username, this.passwordObf, this.tokenSecret);
                this.scheduleConnectHostingServers();
            }
            catch (Exception exception) {
                this.logWarning("Unable to login. " + exception);
                this.logFine(exception);
            }
        }
        if (ConfigurationEntry.SYNC_AND_EXIT.getValueBoolean(this.getController()).booleanValue()) {
            this.getController().performFullSync();
            this.getController().exitAfterSync(60);
        }
    }

    private boolean isFederatedLogin() throws RemoteCallException {
        return ConfigurationEntry.SERVER_FEDERATION_ENABLED.getValueBoolean(this.config) != false && ConfigurationEntry.SERVER_FEDERATED_LOGIN.getValueBoolean(this.config) != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean federatedLoginSuccess() {
        String string;
        Object object;
        String string2 = ConfigurationEntry.SERVER_IDP_LAST_CONNECTED_ECP.getValue(this.getController());
        if (StringUtils.isNotBlank(string2) && !SAML_EXTERNAL_NON_SAML_USERS.equals(string2)) {
            return true;
        }
        try {
            object = this.securityService.getHostingService(this.username);
            if (object == null) {
                return false;
            }
            string = ((ServerInfo)object).getWebUrl();
        }
        catch (RemoteCallException remoteCallException) {
            this.logWarning(this.server + " Problem while retrieving target service in federation: " + remoteCallException);
            return false;
        }
        object = ConfigurationEntry.SERVER_WEB_URL.getValue(this.getController());
        if (StringUtils.isNotBlank(string) && string.equals(object)) {
            return true;
        }
        if (StringUtils.isNotBlank(string) && !string.equals(object)) {
            this.logInfo("Federated login: Starting AccountDiscovery ...");
            this.loadConfigURL(string);
            Object object2 = this.childClients;
            synchronized (object2) {
                if (!this.childClients.isEmpty()) {
                    for (ServerClient serverClient : this.childClients.values()) {
                        serverClient.logout();
                    }
                }
            }
            this.server.markForImmediateConnect();
            object2 = new Waiter(5000L);
            while (!((Waiter)object2).isTimeout() && !this.isConnected()) {
                ((Waiter)object2).waitABit();
            }
            ConfigurationEntry.SERVER_WEB_URL.setValue(this.getController(), string);
            this.getController().saveConfig();
            if (this.isConnected()) {
                this.logInfo("Successfully connected to federation service " + string + " / " + this.server.getNick());
            }
            return true;
        }
        this.logWarning("Federated login failed! Can't find hosting service for account " + this.username);
        return false;
    }

    private class MyThrowableHandler
    implements ThrowableHandler {
        private int loginProblems;

        private MyThrowableHandler() {
        }

        @Override
        public void handle(Throwable throwable) {
            if (throwable instanceof NotLoggedInException) {
                this.autoLogin(throwable);
            } else if (throwable instanceof SecurityException && throwable.getMessage() != null && throwable.getMessage().toLowerCase().contains("not logged")) {
                this.autoLogin(throwable);
            }
        }

        private void autoLogin(Throwable throwable) {
            if (!(ServerClient.this.hasUsername() && ServerClient.this.hasCredentials() && ServerClient.this.isConnected())) {
                return;
            }
            ++this.loginProblems;
            if (this.loginProblems > 20) {
                ServerClient.this.logFine("Got " + this.loginProblems + " login problems. Not longer auto-logging in to prevent hammering server.");
                return;
            }
            ServerClient.this.logInfo("Auto-login for " + ServerClient.this.username + " required to " + ServerClient.this.getServer() + ". Caused by " + throwable);
            try {
                ServerClient.this.login0(ServerClient.this.username, ServerClient.this.passwordObf, ServerClient.this.tokenSecret);
            }
            catch (Exception exception) {
                ServerClient.this.logWarning("Unable to login with " + ServerClient.this.username + " at " + ServerClient.this.getServerString() + ". " + exception);
            }
        }
    }

    private class MyNodeManagerListener
    extends NodeManagerAdapter {
        private MyNodeManagerListener() {
        }

        @Override
        public void settingsChanged(NodeManagerEvent nodeManagerEvent) {
            if (ServerClient.this.isClusterServer(nodeManagerEvent.getNode())) {
                ServerClient.this.logInfo("Discovered new server of cluster(" + ServerClient.this.servers.size() + "): " + nodeManagerEvent.getNode().getNick() + " @ " + nodeManagerEvent.getNode().getReconnectAddress());
            }
            ServerClient.this.listenerSupport.nodeServerStatusChanged(new ServerClientEvent(ServerClient.this, nodeManagerEvent.getNode()));
        }

        @Override
        public void nodeConnected(NodeManagerEvent nodeManagerEvent) {
            if (ServerClient.this.isClusterServer(nodeManagerEvent.getNode()) && !ServerClient.this.isConnected()) {
                ServerClient.this.findAlternativeServer();
            }
            if (ServerClient.this == ServerClient.this.getController().getOSClient() && ServerClient.this.supportsQuickLogin) {
                return;
            }
            if (ServerClient.this.isPrimaryServer(nodeManagerEvent.getNode())) {
                ServerClient.this.primaryServerConnected0(nodeManagerEvent.getNode());
            }
        }

        @Override
        public void nodeDisconnected(NodeManagerEvent nodeManagerEvent) {
            if (ServerClient.this.isPrimaryServer(nodeManagerEvent.getNode())) {
                ServerClient.this.findAlternativeServer();
                ServerClient.this.setAnonAccount();
                ServerClient.this.listenerSupport.serverDisconnected(new ServerClientEvent(ServerClient.this, nodeManagerEvent.getNode()));
            }
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }
    }

    private class MyFolderRepositoryListener
    extends FolderRepositoryAdapter {
        private MyFolderRepositoryListener() {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }

        @Override
        public void folderCreated(FolderRepositoryEvent folderRepositoryEvent) {
            if (!ServerClient.this.getController().isStarted()) {
                return;
            }
            if (!ConfigurationEntry.SERVER_CONNECT.getValueBoolean(ServerClient.this.getController()).booleanValue()) {
                return;
            }
            ServerClient.this.connectHostingServers(true);
        }

        @Override
        public void folderMoved(FolderRepositoryEvent folderRepositoryEvent) {
            this.folderCreated(folderRepositoryEvent);
        }
    }

    private class ServerConnectTask
    extends TimerTask {
        private ServerConnectTask() {
        }

        @Override
        public void run() {
            if (ServerClient.this.isConnected()) {
                return;
            }
            if (ServerClient.this.server.isMySelf()) {
                return;
            }
            boolean bl = ConfigurationEntry.SERVER_CONNECT_FROM_LAN_TO_INTERNET.getValueBoolean(ServerClient.this.config);
            if (!bl && ServerClient.this.getController().isLanOnly() && !ServerClient.this.server.isOnLAN()) {
                ServerClient.this.logFiner("NOT connecting to server: " + ServerClient.this.server + ". Reason: Server not on LAN");
                return;
            }
            if (!ServerClient.this.getController().getNodeManager().isStarted() || !ServerClient.this.getController().getReconnectManager().isStarted()) {
                return;
            }
            if (ServerClient.this.server.isConnecting() || ServerClient.this.server.isConnected()) {
                return;
            }
            ServerClient.this.server.markForImmediateConnect();
            if (ServerClient.this.server.isUnableToConnect()) {
                ServerClient.this.findAlternativeServer();
            }
        }
    }

    private class AutoLoginTask
    extends TimerTask {
        private AutoLoginTask() {
        }

        @Override
        public void run() {
            if (!ServerClient.this.isConnected()) {
                return;
            }
            if (ServerClient.this.isLoggingIn()) {
                return;
            }
            if (!ServerClient.this.lastLoginSuccessful.get()) {
                return;
            }
            try {
                if (ServerClient.this.hasUsername() && ServerClient.this.hasCredentials()) {
                    if (ServerClient.this.isLoggedIn() && ServerClient.this.securityService.isLoggedIn()) {
                        return;
                    }
                    ServerClient.this.logInfo("Auto-Login: Logging in " + ServerClient.this.username);
                    ServerClient.this.login0(ServerClient.this.username, ServerClient.this.passwordObf, ServerClient.this.tokenSecret);
                }
            }
            catch (RemoteCallException remoteCallException) {
                ServerClient.this.logWarning("Unable to automatically login at: " + ServerClient.this.username + " @ " + ServerClient.this.getServerString() + ". " + remoteCallException);
            }
        }
    }

    private class HostingServersConnector
    extends TimerTask {
        private HostingServersConnector() {
        }

        @Override
        public void run() {
            ServerClient.this.connectHostingServers(false);
        }
    }

    private class ServiceTicketGenerator
    implements PrivilegedExceptionAction<byte[]> {
        private ServiceTicketGenerator() {
        }

        @Override
        public byte[] run() {
            try {
                Oid oid = new Oid("1.2.840.113554.1.2.2");
                GSSManager gSSManager = GSSManager.getInstance();
                GSSName gSSName = gSSManager.createName(ServerClient.this.username, GSSName.NT_USER_NAME);
                GSSName gSSName2 = gSSManager.createName(ConfigurationEntry.KERBEROS_SSO_SERVICE_NAME.getValue(ServerClient.this.config) + "@" + ConfigurationEntry.KERBEROS_SSO_REALM.getValue(ServerClient.this.config), null);
                GSSCredential gSSCredential = gSSManager.createCredential(gSSName, 28800, oid, 1);
                GSSContext gSSContext = gSSManager.createContext(gSSName2, oid, gSSCredential, 0);
                byte[] byArray = gSSContext.initSecContext(new byte[0], 0, 0);
                gSSContext.dispose();
                return byArray;
            }
            catch (Exception exception) {
                ServerClient.this.logWarning(exception);
                return null;
            }
        }
    }
}

