/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.clientserver;

import de.dal33t.powerfolder.clientserver.FileLinkFilterModel;
import de.dal33t.powerfolder.clientserver.SendInvitationEmail;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.domain.FileLink;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.FolderStatisticInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.message.Invitation;
import de.dal33t.powerfolder.security.Account;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.util.ArchiveMode;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public interface FolderService {
    public void createFolder(FolderInfo var1);

    public void createFolder(FolderInfo var1, SyncProfile var2);

    public void createFolder(FolderInfo var1, SyncProfile var2, Path var3, boolean var4);

    public void removeFolder(FolderInfo var1, boolean var2);

    public void removeFolder(FolderInfo var1, boolean var2, boolean var3);

    public void leaveFolder(FolderInfo var1);

    public void replicateFolder(FolderInfo var1, int var2, boolean var3);

    public boolean renameFolder(FolderInfo var1, String var2);

    @Deprecated
    public void inviteUser(Invitation var1, String var2);

    public Invitation createInvitation(FolderPermission var1);

    public void sendInvitationEmail(SendInvitationEmail var1);

    public void sendInvitationEmail(SendInvitationEmail var1, boolean var2);

    public void sendInvitation(Invitation var1, boolean var2);

    public SyncProfile getSyncProfile(FolderInfo var1);

    public void setSyncProfile(FolderInfo var1, SyncProfile var2);

    public void setSyncProfileOfAllFolders(SyncProfile var1);

    public void setDefaultSynchronizedFolder(FolderInfo var1);

    public Collection<MemberInfo> getHostingServers(FolderInfo ... var1);

    public boolean hasDeletedContents(FolderInfo var1);

    public List<FileInfo> getArchivedFilesInfos(FileInfo var1);

    @Deprecated
    public FileInfo restore(FileInfo var1, boolean var2) throws IOException;

    public FileInfo restore(FileInfo var1, String var2) throws IOException;

    public void setArchiveMode(FolderInfo var1, int var2);

    @Deprecated
    public void setArchiveMode(FolderInfo var1, ArchiveMode var2, int var3);

    @Deprecated
    public ArchiveMode getArchiveMode(FolderInfo var1);

    public boolean purgeArchive(FolderInfo var1);

    public boolean purgeFromArchive(FileInfo var1);

    public int getVersionsPerFile(FolderInfo var1);

    public boolean isHostedOnThisServer(FolderInfo var1);

    public boolean isHostedOnThisService(FolderInfo var1);

    public boolean isHostedInFederation(FolderInfo var1);

    public boolean isHostedInCloud(FolderInfo var1);

    public boolean isStoredInCloud(FolderInfo var1);

    public String getWebDAVURL(FolderInfo var1);

    public String getOwnerDisplayname(FolderInfo var1);

    public String getFileLink(FileInfo var1);

    public void removeFileLink(FileInfo var1);

    public String getDownloadLink(FileInfo var1);

    public long[] calculateSizes(Collection<FolderInfo> var1);

    public Map<FolderInfo, FolderStatisticInfo> getCloudStatisticInfo(Collection<FolderInfo> var1);

    public Map<FolderInfo, FolderStatisticInfo> getLocalStatisticInfo(Collection<FolderInfo> var1);

    public String prepareFileLink(FolderInfo var1, String var2, String var3, char[] var4, Date var5);

    public boolean isStoragePathCorrect(FolderInfo var1, Account var2);

    public void correctStoragePath(FolderInfo var1, Account var2, boolean var3);

    public boolean isEncrypted(FolderInfo var1);

    public boolean encrypt(FolderInfo var1, Account var2);

    public List<FileLink> getAll(FileLinkFilterModel var1);

    public String getUploadForm(FolderInfo var1);

    public void storeUploadForm(FolderInfo var1, String var2);

    public void logDiffFiles(FolderInfo var1, MemberInfo var2, MemberInfo var3);
}

