/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.activity.domain;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.protocol.InvitationActivityProto;
import de.dal33t.powerfolder.security.AccessMode;
import de.dal33t.powerfolder.security.Account;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
public class InvitationActivity
implements D2DObject {
    @Id
    @Column(length=32)
    private final String id;
    @ManyToOne
    @JoinColumn(name="folder_id")
    private final FolderInfo folderInfo;
    @Enumerated(value=EnumType.STRING)
    private final AccessMode permissionType;
    @ManyToOne
    @JoinColumn(name="recipient_account_id")
    private final Account recipientAccount;

    private InvitationActivity() {
        this.id = null;
        this.folderInfo = null;
        this.permissionType = null;
        this.recipientAccount = null;
    }

    InvitationActivity(@NotNull FolderInfo folderInfo, @NotNull AccessMode accessMode, @NotNull Account account) {
        this.id = UUID.randomUUID().toString().replaceAll("-", "");
        this.folderInfo = folderInfo;
        this.permissionType = accessMode;
        this.recipientAccount = account;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public FolderInfo getFolderInfo() {
        return this.folderInfo;
    }

    @NotNull
    public AccessMode getPermissionType() {
        return this.permissionType;
    }

    @Nullable
    public Account getRecipientAccount() {
        return this.recipientAccount;
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
    }

    @Override
    public AbstractMessage toD2D() {
        InvitationActivityProto.InvitationActivity.Builder builder = InvitationActivityProto.InvitationActivity.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        builder.setId(this.getId());
        builder.setFolderId(this.getFolderInfo().getId());
        if (this.getPermissionType().toD2D() != null) {
            builder.setPermissionType(this.getPermissionType().toD2D());
        }
        if (this.getRecipientAccount() != null) {
            builder.setFolderId(this.getRecipientAccount().getOID());
        }
        return builder.build();
    }
}

