/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.monitoring;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import dagger.producers.monitoring.ProducerMonitor;
import dagger.producers.monitoring.ProducerTimingRecorder;
import java.util.concurrent.TimeUnit;

final class TimingProducerMonitor
extends ProducerMonitor {
    private final ProducerTimingRecorder recorder;
    private final Stopwatch stopwatch;
    private final Stopwatch componentStopwatch;
    private long startNanos = -1L;

    TimingProducerMonitor(ProducerTimingRecorder producerTimingRecorder, Ticker ticker, Stopwatch stopwatch) {
        this.recorder = producerTimingRecorder;
        this.stopwatch = Stopwatch.createUnstarted(ticker);
        this.componentStopwatch = stopwatch;
    }

    @Override
    public void methodStarting() {
        this.startNanos = this.componentStopwatch.elapsed(TimeUnit.NANOSECONDS);
        this.stopwatch.start();
    }

    @Override
    public void methodFinished() {
        long l = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
        this.recorder.recordMethod(this.startNanos, l);
    }

    @Override
    public void succeeded(Object object) {
        long l = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
        this.recorder.recordSuccess(l);
    }

    @Override
    public void failed(Throwable throwable) {
        if (this.stopwatch.isRunning()) {
            long l = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            this.recorder.recordFailure(throwable, l);
        } else {
            this.recorder.recordSkip(throwable);
        }
    }
}

