/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.monitoring;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ProducerToken {
    @Nullable
    private final Class<?> classToken;
    @Nullable
    private final String methodName;

    private ProducerToken(@Nullable Class<?> clazz, @Nullable String string) {
        this.classToken = clazz;
        this.methodName = string;
    }

    public static ProducerToken create(Class<?> clazz) {
        return new ProducerToken(Preconditions.checkNotNull(clazz), null);
    }

    public static ProducerToken create(String string) {
        return new ProducerToken(null, Preconditions.checkNotNull(string));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ProducerToken) {
            ProducerToken producerToken = (ProducerToken)object;
            return Objects.equals(this.classToken, producerToken.classToken) && Objects.equals(this.methodName, producerToken.methodName);
        }
        return false;
    }

    public int hashCode() {
        int n = 1;
        n *= 1000003;
        n ^= Objects.hashCode(this.classToken);
        n *= 1000003;
        return n ^= Objects.hashCode(this.methodName);
    }

    public String toString() {
        if (this.methodName != null) {
            return this.methodName;
        }
        if (this.classToken != null) {
            return this.classToken.getCanonicalName();
        }
        throw new IllegalStateException();
    }
}

