/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.producers.internal.AbstractProducer;
import java.util.List;
import java.util.Set;
import javax.inject.Provider;

public final class Producers {
    private static final AsyncFunction<Throwable, Produced<Object>> FUTURE_FALLBACK_FOR_PRODUCED = new AsyncFunction<Throwable, Produced<Object>>(){

        @Override
        public ListenableFuture<Produced<Object>> apply(Throwable throwable) throws Exception {
            Produced produced = Produced.failed(throwable);
            return Futures.immediateFuture(produced);
        }
    };

    public static <T> ListenableFuture<Produced<T>> createFutureProduced(ListenableFuture<T> listenableFuture) {
        return Futures.catchingAsync(Futures.transform(listenableFuture, new Function<T, Produced<T>>(){

            @Override
            public Produced<T> apply(T t) {
                return Produced.successful(t);
            }
        }, MoreExecutors.directExecutor()), Throwable.class, Producers.futureFallbackForProduced(), MoreExecutors.directExecutor());
    }

    private static <T> AsyncFunction<Throwable, Produced<T>> futureFallbackForProduced() {
        return FUTURE_FALLBACK_FOR_PRODUCED;
    }

    public static <T> ListenableFuture<Set<T>> createFutureSingletonSet(ListenableFuture<T> listenableFuture) {
        return Futures.transform(listenableFuture, new Function<T, Set<T>>(){

            @Override
            public Set<T> apply(T t) {
                return ImmutableSet.of(t);
            }
        }, MoreExecutors.directExecutor());
    }

    public static <T> ListenableFuture<Set<T>> allAsSet(Iterable<? extends ListenableFuture<? extends T>> iterable) {
        return Futures.transform(Futures.allAsList(iterable), new Function<List<T>, Set<T>>(){

            @Override
            public Set<T> apply(List<T> list) {
                return ImmutableSet.copyOf(list);
            }
        }, MoreExecutors.directExecutor());
    }

    public static <T> Producer<T> producerFromProvider(final Provider<T> provider) {
        Preconditions.checkNotNull(provider);
        return new AbstractProducer<T>(){

            @Override
            protected ListenableFuture<T> compute() {
                return Futures.immediateFuture(provider.get());
            }
        };
    }

    public static <T> Producer<T> immediateProducer(final T t) {
        return new Producer<T>(){

            @Override
            public ListenableFuture<T> get() {
                return Futures.immediateFuture(t);
            }
        };
    }

    public static <T> Producer<T> immediateFailedProducer(final Throwable throwable) {
        return new Producer<T>(){

            @Override
            public ListenableFuture<T> get() {
                return Futures.immediateFailedFuture(throwable);
            }
        };
    }

    private Producers() {
    }
}

