/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.Lazy;
import dagger.internal.DaggerCollections;
import dagger.internal.Factory;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Provider;

public final class MapProviderFactory<K, V>
implements Factory<Map<K, Provider<V>>>,
Lazy<Map<K, Provider<V>>> {
    private static final MapProviderFactory<Object, Object> EMPTY = new MapProviderFactory(Collections.emptyMap());
    private final Map<K, Provider<V>> contributingMap;

    public static <K, V> Builder<K, V> builder(int n) {
        return new Builder(n);
    }

    public static <K, V> MapProviderFactory<K, V> empty() {
        return EMPTY;
    }

    private MapProviderFactory(Map<K, Provider<V>> map) {
        this.contributingMap = Collections.unmodifiableMap(map);
    }

    @Override
    public Map<K, Provider<V>> get() {
        return this.contributingMap;
    }

    public static final class Builder<K, V> {
        private final LinkedHashMap<K, Provider<V>> mapBuilder;

        private Builder(int n) {
            this.mapBuilder = DaggerCollections.newLinkedHashMapWithExpectedSize(n);
        }

        public MapProviderFactory<K, V> build() {
            return new MapProviderFactory(this.mapBuilder);
        }

        public Builder<K, V> put(K k, Provider<V> provider) {
            if (k == null) {
                throw new NullPointerException("The key is null");
            }
            if (provider == null) {
                throw new NullPointerException("The provider of the value is null");
            }
            this.mapBuilder.put(k, provider);
            return this;
        }
    }
}

