/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.util.mac;

import com.liferay.nativity.util.mac.AppleScriptUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppleUtil {
    private static Logger _logger = LoggerFactory.getLogger(AppleUtil.class.getName());

    public static String getBundleVersion(String string) {
        try {
            String string2 = AppleScriptUtil.getScript("getbundleversion.applescript", string);
            return (String)AppleScriptUtil.executeScript(string2);
        }
        catch (Exception exception) {
            _logger.error(exception.getMessage(), exception);
            return "";
        }
    }

    public static String getInstalledBundleVersion() {
        try {
            String string = AppleScriptUtil.getScript("getbundleversion.applescript", "/Library/ScriptingAdditions/LiferayNativity.osax");
            return (String)AppleScriptUtil.executeScript(string);
        }
        catch (Exception exception) {
            _logger.error(exception.getMessage(), exception);
            return "";
        }
    }

    public static void installScripts(String string) {
        try {
            String string2 = AppleScriptUtil.getScript("installscripts.applescript", string);
            AppleScriptUtil.executeScript(string2);
            Thread.sleep(1000L);
            AppleUtil.reloadScripts();
        }
        catch (Exception exception) {
            _logger.error(exception.getMessage(), exception);
        }
    }

    public static boolean load() {
        try {
            String string = AppleScriptUtil.getScript("load.applescript");
            AppleScriptUtil.executeScript(string);
            return true;
        }
        catch (Exception exception) {
            _logger.error(exception.getMessage(), exception);
            return false;
        }
    }

    public static boolean loaded() {
        try {
            String string = AppleScriptUtil.getScript("loaded.applescript");
            Long l = (Long)AppleScriptUtil.executeScript(string);
            return l != null && l == 0L;
        }
        catch (Exception exception) {
            _logger.error(exception.getMessage(), exception);
            return false;
        }
    }

    public static void reloadScripts() {
        try {
            String string = AppleScriptUtil.getScript("reloadscripts.applescript");
            AppleScriptUtil.executeScript(string);
        }
        catch (Exception exception) {
            _logger.error(exception.getMessage(), exception);
        }
    }

    public static void uninstallScripts() {
        try {
            String string = AppleScriptUtil.getScript("uninstallscripts.applescript");
            AppleScriptUtil.executeScript(string);
        }
        catch (Exception exception) {
            _logger.error(exception.getMessage(), exception);
        }
    }

    public static boolean unload() {
        try {
            String string = AppleScriptUtil.getScript("unload.applescript");
            AppleScriptUtil.executeScript(string);
            return true;
        }
        catch (Exception exception) {
            _logger.error(exception.getMessage(), exception);
            return false;
        }
    }
}

