/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.modules.fileicon;

import com.liferay.nativity.control.NativityControl;
import com.liferay.nativity.modules.fileicon.FileIconControl;
import com.liferay.nativity.modules.fileicon.FileIconControlCallback;
import com.liferay.nativity.modules.fileicon.findersync.FSFileIconControlImpl;
import com.liferay.nativity.modules.fileicon.unix.AppleFileIconControlImpl;
import com.liferay.nativity.modules.fileicon.unix.LinuxFileIconControlImpl;
import com.liferay.nativity.modules.fileicon.win.WindowsFileIconControlImpl;
import com.liferay.nativity.util.OSDetector;

public class FileIconControlUtil {
    private FileIconControlCallback _fileIconControlCallback;
    private NativityControl _nativityControl;

    public static FileIconControl getFileIconControl(NativityControl nativityControl, FileIconControlCallback fileIconControlCallback) {
        FileIconControlUtil fileIconControlUtil = new FileIconControlUtil(nativityControl, fileIconControlCallback);
        if (OSDetector.isApple()) {
            if (OSDetector.isMinimumAppleVersion("10.10")) {
                return fileIconControlUtil.createFSFileIconControl();
            }
            return fileIconControlUtil.createAppleFileIconControl();
        }
        if (OSDetector.isWindows()) {
            return fileIconControlUtil.createWindowsFileIconControl();
        }
        if (OSDetector.isLinux()) {
            return fileIconControlUtil.createLinuxFileIconControl();
        }
        return null;
    }

    protected FileIconControl createAppleFileIconControl() {
        return new AppleFileIconControlImpl(this._nativityControl, this._fileIconControlCallback);
    }

    protected FileIconControl createFSFileIconControl() {
        return new FSFileIconControlImpl(this._fileIconControlCallback, this._nativityControl);
    }

    protected FileIconControl createLinuxFileIconControl() {
        return new LinuxFileIconControlImpl(this._fileIconControlCallback, this._nativityControl);
    }

    protected FileIconControl createWindowsFileIconControl() {
        return new WindowsFileIconControlImpl(this._fileIconControlCallback, this._nativityControl);
    }

    private FileIconControlUtil(NativityControl nativityControl, FileIconControlCallback fileIconControlCallback) {
        this._nativityControl = nativityControl;
        this._fileIconControlCallback = fileIconControlCallback;
    }
}

