/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.BoundedSize;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.util.DefaultUnitConverter;
import com.jgoodies.forms.util.UnitConverter;
import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public final class Sizes {
    public static final ConstantSize ZERO = Sizes.pixel(0);
    public static final ConstantSize DLUX1 = Sizes.dluX(1);
    public static final ConstantSize DLUX2 = Sizes.dluX(2);
    public static final ConstantSize DLUX3 = Sizes.dluX(3);
    public static final ConstantSize DLUX4 = Sizes.dluX(4);
    public static final ConstantSize DLUX5 = Sizes.dluX(5);
    public static final ConstantSize DLUX6 = Sizes.dluX(6);
    public static final ConstantSize DLUX7 = Sizes.dluX(7);
    public static final ConstantSize DLUX8 = Sizes.dluX(8);
    public static final ConstantSize DLUX9 = Sizes.dluX(9);
    public static final ConstantSize DLUX11 = Sizes.dluX(11);
    public static final ConstantSize DLUX14 = Sizes.dluX(14);
    public static final ConstantSize DLUX21 = Sizes.dluX(21);
    public static final ConstantSize DLUY1 = Sizes.dluY(1);
    public static final ConstantSize DLUY2 = Sizes.dluY(2);
    public static final ConstantSize DLUY3 = Sizes.dluY(3);
    public static final ConstantSize DLUY4 = Sizes.dluY(4);
    public static final ConstantSize DLUY5 = Sizes.dluY(5);
    public static final ConstantSize DLUY6 = Sizes.dluY(6);
    public static final ConstantSize DLUY7 = Sizes.dluY(7);
    public static final ConstantSize DLUY8 = Sizes.dluY(8);
    public static final ConstantSize DLUY9 = Sizes.dluY(9);
    public static final ConstantSize DLUY11 = Sizes.dluY(11);
    public static final ConstantSize DLUY14 = Sizes.dluY(14);
    public static final ConstantSize DLUY21 = Sizes.dluY(21);
    public static final ComponentSize MINIMUM = new ComponentSize("minimum");
    public static final ComponentSize PREFERRED = new ComponentSize("preferred");
    public static final ComponentSize DEFAULT = new ComponentSize("default");
    private static final ComponentSize[] VALUES = new ComponentSize[]{MINIMUM, PREFERRED, DEFAULT};
    private static UnitConverter unitConverter;
    private static ConstantSize.Unit defaultUnit;

    private Sizes() {
    }

    public static ConstantSize constant(String string, boolean bl) {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        String string3 = string2.trim();
        return ConstantSize.valueOf(string3, bl);
    }

    public static ConstantSize dluX(int n) {
        return ConstantSize.dluX(n);
    }

    public static ConstantSize dluY(int n) {
        return ConstantSize.dluY(n);
    }

    public static ConstantSize pixel(int n) {
        return new ConstantSize(n, ConstantSize.PIXEL);
    }

    public static Size bounded(Size size, Size size2, Size size3) {
        return new BoundedSize(size, size2, size3);
    }

    public static int inchAsPixel(double d, Component component) {
        return d == 0.0 ? 0 : Sizes.getUnitConverter().inchAsPixel(d, component);
    }

    public static int millimeterAsPixel(double d, Component component) {
        return d == 0.0 ? 0 : Sizes.getUnitConverter().millimeterAsPixel(d, component);
    }

    public static int centimeterAsPixel(double d, Component component) {
        return d == 0.0 ? 0 : Sizes.getUnitConverter().centimeterAsPixel(d, component);
    }

    public static int pointAsPixel(int n, Component component) {
        return n == 0 ? 0 : Sizes.getUnitConverter().pointAsPixel(n, component);
    }

    public static int dialogUnitXAsPixel(int n, Component component) {
        return n == 0 ? 0 : Sizes.getUnitConverter().dialogUnitXAsPixel(n, component);
    }

    public static int dialogUnitYAsPixel(int n, Component component) {
        return n == 0 ? 0 : Sizes.getUnitConverter().dialogUnitYAsPixel(n, component);
    }

    public static UnitConverter getUnitConverter() {
        if (unitConverter == null) {
            unitConverter = DefaultUnitConverter.getInstance();
        }
        return unitConverter;
    }

    public static void setUnitConverter(UnitConverter unitConverter) {
        Sizes.unitConverter = unitConverter;
    }

    public static ConstantSize.Unit getDefaultUnit() {
        return defaultUnit;
    }

    public static void setDefaultUnit(ConstantSize.Unit unit) {
        if (unit == ConstantSize.DLUX || unit == ConstantSize.DLUY) {
            throw new IllegalArgumentException("The unit must not be DLUX or DLUY. To use DLU as default unit, invoke this method with null.");
        }
        defaultUnit = unit;
    }

    static {
        defaultUnit = ConstantSize.PIXEL;
    }

    static final class ComponentSize
    implements Size,
    Serializable {
        private final transient String name;
        private static int nextOrdinal = 0;
        private final int ordinal = nextOrdinal++;

        private ComponentSize(String string) {
            this.name = string;
        }

        static ComponentSize valueOf(String string) {
            if (string.equals("m") || string.equals("min")) {
                return MINIMUM;
            }
            if (string.equals("p") || string.equals("pref")) {
                return PREFERRED;
            }
            if (string.equals("d") || string.equals("default")) {
                return DEFAULT;
            }
            return null;
        }

        public int maximumSize(Container container, List list, FormLayout.Measure measure, FormLayout.Measure measure2, FormLayout.Measure measure3) {
            FormLayout.Measure measure4 = this == MINIMUM ? measure : (this == PREFERRED ? measure2 : measure3);
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Component component = (Component)iterator.next();
                n = Math.max(n, measure4.sizeOf(component));
            }
            return n;
        }

        public boolean compressible() {
            return this == DEFAULT;
        }

        public String toString() {
            return this.encode();
        }

        public String encode() {
            return this.name.substring(0, 1);
        }

        private Object readResolve() {
            return VALUES[this.ordinal];
        }
    }
}

