/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.value;

import com.jgoodies.binding.value.AbstractConverter;
import com.jgoodies.binding.value.ValueModel;
import java.text.Format;
import java.text.ParseException;

public final class ConverterFactory {
    private ConverterFactory() {
    }

    public static ValueModel createBooleanNegator(ValueModel valueModel) {
        return new BooleanNegator(valueModel);
    }

    public static ValueModel createBooleanToStringConverter(ValueModel valueModel, String string, String string2) {
        return ConverterFactory.createBooleanToStringConverter(valueModel, string, string2, "");
    }

    public static ValueModel createBooleanToStringConverter(ValueModel valueModel, String string, String string2, String string3) {
        return new BooleanToStringConverter(valueModel, string, string2, string3);
    }

    public static ValueModel createDoubleConverter(ValueModel valueModel, double d) {
        return new DoubleConverter(valueModel, d);
    }

    public static ValueModel createDoubleToIntegerConverter(ValueModel valueModel) {
        return ConverterFactory.createDoubleToIntegerConverter(valueModel, 1);
    }

    public static ValueModel createDoubleToIntegerConverter(ValueModel valueModel, int n) {
        return new DoubleToIntegerConverter(valueModel, n);
    }

    public static ValueModel createFloatConverter(ValueModel valueModel, float f) {
        return new FloatConverter(valueModel, f);
    }

    public static ValueModel createFloatToIntegerConverter(ValueModel valueModel) {
        return ConverterFactory.createFloatToIntegerConverter(valueModel, 1);
    }

    public static ValueModel createFloatToIntegerConverter(ValueModel valueModel, int n) {
        return new FloatToIntegerConverter(valueModel, n);
    }

    public static ValueModel createIntegerConverter(ValueModel valueModel, double d) {
        return new IntegerConverter(valueModel, d);
    }

    public static ValueModel createLongConverter(ValueModel valueModel, double d) {
        return new LongConverter(valueModel, d);
    }

    public static ValueModel createLongToIntegerConverter(ValueModel valueModel) {
        return ConverterFactory.createLongToIntegerConverter(valueModel, 1);
    }

    public static ValueModel createLongToIntegerConverter(ValueModel valueModel, int n) {
        return new LongToIntegerConverter(valueModel, n);
    }

    public static ValueModel createStringConverter(ValueModel valueModel, Format format) {
        return new StringConverter(valueModel, format);
    }

    public static final class StringConverter
    extends AbstractConverter {
        private final Format format;

        StringConverter(ValueModel valueModel, Format format) {
            super(valueModel);
            if (format == null) {
                throw new NullPointerException("The format must not be null.");
            }
            this.format = format;
        }

        public Object convertFromSubject(Object object) {
            return this.format.format(object);
        }

        public void setValue(Object object) {
            try {
                this.subject.setValue(this.format.parseObject((String)object));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public static final class LongToIntegerConverter
    extends AbstractConverter {
        private final int multiplier;

        LongToIntegerConverter(ValueModel valueModel, int n) {
            super(valueModel);
            this.multiplier = n;
        }

        public Object convertFromSubject(Object object) {
            int n = ((Long)object).intValue();
            if (this.multiplier != 1) {
                n *= this.multiplier;
            }
            return n;
        }

        public void setValue(Object object) {
            long l = ((Integer)object).longValue();
            if (this.multiplier != 1) {
                l /= (long)this.multiplier;
            }
            this.subject.setValue(l);
        }
    }

    public static final class IntegerConverter
    extends AbstractConverter {
        private final double multiplier;

        IntegerConverter(ValueModel valueModel, double d) {
            super(valueModel);
            this.multiplier = d;
        }

        public Object convertFromSubject(Object object) {
            double d = ((Integer)object).doubleValue();
            return (int)(d * this.multiplier);
        }

        public void setValue(Object object) {
            double d = ((Integer)object).doubleValue();
            this.subject.setValue((int)(d / this.multiplier));
        }
    }

    public static final class LongConverter
    extends AbstractConverter {
        private final double multiplier;

        LongConverter(ValueModel valueModel, double d) {
            super(valueModel);
            this.multiplier = d;
        }

        public Object convertFromSubject(Object object) {
            double d = ((Long)object).doubleValue();
            return (long)(d * this.multiplier);
        }

        public void setValue(Object object) {
            double d = ((Long)object).doubleValue();
            this.subject.setValue((long)(d / this.multiplier));
        }
    }

    public static final class FloatToIntegerConverter
    extends AbstractConverter {
        private final int multiplier;

        FloatToIntegerConverter(ValueModel valueModel, int n) {
            super(valueModel);
            this.multiplier = n;
        }

        public Object convertFromSubject(Object object) {
            float f = ((Float)object).floatValue();
            if (this.multiplier != 1) {
                f *= (float)this.multiplier;
            }
            return Math.round(f);
        }

        public void setValue(Object object) {
            float f = ((Integer)object).floatValue();
            if (this.multiplier != 1) {
                f /= (float)this.multiplier;
            }
            this.subject.setValue(Float.valueOf(f));
        }
    }

    public static final class FloatConverter
    extends AbstractConverter {
        private final float multiplier;

        FloatConverter(ValueModel valueModel, float f) {
            super(valueModel);
            this.multiplier = f;
        }

        public Object convertFromSubject(Object object) {
            float f = ((Float)object).floatValue();
            return Float.valueOf(f * this.multiplier);
        }

        public void setValue(Object object) {
            float f = ((Float)object).floatValue();
            this.subject.setValue(Float.valueOf(f / this.multiplier));
        }
    }

    public static final class DoubleToIntegerConverter
    extends AbstractConverter {
        private final int multiplier;

        DoubleToIntegerConverter(ValueModel valueModel, int n) {
            super(valueModel);
            this.multiplier = n;
        }

        public Object convertFromSubject(Object object) {
            double d = (Double)object;
            if (this.multiplier != 1) {
                d *= (double)this.multiplier;
            }
            return (int)Math.round(d);
        }

        public void setValue(Object object) {
            double d = ((Integer)object).doubleValue();
            if (this.multiplier != 1) {
                d /= (double)this.multiplier;
            }
            this.subject.setValue(d);
        }
    }

    public static final class DoubleConverter
    extends AbstractConverter {
        private final double multiplier;

        DoubleConverter(ValueModel valueModel, double d) {
            super(valueModel);
            this.multiplier = d;
        }

        public Object convertFromSubject(Object object) {
            double d = (Double)object;
            return d * this.multiplier;
        }

        public void setValue(Object object) {
            double d = (Double)object;
            this.subject.setValue(d / this.multiplier);
        }
    }

    public static final class BooleanToStringConverter
    extends AbstractConverter {
        private final String trueText;
        private final String falseText;
        private final String nullText;

        BooleanToStringConverter(ValueModel valueModel, String string, String string2, String string3) {
            super(valueModel);
            if (string == null || string2 == null || string3 == null) {
                throw new NullPointerException("The trueText, falseText and nullText must not be null.");
            }
            if (string.equals(string2)) {
                throw new IllegalArgumentException("The trueText and falseText must be different.");
            }
            this.trueText = string;
            this.falseText = string2;
            this.nullText = string3;
        }

        public Object convertFromSubject(Object object) {
            if (Boolean.TRUE.equals(object)) {
                return this.trueText;
            }
            if (Boolean.FALSE.equals(object)) {
                return this.falseText;
            }
            if (object == null) {
                return this.nullText;
            }
            throw new ClassCastException("The subject value must be of type Boolean.");
        }

        public void setValue(Object object) {
            if (!(object instanceof String)) {
                throw new ClassCastException("The new value must be a string.");
            }
            String string = (String)object;
            if (this.trueText.equalsIgnoreCase(string)) {
                this.subject.setValue(Boolean.TRUE);
            } else if (this.falseText.equalsIgnoreCase(string)) {
                this.subject.setValue(Boolean.FALSE);
            } else if (this.nullText.equalsIgnoreCase(string)) {
                this.subject.setValue(null);
            } else {
                throw new IllegalArgumentException("The new value must be one of: " + this.trueText + '/' + this.falseText + '/' + this.nullText);
            }
        }
    }

    public static final class BooleanNegator
    extends AbstractConverter {
        BooleanNegator(ValueModel valueModel) {
            super(valueModel);
        }

        public Object convertFromSubject(Object object) {
            return this.negate(object);
        }

        public void setValue(Object object) {
            this.subject.setValue(this.negate(object));
        }

        private Boolean negate(Object object) {
            if (object == null) {
                return null;
            }
            if (Boolean.TRUE.equals(object)) {
                return Boolean.FALSE;
            }
            if (Boolean.FALSE.equals(object)) {
                return Boolean.TRUE;
            }
            throw new ClassCastException("The value must be a Boolean.");
        }
    }
}

